/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OABillTypeEnum {
    PAYMENT("1", "\u4ed8\u6b3e\u7533\u8bf7\u6d41\u7a0b"),
    PRE_PAYMENT("2", "\u8d39\u7528\u9884\u4ed8\u6b3e\u6d41\u7a0b");

    private String code;
    private String name;
    public static final Map<String, OABillTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private OABillTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static OABillTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        CODE_LOOKUP = Arrays.stream(OABillTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(OABillTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.name));
    }
}

