/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import java.math.BigDecimal;

public enum AccountRuleTypeEnum {
    SALES_ORDER_MAIN("SALES_ORDER_MAIN", "SALE_LIST", "\u9500\u552e\u5355-\u4e3b\u54c1", "yes"),
    SALES_ORDER_COMPLIMENTARY("SALES_ORDER_COMPLIMENTARY", "SALE_LIST", "\u9500\u552e\u5355-\u8d60\u54c1", "no"),
    RETURN_REFUND_MAIN("RETURN_REFUND_MAIN", "RETURN_BASE", "\u9000\u8d27\u9000\u6b3e-\u4e3b\u54c1", "yes"),
    RETURN_REFUND_COMPLIMENTARY("RETURN_REFUND_COMPLIMENTARY", "RETURN_BASE", "\u9000\u8d27\u9000\u6b3e-\u8d60\u54c1", "no"),
    EXCHANGE_ORDER_MAIN("EXCHANGE_ORDER_MAIN", "EXCHANGE", "\u6362\u8d27\u5355-\u4e3b\u54c1", "yes"),
    EXCHANGE_ORDER_COMPLIMENTARY("EXCHANGE_ORDER_COMPLIMENTARY", "EXCHANGE", "\u6362\u8d27\u5355-\u8d60\u54c1", "no"),
    REFUND_ONLY_AFTER_DELIVERY_MAIN("REFUND_ONLY_AFTER_DELIVERY_MAIN", "DELIVERY_REFUND_ONLY", "\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e-\u4e3b\u54c1", "no"),
    REFUND_ONLY_AFTER_DELIVERY_MAIN_1("REFUND_ONLY_AFTER_DELIVERY_MAIN_1", "DELIVERY_REFUND_ONLY", "\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e-\u4e3b\u54c1", "yes");

    private String code;
    private String orderType;
    private String condition;
    private String name;

    private AccountRuleTypeEnum(String code, String orderType, String name, String condition) {
        this.code = code;
        this.orderType = orderType;
        this.name = name;
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getNameByCode(String code) {
        for (AccountRuleTypeEnum billCreateTypeEnum : AccountRuleTypeEnum.values()) {
            if (!billCreateTypeEnum.getCode().equals(code)) continue;
            return billCreateTypeEnum.getName();
        }
        return null;
    }

    public static AccountRuleTypeEnum getNameByCondition(String orderType, BigDecimal amount) {
        if (null == amount) {
            amount = BigDecimal.ZERO;
        }
        String condition = "no";
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            condition = "yes";
        }
        for (AccountRuleTypeEnum billCreateTypeEnum : AccountRuleTypeEnum.values()) {
            if (!billCreateTypeEnum.getOrderType().equals(orderType) || !billCreateTypeEnum.getCondition().equals(condition)) continue;
            return billCreateTypeEnum;
        }
        return null;
    }
}

