/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum BillTypeEnum {
    SALE_LIST("SALE_LIST", "\u9500\u552e\u5355", null),
    DELIVERY_REFUND_ONLY("DELIVERY_REFUND_ONLY", "\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e", "FHHTK"),
    SMALL_REFUND("SMALL_REFUND", "\u5c0f\u989d\u9000\u6b3e", null),
    RETURN_BASE("RETURN_BASE", "\u9000\u8d27\u9000\u6b3e", "THTK"),
    EXCHANGE("EXCHANGE", "\u6362\u8d27\u5355", "HH"),
    TRANSFERS("TRANSFERS", "\u8c03\u62e8\u5355", null),
    FREIGHT_BOOKKEEPING("FREIGHT_BOOKKEEPING", "\u8fd0\u8d39", null),
    PACKAGE_MATERIAL("PACKAGE_MATERIAL", "\u5305\u6750", null),
    RECEIVE_ORDER("RECEIVE_ORDER", "\u9886\u7528", null),
    RETURN_ORDER("RETURN_ORDER", "\u5f52\u8fd8", null),
    SALES_OUTBOUND_ORDER("SALES_OUTBOUND_ORDER", "\u5916\u90e8-\u9500\u552e\u51fa\u5e93\u5355", null),
    SALES_INBOUND_ORDER("SALES_INBOUND_ORDER", "\u5916\u90e8-\u9500\u552e\u5165\u5e93\u5355", null),
    OTHER_OUTBOUND_ORDER("OTHER_OUTBOUND_ORDER", "\u5916\u90e8-\u5176\u4ed6\u51fa\u5e93\u5355", null),
    OTHER_INBOUND_ORDER("OTHER_INBOUND_ORDER", "\u5916\u90e8-\u5176\u4ed6\u5165\u5e93\u5355", null),
    REFUND_ONLY_ORDER("REFUND_ONLY_ORDER", "\u5916\u90e8-\u4ec5\u9000\u6b3e\u5355", null);

    private String code;
    private String name;
    private String orderType;
    private static final Map<String, String> ORDER_TYPE_ENUM_MAP;
    private static final Map<String, BillTypeEnum> VAL_MAP;

    private BillTypeEnum(String code, String name, String orderType) {
        this.code = code;
        this.name = name;
        this.orderType = orderType;
    }

    public static List<String> getBillTypeEnumList() {
        ArrayList list = Lists.newArrayList();
        for (BillTypeEnum billTypeEnum : BillTypeEnum.values()) {
            list.add(billTypeEnum.getCode());
        }
        return list;
    }

    public static BillTypeEnum getEnum(String code) {
        return VAL_MAP.get(code);
    }

    public static String getMapName(String code) {
        return ORDER_TYPE_ENUM_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getDesc(String index) {
        for (BillTypeEnum billTypeEnum : BillTypeEnum.values()) {
            if (!billTypeEnum.getCode().equals(index)) continue;
            return billTypeEnum.getName();
        }
        return null;
    }

    public static List<Map<String, Object>> toList() {
        ArrayList list = Lists.newArrayList();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            if (!Objects.equals(SALE_LIST.getCode(), orderTypeEnum.getCode()) && !Objects.equals(RETURN_BASE.getCode(), orderTypeEnum.getCode()) && !Objects.equals(EXCHANGE.getCode(), orderTypeEnum.getCode())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", orderTypeEnum.getCode());
            map.put("name", orderTypeEnum.getName());
            list.add(map);
        }
        return list;
    }

    public static Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            map.put(orderTypeEnum.getCode(), orderTypeEnum.getName());
        }
        return map;
    }

    public String getOrderType() {
        return this.orderType;
    }

    static {
        ORDER_TYPE_ENUM_MAP = new HashMap<String, String>();
        VAL_MAP = new HashMap<String, BillTypeEnum>();
        for (BillTypeEnum value : BillTypeEnum.values()) {
            ORDER_TYPE_ENUM_MAP.put(value.getCode(), value.getName());
            VAL_MAP.put(value.getCode(), value);
        }
    }
}

