/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import java.util.stream.Stream;

public enum AccountOperationTypeEnum {
    DEFAULT(99999, ""),
    REBATE_REDUCE(0, "\u8fd4\u5229\u62b5\u6263"),
    REBATE_ADD(1, "\u8fd4\u5229\u91ca\u653e"),
    REBATE_CLEAR(2, "\u5ba2\u6237\u6e05\u9000"),
    REBATE_CONFIRM(3, "\u8fd4\u5229\u786e\u8ba4"),
    REBATE_IMPORT(4, "\u8fd4\u5229\u5bfc\u5165"),
    ACCOUNT_INIT(5, "\u8d26\u6237\u521d\u59cb\u5316"),
    CUSTOMER_REFUND(6, "\u5ba2\u6237\u9000\u6b3e"),
    POLICY_PAY_FREEZE(7, "\u8fd4\u5229\u51bb\u7ed3");

    private Integer code;
    private String operationName;

    public static AccountOperationTypeEnum findByCode(int code) {
        return Stream.of(AccountOperationTypeEnum.values()).filter(type -> type.getCode() == code).findFirst().orElse(DEFAULT);
    }

    private AccountOperationTypeEnum(Integer code, String operationName) {
        this.code = code;
        this.operationName = operationName;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String toString() {
        return "AccountOperationTypeEnum." + this.name() + "(code=" + this.getCode() + ", operationName=" + this.getOperationName() + ")";
    }
}

