/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum FinanceItemTypeEnum {
    NO_GIFT(0, "\u6b63\u54c1"),
    GIFT(1, "\u8d60\u54c1"),
    FOREIGN_GIFT(2, "\u8d60\u54c1-\u5916\u91c7");

    private Integer code;
    private String name;
    private static final Map<Integer, String> KEEP_RESULT_ENUM_MAP;

    private FinanceItemTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getMapName(String code) {
        return KEEP_RESULT_ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getDesc(String index) {
        for (FinanceItemTypeEnum voucherTypeEnum : FinanceItemTypeEnum.values()) {
            if (!voucherTypeEnum.getCode().equals(index)) continue;
            return voucherTypeEnum.getName();
        }
        return index;
    }

    public static List<Map<String, Object>> toList() {
        ArrayList list = Lists.newArrayList();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", orderTypeEnum.getCode());
            map.put("name", orderTypeEnum.getName());
            list.add(map);
        }
        return list;
    }

    public static Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            map.put(orderTypeEnum.getCode(), orderTypeEnum.getName());
        }
        return map;
    }

    static {
        KEEP_RESULT_ENUM_MAP = new HashMap<Integer, String>();
        for (FinanceItemTypeEnum value : FinanceItemTypeEnum.values()) {
            KEEP_RESULT_ENUM_MAP.put(value.getCode(), value.getName());
        }
    }
}

