/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum KeepOrderInterfaceEnum {
    ZO2C("ZO2C", "Z_YX_ORDER_SO2C"),
    ZREC("ZREC", "Z_YX_ORDER_SO2C"),
    ZO2B("ZO2B", "Z_YX_ORDER_SO2B"),
    ZREB("ZREB", "Z_YX_ORDER_SO2B"),
    ZRE4("ZRE4", "Z_YX_ORDER_SEND"),
    ZSSO("ZSSO", "Z_YX_ORDER_SEND"),
    ZFSO("ZFSO", "Z_YX_ORDER_FREE_PRE"),
    ZREF("ZREF", "Z_YX_ORDER_FREE_PRE"),
    ZFS2("ZFS2", "Z_YX_ORDER_FREE_PRE"),
    ZRF2("ZRF2", "Z_YX_ORDER_FREE_PRE"),
    ZFS1("ZFS1", "Z_YX_ORDER_FREE"),
    ZRE6("ZRE6", "Z_YX_ORDER_FREE"),
    ZNCO("ZNCO", "Z_YX_ORDER_FREE"),
    ZRE5("ZRE5", "Z_YX_ORDER_FREE"),
    ZWXT("ZWXT", "Z_YX_ORDER_SWAP"),
    ZWXF("ZWXF", "Z_YX_ORDER_SWAP"),
    ZOR7("ZOR7", "Z_YX_ORDER_SWAP"),
    ZOR8("ZOR8", "Z_YX_ORDER_SWAP"),
    ZDR("ZDR", "Z_YX_ORDER_DC"),
    ZCR("ZCR", "Z_YX_ORDER_DC"),
    ZKB("ZKB", "Z_YX_ORDER_KA"),
    ZKA("ZKA", "Z_YX_ORDER_KA"),
    ZKE("ZKE", "Z_YX_ORDER_KE"),
    ZKR("ZKR", "Z_YX_ORDER_KE"),
    Z94("Z94", "Z_YX_STOCK_OUT"),
    Z76("Z76", "Z_YX_STOCK_OUT"),
    Z35("Z35", "Z_YX_STOCK_OUT"),
    Z29("Z29", "Z_YX_STOCK_OUT"),
    Z33("Z29", "Z_YX_STOCK_OUT"),
    Z30("Z30", "Z_YX_STOCK_IN"),
    Z34("Z34", "Z_YX_STOCK_IN"),
    Z36("Z36", "Z_YX_STOCK_IN"),
    Z77("Z77", "Z_YX_STOCK_IN"),
    Z95("Z95", "Z_YX_STOCK_IN"),
    Z31("Z31", "Z_YX_STOCK_OUT"),
    Z32("Z32", "Z_YX_STOCK_OUT"),
    Z_YX_FIDOC_CDP("Z_YX_FIDOC_CDP", "Z_YX_FIDOC_CDP"),
    ZSSO2("ZSSO2", "ZSSO"),
    ZO2C2("ZO2C2", "ZO2C"),
    Z_BILLING("Z_YX_BILLING", "Z_YX_BILLING");

    private String code;
    private String name;
    private static final Map<String, String> KEEP_RESULT_ENUM_MAP;

    private KeepOrderInterfaceEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getMapName(String code) {
        return KEEP_RESULT_ENUM_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static List<String> getOrderInterFaceEnumList() {
        return Arrays.asList(ZO2C.getCode(), ZFSO.getCode(), ZFS2.getCode(), ZREC.getCode(), ZREF.getCode(), ZRF2.getCode());
    }

    public static String getDesc(String index) {
        if (Objects.equals(ZO2C2.getCode(), index) || Objects.equals(ZSSO2.getCode(), index)) {
            return "Z_YX_ORDER_Z32";
        }
        for (KeepOrderInterfaceEnum voucherTypeEnum : KeepOrderInterfaceEnum.values()) {
            if (!voucherTypeEnum.getCode().equals(index)) continue;
            return voucherTypeEnum.getName();
        }
        return index;
    }

    public static String getChargeAccount(String index) {
        if (Objects.equals(ZO2C2.getCode(), index)) {
            return ZO2C2.getName();
        }
        if (Objects.equals(ZSSO2.getCode(), index)) {
            return ZSSO2.getName();
        }
        for (KeepOrderInterfaceEnum orderInterfaceEnum : KeepOrderInterfaceEnum.values()) {
            if (!orderInterfaceEnum.getCode().equals(index)) continue;
            return orderInterfaceEnum.getCode();
        }
        return index;
    }

    public static List<Map<String, Object>> toList() {
        ArrayList list = Lists.newArrayList();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", orderTypeEnum.getCode());
            map.put("name", orderTypeEnum.getName());
            list.add(map);
        }
        return list;
    }

    public static Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            map.put(orderTypeEnum.getCode(), orderTypeEnum.getName());
        }
        return map;
    }

    static {
        KEEP_RESULT_ENUM_MAP = new HashMap<String, String>();
        for (KeepOrderInterfaceEnum value : KeepOrderInterfaceEnum.values()) {
            KEEP_RESULT_ENUM_MAP.put(value.getCode(), value.getName());
        }
    }
}

