/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public enum SiteChannelEnum {
    TAOBAO("\u6dd8\u5b9d", "taobao"),
    JD("\u4eac\u4e1c", "jingdong"),
    PDD("\u62fc\u591a\u591a", "pdd"),
    DY("\u6296\u97f3", "douyin"),
    MALL("\u5b98\u7f51", "MALL"),
    OA("OA", "OA"),
    POS("POS", "POS"),
    USER_SERVICE("\u7528\u670d", "USER_SERVICE"),
    B2B("B2B", "B2B");

    private final String channelName;
    private final String channelCode;

    public static SiteChannelEnum getByCode(String channelCode) {
        for (SiteChannelEnum channel : SiteChannelEnum.values()) {
            if (!Objects.equals(channelCode, channel.getChannelCode())) continue;
            return channel;
        }
        return null;
    }

    public boolean equalsByCode(String channelCodde) {
        return this.channelCode.equals(channelCodde);
    }

    public static List<String> getByFilterCode(String filterChannelCode) {
        ArrayList<String> list = new ArrayList<String>();
        for (SiteChannelEnum channel : SiteChannelEnum.values()) {
            if (Objects.equals(filterChannelCode, channel.getChannelCode())) continue;
            list.add(channel.getChannelCode());
        }
        return list;
    }

    public static List<String> getNameByFilterName(String filterChannelName) {
        ArrayList<String> list = new ArrayList<String>();
        for (SiteChannelEnum channel : SiteChannelEnum.values()) {
            if (Objects.equals(filterChannelName, channel.getChannelName())) continue;
            list.add(channel.getChannelName());
        }
        return list;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public String toString() {
        return "SiteChannelEnum." + this.name() + "(channelName=" + this.getChannelName() + ", channelCode=" + this.getChannelCode() + ")";
    }

    private SiteChannelEnum(String channelName, String channelCode) {
        this.channelName = channelName;
        this.channelCode = channelCode;
    }
}

