/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.rest.entity;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.PushKeepAccountsReqDto;
import com.yunxi.dg.base.center.finance.dto.request.RuleParamReqDto;
import com.yunxi.dg.base.center.finance.service.entity.IHckBookKeepService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.ISyncKeepAccountingService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepAccountRuleFactory;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.finance.service.mq.keep.DeliveryNoticeAccountingConsumer;
import com.yunxi.dg.base.center.finance.service.mq.keep.RealTimeAccountingConsumer;
import com.yunxi.dg.base.center.finance.service.mq.keep.SaleRealTimeAccountingConsumer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u6837\u672c\u4e2d\u5fc3:\u8bb0\u8d26\u7c7b\u578b\u63a5\u53e3\u670d\u52a1"})
@RequestMapping(value={"/v1/accountingTest"})
public class AccountingTestController {
    @Resource
    private ISyncKeepAccountingService syncKeepAccountingService;
    @Resource
    private SaleRealTimeAccountingConsumer saleRealTimeAccountingConsumer;
    @Resource
    private DeliveryNoticeAccountingConsumer deliveryNoticeAccountingConsumer;
    @Resource
    private IOrderRuleService orderRuleService;
    @Resource
    private IHckBookKeepService iHckBookKeepService;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private RealTimeAccountingConsumer realTimeAccountingConsumer;
    @Value(value="${keep.mode:HCK}")
    private String keepSystem;

    @PostMapping(path={"/saleOrder/delivery"})
    @ApiOperation(value="\u9500\u552e\u5355\u8bb0\u8d26-\u4ea4\u8d27\u8bb0\u8d26", notes="\u9500\u552e\u5355\u8bb0\u8d26-\u4ea4\u8d27\u8bb0\u8d26")
    void accountSaleOrderDelivery(@RequestBody MamualKeepAccountReqDto dto) {
        MamualKeepAccountReqDto mamualKeepAccountReqDto = new MamualKeepAccountReqDto();
        mamualKeepAccountReqDto.setType(KeepTypeEnum.AUTO.getCode());
        mamualKeepAccountReqDto.setVoucherType("2");
        if (!"HCK".equals(this.keepSystem)) {
            mamualKeepAccountReqDto.setExecuteCAndBillKeep("bill");
        }
        this.syncKeepAccountingService.synchronousSaleBookAccount(mamualKeepAccountReqDto);
    }

    @PostMapping(path={"/saleOrder/scheduleTest"})
    @ApiOperation(value="\u8c03\u5ea6\u6d4b\u8bd5", notes="\u8c03\u5ea6\u6d4b\u8bd5")
    void scheduleTest(@RequestParam String type) {
        if (type.equals("1")) {
            MamualKeepAccountReqDto mamualKeepAccountReqDto = new MamualKeepAccountReqDto();
            mamualKeepAccountReqDto.setType(KeepTypeEnum.AUTO.getCode());
            mamualKeepAccountReqDto.setVoucherType("2");
            mamualKeepAccountReqDto.setBillShopType("1");
            Date currentDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            calendar.add(5, -25);
            Date earlierDate = calendar.getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = dateFormat.format(earlierDate);
            String format = dateFormat.format(currentDate);
            mamualKeepAccountReqDto.setStartTime(dateString);
            mamualKeepAccountReqDto.setEndTime(format);
            this.syncKeepAccountingService.synchronousSaleBookAccount(mamualKeepAccountReqDto);
        } else if (type.equals("2")) {
            MamualKeepAccountReqDto mamualKeepAccountReqDto = new MamualKeepAccountReqDto();
            AccountingTestController.extractedInitParam(mamualKeepAccountReqDto);
            KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), mamualKeepAccountReqDto.getOrderType());
            keepNodeRuleParam.getParamReqDto().setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            List keepNodeRules = KeepAccountRuleFactory.getRefundsBaseNodeList((String)VoucherTypeEnum.DELIVERY.getCode(), (String)mamualKeepAccountReqDto.getOrderType(), (String)(Objects.equals("HCK", this.keepSystem) ? this.keepSystem : null));
            keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
            keepNodeRuleParam.getParamReqDto().setVoucherType(VoucherTypeEnum.INVOICE.getCode());
            List keepNodeInvoiceRules = KeepAccountRuleFactory.getRefundsBaseNodeList((String)VoucherTypeEnum.INVOICE.getCode(), (String)mamualKeepAccountReqDto.getOrderType(), (String)(Objects.equals("HCK", this.keepSystem) ? this.keepSystem : null));
            keepNodeInvoiceRules.forEach(rule -> rule.execute(keepNodeRuleParam));
        }
    }

    private static void extractedInitParam(MamualKeepAccountReqDto mamualKeepAccountReqDto) {
        mamualKeepAccountReqDto.setType(KeepTypeEnum.AUTO.getCode());
        mamualKeepAccountReqDto.setBillShopType("1");
        mamualKeepAccountReqDto.setOrderType(BillTypeEnum.RETURN_BASE.getCode());
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(5, -25);
        Date earlierDate = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = dateFormat.format(earlierDate);
        String format = dateFormat.format(currentDate);
        mamualKeepAccountReqDto.setStartTime(dateString);
        mamualKeepAccountReqDto.setEndTime(format);
    }

    @PostMapping(path={"/saleOrder/MqTest"})
    @ApiOperation(value="\u8c03\u5ea6\u6d4b\u8bd5", notes="\u8c03\u5ea6\u6d4b\u8bd5")
    void MqTest(@RequestBody MessageVo message) {
        this.saleRealTimeAccountingConsumer.process(message);
    }

    @PostMapping(path={"/saleOrder/MqTestTemp"})
    @ApiOperation(value="\u8c03\u5ea6\u6d4b\u8bd5", notes="\u8c03\u5ea6\u6d4b\u8bd5")
    void MqTestTemp(@RequestBody MessageVo message) {
        this.deliveryNoticeAccountingConsumer.process(message);
    }

    @PostMapping(path={"/saleOrder/MqTestAfterSaleOrder"})
    @ApiOperation(value="\u8c03\u5ea6\u6d4b\u8bd5", notes="\u8c03\u5ea6\u6d4b\u8bd5")
    void MqTestAfterSaleOrder(@RequestBody MessageVo message) {
        this.realTimeAccountingConsumer.process(message);
    }

    @PostMapping(path={"/saleOrder/MqTestModifySaleOrder"})
    @ApiOperation(value="\u66f4\u65b0\u8d26\u6237\u6d4b\u8bd5", notes="\u66f4\u65b0\u8d26\u6237\u6d4b\u8bd5")
    void MqTestModifySaleOrder(@RequestBody PushKeepAccountsReqDto pushKeepAccountsReqDto) {
        this.pushKeepAccountsService.modifyPushKeepAndKeepDetail(pushKeepAccountsReqDto);
    }

    @PostMapping(path={"/saleOrder/groupBySaleOrderKeep"})
    @ApiOperation(value="\u6d4b\u8bd5\u5206\u7ec4", notes="\u6d4b\u8bd5\u5206\u7ec4")
    void GroupBySaleOrderKeep(@RequestBody RuleParamReqDto paramReqDto) {
        this.iHckBookKeepService.groupBySummaryToErp(paramReqDto);
    }
}

