/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.rest.entity;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.api.entity.IBillInfoApi;
import com.yunxi.dg.base.center.finance.dto.entity.BillInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillInfoPageReqDto;
import com.yunxi.dg.base.center.finance.dto.request.AgainInvoiceQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BatchReissueDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoListQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoReportQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillModifyReqDto;
import com.yunxi.dg.base.center.finance.dto.request.CallBackInvoiceInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceVerificationQueryDto;
import com.yunxi.dg.base.center.finance.dto.response.BatchOperationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoReportRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemExportDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemReportRespDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceItemRespDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceVerificationRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.mq.ModifyInvoiceInfoRedPushConsumer;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u6837\u672c\u4e2d\u5fc3:\u53d1\u7968\u4fe1\u606f\u8868\u63a5\u53e3\u670d\u52a1"})
@RequestMapping(value={"/v1/bill/info"})
public class BillInfoController
implements IBillInfoApi {
    @Resource
    private IBillInfoService service;
    @Resource
    private ModifyInvoiceInfoRedPushConsumer modifyInvoiceInfoRedPushConsumer;

    public RestResponse<Long> insert(@RequestBody BillInfoDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    public RestResponse update(@RequestBody BillInfoDto dto) {
        return this.service.update((BaseDto)dto);
    }

    public RestResponse<BillInfoDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    public RestResponse<PageInfo<BillInfoDto>> page(@RequestBody BillInfoPageReqDto dto) {
        return this.service.page((BaseDto)BeanCopyUtil.copy((Object)dto, BillInfoDto.class), dto.getPageNum(), dto.getPageSize());
    }

    public RestResponse<Long> addBillInfo(@RequestBody BillInfoReqDto addReqDto) {
        return new RestResponse((Object)this.service.addBillInfo(addReqDto));
    }

    public RestResponse<Void> modifyBillInfo(@RequestBody BillInfoReqDto modifyReqDto) {
        this.service.modifyBillInfo(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeBillInfo(@PathVariable(value="ids") String ids, @RequestParam(value="instanceId") Long instanceId) {
        this.service.removeBillInfo(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<BatchOperationRespDto> auditBillInfo(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.auditBillInfo(billFlowNoList));
    }

    public RestResponse<BatchOperationRespDto> addOrderInvoice(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.addOrderInvoice(billFlowNoList));
    }

    public RestResponse<BatchOperationRespDto> redOrderInvoice(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.redOrderInvoice(billFlowNoList));
    }

    public RestResponse<BatchOperationRespDto> cancelBillInfo(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.cancelBillInfo(billFlowNoList));
    }

    public RestResponse<BatchOperationRespDto> paperInvoicePrint(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.paperInvoicePrint(billFlowNoList));
    }

    public RestResponse<BatchOperationRespDto> modifyOrderInvoice(@RequestBody List<BillModifyReqDto> billModifyReqDtos) {
        return new RestResponse((Object)this.service.modifyOrderInvoice(billModifyReqDtos));
    }

    public RestResponse<BatchOperationRespDto> updateStatusQueryInvoiceList(List<BillModifyReqDto> billModifyReqDtos) {
        return new RestResponse((Object)this.service.updateStatusQueryInvoiceList(billModifyReqDtos));
    }

    public RestResponse<BatchOperationRespDto> cancelChangeRedInvoice(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.cancelChangeRedInvoice(billFlowNoList));
    }

    public RestResponse<BatchOperationRespDto> failedReInvoicing(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.failedReInvoicing(billFlowNoList));
    }

    public RestResponse<Void> userSystemRedOrCancel(List<String> platformOrderNoList) {
        this.service.userSystemRedOrCancel(platformOrderNoList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchAuditBillByPlatform(List<String> platformOrderNoList) {
        this.service.batchAuditBillByPlatform(platformOrderNoList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> againInvoice(AgainInvoiceQueryDto againInvoiceQueryDto) {
        this.service.againInvoice(againInvoiceQueryDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> redisDataUpdateDatabase(String type) {
        this.service.redisDataUpdateDatabase(type);
        return RestResponse.VOID;
    }

    public RestResponse<Void> backPassPlatformInvoice(String billFlowNo) {
        this.service.backPassPlatformInvoice(billFlowNo);
        return RestResponse.VOID;
    }

    public RestResponse<List<String>> batchBackPassPlatformInvoice(List<String> billFlowNoList) {
        return new RestResponse((Object)this.service.batchBackPassPlatformInvoice(billFlowNoList));
    }

    public RestResponse<BillInfoRespDto> queryById(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.service.queryById(id));
    }

    public RestResponse<List<BillInfoRespDto>> queryByBillFlowNos(List<String> billFlowNos) {
        return new RestResponse((Object)this.service.queryByBillFlowNos(billFlowNos));
    }

    public RestResponse<Void> cancelInvoice(List<String> billFlowNos, String cancelReason) {
        this.service.cancelInvoice(billFlowNos, cancelReason);
        return RestResponse.VOID;
    }

    public RestResponse<BillInfoRespDto> queryByBillFlowNo(String billFlowNo) {
        return new RestResponse((Object)this.service.queryByBillFlowNo(billFlowNo));
    }

    public RestResponse<List<BillInfoRespDto>> queryByBillFlowNoList(BillInfoListQueryDto billInfoListQueryDto) {
        return new RestResponse((Object)this.service.queryByBillFlowNoList(billInfoListQueryDto));
    }

    public RestResponse<PageInfo<BillInfoRespDto>> queryByPage(@RequestBody BillInfoQueryDto billInfoQueryDto) {
        return new RestResponse((Object)this.service.queryByPage(billInfoQueryDto));
    }

    public RestResponse<Map<String, BigDecimal>> queryTotal(BillInfoQueryDto billInfoQueryDto) {
        return new RestResponse((Object)this.service.queryTotalAmount(billInfoQueryDto));
    }

    public RestResponse<PageInfo<BillItemExportDto>> queryBillItemList(BillInfoQueryDto billInfoQueryDto) {
        return new RestResponse((Object)this.service.queryBillItemList(billInfoQueryDto));
    }

    public RestResponse<PageInfo<InvoiceItemRespDto>> queryItemByPage(@RequestBody InvoiceItemQueryDto invoiceItemDto) {
        return new RestResponse((Object)this.service.queryItemByPage(invoiceItemDto));
    }

    public RestResponse<PageInfo<BillInfoRespDto>> queryBillAndItemByPage(@RequestBody BillInfoQueryDto billInfoQueryDto) {
        return new RestResponse((Object)this.service.queryBillAndItemByPage(billInfoQueryDto));
    }

    public RestResponse<String> getInvoicePdf(String billFlowNo) {
        return new RestResponse((Object)this.service.getInvoicePdf(billFlowNo));
    }

    public RestResponse<BillInfoRespDto> queryBillDetailByApplyNo(String applyNo) {
        return new RestResponse((Object)this.service.queryBillDetailByApplyNo(applyNo));
    }

    public RestResponse<PageInfo<BillInfoReportRespDto>> queryBillInfoReportPage(BillInfoReportQueryDto billInfoReportQueryDto) {
        return new RestResponse((Object)this.service.queryBillInfoReportPage(billInfoReportQueryDto));
    }

    public RestResponse<PageInfo<BillItemReportRespDto>> queryBillItemReportPage(BillInfoReportQueryDto billInfoReportQueryDto) {
        return new RestResponse((Object)this.service.queryBillItemReportPage(billInfoReportQueryDto));
    }

    public RestResponse<BillInfoRespDto> queryBillInfoByPlatformOrderNo(String platformOrderNo) {
        return new RestResponse((Object)this.service.queryBillInfoByPlatformOrderNo(platformOrderNo));
    }

    public RestResponse<PageInfo<BillItemReportRespDto>> queryBillItemReportNewPage(BillInfoReportQueryDto billInfoReportQueryDto) {
        return new RestResponse((Object)this.service.queryBillItemReportNewPage(billInfoReportQueryDto));
    }

    public RestResponse<Boolean> generateBillInfo(BillInfoGenerateReqDto reqDto) {
        return new RestResponse((Object)this.service.generateBillInfo(reqDto));
    }

    public RestResponse<Void> syncInvoiceResult(CallBackInvoiceInfoReqDto invoiceInfoRespDto) {
        this.service.syncInvoiceResult(invoiceInfoRespDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> syncModiyInvoiceInfo(String platformOrderNo) {
        this.modifyInvoiceInfoRedPushConsumer.syncModiyInvoiceInfo(platformOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<InvoiceVerificationRespDto>> queryVerificationByPage(InvoiceVerificationQueryDto invoiceVerificationQueryDto) {
        return new RestResponse((Object)this.service.queryVerificationByPage(invoiceVerificationQueryDto));
    }

    public RestResponse<Void> reGenerateBillInfo(List<String> platformOrderNos) {
        this.service.reGenerateBillInfo(platformOrderNos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchReissue(BatchReissueDto req) {
        this.service.batchReissue(req);
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<BillInfoRespDto>> queryPageList(BillInfoQueryDto billInfoQueryDto) {
        return new RestResponse((Object)this.service.queryPageList(billInfoQueryDto));
    }

    public RestResponse<Void> batchAuditWaitAuditBlueBill(List<String> platformOrderNos) {
        this.service.batchAuditWaitAuditBlueBill(platformOrderNos);
        return RestResponse.VOID;
    }
}

