/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.rest.entity;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.api.entity.IBillItemApi;
import com.yunxi.dg.base.center.finance.dto.entity.BillItemDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillItemPageReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillItemReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IBillItemService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u6837\u672c\u4e2d\u5fc3:\u53d1\u7968\u5546\u54c1\u8868\u63a5\u53e3\u670d\u52a1"})
@RequestMapping(value={"/v1/bill/item"})
public class BillItemController
implements IBillItemApi {
    @Resource
    private IBillItemService service;

    public RestResponse<Long> insert(@RequestBody BillItemDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    public RestResponse update(@RequestBody BillItemDto dto) {
        return this.service.update((BaseDto)dto);
    }

    public RestResponse<BillItemDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    public RestResponse<PageInfo<BillItemDto>> page(@RequestBody BillItemPageReqDto dto) {
        return this.service.page((BaseDto)BeanCopyUtil.copy((Object)dto, BillItemDto.class), dto.getPageNum(), dto.getPageSize());
    }

    public RestResponse<Long> addBillItem(@RequestBody BillItemReqDto addReqDto) {
        return new RestResponse((Object)this.service.addBillItem(addReqDto));
    }

    public RestResponse<Void> modifyBillItem(@RequestBody BillItemReqDto modifyReqDto) {
        this.service.modifyBillItem(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateBillItem(List<BillItemReqDto> billItemReqDtoList) {
        this.service.updateBillItem(billItemReqDtoList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeBillItem(@PathVariable(value="ids") String ids, @RequestParam(value="instanceId") Long instanceId) {
        this.service.removeBillItem(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<BillItemRespDto> queryById(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.service.queryById(id));
    }

    public RestResponse<List<BillItemRespDto>> queryItemByBillFlowNo(BillItemQueryDto billItemQueryDto) {
        return new RestResponse((Object)this.service.queryItemByBillFlowNo(billItemQueryDto));
    }

    public RestResponse<PageInfo<BillItemRespDto>> queryByPage(BillItemQueryDto billItemQueryDto) {
        return new RestResponse((Object)this.service.queryByPage(billItemQueryDto));
    }
}

