/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.base.Throwables;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="autoGenerateBillTask")
public class AutoGenerateBillTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(AutoGenerateBillTask.class);
    @Resource
    private IReconciliationService reconciliationService;
    @Resource
    private IReconciliationRuleService ruleService;

    public void before(TaskMsg taskMsg) {
        log.info("=========\u5f00\u59cb\u5ba2\u6237\u5bf9\u8d26\u4efb\u52a1==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        log.info("=========\u5ba2\u6237\u5bf9\u8d26\u4efb\u52a1\u6267\u884c\u4e2d==========");
        try {
            this.autoGenerateBill("auto_generate_bill");
            this.autoAuditBill("auto_audit_bill");
            this.autoPublishBill("auto_publish_bill");
            this.autoConfirm("auto_confirm");
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u5bf9\u8d26\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
            boolean bl = true;
            return bl;
        }
        finally {
            return true;
        }
    }

    public void after(TaskMsg taskMsg) {
        log.info("=========\u7ed3\u675f\u5ba2\u6237\u5bf9\u8d26\u4efb\u52a1==========");
    }

    private void autoGenerateBill(String ruleStrategy) {
        try {
            this.reconciliationService.autoGenerateCustomerBill(ruleStrategy);
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void autoAuditBill(String ruleStrategy) {
        try {
            this.reconciliationService.autoAuditOrPublishBill(ruleStrategy);
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5ba1\u6838\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void autoPublishBill(String ruleStrategy) {
        try {
            this.reconciliationService.autoAuditOrPublishBill(ruleStrategy);
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u53d1\u5e03\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void autoConfirm(String ruleStrategy) {
        try {
            this.reconciliationService.autoConfirm(ruleStrategy);
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u786e\u8ba4\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

