/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.finance.dto.entity.AutoGenerateKeepOrderQueryDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.service.entity.ISyncKeepAccountingService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AutoGenerateKeepOrderTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(AutoGenerateKeepOrderTask.class);
    @Resource
    private ISyncKeepAccountingService syncKeepAccountingService;

    public void before(TaskMsg taskMsg) {
        String reqId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        log.info("1\u3001=========\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5355\u4efb\u52a1==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        log.info("2\u3001========>\u6267\u884c\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5355\u4efb\u52a1\u6267\u884c\u4e2d");
        try {
            this.autoSaleKeepOrder();
            log.info("\u6267\u884c\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5355\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
        catch (Exception e) {
            log.warn("\u6267\u884c\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5355\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public void after(TaskMsg taskMsg) {
        log.info("3\u3001=========\u7ed3\u675f\u6267\u884c\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5355\u4efb\u52a1==========");
    }

    private void autoSaleKeepOrder() {
        AutoGenerateKeepOrderQueryDto queryDto = new AutoGenerateKeepOrderQueryDto();
        queryDto.setCurrent("yes");
        try {
            queryDto.setOrderType(BillTypeEnum.SALE_LIST.getCode());
            queryDto.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            this.syncKeepAccountingService.autotoGenerateKeepOrder(queryDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            queryDto.setOrderType(BillTypeEnum.SALE_LIST.getCode());
            queryDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
            this.syncKeepAccountingService.autotoGenerateKeepOrder(queryDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            queryDto.setOrderType(BillTypeEnum.RETURN_BASE.getCode());
            queryDto.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            this.syncKeepAccountingService.autotoGenerateKeepOrder(queryDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            queryDto.setOrderType(BillTypeEnum.RETURN_BASE.getCode());
            queryDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
            this.syncKeepAccountingService.autotoGenerateKeepOrder(queryDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            queryDto.setOrderType(BillTypeEnum.EXCHANGE.getCode());
            queryDto.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            this.syncKeepAccountingService.autotoGenerateKeepOrder(queryDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            queryDto.setOrderType(BillTypeEnum.EXCHANGE.getCode());
            queryDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
            this.syncKeepAccountingService.autotoGenerateKeepOrder(queryDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            queryDto.setOrderType(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode());
            queryDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
            queryDto.setCurrent("yes");
            this.syncKeepAccountingService.autotoGenerateKeepOrder(queryDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u751f\u6210\u8bb0\u8d26\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

