/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.ISingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillBusinessRelPlatformDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.INoKeepBillDas;
import com.yunxi.dg.base.center.finance.dao.mapper.NoKeepBillMapper;
import com.yunxi.dg.base.center.finance.dto.enums.NoKeepBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.RelBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.BillBusinessRelPlatformEo;
import com.yunxi.dg.base.center.finance.eo.NoKeepBillEo;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.mq.GenerateInvoiceInfoByAfterOrderConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BookKeepForBillAfterTask
implements ISingleTupleScheduleEvent {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private GenerateInvoiceInfoByAfterOrderConsumer generateInvoiceInfoByAfterOrderConsumer;
    @Resource
    private IBillBusinessRelPlatformDas billBusinessRelPlatformDas;
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IAfterSaleOrderDas afterSaleOrderDas;
    @Resource
    private INoKeepBillDas noKeepBillDas;
    @Resource
    private NoKeepBillMapper noKeepBillMapper;

    public void before(TaskMsg taskMsg) {
        this.logger.info("=========\u5f00\u59cb\u6267\u884c\u552e\u540e\u672a\u8bb0\u8d26\u5b8c\u6210\u7684\u5f85\u5f00\u7968\u8ba2\u5355\u4efb\u52a1==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        this.logger.info("========>\u552e\u540e\u672a\u8bb0\u8d26\u5b8c\u6210\u7684\u5f85\u5f00\u7968\u8ba2\u5355\u4efb\u52a1\u6267\u884c\u4e2d");
        try {
            PageInfo noKeepBillEoPageInfo;
            Integer pageNum = 1;
            do {
                Object list;
                if (CollectionUtils.isNotEmpty((Collection)(noKeepBillEoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.noKeepBillDas.filter().eq((Object)"business_type", (Object)NoKeepBillTypeEnum.AFTER.getCode())).orderByDesc((Object)"id")).page(pageNum, Integer.valueOf(1000))).getList())) {
                    list = noKeepBillEoPageInfo.getList();
                    this.noKeepBillAgainInvoice((List<NoKeepBillEo>)list);
                }
                list = pageNum;
                Integer n = pageNum = Integer.valueOf(pageNum + 1);
            } while (pageNum <= noKeepBillEoPageInfo.getPages());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.info("\u552e\u540e\u672a\u8bb0\u8d26\u5b8c\u6210\u7684\u5f85\u5f00\u7968\u8ba2\u5355\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            this.logger.info("\u5220\u9664\u72b6\u6001\u5df2\u7ecf\u5f00\u7968\u8bb0\u8d26\u7684\u5355\u53f7");
            QueryWrapper deleteWrapper = new QueryWrapper();
            deleteWrapper.eq((Object)"status", (Object)1);
            deleteWrapper.eq((Object)"business_type", (Object)NoKeepBillTypeEnum.AFTER.getCode());
            this.noKeepBillMapper.delete((Wrapper)deleteWrapper);
            this.logger.info("\u552e\u540e\u672a\u8bb0\u8d26\u5b8c\u6210\u7684\u5f85\u5f00\u7968\u8ba2\u5355\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
    }

    public void noKeepBillAgainInvoice(List<NoKeepBillEo> eoList) {
        Map<String, List<NoKeepBillEo>> map = eoList.stream().collect(Collectors.groupingBy(NoKeepBillEo::getBusinessOrderNo));
        List bookList = eoList.stream().map(NoKeepBillEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(bookList)) {
            List allKeepOrderRespDtos;
            List subList;
            int length;
            int i = 0;
            for (length = bookList.size(); length > 400; length -= 400) {
                subList = bookList.subList(i, i + 400);
                allKeepOrderRespDtos = this.pushKeepAccountsService.queryIsBookkeepByAfterSaleOrderNo(subList);
                if (CollectionUtils.isNotEmpty((Collection)allKeepOrderRespDtos)) {
                    allKeepOrderRespDtos.forEach(keep -> {
                        if (1 == keep.getCompleteKeep()) {
                            AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().eq((Object)"after_sale_order_no", (Object)keep.getOrderNo())).one();
                            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"platform_order_no", (Object)afterSaleOrderEo.getPlatformOrderNo())).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list();
                            if (CollectionUtils.isNotEmpty((Collection)list)) {
                                List billFlowNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                                List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
                                if (CollectionUtils.isNotEmpty((Collection)billInfoList)) {
                                    this.generateInvoiceInfoByAfterOrderConsumer.platformOrderInvoice(billInfoList, afterSaleOrderEo.getPlatformOrderNo(), afterSaleOrderEo.getAfterSaleOrderType());
                                } else {
                                    this.logger.info("\u672a\u5f00\u7968\u4e0d\u9700\u8981\u5904\u7406");
                                }
                            }
                            if (map.containsKey(keep.getOrderNo())) {
                                List noKeepBillEoList = (List)map.get(keep.getOrderNo());
                                noKeepBillEoList.forEach(eo -> {
                                    NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                                    noKeepBillEo.setId(eo.getId());
                                    noKeepBillEo.setStatus(Integer.valueOf(1));
                                    this.noKeepBillDas.updateSelective((BaseEo)noKeepBillEo);
                                });
                            }
                        }
                    });
                }
                i += 400;
            }
            if (length > 0 && CollectionUtils.isNotEmpty((Collection)(allKeepOrderRespDtos = this.pushKeepAccountsService.queryIsBookkeepByAfterSaleOrderNo(subList = bookList.subList(i, i + length))))) {
                allKeepOrderRespDtos.forEach(keep -> {
                    if (1 == keep.getCompleteKeep()) {
                        AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().eq((Object)"after_sale_order_no", (Object)keep.getOrderNo())).one();
                        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"platform_order_no", (Object)afterSaleOrderEo.getPlatformOrderNo())).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list();
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            List billFlowNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                            List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
                            if (CollectionUtils.isNotEmpty((Collection)billInfoList)) {
                                this.generateInvoiceInfoByAfterOrderConsumer.platformOrderInvoice(billInfoList, afterSaleOrderEo.getPlatformOrderNo(), afterSaleOrderEo.getAfterSaleOrderType());
                            } else {
                                this.logger.info("\u672a\u5f00\u7968\u4e0d\u9700\u8981\u5904\u7406");
                            }
                        }
                        if (map.containsKey(keep.getOrderNo())) {
                            List noKeepBillEoList = (List)map.get(keep.getOrderNo());
                            noKeepBillEoList.forEach(eo -> {
                                NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                                noKeepBillEo.setId(eo.getId());
                                noKeepBillEo.setStatus(Integer.valueOf(1));
                                this.noKeepBillDas.updateSelective((BaseEo)noKeepBillEo);
                            });
                        }
                    }
                });
            }
        }
    }

    public void after(TaskMsg taskMsg) {
        this.logger.info("=========\u7ed3\u675f\u552e\u540e\u672a\u8bb0\u8d26\u5b8c\u6210\u7684\u5f85\u5f00\u7968\u8ba2\u5355\u4efb\u52a1==========");
    }
}

