/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.ISyncKeepAccountingService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepAccountRuleFactory;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="saleOrderKeepAccountingTask")
public class SaleOrderKeepAccountingTask
extends SingleTupleScheduleEvent {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private ISyncKeepAccountingService syncKeepAccountingService;
    @Resource
    private IOrderRuleService orderRuleService;
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;
    @Value(value="${task.days.interval:1}")
    private Integer taskDaysInterval;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void before(TaskMsg taskMsg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        if (!this.extractedVaildTime()) {
            return true;
        }
        this.logger.info("\u9500\u552e\u5355\u5b9a\u65f6\u8bb0\u8d26\u4efb\u52a1\u542f\u52a8\uff1a{}", (Object)taskMsg.getContent());
        String reqId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        ServiceContext.getContext().setAttachment("yes.req.userCode", "system");
        this.logger.info("\u9500\u552e\u5355\u5b9a\u65f6\u8bb0\u8d26\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        try {
            MamualKeepAccountReqDto mamualKeepAccountReqDto = new MamualKeepAccountReqDto();
            this.extractedInitParam(mamualKeepAccountReqDto);
            this.logger.info("=================\u5f00\u59cb\u5904\u7406\u9500\u552e\u5355\u8bb0\u8d26\u5355\u5165\u5e93\u6570\u636e===================,{}", (Object)JSON.toJSONString((Object)mamualKeepAccountReqDto));
            KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), BillTypeEnum.SALE_LIST.getCode());
            keepNodeRuleParam.getParamReqDto().setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            keepNodeRuleParam.setAction(true);
            List keepNodeRules = KeepAccountRuleFactory.getSaleKeepNodeRuleList((String)VoucherTypeEnum.DELIVERY.getCode(), (String)BillTypeEnum.SALE_LIST.getCode(), (String)this.keepSystem);
            keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("\u9500\u552e\u5355\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.logger.info("\u9500\u552e\u5355\u8bb0\u8d26\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
    }

    private void extractedInitParam(MamualKeepAccountReqDto mamualKeepAccountReqDto) {
        mamualKeepAccountReqDto.setType(KeepTypeEnum.AUTO.getCode());
        mamualKeepAccountReqDto.setVoucherType("2");
        mamualKeepAccountReqDto.setBillShopType("1");
        LocalDate currentDate = LocalDate.now();
        LocalDate earlierDate = currentDate.minusDays(this.taskDaysInterval.intValue());
        LocalDateTime startTime = LocalDateTime.of(earlierDate, LocalTime.MIN);
        LocalDateTime endTime = LocalDateTime.of(currentDate, LocalTime.MAX);
        String dateString = startTime.format(FORMATTER);
        String format = endTime.format(FORMATTER);
        mamualKeepAccountReqDto.setStartTime(dateString);
        mamualKeepAccountReqDto.setEndTime(format);
    }

    private boolean extractedVaildTime() {
        Date date = new Date();
        OrderRuleRespDto orderRuleRespDto = this.orderRuleService.selectOrderRule();
        if (orderRuleRespDto.getAccountType().equals("REAL_TIME")) {
            return false;
        }
        String billTime = orderRuleRespDto.getBillTime();
        LocalTime billLocalTime = LocalTime.parse(billTime);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        boolean hourMatch = localDateTime.getHour() == billLocalTime.getHour();
        boolean minuteMatch = localDateTime.getMinute() == billLocalTime.getMinute();
        boolean isMatch = hourMatch && minuteMatch;
        return isMatch;
    }

    public void after(TaskMsg taskMsg) {
    }
}

