/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushPlatformStateEnum;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderSnapshotEo;
import com.yunxi.dg.base.center.finance.service.entity.ICallBackPassPlatformInvoiceService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.pull.dto.IinvoiceItemsReqDto;
import com.yunxi.dg.base.center.pull.dto.IinvoiceUploadReqDto;
import com.yunxi.dg.base.center.pull.proxy.IInvoiceChannelApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CallBackPassPlatformInvoiceServiceImpl
implements ICallBackPassPlatformInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(CallBackPassPlatformInvoiceServiceImpl.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private IInvoiceChannelApiProxy iInvoiceChannelApiProxy;
    @Resource
    private IPerformOrderSnapshotDomain iPerformOrderSnapshotDomain;
    @Resource
    private IPerformOrderInfoDomain iPerformOrderInfoDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void callBackChannelInvoiceInfo(String billFlowNo) {
        BillInfoEo updateInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billFlowNo)).one();
        String saleOrderCreate = this.billInfoDas.getOrderLabelInfo(updateInfoEo.getPlatformOrderNo(), "SALE_ORDER_CREATE");
        log.info("\u67e5\u8be2\u5904\u7406\u56de\u4f20\u5e73\u53f0\u5355\u636e\uff1a{}", JSON.toJSON((Object)updateInfoEo));
        if (!BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(updateInfoEo.getBillType())) {
            log.info("\u975e\u84dd\u7968\u4e0d\u9700\u8981\u5904\u7406:{},{}", (Object)updateInfoEo.getPlatformOrderNo(), (Object)updateInfoEo.getBillFlowNo());
            return;
        }
        List performOrderInfoEos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)updateInfoEo.getPlatformOrderNo())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)performOrderInfoEos), String.format("\u3010%s\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f", updateInfoEo.getPlatformOrderNo()));
        List collect = performOrderInfoEos.stream().filter(x -> 1 == x.getOrderSource()).collect(Collectors.toList());
        List orderIds = performOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List orderLabelRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderLabelRecordDomain.filter().in((Object)"order_id", orderIds)).eq((Object)"label_code", (Object)"SALE_ORDER_CREATE")).list();
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordEos) && CollectionUtils.isEmpty(collect)) {
            log.info("\u8bf4\u660e\u662f\u624b\u5de5\uff0c\u4e0d\u9700\u8981\u5904\u7406 \u6216\u8005\u975e\u84dd\u7968:{}", (Object)updateInfoEo.getBillFlowNo(), (Object)updateInfoEo.getPlatformOrderNo());
            return;
        }
        try {
            IinvoiceUploadReqDto reqDto = this.buildInvoiceUploadReqDto(updateInfoEo);
            log.info("\u53d1\u8d77\u8bf7\u6c42\u56de\u8c03\u5e73\u53f0\u5165\u53c2=\u300b{}", (Object)JSONUtil.toJsonStr((Object)updateInfoEo));
            RestResponse restResp = this.iInvoiceChannelApiProxy.invoiceUpload(reqDto);
            log.info("\u56de\u8c03\u7ed3\u679c=\u300b{}", (Object)JSONUtil.toJsonStr((Object)restResp));
            String code = restResp.getResultCode();
            if ("0".equals(code)) {
                updateInfoEo.setPushPlatformState(PushPlatformStateEnum.SUCCESS.getCode());
                updateInfoEo.setPushPlatformError("");
            } else {
                updateInfoEo.setPushPlatformState(PushPlatformStateEnum.FAIL.getCode());
                updateInfoEo.setPushPlatformError(restResp.getResultMsg());
            }
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u5e73\u53f0\u53d1\u7968\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            updateInfoEo.setPushPlatformState(PushPlatformStateEnum.FAIL.getCode());
            updateInfoEo.setPushPlatformError(e.getMessage());
        }
        finally {
            this.billInfoDas.updateSelective((BaseEo)updateInfoEo);
        }
    }

    private IinvoiceUploadReqDto buildInvoiceUploadReqDto(BillInfoEo infoEo) {
        List performOrderInfoEos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)infoEo.getPlatformOrderNo())).list();
        PerformOrderInfoEo performOrderInfoEo = (PerformOrderInfoEo)performOrderInfoEos.get(0);
        List snapshotEoList = ((ExtQueryChainWrapper)this.iPerformOrderSnapshotDomain.filter().eq((Object)"order_id", (Object)performOrderInfoEo.getId())).list();
        PerformOrderSnapshotEo performOrderSnapshotEo = (PerformOrderSnapshotEo)snapshotEoList.get(0);
        IinvoiceUploadReqDto reqDto = new IinvoiceUploadReqDto();
        reqDto.setChannelCode(performOrderSnapshotEo.getSiteCode());
        reqDto.setShopCode(performOrderSnapshotEo.getShopCode());
        reqDto.setPlatformOrderNo(infoEo.getPlatformOrderNo());
        reqDto.setReceiverTaxNo(infoEo.getDistributorTaxesCode());
        reqDto.setReceiverName(infoEo.getEntityName());
        reqDto.setInvoiceNo(infoEo.getExternalInvoiceNo());
        reqDto.setInvoiceCode(infoEo.getExternalInvoiceCode());
        reqDto.setIvcTitle(infoEo.getBillTitle());
        reqDto.setRegisteredAddress(infoEo.getRegisteredAddress());
        reqDto.setRegisteredPhone(infoEo.getRegisteredPhone());
        reqDto.setBankAccount(infoEo.getBankAccount());
        reqDto.setBank(infoEo.getBank());
        reqDto.setPayerRegisterNo(infoEo.getTaxesCode());
        reqDto.setTotalPrice(infoEo.getInvoiceAmount());
        reqDto.setInvoiceTime(DateUtil.format((Date)infoEo.getExternalInvoiceTime()));
        reqDto.setPdfUrl(StrUtil.isNotBlank((CharSequence)infoEo.getUploadPdfUrl()) ? infoEo.getUploadPdfUrl() : infoEo.getInvoiceConnectUrl());
        reqDto.setInvoiceKind(this.convertPlatformInvoiceType(infoEo.getInvoiceType()));
        reqDto.setBusinessType(Integer.valueOf(infoEo.getTitleType().equals("person") ? 0 : 1));
        this.buildInvoiceItems(infoEo, reqDto);
        return reqDto;
    }

    private void buildInvoiceItems(BillInfoEo infoEo, IinvoiceUploadReqDto reqDto) {
        List billItemEoList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)infoEo.getBillFlowNo())).list(Integer.valueOf(Integer.MAX_VALUE));
        ArrayList<IinvoiceItemsReqDto> invoiceItems = new ArrayList<IinvoiceItemsReqDto>();
        for (BillItemEo billItemEo : billItemEoList) {
            IinvoiceItemsReqDto dto = IinvoiceItemsReqDto.builder().taxRate(billItemEo.getTaxRate()).tax(billItemEo.getTaxAmount()).price(billItemEo.getUnitPrice()).quantity(Integer.valueOf(billItemEo.getQuantity().intValue())).sumPrice(billItemEo.getAmount().subtract(billItemEo.getTaxAmount())).amount(billItemEo.getAmount()).itemNo(billItemEo.getTaxClassificationCode()).itemName(billItemEo.getItemName()).build();
            invoiceItems.add(dto);
            reqDto.setSumPrice(reqDto.getSumPrice().add(dto.getSumPrice()));
            reqDto.setSumTax(reqDto.getSumTax().add(billItemEo.getTaxAmount()));
        }
        reqDto.setInvoiceItems(invoiceItems);
    }

    private Integer convertPlatformInvoiceType(String invoiceType) {
        switch (invoiceType) {
            case "electronic_general_invoice": {
                return 0;
            }
            case "paper_general_invoice": {
                return 1;
            }
            case "special_paper_invoice": {
                return 2;
            }
            case "electronic_special_invoice": {
                return 3;
            }
            case "all_electronic_general_invoice": {
                return 4;
            }
            case "all_electronic_special_invoice": {
                return 5;
            }
            case "num_electronic_special_paper_invoice": {
                return 6;
            }
            case "num_electronic_paper_general_invoice": {
                return 7;
            }
        }
        return 0;
    }
}

