/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.connector.dynamic.api.IDynamicIKeepAccountBillSyncApiOpenApi;
import com.dtyunxi.yundt.connector.dynamic.api.dto.KeepAccountBillReqDto;
import com.dtyunxi.yundt.connector.dynamic.api.dto.KeepAccountBillRespDto;
import com.dtyunxi.yundt.cube.center.outPartSys.proxy.finance.IFinanceDealOutInterfaceApiProxy;
import com.dtyunxi.yundt.cube.center.trade.proxy.aftersale.IDgAfterSaleOrderQueryApiProxy;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.PushKeepAccountsConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyShopDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepDetailMappingDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepItemRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepOutResultDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IOrderRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepInternalOrderDas;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepAccountsDetailMapper;
import com.yunxi.dg.base.center.finance.dao.vo.AllKeepOrderVo;
import com.yunxi.dg.base.center.finance.dao.vo.BillKeepAccountReqVo;
import com.yunxi.dg.base.center.finance.dao.vo.KeepQueryConditionVo;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPushKeepAccountsAmountDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPushKeepAccountsDomain;
import com.yunxi.dg.base.center.finance.dto.ModifySalesAreaSalesDepartmentDto;
import com.yunxi.dg.base.center.finance.dto.PushKeepAccountDetailVo;
import com.yunxi.dg.base.center.finance.dto.PushKeepAccountVo;
import com.yunxi.dg.base.center.finance.dto.PushOutsideSysAccountDto;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.common.FinanceConstant;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepAccountsAmountDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepAccountsDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalUpdateOrderDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BalanceProcessingResultEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillShopTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BookKeepingType;
import com.yunxi.dg.base.center.finance.dto.enums.FinanceExceptionCode;
import com.yunxi.dg.base.center.finance.dto.enums.FinanceItemTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepResultEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.PushStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.YesOrNoEnum;
import com.yunxi.dg.base.center.finance.dto.mq.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.finance.dto.request.BatchModifyPushKeepAccount;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillPlatormOrderReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BookKeepingRemarkReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BookKeepingRepairReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepAccountsDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepQueryConditionDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepTimeOutReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeKeepAccountingReqDto;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.ModifyCustomerReqDto;
import com.yunxi.dg.base.center.finance.dto.request.OrderKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.OrderRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.request.PushKeepAccountsReqDto;
import com.yunxi.dg.base.center.finance.dto.request.RuleParamReqDto;
import com.yunxi.dg.base.center.finance.dto.request.SapKeepConditionReqDto;
import com.yunxi.dg.base.center.finance.dto.request.UpdateKeepVoucherDto;
import com.yunxi.dg.base.center.finance.dto.response.AllKeepOrderRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoKeepAccountRespDto;
import com.yunxi.dg.base.center.finance.dto.response.HandlerAuditRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderKeepAccountDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.dto.response.PushKeepAccountsRespDto;
import com.yunxi.dg.base.center.finance.dto.response.RetryKeepReqDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyShopEo;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepOutResultDetailEo;
import com.yunxi.dg.base.center.finance.eo.OrderRuleEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsAmountEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepInternalOrderEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IFianceInsiderTransactionService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepNodeCommonService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepTimeOutService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepInternalOrderService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.entity.ISyncKeepAccountingService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.logistics.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.logistics.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.openapi.dto.anjier.PostSalesTableMoveJsDto;
import com.yunxi.dg.base.center.openapi.dto.anjier.PostSalesTableMoveJsReqDto;
import com.yunxi.dg.base.center.openapi.dto.anjier.PostSalesTableOutJsDto;
import com.yunxi.dg.base.center.openapi.dto.anjier.PostSalesTableRtJsDto;
import com.yunxi.dg.base.center.openapi.dto.anjier.PostSalesTableRtOutJsDto;
import com.yunxi.dg.base.center.openapi.dto.anjier.SalesTableAtJsDto;
import com.yunxi.dg.base.center.openapi.dto.param.PortalSalesTable;
import com.yunxi.dg.base.center.openapi.dto.param.PortalSalesTableDto;
import com.yunxi.dg.base.center.openapi.dto.param.PortalSalesTableOut;
import com.yunxi.dg.base.center.openapi.dto.param.PortalSalesTableRt;
import com.yunxi.dg.base.center.openapi.dto.param.PortalSalesTableRtDto;
import com.yunxi.dg.base.center.openapi.dto.param.PortalSalesTableRtOutDto;
import com.yunxi.dg.base.center.openapi.dto.response.SalesTableAtJsRespDto;
import com.yunxi.dg.base.center.openapi.proxy.erp.ISaleOrderErpApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PushKeepAccountsServiceImpl
extends BaseServiceImpl<PushKeepAccountsDto, PushKeepAccountsEo, IPushKeepAccountsDomain>
implements IPushKeepAccountsService {
    private static final Logger log = LoggerFactory.getLogger(PushKeepAccountsServiceImpl.class);
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IFinanceDealOutInterfaceApiProxy financeDealOutInterfaceApiProxy;
    @Resource
    private IKeepNodeCommonService keepNodeCommonService;
    @Resource
    private IDynamicIKeepAccountBillSyncApiOpenApi dynamicIKeepAccountBillSyncApiOpenApi;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private IKeepNodeCommonService iKeepNodeCommonService;
    @Resource
    private ISaleOrderErpApiProxy saleOrderErpApiProxy;
    @Resource
    private IPushKeepAccountsDomain pushKeepAccountsDomain;
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IKeepOutResultDetailDas keepOutResultDetailDas;
    @Resource
    private IPushKeepAccountsDetailDas pushKeepAccountsDetailDas;
    @Resource
    private IKeepItemRuleDas keepItemRuleDas;
    @Resource
    private ILockService lockService;
    @Resource
    private IBillStrategyDas billStrategyDas;
    @Resource
    private IOrderRuleService orderRuleService;
    @Resource
    private IBillStrategyShopDas billStrategyShopDas;
    @Resource
    private IKeepDetailMappingDas keepDetailMappingDas;
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IKeepTimeOutService keepTimeOutService;
    @Resource
    private IPushKeepAccountsAmountDomain pushKeepAccountsAmountDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IShopService shopService;
    @Resource
    private IOrderRuleDas orderRuleDas;
    @Resource
    private IPushKeepInternalOrderDas internalOrderDas;
    @Resource
    private IFianceInsiderTransactionService fianceInsiderTransactionService;
    @Resource
    private IKeepAccountsDetailDomain keepAccountsDetailDomain;
    @Resource
    private IPushKeepInternalOrderService pushKeepInternalOrderService;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private ISyncKeepAccountingService syncKeepAccountingService;
    @Resource
    private IDgAfterSaleOrderQueryApiProxy afterSaleOrderQueryApiProxy;
    @Resource
    private IPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    private static final String TABLENAME_SAP = "push_sap_keep";
    private static final String DELETE_KEEP = "delete_keep";
    private int size = 1000;
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;
    private static final Pattern TIME_PART = Pattern.compile("\\s[0-9]{2}:[0-9]{2}:[0-9]{2}$");

    public PushKeepAccountsServiceImpl(IPushKeepAccountsDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PushKeepAccountsDto, PushKeepAccountsEo> converter() {
        return PushKeepAccountsConverter.INSTANCE;
    }

    @Override
    public Long addPushKeepAccounts(PushKeepAccountsReqDto addReqDto) {
        PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pushKeepAccountsEo);
        this.pushKeepAccountsDas.insert((BaseEo)pushKeepAccountsEo);
        return pushKeepAccountsEo.getId();
    }

    @Override
    public void modifyPushKeepAccounts(PushKeepAccountsReqDto modifyReqDto) {
        PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)pushKeepAccountsEo);
        this.pushKeepAccountsDas.updateSelective((BaseEo)pushKeepAccountsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePushKeepAccounts(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.pushKeepAccountsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PushKeepAccountsRespDto queryById(Long id) {
        PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)this.pushKeepAccountsDas.selectByPrimaryKey(id);
        PushKeepAccountsRespDto pushKeepAccountsRespDto = new PushKeepAccountsRespDto();
        DtoHelper.eo2Dto((BaseEo)pushKeepAccountsEo, (BaseVo)pushKeepAccountsRespDto);
        return pushKeepAccountsRespDto;
    }

    @Override
    public PageInfo<PushKeepAccountsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PushKeepAccountsReqDto pushKeepAccountsReqDto = (PushKeepAccountsReqDto)com.alibaba.fastjson.JSON.parseObject((String)filter, PushKeepAccountsReqDto.class);
        PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
        DtoHelper.dto2Eo((BaseVo)pushKeepAccountsReqDto, (BaseEo)pushKeepAccountsEo);
        PageInfo eoPageInfo = this.pushKeepAccountsDomain.selectPage((BaseEo)pushKeepAccountsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PushKeepAccountsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<String, BigDecimal> queryTotal(KeepQueryConditionDto conditionDto) {
        log.info("\u4ea4\u8d27\u5f00\u7968\u6570\u91cf\u91d1\u989d\u6c47\u603b\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)conditionDto));
        if (Objects.nonNull(conditionDto) && (Objects.nonNull(conditionDto.getItemCode()) || Objects.nonNull(conditionDto.getSaleNo()) || Objects.nonNull(conditionDto.getPlatformOrderNo()) || CollectionUtil.isNotEmpty((Collection)conditionDto.getItemCodes()) || CollectionUtil.isNotEmpty((Collection)conditionDto.getPlatformOrderNos()))) {
            Set<String> chargeCodes = this.getChargeCodes(conditionDto.getItemCode(), conditionDto.getSaleNo(), conditionDto.getPlatformOrderNos(), conditionDto.getPlatformOrderNo(), conditionDto.getItemCodes());
            if (CollectionUtil.isEmpty(chargeCodes)) {
                return Maps.newHashMap();
            }
            if (CollectionUtil.isNotEmpty((Collection)conditionDto.getChargeCodes())) {
                ArrayList<String> codes = new ArrayList<String>();
                for (String chargeCode : conditionDto.getChargeCodes()) {
                    if (!chargeCodes.contains(chargeCode)) continue;
                    codes.add(chargeCode);
                }
                if (CollectionUtil.isEmpty(codes)) {
                    return Maps.newHashMap();
                }
                conditionDto.setChargeCodes(codes);
            } else {
                conditionDto.setChargeCodes(new ArrayList<String>(chargeCodes));
            }
        }
        ExtQueryChainWrapper sqlFilters = this.pushKeepAccountsDas.filter().select(new String[]{"item_num,item_price,order_type"});
        this.queryCondition((ExtQueryChainWrapper<PushKeepAccountsEo>)sqlFilters, conditionDto);
        HashMap resultMap = Maps.newHashMap();
        List pushKeepAccountsEos = sqlFilters.list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pushKeepAccountsEos)) {
            resultMap.put("sumItemNum", BigDecimal.ZERO);
            resultMap.put("sumItemPrice", BigDecimal.ZERO);
            return resultMap;
        }
        Integer saleItemNum = 0;
        BigDecimal saleSumItemPrice = BigDecimal.ZERO;
        List keepAccountsEos = pushKeepAccountsEos.stream().filter(x -> null != x.getItemNum() && BillTypeEnum.SALE_LIST.getCode().equals(x.getOrderType())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(keepAccountsEos)) {
            saleItemNum = keepAccountsEos.stream().filter(x -> null != x.getItemNum()).map(PushKeepAccountsEo::getItemNum).reduce(Integer::sum).get();
            saleSumItemPrice = keepAccountsEos.stream().filter(x -> null != x.getItemPrice()).map(PushKeepAccountsEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(4, 4);
        }
        log.info("\u6b63\u5411\u8bb0\u8d26\u5355\u5408\u8ba1:saleItemNum:{},saleSumItemPrice:{}", (Object)saleItemNum, (Object)saleSumItemPrice);
        Integer afterItemNum = 0;
        BigDecimal afterSumItemPrice = BigDecimal.ZERO;
        List accountsEos = pushKeepAccountsEos.stream().filter(x -> null != x.getItemNum() && !BillTypeEnum.SALE_LIST.getCode().equals(x.getOrderType())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(accountsEos)) {
            afterItemNum = accountsEos.stream().filter(x -> null != x.getItemNum()).map(PushKeepAccountsEo::getItemNum).reduce(Integer::sum).get();
            afterSumItemPrice = accountsEos.stream().filter(x -> null != x.getItemPrice()).map(PushKeepAccountsEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(4, 4);
        }
        log.info("\u9006\u5411\u8bb0\u8d26\u5355\u5408\u8ba1:afterItemNum:{},afterSumItemPrice:{}", (Object)afterItemNum, (Object)afterSumItemPrice);
        BigDecimal sumItemNum = BigDecimal.ZERO;
        sumItemNum = sumItemNum.add(new BigDecimal(saleItemNum)).add(0 == afterItemNum ? BigDecimal.ZERO : new BigDecimal(afterItemNum).negate());
        BigDecimal sumItemPrice = BigDecimal.ZERO;
        sumItemPrice = sumItemPrice.add(saleSumItemPrice).add(afterSumItemPrice.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : afterSumItemPrice.negate());
        log.info("\u8bb0\u8d26\u5355\u6570\u91cf\uff0c\u91d1\u989d\u6c47\u603b\uff1asumItemNum{}\uff0csumItemPrice\uff1a{}", (Object)sumItemNum, (Object)sumItemPrice);
        resultMap.put("sumItemNum", sumItemNum);
        resultMap.put("sumItemPrice", sumItemPrice);
        return resultMap;
    }

    @Override
    public PageInfo<PushKeepAccountsRespDto> queryPage(KeepQueryConditionDto conditionDto, Integer pageNum, Integer pageSize) {
        log.info("KeepQueryConditionDto\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)conditionDto));
        PageInfo dtoPageInfo = new PageInfo();
        if (Objects.nonNull(conditionDto) && (Objects.nonNull(conditionDto.getItemCode()) || Objects.nonNull(conditionDto.getSaleNo()) || Objects.nonNull(conditionDto.getPlatformOrderNo()) || CollectionUtil.isNotEmpty((Collection)conditionDto.getItemCodes()) || CollectionUtil.isNotEmpty((Collection)conditionDto.getPlatformOrderNos()))) {
            Set<String> chargeCodes = this.getChargeCodes(conditionDto.getItemCode(), conditionDto.getSaleNo(), conditionDto.getPlatformOrderNos(), conditionDto.getPlatformOrderNo(), conditionDto.getItemCodes());
            if (CollectionUtil.isEmpty(chargeCodes)) {
                return dtoPageInfo;
            }
            if (CollectionUtil.isNotEmpty((Collection)conditionDto.getChargeCodes())) {
                ArrayList<String> codes = new ArrayList<String>();
                for (String chargeCode : conditionDto.getChargeCodes()) {
                    if (!chargeCodes.contains(chargeCode)) continue;
                    codes.add(chargeCode);
                }
                if (CollectionUtil.isEmpty(codes)) {
                    return dtoPageInfo;
                }
                conditionDto.setChargeCodes(codes);
            } else {
                conditionDto.setChargeCodes(new ArrayList<String>(chargeCodes));
            }
        }
        ExtQueryChainWrapper sqlFilters = this.pushKeepAccountsDas.filter();
        this.queryCondition((ExtQueryChainWrapper<PushKeepAccountsEo>)sqlFilters, conditionDto);
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List<String> chargeCodes = eoPageInfo.getList().stream().map(PushKeepAccountsEo::getChargeCode).distinct().collect(Collectors.toList());
            Map<String, List<KeepAccountsDetailEo>> keepAccountsDetailsMap = this.getKeepAccountsDetailsMap(chargeCodes);
            Map<String, List<PushKeepAccountsAmountEo>> pushKeepAccountsAmountMap = this.getKeepAccountsAmountMap(chargeCodes);
            ArrayList<PushKeepAccountsRespDto> keepAccountsRespDtos = new ArrayList<PushKeepAccountsRespDto>();
            for (PushKeepAccountsEo v : eoPageInfo.getList()) {
                List<KeepAccountsDetailEo> list;
                PushKeepAccountsRespDto keepAccountsRespDto = new PushKeepAccountsRespDto();
                CubeBeanUtils.copyProperties((Object)keepAccountsRespDto, (Object)v, (String[])new String[0]);
                keepAccountsRespDto.setOrderTypeName(BillTypeEnum.getDesc((String)v.getOrderType()));
                keepAccountsRespDto.setVoucherTypeName(VoucherTypeEnum.getDesc((String)v.getVoucherType()));
                keepAccountsRespDto.setKeepingResultName(KeepResultEnum.getDesc((String)v.getKeepingResult()));
                keepAccountsRespDto.setWarehouseName(v.getWarehouseName());
                keepAccountsRespDto.setCrossOrganizationalTransactionName(StrUtil.isNotBlank((CharSequence)keepAccountsRespDto.getCrossOrganizationalTransaction()) ? ("yes".equalsIgnoreCase(keepAccountsRespDto.getCrossOrganizationalTransaction()) ? "\u662f" : "\u5426") : "");
                keepAccountsRespDto.setQuantity(v.getItemNum() + "");
                if (null != v.getItemNum()) {
                    keepAccountsRespDto.setItemNum(Integer.valueOf(v.getItemNum()));
                }
                keepAccountsRespDto.setFailResult(v.getReason());
                keepAccountsRespDto.setDeliveryPushTime(v.getDeliveryPushTime());
                keepAccountsRespDto.setInvoicePushTime(v.getInvoicePushTime());
                if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), v.getVoucherType())) {
                    keepAccountsRespDto.setChargeAccountName(v.getChargeAccountName());
                } else if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), v.getVoucherType())) {
                    keepAccountsRespDto.setChargeAccountName(v.getBillAccountName());
                }
                List<PushKeepAccountsAmountEo> pushKeepAccountsAmountEos = pushKeepAccountsAmountMap.get(v.getChargeCode());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(pushKeepAccountsAmountEos)) {
                    ArrayList dtos = new ArrayList();
                    CubeBeanUtils.copyCollection(dtos, pushKeepAccountsAmountEos, PushKeepAccountsAmountDto.class);
                    keepAccountsRespDto.setPushKeepAccountsAmountDtos(dtos);
                }
                if (!CollectionUtil.isEmpty(keepAccountsDetailsMap) && org.apache.commons.collections.CollectionUtils.isNotEmpty(list = keepAccountsDetailsMap.get(v.getChargeCode()))) {
                    Optional firstElement = list.stream().findFirst();
                    firstElement.ifPresent(e -> {
                        keepAccountsRespDto.setPlatformCreateTime(e.getPlatformCreateTime());
                        keepAccountsRespDto.setSaleOrderType(e.getSaleOrderType());
                    });
                    String orderNos = list.stream().filter(e -> null != e.getOrderNo()).map(KeepAccountsDetailEo::getOrderNo).distinct().collect(Collectors.joining(","));
                    String platformOrderNos = list.stream().filter(e -> null != e.getPlatformOrderNo()).map(KeepAccountsDetailEo::getPlatformOrderNo).distinct().collect(Collectors.joining(","));
                    keepAccountsRespDto.setPlatformNo(platformOrderNos);
                    keepAccountsRespDto.setInnerOrderNo(orderNos);
                    keepAccountsRespDto.setRefundDifference(BigDecimal.ZERO);
                }
                if (StringUtils.isNotBlank((CharSequence)v.getBalanceProcessingResult())) {
                    keepAccountsRespDto.setBalanceProcessingResult(BalanceProcessingResultEnum.getDesc((String)v.getBalanceProcessingResult()));
                }
                keepAccountsRespDtos.add(keepAccountsRespDto);
            }
            dtoPageInfo.setList(keepAccountsRespDtos);
        }
        return dtoPageInfo;
    }

    private Map<String, List<KeepAccountsDetailEo>> getKeepAccountsDetailsMap(List<String> chargeCodes) {
        HashMap keepAccountsDetailsMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(chargeCodes)) {
            List keepAccountsDetailEos;
            int length;
            int i = 0;
            for (length = chargeCodes.size(); length > this.size; length -= this.size) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + this.size))).list();
                keepAccountsDetailsMap.putAll(keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode)));
                i += this.size;
            }
            if (length > 0) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).list();
                keepAccountsDetailsMap.putAll(keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode)));
            }
        }
        return keepAccountsDetailsMap;
    }

    private Map<String, List<PushKeepAccountsAmountEo>> getKeepAccountsAmountMap(List<String> chargeCodes) {
        HashMap<String, List<PushKeepAccountsAmountEo>> pushKeepAccountsAmountMap = new HashMap<String, List<PushKeepAccountsAmountEo>>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(chargeCodes)) {
            List amountEos;
            int length;
            int i = 0;
            for (length = chargeCodes.size(); length > this.size; length -= this.size) {
                amountEos = ((ExtQueryChainWrapper)this.pushKeepAccountsAmountDomain.filter().in((Object)"charge_code", chargeCodes.subList(i, i + this.size))).list();
                pushKeepAccountsAmountMap.putAll(amountEos.stream().collect(Collectors.groupingBy(PushKeepAccountsAmountEo::getChargeCode)));
                i += this.size;
            }
            if (length > 0) {
                amountEos = ((ExtQueryChainWrapper)this.pushKeepAccountsAmountDomain.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).list();
                pushKeepAccountsAmountMap.putAll(amountEos.stream().collect(Collectors.groupingBy(PushKeepAccountsAmountEo::getChargeCode)));
            }
        }
        return pushKeepAccountsAmountMap;
    }

    @Override
    public PageInfo<BillInfoKeepAccountRespDto> billKeepReportByPage(BillInfoKeepAccountReqDto billInfoKeepAccountReqDto, Integer pageNum, Integer pageSize) {
        log.info("\u53d1\u7968\u8bb0\u8d26\u62a5\u8868\u8bf7\u6c42\u53c2\u6570\uff1a{},{},{}", new Object[]{com.alibaba.fastjson.JSON.toJSONString((Object)billInfoKeepAccountReqDto), pageNum, pageSize});
        if (Objects.isNull(billInfoKeepAccountReqDto)) {
            return new PageInfo();
        }
        if (Objects.isNull(billInfoKeepAccountReqDto.getStartChargeDate()) && Objects.isNull(billInfoKeepAccountReqDto.getEndChargeDate()) && Objects.isNull(billInfoKeepAccountReqDto.getExternalInvoiceStartTime()) && Objects.isNull(billInfoKeepAccountReqDto.getExternalInvoiceEndTime()) && Objects.isNull(billInfoKeepAccountReqDto.getDivergence()) && Objects.isNull(billInfoKeepAccountReqDto.getToCBill()) && Objects.isNull(billInfoKeepAccountReqDto.getPlatformOrderNo())) {
            return new PageInfo();
        }
        BillKeepAccountReqVo keepAccountReqVo = new BillKeepAccountReqVo();
        keepAccountReqVo.setPlatformOrderNo(billInfoKeepAccountReqDto.getPlatformOrderNo());
        if (Objects.nonNull(billInfoKeepAccountReqDto.getStartChargeDate())) {
            keepAccountReqVo.setStartChargeDate(billInfoKeepAccountReqDto.getStartChargeDate() + " 00:00");
        }
        if (Objects.nonNull(billInfoKeepAccountReqDto.getEndChargeDate())) {
            keepAccountReqVo.setEndChargeDate(billInfoKeepAccountReqDto.getEndChargeDate() + " 23:59");
        }
        if (Objects.nonNull(billInfoKeepAccountReqDto.getExternalInvoiceStartTime())) {
            keepAccountReqVo.setExternalInvoiceStartTime(billInfoKeepAccountReqDto.getExternalInvoiceStartTime() + " 00:00");
        }
        if (Objects.nonNull(billInfoKeepAccountReqDto.getExternalInvoiceEndTime())) {
            keepAccountReqVo.setExternalInvoiceEndTime(billInfoKeepAccountReqDto.getExternalInvoiceEndTime() + " 23:59");
        }
        if (Objects.nonNull(billInfoKeepAccountReqDto) && Objects.nonNull(billInfoKeepAccountReqDto.getToCBill())) {
            List list = ((ExtQueryChainWrapper)this.billStrategyDas.filter().eq((Object)"strategy_status", (Object)"enable")).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                List id = list.stream().map(BaseEo::getId).collect(Collectors.toList());
                List billStrategyShopEoList = ((ExtQueryChainWrapper)this.billStrategyShopDas.filter().in((Object)"bill_strategy_id", id)).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyShopEoList)) {
                    List shopCodes = billStrategyShopEoList.stream().map(BillStrategyShopEo::getShopCode).distinct().collect(Collectors.toList());
                    keepAccountReqVo.setShopCodes(shopCodes);
                }
            }
            if (1 == billInfoKeepAccountReqDto.getToCBill()) {
                keepAccountReqVo.setToShop("shop_yes");
            } else if (0 == billInfoKeepAccountReqDto.getToCBill()) {
                keepAccountReqVo.setToShop("shop_no");
            }
        }
        if (Objects.nonNull(billInfoKeepAccountReqDto) && Objects.nonNull(billInfoKeepAccountReqDto.getDivergence())) {
            if (1 == billInfoKeepAccountReqDto.getDivergence()) {
                keepAccountReqVo.setFlag("divergence_yes");
            } else if (0 == billInfoKeepAccountReqDto.getDivergence()) {
                keepAccountReqVo.setFlag("divergence_no");
            }
        }
        PageInfo eoPageInfo = this.pushKeepAccountsDas.billKeepReportByPage(keepAccountReqVo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List dtoList = eoPageInfo.getList().stream().map(v -> {
                BillInfoKeepAccountRespDto respDto = new BillInfoKeepAccountRespDto();
                respDto.setShopCode(v.getShopCode());
                respDto.setShopName(v.getShopName());
                respDto.setCustomerCode(v.getCustomerCode());
                respDto.setCustomerName(v.getCustomerName());
                respDto.setPlatformNo(v.getPlatformNo());
                respDto.setZxKeepAmount(v.getZxKeepAmount());
                respDto.setNxKeepAmount(v.getNxKeepAmount());
                respDto.setTotalKeepAmount(v.getTotalKeepAmount());
                respDto.setAmount(v.getAmount());
                respDto.setKeepAndBillAmount(v.getKeepAndBillAmount());
                respDto.setDivergence(v.getDivergence());
                respDto.setEnterprise(v.getEnterprise());
                return respDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(dtoList);
        }
        return dtoPageInfo;
    }

    @Override
    public PageInfo<OrderKeepAccountDetailRespDto> queryDetailsByPage(KeepQueryConditionDto conditionDto, Integer pageNum, Integer pageSize) {
        if (Objects.isNull(conditionDto)) {
            throw new BizException("id\u548c\u8bb0\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"id", (Object)conditionDto.getId())).one();
        if (Objects.isNull(pushKeepAccountsEo)) {
            throw new BizException("\u8bb0\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        ExtQueryChainWrapper sqlFilters = this.keepAccountsDetailDas.filter();
        sqlFilters.eq((Object)"charge_code", (Object)conditionDto.getChargeCode());
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List orderKeepAccountDetailRespDtos = eoPageInfo.getList().stream().map(v -> {
                OrderKeepAccountDetailRespDto detailRespDto = new OrderKeepAccountDetailRespDto();
                detailRespDto.setId(v.getId());
                detailRespDto.setOrderNo(v.getOrderNo());
                detailRespDto.setChargeDate(v.getChargeDate());
                detailRespDto.setVoucherType(pushKeepAccountsEo.getVoucherType());
                if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), v.getVoucherType())) {
                    detailRespDto.setChargeAccountName(v.getChargeAccountName());
                } else if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), v.getVoucherType())) {
                    detailRespDto.setChargeAccountName(v.getBillAccountName());
                }
                detailRespDto.setDeliveryNote(v.getDeliveryNote());
                detailRespDto.setSaleNo(v.getSaleNo());
                detailRespDto.setPostingNo(v.getPostingNo());
                detailRespDto.setInvoiceNo(v.getInvoiceNo());
                detailRespDto.setCustomerCode(v.getCustomerCode());
                detailRespDto.setWarehouseCode(v.getWarehouseCode());
                if (Objects.equals("virtual", v.getWarehouseCode())) {
                    detailRespDto.setWarehouseCode(null);
                }
                detailRespDto.setItemCode(v.getItemCode());
                detailRespDto.setNum(v.getItemNum());
                detailRespDto.setObtain(v.getObtainIntegal());
                detailRespDto.setConsume(v.getConsumeIntegal());
                detailRespDto.setIssueNo(v.getIntegralIssueNo());
                detailRespDto.setConsumeNo(v.getIntegralConsumeNo());
                detailRespDto.setAmount(v.getItemPrice());
                detailRespDto.setPrice(v.getItemPrice());
                detailRespDto.setOrderType(v.getOrderType());
                detailRespDto.setOrderTypeName(BillTypeEnum.getDesc((String)v.getOrderType()));
                detailRespDto.setXfPurchaseOrderNo(v.getXfPurchaseOrderNo());
                detailRespDto.setXfReceiveOrderNo(v.getXfReceiveOrderNo());
                detailRespDto.setXfSalesOrderNo(v.getXfSalesOrderNo());
                detailRespDto.setGroupPurchaseOrderNo(v.getGroupPurchaseOrderNo());
                detailRespDto.setGroupReceiveOrder(v.getGroupReceiveOrder());
                detailRespDto.setCrossOrganizationalTransaction(v.getCrossOrganizationalTransaction());
                detailRespDto.setCrossOrganizationalTransactionName(StrUtil.isNotBlank((CharSequence)v.getCrossOrganizationalTransaction()) ? ("yes".equalsIgnoreCase(v.getCrossOrganizationalTransaction()) ? "\u662f" : "\u5426") : "");
                return detailRespDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(orderKeepAccountDetailRespDtos);
        }
        return dtoPageInfo;
    }

    @Override
    public List<PushKeepAccountsRespDto> queryList(KeepQueryConditionDto conditionDto) {
        ArrayList result = Lists.newArrayList();
        if (Objects.nonNull(conditionDto) && (Objects.nonNull(conditionDto.getItemCode()) || Objects.nonNull(conditionDto.getSaleNo()) || Objects.nonNull(conditionDto.getPlatformOrderNo()) || CollectionUtil.isNotEmpty((Collection)conditionDto.getPlatformOrderNos()) || CollectionUtil.isNotEmpty((Collection)conditionDto.getItemCodes()))) {
            Set<String> chargeCodes = this.getChargeCodes(conditionDto.getItemCode(), conditionDto.getSaleNo(), conditionDto.getPlatformOrderNos(), conditionDto.getPlatformOrderNo(), conditionDto.getItemCodes());
            if (CollectionUtil.isEmpty(chargeCodes)) {
                return result;
            }
            if (CollectionUtil.isNotEmpty((Collection)conditionDto.getChargeCodes())) {
                ArrayList<String> codes = new ArrayList<String>();
                for (String chargeCode : conditionDto.getChargeCodes()) {
                    if (!chargeCodes.contains(chargeCode)) continue;
                    codes.add(chargeCode);
                }
                if (CollectionUtil.isEmpty(codes)) {
                    return result;
                }
                conditionDto.setChargeCodes(codes);
            } else {
                conditionDto.setChargeCodes(new ArrayList<String>(chargeCodes));
            }
        }
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().orderByDesc((Object)"id");
        this.queryCondition((ExtQueryChainWrapper<PushKeepAccountsEo>)sqlFilters, conditionDto);
        PageInfo pageInfo = sqlFilters.page(Integer.valueOf(1), Integer.valueOf(1000));
        result.addAll(this.assembleExportVo(pageInfo.getList()));
        int pageNo = (int)Math.ceil(Double.valueOf(pageInfo.getTotal()) / Double.valueOf(1000.0));
        for (int i = 2; i < pageNo; ++i) {
            PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), Integer.valueOf(1000));
            result.addAll(this.assembleExportVo(eoPageInfo.getList()));
        }
        return result;
    }

    public void queryCondition(ExtQueryChainWrapper<PushKeepAccountsEo> sqlFilters, KeepQueryConditionDto conditionDto) {
        if (Objects.nonNull(conditionDto)) {
            StringBuilder sql;
            if (Objects.nonNull(conditionDto.getChargeCode())) {
                sqlFilters.like((Object)"charge_code", (Object)conditionDto.getChargeCode());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getChargeCodes())) {
                if (conditionDto.getChargeCodes().size() > 1) {
                    sqlFilters.in((Object)"charge_code", (Collection)conditionDto.getChargeCodes());
                } else {
                    sqlFilters.like((Object)"charge_code", conditionDto.getChargeCodes().get(0));
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getLineOrderTypes())) {
                HashSet orderTypes = new HashSet();
                conditionDto.getLineOrderTypes().forEach(v -> {
                    if (0 == v) {
                        orderTypes.add(BillTypeEnum.SALE_LIST.getCode());
                    }
                    if (1 == v) {
                        orderTypes.addAll(Arrays.asList(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode(), BillTypeEnum.RETURN_BASE.getCode(), BillTypeEnum.EXCHANGE.getCode()));
                    }
                });
                sqlFilters.in((Object)"order_type", new ArrayList(orderTypes));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getOrderNos())) {
                if (conditionDto.getOrderNos().size() > 1) {
                    sql = new StringBuilder();
                    sql.append("( ");
                    List orderNos = conditionDto.getOrderNos();
                    for (int i = 0; i < orderNos.size(); ++i) {
                        String orderNo = (String)orderNos.get(i);
                        sql.append("FIND_IN_SET('").append(orderNo).append("', order_no)");
                        if (i >= orderNos.size() - 1) continue;
                        sql.append(" OR ");
                    }
                    sql.append(" )");
                    sqlFilters.apply(sql.toString(), new Object[0]);
                } else {
                    sqlFilters.like((Object)"order_no", conditionDto.getOrderNos().get(0));
                }
            }
            if (Objects.nonNull(conditionDto.getStartTime())) {
                sqlFilters.ge((Object)"charge_date", (Object)(conditionDto.getStartTime() + " 00:00:00"));
            }
            if (Objects.nonNull(conditionDto.getEndTime())) {
                sqlFilters.le((Object)"charge_date", (Object)(conditionDto.getEndTime() + " 23:59:59"));
            }
            if (Objects.nonNull(conditionDto.getOrderType())) {
                sqlFilters.eq((Object)"order_type", (Object)conditionDto.getOrderType());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getOrderTypes())) {
                sqlFilters.in((Object)"order_type", (Collection)conditionDto.getOrderTypes());
            }
            if (Objects.nonNull(conditionDto.getVoucherType())) {
                sqlFilters.eq((Object)"voucher_type", (Object)conditionDto.getVoucherType());
            }
            if (Objects.nonNull(conditionDto.getGenerateStartTime())) {
                sqlFilters.ge((Object)"generate_time", (Object)(conditionDto.getGenerateStartTime() + " 00:00:00"));
            }
            if (Objects.nonNull(conditionDto.getGenerateEndTime())) {
                sqlFilters.le((Object)"generate_time", (Object)(conditionDto.getGenerateEndTime() + " 23:59:59"));
            }
            if (Objects.nonNull(conditionDto.getKeepingResult())) {
                sqlFilters.eq((Object)"keeping_result", (Object)conditionDto.getKeepingResult());
            }
            if (Objects.nonNull(conditionDto.getCustomerCode())) {
                sqlFilters.like((Object)"customer_code", (Object)conditionDto.getCustomerCode());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getCustomerCodeList())) {
                sqlFilters.in((Object)"customer_code", (Collection)conditionDto.getCustomerCodeList());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getCustomerCodeList())) {
                if (conditionDto.getCustomerCodeList().size() > 1) {
                    sqlFilters.in((Object)"customer_code", (Collection)conditionDto.getCustomerCodeList());
                } else {
                    sqlFilters.eq((Object)"customer_code", conditionDto.getCustomerCodeList().get(0));
                }
            }
            if (Objects.nonNull(conditionDto.getWarehouseCode())) {
                sqlFilters.like((Object)"warehouse_code", (Object)conditionDto.getWarehouseCode());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getWarehouseCodeList())) {
                sqlFilters.in((Object)"warehouse_code", (Collection)conditionDto.getWarehouseCodeList());
            }
            if (Objects.nonNull(conditionDto.getAccountingResult())) {
                sqlFilters.in((Object)"accounting_result", new Object[]{conditionDto.getAccountingResult()});
            }
            if (Objects.nonNull(conditionDto.getSaleNo())) {
                sqlFilters.like((Object)"sale_no", (Object)conditionDto.getSaleNo());
            }
            if (Objects.nonNull(conditionDto.getDeliveryNote())) {
                sqlFilters.like((Object)"delivery_note", (Object)conditionDto.getDeliveryNote());
            }
            if (Objects.nonNull(conditionDto.getPostingNo())) {
                sqlFilters.like((Object)"posting_no", (Object)conditionDto.getPostingNo());
            }
            if (Objects.nonNull(conditionDto.getInvoiceNo())) {
                sqlFilters.like((Object)"invoice_no", (Object)conditionDto.getInvoiceNo());
            }
            if (StrUtil.isNotBlank((CharSequence)conditionDto.getDocumentNo())) {
                sqlFilters.eq((Object)"document_no", (Object)conditionDto.getDocumentNo());
            }
            if (Objects.nonNull(conditionDto.getChargeAccountName())) {
                sql = new StringBuilder();
                sql.append(" ( ");
                sql.append("charge_account_name like '%" + conditionDto.getChargeAccountName() + "%' or bill_account_name like '%" + conditionDto.getChargeAccountName() + "%'");
                sql.append(")");
                sqlFilters.apply(sql.toString(), new Object[0]);
            }
            if (Objects.nonNull(conditionDto.getDeliveryTimeStart())) {
                String deliveryTimeStart = conditionDto.getDeliveryTimeStart();
                if (!this.hasTimePart(deliveryTimeStart)) {
                    deliveryTimeStart = deliveryTimeStart + " 00:00:00";
                }
                sqlFilters.ge((Object)"delivery_time", (Object)deliveryTimeStart);
            }
            if (Objects.nonNull(conditionDto.getDeliveryTimeEnd())) {
                String deliveryTimeEnd = conditionDto.getDeliveryTimeEnd();
                if (!this.hasTimePart(deliveryTimeEnd)) {
                    deliveryTimeEnd = deliveryTimeEnd + " 23:59:59";
                }
                sqlFilters.le((Object)"delivery_time", (Object)deliveryTimeEnd);
            }
            if (Objects.nonNull(conditionDto.getCompleteTimeStart())) {
                String completeTimeStart = conditionDto.getCompleteTimeStart();
                if (!this.hasTimePart(completeTimeStart)) {
                    completeTimeStart = completeTimeStart + " 00:00:00";
                }
                sqlFilters.ge((Object)"complete_time", (Object)completeTimeStart);
            }
            if (Objects.nonNull(conditionDto.getCompleteTimeEnd())) {
                String completeTimeEnd = conditionDto.getCompleteTimeEnd();
                if (!this.hasTimePart(completeTimeEnd)) {
                    completeTimeEnd = completeTimeEnd + " 23:59:59";
                }
                sqlFilters.le((Object)"complete_time", (Object)completeTimeEnd);
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getSiteCode())) {
                sqlFilters.like((Object)"site_code", (Object)conditionDto.getSiteCode());
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getSiteName())) {
                sqlFilters.like((Object)"site_name", (Object)conditionDto.getSiteName());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getSiteCodes())) {
                sqlFilters.in((Object)"site_code", (Collection)conditionDto.getSiteCodes());
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getShopCode())) {
                sqlFilters.like((Object)"shop_code", (Object)conditionDto.getShopCode());
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getShopName())) {
                sqlFilters.like((Object)"shop_name", (Object)conditionDto.getShopName());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getShopCodes())) {
                if (conditionDto.getShopCodes().size() > 1) {
                    sqlFilters.in((Object)"shop_code", (Collection)conditionDto.getShopCodes());
                } else {
                    sqlFilters.eq((Object)"shop_code", conditionDto.getShopCodes().get(0));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getGeneratePerson())) {
                sqlFilters.like((Object)"generate_person", (Object)conditionDto.getGeneratePerson());
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getPushPerson())) {
                sqlFilters.like((Object)"push_person", (Object)conditionDto.getPushPerson());
            }
            if (Objects.equals(BillShopTypeEnum.B.getCode(), conditionDto.getBillShopType())) {
                sqlFilters.eq((Object)"bill_shop_type", (Object)BillShopTypeEnum.B.getCode());
            } else {
                sqlFilters.like((Object)"bill_shop_type", (Object)BillShopTypeEnum.C.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getMasterDeputyIdentity())) {
                sqlFilters.eq((Object)"master_deputy_identity", (Object)conditionDto.getMasterDeputyIdentity());
            }
            if (Objects.nonNull(conditionDto.getCrossOrganizationalTransaction())) {
                sqlFilters.eq((Object)"cross_organizational_transaction", (Object)conditionDto.getCrossOrganizationalTransaction());
            }
            if (CollectionUtil.isNotEmpty((Collection)conditionDto.getXfAndGroupOrderNos())) {
                sqlFilters.and(wrapper -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"xf_sales_order_no", (Collection)conditionDto.getXfAndGroupOrderNos())).or()).in((Object)"xf_purchase_order_no", (Collection)conditionDto.getXfAndGroupOrderNos())).or()).in((Object)"group_purchase_order_no", (Collection)conditionDto.getXfAndGroupOrderNos());
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)conditionDto.getXfAndGroupReceiveOrderNos())) {
                sqlFilters.and(wrapper -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"xf_receive_order_no", (Collection)conditionDto.getXfAndGroupReceiveOrderNos())).or()).in((Object)"group_receive_order", (Collection)conditionDto.getXfAndGroupReceiveOrderNos());
                });
            }
            if (Objects.nonNull(conditionDto.getGroupReceiveOrder())) {
                sqlFilters.like((Object)"group_receive_order", (Object)conditionDto.getGroupReceiveOrder());
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getProvince())) {
                sqlFilters.like((Object)"province", (Object)conditionDto.getProvince());
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getCity())) {
                sqlFilters.like((Object)"city", (Object)conditionDto.getCity());
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getProvinceCode())) {
                sqlFilters.eq((Object)"province_code", (Object)conditionDto.getProvinceCode());
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getCityCode())) {
                sqlFilters.eq((Object)"city_code", (Object)conditionDto.getCityCode());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getProvinceCodes())) {
                if (conditionDto.getProvinceCodes().size() > 1) {
                    sqlFilters.in((Object)"province_code", (Collection)conditionDto.getProvinceCodes());
                } else {
                    sqlFilters.like((Object)"province_code", conditionDto.getProvinceCodes().get(0));
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getCityCodes())) {
                if (conditionDto.getCityCodes().size() > 1) {
                    sqlFilters.in((Object)"city_code", (Collection)conditionDto.getCityCodes());
                } else {
                    sqlFilters.like((Object)"city_code", conditionDto.getCityCodes().get(0));
                }
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getSaleAreaCode())) {
                sqlFilters.eq((Object)"sale_area_code", (Object)conditionDto.getSaleAreaCode());
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getSaleAreaName())) {
                sqlFilters.like((Object)"sale_area_name", (Object)conditionDto.getCity());
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getSaleDeptCode())) {
                sqlFilters.eq((Object)"sale_dept_code", (Object)conditionDto.getSaleDeptCode());
            }
            if (Objects.nonNull(conditionDto) && StringUtils.isNotBlank((CharSequence)conditionDto.getSaleDeptName())) {
                sqlFilters.like((Object)"sale_dept_name", (Object)conditionDto.getSaleDeptName());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getSaleAreaCodes())) {
                if (conditionDto.getSaleAreaCodes().size() > 1) {
                    sqlFilters.in((Object)"sale_area_code", (Collection)conditionDto.getSaleAreaCodes());
                } else {
                    sqlFilters.like((Object)"sale_area_code", conditionDto.getSaleAreaCodes().get(0));
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getSaleDeptCodes())) {
                if (conditionDto.getSaleDeptCodes().size() > 1) {
                    sqlFilters.in((Object)"sale_dept_code", (Collection)conditionDto.getSaleDeptCodes());
                } else {
                    sqlFilters.like((Object)"sale_dept_code", conditionDto.getSaleDeptCodes().get(0));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getPlatformSellerEntityNumber())) {
                sqlFilters.eq((Object)"platform_seller_entity_number", (Object)conditionDto.getPlatformSellerEntityNumber());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getPlatformSellerEntityNumberList())) {
                if (conditionDto.getPlatformSellerEntityNumberList().size() > 1) {
                    sqlFilters.in((Object)"platform_seller_entity_number", (Collection)conditionDto.getPlatformSellerEntityNumberList());
                } else {
                    sqlFilters.like((Object)"platform_seller_entity_number", conditionDto.getPlatformSellerEntityNumberList().get(0));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getRelatedEntityName())) {
                sqlFilters.like((Object)"related_entity_name", (Object)conditionDto.getRelatedEntityName());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getRelatedEntityNumberList())) {
                if (conditionDto.getRelatedEntityNumberList().size() > 1) {
                    sqlFilters.in((Object)"related_entity_number", (Collection)conditionDto.getRelatedEntityNumberList());
                } else {
                    sqlFilters.like((Object)"related_entity_number", conditionDto.getRelatedEntityNumberList().get(0));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getRuleCode())) {
                sqlFilters.eq((Object)"rule_code", (Object)conditionDto.getRuleCode());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getRuleCodeList())) {
                if (conditionDto.getRuleCodeList().size() > 1) {
                    sqlFilters.in((Object)"rule_code", (Collection)conditionDto.getRuleCodeList());
                } else {
                    sqlFilters.like((Object)"rule_code", conditionDto.getRuleCodeList().get(0));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)conditionDto.getOwnEntity())) {
                sqlFilters.eq((Object)"own_entity", (Object)conditionDto.getOwnEntity());
            }
            sqlFilters.in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getChargeAccountCodes()), (Object)"charge_account_code", (Collection)conditionDto.getChargeAccountCodes());
            sqlFilters.in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionDto.getSaleChannelCodes()), (Object)"sale_channel", (Collection)conditionDto.getSaleChannelCodes());
        }
        sqlFilters.orderByDesc((Object)"create_time");
    }

    private boolean hasTimePart(String timeStr) {
        return TIME_PART.matcher(timeStr).find();
    }

    private Set<String> getChargeCodes(String itemCode, String orderNo, List<String> platformOrderNos, String platformOrderNo, List<String> itemCodes) {
        Set<String> chargeCodes = new HashSet<String>();
        List accountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().like(Objects.nonNull(itemCode), (Object)"item_code", (Object)itemCode)).in(CollectionUtil.isNotEmpty(itemCodes), (Object)"item_code", itemCodes)).like(Objects.nonNull(orderNo), (Object)"order_no", (Object)orderNo)).in(CollectionUtil.isNotEmpty(platformOrderNos), (Object)"platform_no", platformOrderNos)).eq(Objects.nonNull(platformOrderNo), (Object)"platform_no", (Object)platformOrderNo)).list();
        if (CollectionUtil.isNotEmpty((Collection)accountsDetailEos)) {
            chargeCodes = accountsDetailEos.stream().filter(e -> Objects.nonNull(e.getChargeCode())).map(KeepAccountsDetailEo::getChargeCode).collect(Collectors.toSet());
        }
        return chargeCodes;
    }

    private List<PushKeepAccountsRespDto> assembleExportVo(List<PushKeepAccountsEo> pushKeepAccountsEos) {
        ArrayList excelDtoList = Lists.newArrayList();
        pushKeepAccountsEos.forEach(v -> {
            PushKeepAccountsRespDto excelDto = new PushKeepAccountsRespDto();
            CubeBeanUtils.copyProperties((Object)excelDto, (Object)v, (String[])new String[0]);
            excelDto.setOrderTypeName(BillTypeEnum.getDesc((String)v.getOrderType()));
            excelDto.setVoucherTypeName(VoucherTypeEnum.getDesc((String)v.getVoucherType()));
            excelDto.setKeepingResultName(KeepResultEnum.getDesc((String)v.getKeepingResult()));
            if (Objects.equals("virtual", v.getWarehouseCode())) {
                excelDto.setWarehouseCode(null);
            }
            excelDtoList.add(excelDto);
        });
        return excelDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateKeepAcountTime(UpdateKeepVoucherDto keepVoucherDto) {
        log.info("\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)keepVoucherDto));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)keepVoucherDto.getIds())) {
            throw new BizException("\u8bf7\u6c42\u8bb0\u5f55ID\u4e0d\u5b58\u5728!");
        }
        if (Objects.isNull(keepVoucherDto.getChargeDate())) {
            throw new BizException("\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<PushKeepAccountsEo> pushKeepAccountsEos = this.getPushAccounts(keepVoucherDto.getIds());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(pushKeepAccountsEos)) {
            throw new BizException("\u8bb0\u8d26\u51ed\u8bc1\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        pushKeepAccountsEos.forEach(v -> {
            if (KeepResultEnum.SUCCESS.getCode().equals(v.getKeepingResult())) {
                throw new BizException("\u8bb0\u8d26\u5355" + v.getChargeCode() + "\u72b6\u6001\u4e3a\u6210\u529f,\u65e0\u6cd5\u4fee\u6539\u8bb0\u8d26\u65e5\u671f");
            }
            if (KeepResultEnum.PUSHING.getCode().equals(v.getKeepingResult())) {
                throw new BizException("\u8bb0\u8d26\u5355" + v.getChargeCode() + "\u72b6\u6001\u4e3a\u63a8\u9001\u4e2d,\u65e0\u6cd5\u4fee\u6539\u8bb0\u8d26\u65e5\u671f");
            }
        });
        List<String> chargeCodes = pushKeepAccountsEos.stream().map(PushKeepAccountsEo::getChargeCode).distinct().collect(Collectors.toList());
        List<KeepAccountsDetailEo> keepAccountsDetailEos = this.getKeepAccountsDetails(chargeCodes);
        ArrayList keepAccountsEos = Lists.newArrayList();
        pushKeepAccountsEos.forEach(v -> {
            PushKeepAccountsEo keepAccountsEo = new PushKeepAccountsEo();
            keepAccountsEo.setId(v.getId());
            keepAccountsEo.setChargeDate(keepVoucherDto.getChargeDate());
            keepAccountsEos.add(keepAccountsEo);
        });
        ArrayList keepAccountsDetailEoList = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
            keepAccountsDetailEo.setId(v.getId());
            keepAccountsDetailEo.setChargeDate(keepVoucherDto.getChargeDate());
            keepAccountsDetailEoList.add(keepAccountsDetailEo);
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsEos)) {
            this.pushKeepAccountsDas.batchUpdateChargeDate((List)keepAccountsEos);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEoList)) {
                this.pushKeepAccountsDas.batchUpdateDetailChargeDate((List)keepAccountsDetailEoList);
            }
        }
        PushKeepInternalOrderReqDto reqDto = new PushKeepInternalOrderReqDto();
        reqDto.setChargeDate(keepVoucherDto.getChargeDate());
        reqDto.setChargeNoList(chargeCodes);
        this.pushKeepInternalOrderService.updateChargeDateByChargeNo(reqDto);
    }

    private List<PushKeepAccountsEo> getPushAccounts(List<Long> ids) {
        ArrayList<PushKeepAccountsEo> list = new ArrayList<PushKeepAccountsEo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(ids)) {
            List pushKeepAccountsEos;
            int length;
            int i = 0;
            for (length = ids.size(); length > FinanceConstant.SIZE; length -= FinanceConstant.SIZE.intValue()) {
                pushKeepAccountsEos = ((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"id", ids.subList(i, i + FinanceConstant.SIZE))).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepAccountsEos)) {
                    list.addAll(pushKeepAccountsEos);
                }
                i += FinanceConstant.SIZE.intValue();
            }
            if (length > 0 && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(pushKeepAccountsEos = ((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"id", ids.subList(i, i + length))).list()))) {
                list.addAll(pushKeepAccountsEos);
            }
        }
        return list;
    }

    private List<KeepAccountsDetailEo> getKeepAccountsDetails(List<String> chargeCodes) {
        ArrayList<KeepAccountsDetailEo> list = new ArrayList<KeepAccountsDetailEo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(chargeCodes)) {
            List detailEoList;
            int length;
            int i = 0;
            for (length = chargeCodes.size(); length > FinanceConstant.SIZE; length -= FinanceConstant.SIZE.intValue()) {
                detailEoList = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().select(new String[]{"id", "charge_code"}).in((Object)"charge_code", chargeCodes.subList(i, i + FinanceConstant.SIZE))).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)detailEoList)) {
                    list.addAll(detailEoList);
                }
                i += FinanceConstant.SIZE.intValue();
            }
            if (length > 0 && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(detailEoList = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().select(new String[]{"id", "charge_code"}).in((Object)"charge_code", chargeCodes.subList(i, i + length))).list()))) {
                list.addAll(detailEoList);
            }
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSavePushKeepAccounts(List<PushKeepAccountsEo> pushKeepAccountsEos) {
        this.pushKeepAccountsDas.insertBatch(pushKeepAccountsEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatchPushKeepAccount(List<PushKeepAccountsReqDto> pushKeepAccountsReqDtos) {
        ArrayList pushKeepAccountsEos = new ArrayList();
        CubeBeanUtils.copyCollection(pushKeepAccountsEos, pushKeepAccountsReqDtos, PushKeepAccountsEo.class);
        this.pushKeepAccountsDas.insertBatch(pushKeepAccountsEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePushKeepAccount(List<PushKeepAccountsReqDto> pushKeepAccountsReqDtos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(pushKeepAccountsReqDtos)) {
            pushKeepAccountsReqDtos.forEach(v -> {
                PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)v.getChargeCode())).eq((Object)"order_type", (Object)BillTypeEnum.TRANSFERS.getCode())).one();
                if (Objects.nonNull(pushKeepAccountsEo)) {
                    pushKeepAccountsEo.setDeliveryNote(v.getDeliveryNote());
                    pushKeepAccountsEo.setSaleNo(v.getSaleNo());
                    pushKeepAccountsEo.setPostingNo(v.getPostingNo());
                    if (null != v.getChargeDate()) {
                        pushKeepAccountsEo.setChargeDate(v.getChargeDate());
                    }
                    this.pushKeepAccountsDas.updateSelective((BaseEo)pushKeepAccountsEo);
                }
            });
        }
    }

    @Override
    public HandlerAuditRespDto retryKeep(List<RetryKeepReqDto> retryKeepReqDtos) {
        log.info("\u8bf7\u6c42\u91cd\u8bd5\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSON.toJSONString(retryKeepReqDtos));
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(retryKeepReqDtos)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (retryKeepReqDtos.size() < 1) {
            return handlerAuditRespDto;
        }
        Long successNum = 0L;
        Long failNum = 0L;
        List idList = retryKeepReqDtos.stream().map(e -> e.getId()).collect(Collectors.toList());
        ArrayList<String> pushResult = new ArrayList<String>();
        pushResult.add(KeepResultEnum.FAIL.getCode());
        pushResult.add(KeepResultEnum.PENDING.getCode());
        List pushKeepAccountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"id", idList)).in((Object)"keeping_result", pushResult)).list();
        if (CollectionUtil.isEmpty((Collection)pushKeepAccountsEos)) {
            return handlerAuditRespDto;
        }
        String voucherType = ((PushKeepAccountsEo)pushKeepAccountsEos.get(0)).getVoucherType();
        Set chargeCodes = pushKeepAccountsEos.stream().map(PushKeepAccountsEo::getChargeCode).collect(Collectors.toSet());
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes)).list();
        List chargeCodeListRetry = keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getChargeCode).collect(Collectors.toList());
        List businessNos = keepAccountsDetailEos.stream().distinct().map(KeepAccountsDetailEo::getBusinessNo).collect(Collectors.toList());
        List detailEoList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(businessNos)) {
            detailEoList = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_no", businessNos)).list();
        }
        HashMap<String, String> outSideSaleOrderNoMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            outSideSaleOrderNoMap = detailEoList.stream().filter(e -> null != e.getOrderNo() && null != e.getSaleNo()).collect(Collectors.toMap(KeepAccountsDetailEo::getOrderNo, KeepAccountsDetailEo::getSaleNo, (k1, k2) -> k1));
        }
        boolean action = true;
        OrderRuleEo orderRuleEo = (OrderRuleEo)this.orderRuleDas.filter().one();
        if (orderRuleEo.getInsiderTransactionAction().equals("yes")) {
            List pushKeepInternalOrderEos = ((ExtQueryChainWrapper)this.internalOrderDas.filter().in((Object)"charge_no", chargeCodeListRetry)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepInternalOrderEos)) {
                List existPushKeepInternal = pushKeepInternalOrderEos.stream().map(PushKeepInternalOrderEo::getChargeNo).collect(Collectors.toList());
                if (existPushKeepInternal.size() != chargeCodeListRetry.size()) {
                    List<KeepAccountsDetailEo> filter = keepAccountsDetailEos.stream().filter(e -> !existPushKeepInternal.contains(e.getChargeCode())).collect(Collectors.toList());
                    action = this.extractedGenerateInternal(filter, orderRuleEo);
                }
            } else {
                action = this.extractedGenerateInternal(keepAccountsDetailEos, orderRuleEo);
            }
        }
        Map<String, PushOutsideSysAccountDto> pushErpMap = this.getStringPushOutsideSysAccountDtoMap(voucherType, keepAccountsDetailEos, outSideSaleOrderNoMap);
        if ("AJR".equals(this.keepSystem) && action) {
            ArrayList<PushOutsideSysAccountDto> hckKeepAccountVos = new ArrayList<PushOutsideSysAccountDto>(pushErpMap.values());
            Set<String> chargeCodeList = pushErpMap.keySet();
            this.pushKeepAccountsService.updateAccountStatusByChargeCodes(chargeCodeList, KeepResultEnum.PUSHING.getCode(), AccountRuleEnum.PUSHING.getCode());
            log.info("retryKeep-\u63a8\u9001ERP\u7684\u6570\u636e\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(hckKeepAccountVos));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hckKeepAccountVos)) {
                Map<String, ShopEo> shopMap = this.getShopMap(hckKeepAccountVos);
                for (PushOutsideSysAccountDto pushOutsideSysAccountDto : hckKeepAccountVos) {
                    try {
                        PushKeepAccountVo vo = pushOutsideSysAccountDto.getPushKeepAccountVo();
                        ShopEo shop = Objects.nonNull(shopMap.get(vo.getShopCode())) ? shopMap.get(vo.getShopCode()) : new ShopEo();
                        log.info("retryKeep-\u63a8\u9001ERP\u6570\u636e\u65f6\u67e5\u8be2\u5e97\u94fa\uff1a{}", com.alibaba.fastjson.JSON.toJSON((Object)shop));
                        vo.setDepartCode(shop.getOrganizationCode());
                        this.pushErp(pushOutsideSysAccountDto);
                        successNum = successNum + 1L;
                    }
                    catch (Exception e2) {
                        failNum = failNum + 1L;
                        e2.printStackTrace();
                        log.info("\u63a8\u9001erp\u5931\u8d25===============>");
                    }
                }
            }
        } else if ("AF".equals(this.keepSystem)) {
            ArrayList<String> chargCodes = new ArrayList<String>(pushErpMap.keySet());
            this.financeDealOutInterfaceApiProxy.pushErp(chargCodes);
            successNum = retryKeepReqDtos.size();
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        return handlerAuditRespDto;
    }

    @NotNull
    private Map<String, PushOutsideSysAccountDto> getStringPushOutsideSysAccountDtoMap(String voucherType, List<KeepAccountsDetailEo> keepAccountsDetailEos, Map<String, String> outSideSaleOrderNoMap) {
        Map<String, List<KeepAccountsDetailEo>> collected = keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode));
        LinkedHashMap pushErpMap = Maps.newLinkedHashMap();
        Map<String, String> finalOutSideSaleOrderNoMap = outSideSaleOrderNoMap;
        collected.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty((Collection)v)) {
                KeepAccountsDetailEo accountsDetailEo = (KeepAccountsDetailEo)v.get(0);
                PushKeepAccountsEo pushKeepAccountsEo = this.iKeepNodeCommonService.initKeepAccounts((List<KeepAccountsDetailEo>)v, voucherType);
                PushOutsideSysAccountDto pushOutsideSysAccountDto = new PushOutsideSysAccountDto();
                PushKeepAccountVo pushKeepAccountVo = new PushKeepAccountVo();
                CubeBeanUtils.copyProperties((Object)pushKeepAccountVo, (Object)pushKeepAccountsEo, (String[])new String[0]);
                ArrayList<PushKeepAccountDetailVo> keepAccountVos = new ArrayList<PushKeepAccountDetailVo>();
                for (KeepAccountsDetailEo detailEo : v) {
                    String s;
                    PushKeepAccountDetailVo temp = new PushKeepAccountDetailVo();
                    CubeBeanUtils.copyProperties((Object)temp, (Object)detailEo, (String[])new String[0]);
                    if (StringUtils.isEmpty((CharSequence)temp.getSaleNo()) && StringUtils.isNotEmpty((CharSequence)(s = (String)finalOutSideSaleOrderNoMap.get(detailEo.getBusinessNo())))) {
                        temp.setSaleNo(s);
                    }
                    keepAccountVos.add(temp);
                }
                pushKeepAccountVo.setItemType(accountsDetailEo.getItemType());
                pushOutsideSysAccountDto.setPushKeepAccountVo(pushKeepAccountVo);
                pushOutsideSysAccountDto.setPushKeepAccountDetailVos(keepAccountVos);
                pushErpMap.put(k, pushOutsideSysAccountDto);
            }
        });
        return pushErpMap;
    }

    private boolean extractedGenerateInternal(List<KeepAccountsDetailEo> detailEoList, OrderRuleEo orderRuleEo) {
        KeepNodeRuleParam keepNodeRuleParam = new KeepNodeRuleParam();
        OrderRuleRespDto orderRuleRespDto = new OrderRuleRespDto();
        CubeBeanUtils.copyProperties((Object)orderRuleRespDto, (Object)orderRuleEo, (String[])new String[0]);
        keepNodeRuleParam.setOrderRuleRespDto(orderRuleRespDto);
        keepNodeRuleParam.setCrossOrganizationalRelation("no");
        return this.fianceInsiderTransactionService.insertInnerOrder(detailEoList, keepNodeRuleParam);
    }

    private Map<String, ShopEo> getShopMap(List<PushOutsideSysAccountDto> hckKeepAccountVos) {
        List<ShopEo> shopEos;
        HashSet<String> shopCodeList = new HashSet<String>();
        for (PushOutsideSysAccountDto hckKeepAccountVo : hckKeepAccountVos) {
            if (!Objects.nonNull(hckKeepAccountVo.getPushKeepAccountVo()) || !Objects.nonNull(hckKeepAccountVo.getPushKeepAccountVo().getShopCode())) continue;
            shopCodeList.add(hckKeepAccountVo.getPushKeepAccountVo().getShopCode());
        }
        Map<String, Object> shopEoMap = new HashMap<String, ShopEo>();
        if (CollectionUtil.isNotEmpty(shopCodeList) && CollectionUtil.isNotEmpty(shopEos = this.shopService.selectShopByCodes(new ArrayList<String>(shopCodeList)))) {
            shopEoMap = shopEos.stream().collect(Collectors.toMap(ShopEo::getCode, Function.identity(), (v1, v2) -> v2));
        }
        return shopEoMap;
    }

    @Override
    public void pushErp(PushOutsideSysAccountDto hckKeepAccountVo) {
        if (Objects.isNull(hckKeepAccountVo)) {
            return;
        }
        PushKeepAccountVo keepAccountVo = hckKeepAccountVo.getPushKeepAccountVo();
        if (Objects.equals("1", keepAccountVo.getVoucherType())) {
            return;
        }
        this.getWarehouseCorrespondingSystem(hckKeepAccountVo.getPushKeepAccountDetailVos());
        PushKeepAccountsReqDto pushKeepAccountsReqDto = new PushKeepAccountsReqDto();
        pushKeepAccountsReqDto.setId(keepAccountVo.getId());
        pushKeepAccountsReqDto.setChargeCode(keepAccountVo.getChargeCode());
        if (BillTypeEnum.SALE_LIST.getCode().equals(keepAccountVo.getOrderType())) {
            log.info("\u6267\u884cerp\u8c03\u7528{}", com.alibaba.fastjson.JSON.toJSON((Object)hckKeepAccountVo));
            if (FinanceItemTypeEnum.FOREIGN_GIFT.getName().equals(keepAccountVo.getItemType())) {
                this.pushOtherSaleOrder(pushKeepAccountsReqDto, hckKeepAccountVo);
            } else {
                String orderType = FinanceItemTypeEnum.GIFT.getName().equals(keepAccountVo.getItemType()) ? "\u8d60\u54c1\u8ba2\u5355" : "\u6b63\u5e38\u8ba2\u5355";
                this.pushSaleOrder(orderType, pushKeepAccountsReqDto, hckKeepAccountVo);
            }
        } else if (BillTypeEnum.RETURN_BASE.getCode().equals(keepAccountVo.getOrderType())) {
            log.info("\u6267\u884cerp\u8c03\u7528{}", com.alibaba.fastjson.JSON.toJSON((Object)hckKeepAccountVo));
            if (FinanceItemTypeEnum.FOREIGN_GIFT.getName().equals(keepAccountVo.getItemType())) {
                this.pushOtherSaleOrderReturn(pushKeepAccountsReqDto, hckKeepAccountVo);
            } else {
                String orderType = "\u65e0\u539f\u59cb\u8ba2\u5355\u9000\u8d27";
                this.pushSaleReturn(orderType, pushKeepAccountsReqDto, hckKeepAccountVo);
            }
        } else if (BillTypeEnum.EXCHANGE.getCode().equals(keepAccountVo.getOrderType())) {
            log.info("\u6267\u884cerp\u8c03\u7528{}", com.alibaba.fastjson.JSON.toJSON((Object)hckKeepAccountVo));
            if (FinanceItemTypeEnum.FOREIGN_GIFT.getName().equals(keepAccountVo.getItemType())) {
                this.pushOtherSaleOrderReturn(pushKeepAccountsReqDto, hckKeepAccountVo);
            } else {
                String orderType = "\u65e0\u539f\u59cb\u8ba2\u5355\u9000\u8d27";
                this.pushSaleReturn(orderType, pushKeepAccountsReqDto, hckKeepAccountVo);
            }
        }
        this.pushKeepAccountsService.modifyPushKeepAndKeepDetail(pushKeepAccountsReqDto);
    }

    @Override
    public void pushSaleOrder(String orderType, PushKeepAccountsReqDto pushKeepAccountsReqDto, PushOutsideSysAccountDto accountVo) {
        String salesId;
        String outSaleCode;
        String message;
        String keepingResult;
        String pushStatus;
        Date now;
        block10: {
            if (Objects.isNull(accountVo) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountVo.getPushKeepAccountDetailVos())) {
                return;
            }
            log.info("\u5f00\u59cb\u6267\u884c\u63a8\u9001erp\u903b\u8f91,\u5165\u53c2{}", com.alibaba.fastjson.JSON.toJSON((Object)accountVo));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            now = new Date();
            String transDate = format.format(now);
            pushStatus = "2";
            keepingResult = KeepResultEnum.FAIL.getCode();
            message = "";
            outSaleCode = "";
            salesId = "";
            RestResponse<SalesTableAtJsRespDto> response = new RestResponse<SalesTableAtJsRespDto>();
            try {
                response = this.pushSaleOrderReq(orderType, transDate, accountVo);
            }
            catch (Exception e) {
                response.setResultMsg(e.getMessage());
                response.setResultCode("10000");
                log.error("\u5c01\u88c5\u6570\u636e\u5f02\u5e38", (Throwable)e);
            }
            if (response.isSuccess()) {
                SalesTableAtJsRespDto salesTRespDto = (SalesTableAtJsRespDto)response.getData();
                salesId = salesTRespDto.getSalesId();
                try {
                    RestResponse<String> result = this.pushSalesTableOut(transDate, salesTRespDto.getSalesId(), accountVo);
                    if (result.isSuccess()) {
                        outSaleCode = (String)result.getData();
                        pushStatus = "0";
                        keepingResult = KeepResultEnum.SUCCESS.getCode();
                        log.info("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u6210\u529f===============>\u9500\u552e\u5355\u8fd4\u56de{},\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u5355\u53f7{}", com.alibaba.fastjson.JSON.toJSON((Object)salesTRespDto), (Object)outSaleCode);
                        break block10;
                    }
                    message = result.getResultMsg();
                }
                catch (Exception e) {
                    message = e.getMessage();
                    log.info("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u5931\u8d25===============>\u64cd\u4f5c\u65f6\u95f4{},erp\u9500\u552e\u8ba2\u5355\u53f7{},\u5165\u53c2{}", new Object[]{transDate, salesId, com.alibaba.fastjson.JSON.toJSON((Object)accountVo)});
                }
            } else {
                message = response.getResultMsg();
            }
        }
        pushKeepAccountsReqDto.setPushStatus(pushStatus);
        pushKeepAccountsReqDto.setReason(message);
        pushKeepAccountsReqDto.setSaleNo(salesId);
        pushKeepAccountsReqDto.setKeepingResult(keepingResult);
        pushKeepAccountsReqDto.setDeliveryPushTime(now);
        String voucherType = accountVo.getPushKeepAccountVo().getVoucherType();
        if (voucherType.equals("0")) {
            pushKeepAccountsReqDto.setDeliveryNote(outSaleCode);
        } else {
            pushKeepAccountsReqDto.setInvoiceNo(outSaleCode);
        }
        pushKeepAccountsReqDto.setOutSaleOrderType("\u5916\u90e8-\u9500\u552e\u8ba2\u5355");
        log.info("\u63a8\u9001ERP\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)pushKeepAccountsReqDto));
    }

    @Override
    public void pushOtherSaleOrder(PushKeepAccountsReqDto pushKeepAccountsReqDto, PushOutsideSysAccountDto accountVo) {
        if (Objects.isNull(accountVo) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountVo.getPushKeepAccountDetailVos())) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String transDate = format.format(now);
        String salesCode = "";
        String pushStatus = "2";
        String keepingResult = KeepResultEnum.FAIL.getCode();
        String message = "";
        try {
            RestResponse<String> response = this.pushSalesTableMoveJS(transDate, accountVo);
            if (response.isSuccess()) {
                salesCode = (String)response.getData();
                pushStatus = "0";
                keepingResult = KeepResultEnum.SUCCESS.getCode();
                log.info("\u9500\u552e\u8ba2\u5355\u5176\u4ed6\u51fa\u5e93\u6210\u529f===============>\u5176\u4ed6\u5355\u8fd4\u56de{}", (Object)salesCode);
            } else {
                message = response.getResultMsg();
            }
        }
        catch (Exception e) {
            message = e.getMessage();
            log.info("\u9500\u5176\u4ed6\u51fa\u5e93\u5355\u63a8\u9001\u5931\u8d25===============>\u64cd\u4f5c\u65f6\u95f4{},erp\u9500\u552e\u5176\u4ed6\u51fa\u5e93\u8ba2\u5355\u53f7{},\u5165\u53c2{}", new Object[]{transDate, salesCode, com.alibaba.fastjson.JSON.toJSON((Object)accountVo)});
        }
        pushKeepAccountsReqDto.setPushStatus(pushStatus);
        pushKeepAccountsReqDto.setReason(message);
        pushKeepAccountsReqDto.setSaleNo(salesCode);
        pushKeepAccountsReqDto.setOutSaleOrderType("\u5916\u90e8-\u5176\u4ed6\u51fa\u5e93\u5355");
        pushKeepAccountsReqDto.setKeepingResult(keepingResult);
        pushKeepAccountsReqDto.setDeliveryPushTime(now);
        log.info("ERP\u63a8\u9001\u54cd\u5e94\u6570\u636e:{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)pushKeepAccountsReqDto));
    }

    @Override
    public void pushSaleReturn(String orderType, PushKeepAccountsReqDto pushKeepAccountsReqDto, PushOutsideSysAccountDto accountVo) {
        String saleCode;
        String outSaleCode;
        String message;
        String keepingResult;
        String pushStatus;
        Date now;
        block8: {
            if (Objects.isNull(accountVo) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountVo.getPushKeepAccountDetailVos())) {
                return;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            now = new Date();
            String transDate = format.format(now);
            pushStatus = "2";
            keepingResult = KeepResultEnum.FAIL.getCode();
            message = "";
            outSaleCode = "";
            saleCode = "";
            RestResponse<String> response = new RestResponse<String>();
            try {
                response = this.pushSalesTableRtJs(orderType, transDate, accountVo);
            }
            catch (Exception e) {
                response.setResultMsg(e.getMessage());
                response.setResultCode("10000");
            }
            if (response.isSuccess()) {
                saleCode = (String)response.getData();
                try {
                    RestResponse<String> result = this.pushSalesTableRtJsIn(transDate, saleCode, accountVo);
                    if (result.isSuccess()) {
                        outSaleCode = (String)result.getData();
                        pushStatus = "0";
                        keepingResult = KeepResultEnum.SUCCESS.getCode();
                        log.info("\u9500\u552e\u9000\u8d27\u8ba2\u5355\u5165\u5e93\u6210\u529f===============>\u9000\u8d27\u5355\u8fd4\u56de{},\u9000\u8d27\u8ba2\u5355\u5165\u5e93\u5355\u53f7{}", (Object)saleCode, (Object)outSaleCode);
                        break block8;
                    }
                    message = result.getResultMsg();
                }
                catch (Exception e) {
                    message = e.getMessage();
                    log.info("\u9000\u6b3e\u8ba2\u5355\u5165\u5e93\u5931\u8d25===============>\u64cd\u4f5c\u65f6\u95f4{},erp\u9000\u6b3e\u8ba2\u5355\u53f7{},\u5165\u53c2{}", new Object[]{transDate, saleCode, com.alibaba.fastjson.JSON.toJSON((Object)accountVo)});
                }
            } else {
                message = response.getResultMsg();
            }
        }
        pushKeepAccountsReqDto.setPushStatus(pushStatus);
        pushKeepAccountsReqDto.setReason(message);
        pushKeepAccountsReqDto.setSaleNo(saleCode);
        pushKeepAccountsReqDto.setDeliveryNote(outSaleCode);
        pushKeepAccountsReqDto.setKeepingResult(keepingResult);
        pushKeepAccountsReqDto.setDeliveryPushTime(now);
        pushKeepAccountsReqDto.setOutSaleOrderType("\u5916\u90e8-\u9000\u8d27\u8ba2\u5355");
    }

    @Override
    public void pushOtherSaleOrderReturn(PushKeepAccountsReqDto pushKeepAccountsReqDto, PushOutsideSysAccountDto accountVo) {
        if (Objects.isNull(accountVo) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountVo.getPushKeepAccountDetailVos())) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String transDate = format.format(now);
        String salesCode = "";
        String pushStatus = "2";
        String keepingResult = KeepResultEnum.FAIL.getCode();
        String message = "";
        try {
            RestResponse<String> response = this.pushOtherSaleReturn(transDate, accountVo);
            if (response.isSuccess()) {
                pushStatus = "0";
                keepingResult = KeepResultEnum.SUCCESS.getCode();
                salesCode = (String)response.getData();
                log.info("\u5176\u4ed6\u9000\u8d27\u8ba2\u5355\u5165\u5e93\u6210\u529f===============>\u5176\u4ed6\u9000\u8d27\u5355\u8fd4\u56de{},", (Object)salesCode);
            } else {
                message = response.getResultMsg();
            }
        }
        catch (Exception e) {
            message = e.getMessage();
            log.info("\u5176\u4ed6\u5165\u5e93\u5355\u63a8\u9001\u5931\u8d25===============>\u64cd\u4f5c\u65f6\u95f4{},erp\u9500\u552e\u5176\u4ed6\u5165\u5e93\u8ba2\u5355\u53f7{},\u5165\u53c2{}", new Object[]{transDate, salesCode, com.alibaba.fastjson.JSON.toJSON((Object)accountVo)});
        }
        pushKeepAccountsReqDto.setPushStatus(pushStatus);
        pushKeepAccountsReqDto.setReason(message);
        pushKeepAccountsReqDto.setSaleNo(salesCode);
        pushKeepAccountsReqDto.setDeliveryPushTime(now);
        pushKeepAccountsReqDto.setOutSaleOrderType("\u5916\u90e8-\u5176\u4ed6\u5165\u5e93\u8ba2\u5355");
        pushKeepAccountsReqDto.setKeepingResult(keepingResult);
    }

    private void getWarehouseCorrespondingSystem(List<PushKeepAccountDetailVo> detailVos) {
        if (CollectionUtil.isEmpty(detailVos)) {
            return;
        }
        List warehouseCodes = detailVos.stream().map(PushKeepAccountDetailVo::getWarehouseCode).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return;
        }
        List warehouseEos = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list();
        if (CollectionUtil.isEmpty((Collection)warehouseEos)) {
            return;
        }
        Map<String, String> warehouseMap = warehouseEos.stream().filter(e -> Objects.nonNull(e.getWarehouseCode()) && Objects.nonNull(e.getWarehouseCorrespondingSystem())).collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, LogicWarehouseEo::getWarehouseCorrespondingSystem, (k1, k2) -> k1));
        if (null == warehouseMap || warehouseMap.isEmpty()) {
            return;
        }
        for (PushKeepAccountDetailVo detailVo : detailVos) {
            detailVo.setWarehouseCorrespondingSystem(warehouseMap.get(detailVo.getWarehouseCode()));
        }
    }

    private RestResponse<SalesTableAtJsRespDto> pushSaleOrderReq(String orderType, String transDate, PushOutsideSysAccountDto accountVo) {
        List detailDto = accountVo.getPushKeepAccountDetailVos();
        SalesTableAtJsDto reqDto = new SalesTableAtJsDto();
        ArrayList<PortalSalesTableRt> portalSalesTableRt = new ArrayList<PortalSalesTableRt>();
        for (PushKeepAccountDetailVo detailVo : detailDto) {
            Integer itemNum = Objects.nonNull(detailVo.getItemNum()) ? detailVo.getItemNum() : 1;
            PortalSalesTableRt salesTableRt = new PortalSalesTableRt();
            salesTableRt.setSalesQty(itemNum.toString());
            salesTableRt.setCustAccount(detailVo.getCustomerCode());
            salesTableRt.setSalesUnit("pcs");
            salesTableRt.setAGL_ZTLineNum(detailVo.getOrderItemId());
            salesTableRt.setAGL_Sid(detailVo.getChargeCode());
            salesTableRt.setItemid(detailVo.getItemCode());
            AssertUtils.notNull((Object)detailVo.getWarehouseCorrespondingSystem(), (String)"\u672a\u627e\u5230ERP\u7cfb\u7edfID");
            salesTableRt.setInventLocationId(detailVo.getWarehouseCorrespondingSystem());
            salesTableRt.setReturnString("\u7f51\u5e97\u7ba1\u5bb6");
            salesTableRt.setSalesTaker(detailVo.getCustomerName());
            salesTableRt.setSalesTakerAlias(detailVo.getCustomerName());
            salesTableRt.setSalesRep("\u5218\u5fd7\u4f1f");
            salesTableRt.setSalesRepAlias("\u5218\u5fd7\u4f1f");
            salesTableRt.setTransDate(transDate);
            salesTableRt.setOrderType(orderType);
            salesTableRt.setWdgjOrderId(detailVo.getPlatformNo());
            salesTableRt.setWMSLocationid("00");
            salesTableRt.setOrigOrderId(detailVo.getChargeCode());
            BigDecimal itemPrice = Objects.nonNull(detailVo.getItemPrice()) ? detailVo.getItemPrice() : BigDecimal.ZERO;
            salesTableRt.setSalesAmount(itemPrice.toString());
            portalSalesTableRt.add(salesTableRt);
        }
        reqDto.setPortal_SalesTable(portalSalesTableRt);
        return this.saleOrderErpApiProxy.pushSaleOrder(reqDto);
    }

    private RestResponse<String> pushSalesTableMoveJS(String transDate, PushOutsideSysAccountDto accountVo) {
        PushKeepAccountVo pushKeepAccountVo = accountVo.getPushKeepAccountVo();
        List detailDto = accountVo.getPushKeepAccountDetailVos();
        PostSalesTableMoveJsDto reqDto = new PostSalesTableMoveJsDto();
        ArrayList<PortalSalesTable> portalSalesTables = new ArrayList<PortalSalesTable>();
        for (PushKeepAccountDetailVo detail : detailDto) {
            PortalSalesTable salesTable = new PortalSalesTable();
            salesTable.setAGL_ZTCreatedBy(detail.getCreatePerson());
            salesTable.setAGL_ZTCreatedDateTime(detail.getCreateTime());
            salesTable.setAGL_ZTPostedUser(detail.getCreatePerson());
            salesTable.setItemId(detail.getItemCode());
            AssertUtils.notNull((Object)detail.getWarehouseCorrespondingSystem(), (String)"\u672a\u627e\u5230ERP\u7cfb\u7edfID");
            salesTable.setInventLocationId(detail.getWarehouseCorrespondingSystem());
            salesTable.setOrderType("\u5176\u4ed6\u51fa\u5e93");
            salesTable.setTransDate(transDate);
            salesTable.setSalesUnit(detail.getItemUnit());
            salesTable.setQty(detail.getItemNum().toString());
            salesTable.setWMSLocationId("00");
            salesTable.setCostAmount("0.0000");
            salesTable.setOrigOrderId(detail.getChargeCode());
            salesTable.setAGL_ZTPostedUser("angelaly");
            salesTable.setAGL_ZTApprover("angelaly");
            salesTable.setLedgerDimension("660110");
            salesTable.setFinancefree("1099");
            salesTable.setDepartId(pushKeepAccountVo.getDepartCode());
            portalSalesTables.add(salesTable);
        }
        reqDto.setPortal_SalesTable(portalSalesTables);
        log.info("\u63a8\u9001ERP\u6570\u636e\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)reqDto));
        return this.saleOrderErpApiProxy.pushSalesTableMoveJS(reqDto);
    }

    private RestResponse<String> pushSalesTableOut(String transDate, String erpOrderCode, PushOutsideSysAccountDto accountVo) {
        List detailDto = accountVo.getPushKeepAccountDetailVos();
        PostSalesTableOutJsDto reqDto = new PostSalesTableOutJsDto();
        ArrayList<PortalSalesTableOut> portalSalesTableOuts = new ArrayList<PortalSalesTableOut>();
        for (PushKeepAccountDetailVo detail : detailDto) {
            PortalSalesTableOut salesTableOut = new PortalSalesTableOut();
            AssertUtils.notNull((Object)detail.getWarehouseCorrespondingSystem(), (String)"\u672a\u627e\u5230ERP\u7cfb\u7edfID");
            salesTableOut.setInventLocationId(detail.getWarehouseCorrespondingSystem());
            salesTableOut.setTransDate(transDate);
            salesTableOut.setWMSLocationId("00");
            salesTableOut.setSalesId(erpOrderCode);
            salesTableOut.setItemId(detail.getItemCode());
            salesTableOut.setAGL_Sid(detail.getChargeCode());
            portalSalesTableOuts.add(salesTableOut);
        }
        reqDto.setPortal_SalesTableOut(portalSalesTableOuts);
        log.info("\u63a8\u9001ERP\u6570\u636e\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)reqDto));
        return this.saleOrderErpApiProxy.pushSalesTableOut(reqDto);
    }

    private RestResponse<String> pushSalesTableRtJs(String orderType, String transDate, PushOutsideSysAccountDto accountVo) {
        List detailDto = accountVo.getPushKeepAccountDetailVos();
        PostSalesTableRtJsDto reqDto = new PostSalesTableRtJsDto();
        ArrayList<PortalSalesTableRtDto> portalSalesTableRtDtos = new ArrayList<PortalSalesTableRtDto>();
        for (PushKeepAccountDetailVo detail : detailDto) {
            PortalSalesTableRtDto salesTableRtDto = new PortalSalesTableRtDto();
            String saleNo = Objects.nonNull(detail.getSaleNo()) ? detail.getSaleNo() : "";
            String orderItemId = Objects.nonNull(detail.getOrderItemId()) ? detail.getOrderItemId().toString() : detail.getId().toString();
            String returnRef = saleNo + "&" + orderItemId;
            salesTableRtDto.setReturnRef(returnRef);
            salesTableRtDto.setCustAccount(detail.getCustomerCode());
            Integer itemNum = Objects.nonNull(detail.getItemNum()) ? detail.getItemNum() : 1;
            BigDecimal itemPrice = Objects.nonNull(detail.getItemPrice()) ? detail.getItemPrice() : BigDecimal.ZERO;
            BigDecimal salesPrice = itemPrice.divide(new BigDecimal(itemNum), 6, RoundingMode.HALF_UP).stripTrailingZeros();
            salesTableRtDto.setSalesPrice(salesPrice.toString());
            salesTableRtDto.setOrderType(orderType);
            salesTableRtDto.setCurrency("CNY");
            salesTableRtDto.setWMSLocationId("00");
            salesTableRtDto.setAGL_ZTLineNum(orderItemId);
            salesTableRtDto.setLog_RefRecId("0");
            salesTableRtDto.setOrigOrderId(detail.getPlatformNo());
            BigDecimal salesAmount = itemPrice.multiply(new BigDecimal(-1));
            salesTableRtDto.setSalesAmount(salesAmount.toString());
            salesTableRtDto.setSalesQty(-1 * itemNum + "");
            salesTableRtDto.setSalesUnit(detail.getItemUnit());
            salesTableRtDto.setReturn_OrigOrderId(detail.getChargeCode());
            salesTableRtDto.setWdgjOrderId(detail.getChargeCode());
            salesTableRtDto.setAGL_Sid(detail.getChargeCode());
            salesTableRtDto.setItemid(detail.getItemCode());
            AssertUtils.notNull((Object)detail.getWarehouseCorrespondingSystem(), (String)"\u672a\u627e\u5230ERP\u7cfb\u7edfID");
            salesTableRtDto.setInventLocationId(detail.getWarehouseCorrespondingSystem());
            salesTableRtDto.setTransDate(transDate);
            salesTableRtDto.setReturnReason("R-1106-01");
            salesTableRtDto.setSalesTaker(detail.getCustomerName());
            salesTableRtDto.setSalesTakerAlias(detail.getCustomerName());
            salesTableRtDto.setSalesRep("\u5218\u5fd7\u4f1f");
            salesTableRtDto.setSalesRepAlias("\u5218\u5fd7\u4f1f");
            portalSalesTableRtDtos.add(salesTableRtDto);
        }
        reqDto.setPortal_SalesTable_RT(portalSalesTableRtDtos);
        return this.saleOrderErpApiProxy.pushSalesTableRtJs(reqDto);
    }

    private RestResponse<String> pushSalesTableRtJsIn(String transDate, String erpOrderCode, PushOutsideSysAccountDto accountVo) {
        List detailDto = accountVo.getPushKeepAccountDetailVos();
        PostSalesTableRtOutJsDto reqDto = new PostSalesTableRtOutJsDto();
        ArrayList<PortalSalesTableRtOutDto> portalSalesTableOuts = new ArrayList<PortalSalesTableRtOutDto>();
        for (PushKeepAccountDetailVo detail : detailDto) {
            PortalSalesTableRtOutDto salesTableOut = new PortalSalesTableRtOutDto();
            salesTableOut.setSalesQty(-1 * detail.getItemNum() + "");
            salesTableOut.setTransDate(transDate);
            salesTableOut.setCustAccount(detail.getCustomerCode());
            salesTableOut.setSalesUnit(detail.getItemUnit());
            String orderItemId = Objects.nonNull(detail.getOrderItemId()) ? detail.getOrderItemId().toString() : "";
            salesTableOut.setAGL_ZTLineNum(orderItemId);
            salesTableOut.setAGL_Sid(detail.getChargeCode());
            salesTableOut.setItemid(detail.getItemCode());
            salesTableOut.setSalesId(erpOrderCode);
            portalSalesTableOuts.add(salesTableOut);
        }
        reqDto.setPortal_SalesTable_RT_Out(portalSalesTableOuts);
        return this.saleOrderErpApiProxy.pushSalesTableRtOutJs(reqDto);
    }

    private RestResponse<String> pushOtherSaleReturn(String transDate, PushOutsideSysAccountDto accountVo) {
        PushKeepAccountVo pushKeepAccountVo = accountVo.getPushKeepAccountVo();
        List detailDto = accountVo.getPushKeepAccountDetailVos();
        PostSalesTableMoveJsReqDto reqDto = new PostSalesTableMoveJsReqDto();
        ArrayList<PortalSalesTableDto> portalSalesTableRtDtos = new ArrayList<PortalSalesTableDto>();
        for (PushKeepAccountDetailVo detail : detailDto) {
            PortalSalesTableDto salesTableRtDto = new PortalSalesTableDto();
            salesTableRtDto.setCustAccount(detail.getCustomerCode());
            salesTableRtDto.setSalesUnit(detail.getItemUnit());
            salesTableRtDto.setAGL_ZTCreatedBy("angelaly");
            salesTableRtDto.setAGL_ZTPostedUser("angelaly");
            salesTableRtDto.setItemid(detail.getItemCode());
            AssertUtils.notNull((Object)detail.getWarehouseCorrespondingSystem(), (String)"\u672a\u627e\u5230ERP\u7cfb\u7edfID");
            salesTableRtDto.setInventLocationId(detail.getWarehouseCorrespondingSystem());
            salesTableRtDto.setAGL_ZTApprover("angelaly");
            salesTableRtDto.setAGL_ZTCreatedDateTime(detail.getCreateTime());
            salesTableRtDto.setOrderType("\u5176\u4ed6\u5165\u5e93");
            salesTableRtDto.setLedgerDimension("660110");
            salesTableRtDto.setTransDate(transDate);
            salesTableRtDto.setQty(detail.getItemNum().toString());
            salesTableRtDto.setWMSLocationId("00");
            salesTableRtDto.setFinancefree("1099");
            salesTableRtDto.setCostAmount("0.0000");
            salesTableRtDto.setOrigOrderId(detail.getChargeCode());
            salesTableRtDto.setDepartId(pushKeepAccountVo.getDepartCode());
            portalSalesTableRtDtos.add(salesTableRtDto);
        }
        reqDto.setPortal_SalesTable(portalSalesTableRtDtos);
        return this.saleOrderErpApiProxy.pushOtherSalesTableMoveJs(reqDto);
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandlerAuditRespDto retryPush(List<RetryKeepReqDto> retryKeepReqDtos) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(retryKeepReqDtos)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (retryKeepReqDtos.size() < 1) {
            return handlerAuditRespDto;
        }
        Long successNum = 0L;
        Long failNum = 0L;
        String pushPerson = null != retryKeepReqDtos.get(0) ? retryKeepReqDtos.get(0).getPushPerson() : null;
        for (RetryKeepReqDto v : retryKeepReqDtos) {
            Long l;
            Long l2;
            PushKeepAccountsEo pushKeepAccountsEo;
            Mutex mutex;
            block13: {
                mutex = null;
                mutex = this.lockService.lock(TABLENAME_SAP, Convert.toStr((Object)v.getId()), 10, 20, TimeUnit.SECONDS);
                pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"id", (Object)v.getId())).in((Object)"keeping_result", Arrays.asList(KeepResultEnum.FAIL.getCode(), KeepResultEnum.PENDING.getCode()))).eq((Object)"bill_shop_type", (Object)BillShopTypeEnum.C.getCode())).one();
                if (!Objects.isNull(pushKeepAccountsEo)) break block13;
                log.error("{}\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object)v.getId());
                l2 = failNum;
                l = failNum = Long.valueOf(failNum + 1L);
                if (mutex == null) continue;
                this.lockService.unlock(mutex);
                continue;
            }
            try {
                OrderKeepAccountReqDto orderKeepAccountReqDto;
                if (null == mutex) {
                    log.error("\u91cd\u65b0\u751f\u6210\u4ea4\u8d27\u8bb0\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    throw new BizException("\u91cd\u65b0\u751f\u6210\u4ea4\u8d27\u8bb0\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                if (!Objects.equals(BillTypeEnum.TRANSFERS.getCode(), pushKeepAccountsEo.getOrderType()) && Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), pushKeepAccountsEo.getVoucherType())) {
                    orderKeepAccountReqDto = new OrderKeepAccountReqDto();
                    orderKeepAccountReqDto.setChargeCode(pushKeepAccountsEo.getChargeCode());
                    orderKeepAccountReqDto.setConditionType(pushKeepAccountsEo.getConditionType());
                    orderKeepAccountReqDto.setOrderType(pushKeepAccountsEo.getOrderType());
                    orderKeepAccountReqDto.setPushPerson(pushPerson);
                } else if (!Objects.equals(BillTypeEnum.TRANSFERS.getCode(), pushKeepAccountsEo.getOrderType()) && Objects.equals(VoucherTypeEnum.INVOICE.getCode(), pushKeepAccountsEo.getVoucherType())) {
                    orderKeepAccountReqDto = new OrderKeepAccountReqDto();
                    orderKeepAccountReqDto.setChargeCode(pushKeepAccountsEo.getChargeCode());
                    orderKeepAccountReqDto.setConditionType(pushKeepAccountsEo.getConditionType());
                    orderKeepAccountReqDto.setOrderType(pushKeepAccountsEo.getOrderType());
                    orderKeepAccountReqDto.setPushPerson(pushPerson);
                }
                if (mutex == null) continue;
            }
            catch (Exception e) {
                try {
                    log.error("\u91cd\u65b0\u63a8\u9001SAP\u8d27\u8bb0\u8d26\u5355\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                    l2 = failNum;
                    l = failNum = Long.valueOf(failNum + 1L);
                    if (mutex == null) continue;
                }
                catch (Throwable throwable) {
                    if (mutex != null) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                continue;
            }
            this.lockService.unlock(mutex);
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        return handlerAuditRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void abnormalBookkeepingCorrection(List<PushKeepAccountsReqDto> reqDtos) {
        Optional.ofNullable(reqDtos).orElseThrow(() -> {
            throw new BizException(FinanceExceptionCode.PARAM_NOT_NULL.getMsg());
        });
        ArrayList pushKeepAccountsEos = Lists.newArrayList();
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        reqDtos.forEach(v -> {
            if (Objects.isNull(v.getId())) {
                throw new BizException(FinanceExceptionCode.PARAM_CODE_ID_IS_NULL.getMsg());
            }
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"id", (Object)v.getId())).one();
            if (Objects.nonNull(pushKeepAccountsEo)) {
                PushKeepAccountsEo accountsEo = new PushKeepAccountsEo();
                accountsEo.setId(v.getId());
                accountsEo.setDeliveryNote(v.getDeliveryNote());
                accountsEo.setSaleNo(v.getSaleNo());
                accountsEo.setPostingNo(v.getPostingNo());
                accountsEo.setInvoiceNo(v.getInvoiceNo());
                accountsEo.setDeliveryPushTime(v.getDeliveryPushTime());
                accountsEo.setInvoicePushTime(v.getInvoicePushTime());
                accountsEo.setGroupReceiveOrder(v.getGroupReceiveOrder());
                accountsEo.setReason(v.getReason());
                accountsEo.setYxId(v.getYxId());
                if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), pushKeepAccountsEo.getVoucherType())) {
                    accountsEo.setDeliveryPushTime(new Date());
                } else {
                    accountsEo.setInvoicePushTime(new Date());
                }
                if (StringUtils.isNotBlank((CharSequence)v.getReason())) {
                    accountsEo.setReason(v.getReason());
                } else {
                    accountsEo.setReason("");
                }
                accountsEo.setKeepingResult(KeepResultEnum.SUCCESS.getCode());
                accountsEo.setPushStatus(PushStatusEnum.PUSH_SUCC.getCode());
                accountsEo.setAccountingResult(AccountRuleEnum.ACCOUNT_SUCCESS.getCode());
                accountsEo.setManualCorrection(Integer.valueOf(1));
                pushKeepAccountsEos.add(accountsEo);
                KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
                keepAccountsDetailEo.setChargeCode(pushKeepAccountsEo.getChargeCode());
                keepAccountsDetailEo.setDeliveryNote(v.getDeliveryNote());
                keepAccountsDetailEo.setSaleNo(v.getSaleNo());
                keepAccountsDetailEo.setPostingNo(v.getPostingNo());
                keepAccountsDetailEo.setInvoiceNo(v.getInvoiceNo());
                keepAccountsDetailEo.setGroupReceiveOrder(v.getGroupReceiveOrder());
                keepAccountsDetailEo.setBookKeeping(BookKeepingType.DEAL.getCode());
                keepAccountsDetailEo.setAccountingResult(AccountRuleEnum.ACCOUNT_SUCCESS.getCode());
                keepAccountsDetailEo.setManualCorrection(Integer.valueOf(1));
                keepAccountsDetailEos.add(keepAccountsDetailEo);
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepAccountsEos)) {
            this.pushKeepAccountsDas.abnormalBookkeepingCorrection((List)pushKeepAccountsEos);
            this.pushKeepAccountsDas.abnormalBookkeepingCorrectionDetail((List)keepAccountsDetailEos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public HandlerAuditRespDto deleteKeepAccount(List<RetryKeepReqDto> retryKeepReqDtos) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(retryKeepReqDtos)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long successNum = 0L;
        Long failNum = 0L;
        String updatePerson = retryKeepReqDtos.get(0).getUpdatePerson();
        for (RetryKeepReqDto v : retryKeepReqDtos) {
            Long l;
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"id", (Object)v.getId())).in((Object)"keeping_result", Arrays.asList(KeepResultEnum.PENDING.getCode(), KeepResultEnum.FAIL.getCode()))).one();
            if (Objects.isNull(pushKeepAccountsEo)) {
                log.error("{}\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object)v.getId());
                continue;
            }
            Mutex mutex = null;
            try {
                Object object;
                mutex = this.lockService.lock(DELETE_KEEP, Convert.toStr((Object)v.getId()), 10, 20, TimeUnit.SECONDS);
                if (null == mutex) {
                    log.error("\u8bb0\u8d26\u5355\u5220\u9664\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    throw new BizException("\u8bb0\u8d26\u5355\u5220\u9664\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                PushKeepAccountsEo keepAccountsEo = new PushKeepAccountsEo();
                keepAccountsEo.setId(v.getId());
                keepAccountsEo.setExtension("\u6279\u91cf\u5220\u9664\u8bb0\u8d26\u5355");
                keepAccountsEo.setUpdatePerson(updatePerson);
                this.pushKeepAccountsDas.logicDelete((BaseEo)keepAccountsEo);
                List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", Arrays.asList(pushKeepAccountsEo.getChargeCode()))).eq((Object)"book_keeping", (Object)BookKeepingType.NOT_DEAL.getCode())).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) {
                    List codes = keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getChargeCode).distinct().collect(Collectors.toList());
                    this.pushKeepAccountsDas.batchRemoveKeepDetail(codes, updatePerson);
                }
                if ("HCK".equals(this.keepSystem)) {
                    List outResultDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepOutResultDetailDas.filter().in((Object)"charge_code", Arrays.asList(pushKeepAccountsEo.getChargeCode()))).eq((Object)"book_keeping", (Object)BookKeepingType.NOT_DEAL.getCode())).list();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)outResultDetailEos)) {
                        object = outResultDetailEos.stream().map(KeepOutResultDetailEo::getChargeCode).distinct().collect(Collectors.toList());
                    }
                } else {
                    List keepDetailMappingEos;
                    List pushKeepAccountsDetailEos = ((ExtQueryChainWrapper)this.pushKeepAccountsDetailDas.filter().in((Object)"charge_code", Arrays.asList(pushKeepAccountsEo.getChargeCode()))).list();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepAccountsDetailEos)) {
                        List codes = pushKeepAccountsDetailEos.stream().map(PushKeepAccountsDetailEo::getChargeCode).distinct().collect(Collectors.toList());
                        this.pushKeepAccountsDas.batchRemovePushKeepDetail(codes, updatePerson);
                    }
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(keepDetailMappingEos = ((ExtQueryChainWrapper)this.keepDetailMappingDas.filter().eq((Object)"charge_code", Arrays.asList(pushKeepAccountsEo.getChargeCode()))).list()))) {
                        List codes = pushKeepAccountsDetailEos.stream().map(PushKeepAccountsDetailEo::getChargeCode).distinct().collect(Collectors.toList());
                        this.pushKeepAccountsDas.batchRemoveKeepDetailMapping(codes, updatePerson);
                    }
                }
                l = successNum;
                successNum = successNum + 1L;
                object = successNum;
                if (mutex == null) continue;
            }
            catch (Exception e) {
                try {
                    log.error("\u5220\u9664\u8bb0\u8d26\u5355\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                    Long l2 = failNum;
                    l = failNum = Long.valueOf(failNum + 1L);
                    if (mutex == null) continue;
                }
                catch (Throwable throwable) {
                    if (mutex != null) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                continue;
            }
            this.lockService.unlock(mutex);
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        return handlerAuditRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCustomer(List<ModifyCustomerReqDto> customerReqDtos, String updatePerson) {
        log.info("\u4fee\u6539\u8bb0\u8d26\u5355\u6838\u7b97\u5ba2\u6237\u53c2\u6570\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(customerReqDtos));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerReqDtos)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List ids = customerReqDtos.stream().map(ModifyCustomerReqDto::getPushAccountId).distinct().collect(Collectors.toList());
        Map modifyCustomerReqDtoMap = customerReqDtos.stream().collect(Collectors.toMap(ModifyCustomerReqDto::getPushAccountId, Function.identity(), (k1, k2) -> k1));
        List pushKeepAccountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"id", ids)).eq((Object)"keeping_result", (Object)KeepResultEnum.PENDING.getCode())).list();
    }

    @Override
    public List<AllKeepOrderRespDto> queryIsBookKeepByPlatformNo(List<String> platformOrderNos) {
        ArrayList keepOrderRespDtos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(platformOrderNos)) {
            List orderVoList = this.pushKeepAccountsDas.statisticsOrderItemByPlatformOrderNo(platformOrderNos);
            Map allKeepOrderVoMap = orderVoList.stream().collect(Collectors.toMap(AllKeepOrderVo::getOrderNo, Function.identity(), (k1, k2) -> k1));
            List keepOrderVoList = this.pushKeepAccountsDas.statisticsKeepDetailOrderItemByPlatformOrderNo(platformOrderNos);
            Map keepOrderVoMap = keepOrderVoList.stream().collect(Collectors.toMap(AllKeepOrderVo::getOrderNo, Function.identity(), (k1, k2) -> k1));
            if (!org.springframework.util.CollectionUtils.isEmpty(allKeepOrderVoMap)) {
                allKeepOrderVoMap.forEach((k, v) -> {
                    AllKeepOrderRespDto orderRespDto = new AllKeepOrderRespDto();
                    orderRespDto.setOrderNo(k);
                    if (!org.springframework.util.CollectionUtils.isEmpty((Map)keepOrderVoMap)) {
                        AllKeepOrderVo allKeepOrderVo = (AllKeepOrderVo)keepOrderVoMap.get(k);
                        if (null != v.getCount() && Objects.nonNull(allKeepOrderVo) && v.getCount().equals(allKeepOrderVo.getCount())) {
                            orderRespDto.setCompleteKeep(Integer.valueOf(1));
                        } else {
                            orderRespDto.setCompleteKeep(Integer.valueOf(0));
                        }
                    } else {
                        orderRespDto.setCompleteKeep(Integer.valueOf(0));
                    }
                    keepOrderRespDtos.add(orderRespDto);
                });
            }
        }
        return keepOrderRespDtos;
    }

    @Override
    public List<AllKeepOrderRespDto> queryAllKeepAccount(List<BillPlatormOrderReqDto> orderReqDtos) {
        log.info("\u9500\u552e\u5355\u662f\u5426\u5168\u90e8\u8bb0\u8d26\u5165\u53c2\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(orderReqDtos));
        ArrayList keepOrderRespDtos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderReqDtos)) {
            List list = this.keepItemRuleDas.filter().list();
        }
        return keepOrderRespDtos;
    }

    @Override
    public List<AllKeepOrderRespDto> queryIsBookkeepByAfterSaleOrderNo(List<String> afterSaleOrderNos) {
        log.info("\u552e\u540e\u5355\u662f\u5426\u5168\u90e8\u8bb0\u8d26\u5165\u53c2\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(afterSaleOrderNos));
        ArrayList keepOrderRespDtos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(afterSaleOrderNos)) {
            List orderVoList = this.pushKeepAccountsDas.statisticsAfterSaleOrderItemByPlatformOrderNo(afterSaleOrderNos);
            Map allKeepOrderVoMap = orderVoList.stream().collect(Collectors.toMap(AllKeepOrderVo::getOrderNo, Function.identity(), (k1, k2) -> k1));
            List keepOrderVoList = this.pushKeepAccountsDas.statisticsAfterSaleKeepDetailOrderItemByPlatformOrderNo(afterSaleOrderNos);
            Map keepOrderVoMap = keepOrderVoList.stream().collect(Collectors.toMap(AllKeepOrderVo::getOrderNo, Function.identity(), (k1, k2) -> k1));
            if (!org.springframework.util.CollectionUtils.isEmpty(allKeepOrderVoMap)) {
                allKeepOrderVoMap.forEach((k, v) -> {
                    AllKeepOrderRespDto orderRespDto = new AllKeepOrderRespDto();
                    orderRespDto.setOrderNo(k);
                    if (!org.springframework.util.CollectionUtils.isEmpty((Map)keepOrderVoMap)) {
                        AllKeepOrderVo allKeepOrderVo = (AllKeepOrderVo)keepOrderVoMap.get(k);
                        if (null != v.getCount() && Objects.nonNull(allKeepOrderVo) && v.getCount().equals(allKeepOrderVo.getCount())) {
                            orderRespDto.setCompleteKeep(Integer.valueOf(1));
                        } else {
                            orderRespDto.setCompleteKeep(Integer.valueOf(0));
                        }
                    } else {
                        orderRespDto.setCompleteKeep(Integer.valueOf(0));
                    }
                    keepOrderRespDtos.add(orderRespDto);
                });
            }
        }
        return keepOrderRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public HandlerAuditRespDto bookKeepingRemark(BookKeepingRemarkReqDto bookKeepingRemarkReqDto) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        Long successNum = 0L;
        Long failNum = 0L;
        String updatePerson = bookKeepingRemarkReqDto.getUpdatePerson();
        for (Long v : bookKeepingRemarkReqDto.getIds()) {
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"id", (Object)v)).eq((Object)"bill_shop_type", (Object)BillShopTypeEnum.B.getCode())).one();
            if (Objects.isNull(pushKeepAccountsEo)) {
                log.error("{}\u8bb0\u5f55\u4e0d\u5b58\u5728");
                continue;
            }
            try {
                Date chargeDate = Objects.equals(KeepResultEnum.SUCCESS.getCode(), bookKeepingRemarkReqDto.getKeepingResult()) ? new Date() : null;
                PushKeepAccountsEo keepAccountsEo = new PushKeepAccountsEo();
                keepAccountsEo.setId(v);
                keepAccountsEo.setExtension("\u8bb0\u8d26\u6807\u8bb0");
                keepAccountsEo.setKeepingResult(bookKeepingRemarkReqDto.getKeepingResult());
                keepAccountsEo.setUpdatePerson(updatePerson);
                keepAccountsEo.setInvoicePushTime(new Date());
                keepAccountsEo.setChargeDate(chargeDate);
                this.pushKeepAccountsDas.updateSelective((BaseEo)keepAccountsEo);
                String bookKeeping = Objects.equals(KeepResultEnum.SUCCESS.getCode(), bookKeepingRemarkReqDto.getKeepingResult()) ? BookKeepingType.DEAL.getCode() : BookKeepingType.NOT_DEAL.getCode();
                this.pushKeepAccountsDas.bookKeepingRemark(bookKeeping, "\u8bb0\u8d26\u6807\u8bb0", updatePerson, chargeDate, pushKeepAccountsEo.getChargeCode());
                Long l = successNum;
                Long l2 = successNum = Long.valueOf(successNum + 1L);
            }
            catch (Exception e) {
                log.error("\u6807\u8bb0\u8bb0\u8d26\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                Long l = failNum;
                Long l3 = failNum = Long.valueOf(failNum + 1L);
            }
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        return handlerAuditRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public HandlerAuditRespDto repairKeepByChargeCodes(List<String> chargeCodes) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        AtomicReference<Long> successNum = new AtomicReference<Long>(0L);
        AtomicReference<Long> failNum = new AtomicReference<Long>(0L);
        chargeCodes.forEach(v -> {
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", v)).eq((Object)"keeping_result", (Object)KeepResultEnum.FAIL.getCode())).one();
            if (Objects.isNull(pushKeepAccountsEo)) {
                log.error("{}\u8bb0\u5f55\u4e0d\u5b58\u5728");
                return;
            }
            try {
                Date chargeDate = Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), pushKeepAccountsEo.getVoucherType()) ? pushKeepAccountsEo.getDeliveryPushTime() : pushKeepAccountsEo.getInvoicePushTime();
                PushKeepAccountsEo keepAccountsEo = new PushKeepAccountsEo();
                keepAccountsEo.setId(pushKeepAccountsEo.getId());
                keepAccountsEo.setExtension("\u8bb0\u8d26\u6570\u636e\u4fee\u590d");
                keepAccountsEo.setKeepingResult(KeepResultEnum.SUCCESS.getCode());
                keepAccountsEo.setChargeDate(chargeDate);
                keepAccountsEo.setReason("");
                this.pushKeepAccountsDas.updateSelective((BaseEo)keepAccountsEo);
                String bookKeeping = BookKeepingType.DEAL.getCode();
                this.pushKeepAccountsDas.repairKeepByChargeCodes(bookKeeping, chargeDate, pushKeepAccountsEo.getChargeCode());
                successNum.getAndSet((Long)successNum.get() + 1L);
            }
            catch (Exception e) {
                log.error("\u6807\u8bb0\u8bb0\u8d26\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                failNum.getAndSet((Long)failNum.get() + 1L);
            }
        });
        handlerAuditRespDto.setSuccessNum(successNum.get());
        handlerAuditRespDto.setFailNum(failNum.get());
        return handlerAuditRespDto;
    }

    @Override
    public PageInfo<PushKeepAccountsRespDto> page(KeepQueryConditionDto conditionDto, Integer pageNum, Integer pageSize) {
        log.info("KeepQueryConditionDto\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)conditionDto));
        KeepQueryConditionVo conditionVo = new KeepQueryConditionVo();
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getStartTime())) {
            conditionDto.setStartTime(conditionDto.getStartTime() + " 00:00:00");
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getEndTime())) {
            conditionDto.setEndTime(conditionDto.getEndTime() + " 23:59:59");
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getGenerateStartTime())) {
            conditionDto.setGenerateStartTime(conditionDto.getGenerateStartTime() + " 00:00:00");
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getGenerateEndTime())) {
            conditionDto.setGenerateEndTime(conditionDto.getGenerateEndTime() + " 23:59:59");
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getDeliveryTimeStart())) {
            conditionDto.setDeliveryTimeStart(conditionDto.getDeliveryTimeStart() + " 00:00:00");
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getDeliveryTimeEnd())) {
            conditionDto.setDeliveryTimeEnd(conditionDto.getDeliveryTimeEnd() + " 23:59:59");
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getCompleteTimeStart())) {
            conditionDto.setCompleteTimeStart(conditionDto.getCompleteTimeStart() + " 00:00:00");
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getCompleteTimeEnd())) {
            conditionDto.setCompleteTimeEnd(conditionDto.getCompleteTimeEnd() + " 23:59:59");
        }
        if (Objects.nonNull(conditionDto) && Objects.equals(BillShopTypeEnum.B.getCode(), conditionDto.getBillShopType())) {
            conditionDto.setBillShopType(BillShopTypeEnum.B.getCode());
        } else {
            conditionDto.setBillShopType(BillShopTypeEnum.C.getCode());
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getSaleOrderType())) {
            conditionDto.setSaleOrderType(conditionDto.getSaleOrderType());
        }
        if (Objects.nonNull(conditionDto) && Objects.nonNull(conditionDto.getSaleOrderTypes())) {
            conditionDto.setSaleOrderTypes(conditionDto.getSaleOrderTypes());
        }
        CubeBeanUtils.copyProperties((Object)conditionVo, (Object)conditionDto, (String[])new String[0]);
        PageInfo eoPageInfo = this.pushKeepAccountsDas.page(conditionVo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List<String> chargeCodes = eoPageInfo.getList().stream().map(PushKeepAccountsEo::getChargeCode).distinct().collect(Collectors.toList());
            Map<String, List<KeepAccountsDetailEo>> keepAccountsDetailsMap = this.getKeepAccountsDetailsMap(chargeCodes);
            List keepAccountsRespDtos = eoPageInfo.getList().stream().map(v -> {
                List list;
                PushKeepAccountsRespDto keepAccountsRespDto = new PushKeepAccountsRespDto();
                CubeBeanUtils.copyProperties((Object)keepAccountsRespDto, (Object)v, (String[])new String[0]);
                keepAccountsRespDto.setOrderTypeName(BillTypeEnum.getDesc((String)v.getOrderType()));
                keepAccountsRespDto.setVoucherTypeName(VoucherTypeEnum.getDesc((String)v.getVoucherType()));
                keepAccountsRespDto.setKeepingResultName(KeepResultEnum.getDesc((String)v.getKeepingResult()));
                if (Objects.equals("virtual", v.getWarehouseCode()) || Objects.equals("8888", v.getWarehouseCode()) || Objects.equals("9999", v.getWarehouseCode())) {
                    keepAccountsRespDto.setWarehouseCode(null);
                }
                if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), v.getVoucherType())) {
                    keepAccountsRespDto.setChargeAccountName(v.getChargeAccountName());
                } else if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), v.getVoucherType())) {
                    keepAccountsRespDto.setChargeAccountName(v.getBillAccountName());
                }
                if (!org.springframework.util.CollectionUtils.isEmpty((Map)keepAccountsDetailsMap) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(list = (List)keepAccountsDetailsMap.get(v.getChargeCode())))) {
                    keepAccountsRespDto.setPlatformCreateTime(null != ((KeepAccountsDetailEo)list.get(0)).getPlatformCreateTime() ? ((KeepAccountsDetailEo)list.get(0)).getPlatformCreateTime() : null);
                    keepAccountsRespDto.setSaleOrderType(null != ((KeepAccountsDetailEo)list.get(0)).getSaleOrderType() ? ((KeepAccountsDetailEo)list.get(0)).getSaleOrderType() : null);
                }
                return keepAccountsRespDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(keepAccountsRespDtos);
        }
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairDeliveryAndInvoice(List<String> chargeCodes, String vocherType, String rfcCode, String messageType) {
        SapKeepConditionReqDto conditionReqDto = new SapKeepConditionReqDto();
        conditionReqDto.setChargeCodes(chargeCodes);
        conditionReqDto.setVocherTypes(Arrays.asList(vocherType));
        conditionReqDto.setRfcCodes(Arrays.asList(rfcCode));
        if (StringUtils.isNotBlank((CharSequence)messageType)) {
            conditionReqDto.setMessageType(messageType);
        }
        if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), vocherType)) {
            // empty if block
        }
    }

    @Override
    public void testRealTimeAccounting(List<String> afterSaleOrderNos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(afterSaleOrderNos)) {
            // empty if block
        }
    }

    @Override
    public List<String> saveKeepAccounting(List<KingdeeKeepAccountingReqDto> kingdeeKeepAccountingReqDtos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(kingdeeKeepAccountingReqDtos)) {
            log.info("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return new ArrayList<String>();
        }
        ArrayList chargeCodes = Lists.newArrayList();
        HashMap addKeepMap = Maps.newHashMap();
        HashMap updateKeepMap = Maps.newHashMap();
        kingdeeKeepAccountingReqDtos.forEach(v -> {
            ArrayList accountsDetailEos = Lists.newArrayList();
            List detailReqDtos = v.getKeepAccountsDetailReqDtos();
            CubeBeanUtils.copyCollection((Collection)accountsDetailEos, (Collection)detailReqDtos, KeepAccountsDetailEo.class);
            List orderItemIds = accountsDetailEos.stream().map(KeepAccountsDetailEo::getOrderItemId).collect(Collectors.toList());
            List voucherTypes = accountsDetailEos.stream().map(KeepAccountsDetailEo::getVoucherType).distinct().collect(Collectors.toList());
            List orderTypes = accountsDetailEos.stream().map(KeepAccountsDetailEo::getOrderType).distinct().collect(Collectors.toList());
            List keepAccountsDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", orderItemIds)).in((Object)"voucher_type", voucherTypes)).in((Object)"order_type", orderTypes)).list();
            Map<String, KeepAccountsDetailEo> keepAccountsDetailEoMap = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEoList)) {
                keepAccountsDetailEoMap = keepAccountsDetailEoList.stream().collect(Collectors.toMap(k -> k.getOrderItemId() + "_" + k.getVoucherType() + "_" + k.getOrderType(), Function.identity()));
            }
            PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
            CubeBeanUtils.copyProperties((Object)pushKeepAccountsEo, (Object)v.getPushKeepAccountsReqDto(), (String[])new String[0]);
            chargeCodes.add(this.detailKingdeeAccounting(addKeepMap, updateKeepMap, accountsDetailEos, keepAccountsDetailEoMap, pushKeepAccountsEo));
        });
        return chargeCodes;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void modifyPushKeepAndKeepDetail(PushKeepAccountsReqDto pushKeepAccountsReqDto) {
        PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
        pushKeepAccountsEo.setChargeCode(pushKeepAccountsReqDto.getChargeCode());
        PushKeepAccountsEo accountsEo = (PushKeepAccountsEo)this.pushKeepAccountsDas.selectOne((BaseEo)pushKeepAccountsEo);
        if (null != accountsEo) {
            PushKeepAccountsEo keepAccountsEo = PushKeepAccountsServiceImpl.assemblyPushKeepAccountsEo(pushKeepAccountsReqDto, accountsEo);
            this.pushKeepAccountsDas.updateSelective((BaseEo)keepAccountsEo);
            List keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"charge_code", (Object)pushKeepAccountsReqDto.getChargeCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) {
                Map<Object, Object> detailReqMap = new HashMap();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepAccountsReqDto.getDetails())) {
                    detailReqMap = pushKeepAccountsReqDto.getDetails().stream().filter(a -> Objects.nonNull(a.getId())).collect(Collectors.toMap(KeepAccountsDetailReqDto::getId, Function.identity(), (v1, v2) -> v1));
                }
                ArrayList accountsDetailEos = Lists.newArrayList();
                for (KeepAccountsDetailEo v : keepAccountsDetailEos) {
                    KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                    detailEo.setId(v.getId());
                    PushKeepAccountsServiceImpl.AssemblyAccountsDetailEos(pushKeepAccountsReqDto, detailEo);
                    KeepAccountsDetailReqDto detailReqDto = (KeepAccountsDetailReqDto)detailReqMap.get(v.getId());
                    if (Objects.nonNull(detailReqDto)) {
                        detailEo.setSaleProjectId(detailReqDto.getSaleProjectId());
                        detailEo.setDeliveryProjectId(detailReqDto.getDeliveryProjectId());
                        detailEo.setU9ConversionOrderNo(detailReqDto.getU9ConversionOrderNo());
                    }
                    accountsDetailEos.add(detailEo);
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) {
                    int length;
                    int i = 0;
                    for (length = accountsDetailEos.size(); length > 500; length -= 500) {
                        this.keepAccountsDetailDas.batchUpdateKeepAccountsDetail(accountsDetailEos.subList(i, i + 500));
                        i += 500;
                    }
                    if (length > 0) {
                        this.keepAccountsDetailDas.batchUpdateKeepAccountsDetail(accountsDetailEos.subList(i, i + length));
                    }
                }
            }
        }
    }

    @Override
    public void invoiceAccountingWhenSuccess(PushKeepAccountsEo keepAccountsEo) {
        log.info("\u8bb0\u8d26\u5355\u72b6\u6001\u66f4\u65b0invoiceAccountingWhenSuccess\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)keepAccountsEo));
        if (!Objects.equals(keepAccountsEo.getAccountingResult(), AccountRuleEnum.ACCOUNT_SUCCESS.getCode())) {
            log.info("\u8bb0\u8d26\u5c1a\u672a\u6210\u529f\uff0c\u4e0d\u5904\u7406\u540e\u7eed\u903b\u8f91");
            return;
        }
        VoucherTypeEnum voucherTypeEnum = VoucherTypeEnum.forCode((String)keepAccountsEo.getVoucherType());
        List orderNos = Arrays.stream(keepAccountsEo.getOrderNo().split(",")).collect(Collectors.toList());
        MamualKeepAccountReqDto keepAccountReqDto = new MamualKeepAccountReqDto();
        keepAccountReqDto.setType(KeepTypeEnum.REAL.getCode());
        keepAccountReqDto.setAccountType(KeepTypeEnum.REAL.getCode());
        keepAccountReqDto.setGeneratePerson(keepAccountsEo.getUpdatePerson());
        switch (voucherTypeEnum) {
            case DELIVERY: {
                keepAccountReqDto.setOrderType(keepAccountsEo.getOrderType());
                keepAccountReqDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
                keepAccountReqDto.setInnerOrderNos(orderNos);
                log.info("\u4ea4\u8d27\u8bb0\u8d26\u6210\u529f\uff0c\u5f00\u7968\u8bb0\u8d26\uff1a{}", orderNos);
                this.syncKeepAccountingService.manualGenerateBookAccount(keepAccountReqDto);
                break;
            }
            case INVOICE: {
                if (Objects.equals(keepAccountsEo.getOrderType(), BillTypeEnum.SALE_LIST.getCode())) {
                    log.info("\u9500\u552e\u5355\u5f00\u7968\u8bb0\u8d26\u6210\u529f\u3002 chargeCode: {}, orderNo: {}", (Object)keepAccountsEo.getChargeCode(), (Object)keepAccountsEo.getOrderNo());
                    HashMap objs = new HashMap(ServiceContext.getContext().getAttachments());
                    log.info("objs======\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString(objs));
                    String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
                    CompletableFuture.runAsync(() -> {
                        PushKeepAccountsServiceImpl.setAttachmentAsync(objs);
                        MDC.put((String)"yes.req.requestId", (String)reqId);
                        log.info("\u751f\u6210\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u8bb0\u8d26\u5165\u53c2orderNos:{}", (Object)JSONObject.toJSONString((Object)orderNos));
                        this.generateRefundOnlyKeep(orderNos, keepAccountsEo.getUpdatePerson());
                    });
                    List deliverySuccessEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"business_no", orderNos)).eq((Object)"voucher_type", (Object)VoucherTypeEnum.DELIVERY.getCode())).eq((Object)"accounting_result", (Object)AccountRuleEnum.ACCOUNT_SUCCESS.getCode())).list();
                    log.info("\u9500\u552e\u5355\u5f00\u7968\u8bb0\u8d26\u6210\u529f\uff0c\u9000\u8d27\u4ea4\u8d27\u6210\u529f\u7684\u6570\u636e\u3002 deliverySuccessEos: {}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)deliverySuccessEos));
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)deliverySuccessEos)) {
                        return;
                    }
                    Map<String, List<KeepAccountsDetailEo>> orderNoTypeMap = deliverySuccessEos.stream().collect(Collectors.groupingBy(a -> a.getOrderNo() + "-" + a.getOrderType()));
                    orderNoTypeMap.forEach((k, v) -> {
                        String[] arr = k.split("-");
                        keepAccountReqDto.setOrderType(arr[1]);
                        keepAccountReqDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
                        keepAccountReqDto.setInnerOrderNo(arr[0]);
                        log.info("\u6b63\u5411\u5f00\u7968\u8bb0\u8d26\u6210\u529f\uff0c\u9006\u5411\u5f00\u7968\u8bb0\u8d26\uff1a{}", (Object)arr[0]);
                        this.syncKeepAccountingService.manualGenerateBookAccount(keepAccountReqDto);
                    });
                    break;
                }
                if (!Objects.equals(keepAccountsEo.getOrderType(), BillTypeEnum.EXCHANGE.getCode())) break;
                log.info("\u6362\u8d27\u5f00\u7968\u8bb0\u8d26\u6210\u529f\u3002 chargeCode: {}, orderNo: {}", (Object)keepAccountsEo.getChargeCode(), (Object)keepAccountsEo.getOrderNo());
                List performOrderInfoEos = ((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().eq((Object)"exchange_order_no", (Object)keepAccountsEo.getOrderNo())).list();
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)performOrderInfoEos)) break;
                keepAccountReqDto.setOrderType(BillTypeEnum.SALE_LIST.getCode());
                keepAccountReqDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
                keepAccountReqDto.setInnerOrderNo(((PerformOrderInfoEo)performOrderInfoEos.get(0)).getSaleOrderNo());
                log.info("\u6362\u8d27\u5f00\u7968\u8bb0\u8d26\u6210\u529f\uff0c\u6b63\u5411\u5f00\u7968\u8bb0\u8d26\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)keepAccountReqDto));
                this.syncKeepAccountingService.manualGenerateBookAccount(keepAccountReqDto);
                break;
            }
        }
    }

    @Override
    public void afterSendMqBySaleSuccess(PushKeepAccountsEo keepAccountsEo) {
        log.info("\u9500\u552e\u5355\u8bb0\u8d26\u6210\u529f\uff0c\u89e6\u53d1\u6ca1\u6709\u8bb0\u8d26\u6210\u529f\u7684\u9006\u5411\u5355\u636e\u8fdb\u884c\u8bb0\u8d26\uff1a{}", (Object)keepAccountsEo);
        if (!keepAccountsEo.getOrderType().equals(AccountRuleEnum.SALE_LIST.getCode()) || !keepAccountsEo.getAccountingResult().equals(AccountRuleEnum.ACCOUNT_SUCCESS.getCode()) || StringUtils.isBlank((CharSequence)keepAccountsEo.getOrderNo())) {
            log.error("\u4e0d\u6ee1\u8db3\u6761\u4ef6");
            return;
        }
        List afterList = (List)RestResponseHelper.extractData((RestResponse)this.afterSaleOrderQueryApiProxy.queryBySaleOrderNo(keepAccountsEo.getOrderNo()));
        if (CollectionUtil.isEmpty((Collection)afterList)) {
            log.error("\u65e0\u552e\u540e\u5355\u636e");
            return;
        }
        List afterOrderNos = afterList.stream().map(DgAfterSaleOrderRespDto::getAfterSaleOrderNo).collect(Collectors.toList());
        List invoiceList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"order_no", afterOrderNos)).eq((Object)"voucher_type", (Object)keepAccountsEo.getVoucherType())).ne((Object)"accounting_result", (Object)AccountRuleEnum.ACCOUNT_SUCCESS.getCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)invoiceList)) {
            log.info("\u67e5\u8be2\u672a\u8bb0\u8d26\u6216\u8bb0\u8d26\u5931\u8d25\u7684\u9006\u5411\u5355\u636e\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)invoiceList));
            invoiceList.forEach(invoice -> {
                MessageVo message = new MessageVo();
                message.setCenterType("\u8d22\u52a1\u4e2d\u5fc3");
                message.setSingleOr("\u5355\u53d1");
                message.setData((Object)com.alibaba.fastjson.JSON.toJSONString((Object)Lists.newArrayList((Object[])new String[]{invoice.getChargeCode()})));
                log.info("\u53d1\u9001\u8bb0\u8d26MQ\u6d88\u606f\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)message));
                MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("PUSH_KEEP_INNER_ORDER_ACCOUNT", (Object)message);
                log.info("\u53d1\u9001\u8bb0\u8d26MQ\u6d88\u606f\u7ed3\u679c\uff1a{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)messageResponse));
            });
        } else {
            log.info("\u65e0\u6570\u636e");
        }
    }

    private void delayProcessInvoinceAccounting(MamualKeepAccountReqDto keepAccountReqDto) {
        try {
            Thread.sleep(3000L);
            this.syncKeepAccountingService.manualGenerateBookAccount(keepAccountReqDto);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Thread interrupted", (Throwable)e);
        }
    }

    private void extractedUpdateInternalOrder(PushKeepAccountsReqDto pushKeepAccountsReqDto) {
        PushKeepInternalUpdateOrderDto pushKeepInternalUpdateOrderDto = new PushKeepInternalUpdateOrderDto();
        if (Objects.equals(KeepResultEnum.SUCCESS.getCode(), pushKeepAccountsReqDto.getKeepingResult())) {
            pushKeepInternalUpdateOrderDto.setChargeResult(AccountRuleEnum.ACCOUNT_SUCCESS.getCode());
        } else if (Objects.equals(KeepResultEnum.PUSHING.getCode(), pushKeepAccountsReqDto.getKeepingResult())) {
            pushKeepInternalUpdateOrderDto.setChargeResult(AccountRuleEnum.PUSHING.getCode());
        } else {
            pushKeepInternalUpdateOrderDto.setChargeFailReason(pushKeepAccountsReqDto.getReason());
            pushKeepInternalUpdateOrderDto.setChargeResult(AccountRuleEnum.ACCOUNT_FAIL.getCode());
        }
        pushKeepInternalUpdateOrderDto.setFinanceChargeDate(pushKeepAccountsReqDto.getAccountingCompleteTime());
        this.pushKeepInternalOrderService.updateByChargeNo(pushKeepAccountsReqDto.getChargeCode(), pushKeepInternalUpdateOrderDto);
    }

    private static void AssemblyAccountsDetailEos(PushKeepAccountsReqDto pushKeepAccountsReqDto, KeepAccountsDetailEo detailEo) {
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getDeliveryNote())) {
            detailEo.setDeliveryNote(pushKeepAccountsReqDto.getDeliveryNote());
        }
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getSaleNo())) {
            detailEo.setSaleNo(pushKeepAccountsReqDto.getSaleNo());
        }
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getGroupReceiveOrder())) {
            detailEo.setGroupReceiveOrder(pushKeepAccountsReqDto.getGroupReceiveOrder());
        }
        if (Objects.equals(AccountRuleEnum.ACCOUNT_SUCCESS.getCode(), pushKeepAccountsReqDto.getAccountingResult())) {
            detailEo.setAccountingResult(AccountRuleEnum.ACCOUNT_SUCCESS.getCode());
        } else if (Objects.equals(AccountRuleEnum.PUSHING.getCode(), pushKeepAccountsReqDto.getAccountingResult())) {
            detailEo.setAccountingResult(AccountRuleEnum.PUSHING.getCode());
        } else if (Objects.equals(AccountRuleEnum.ACCOUNT_FAIL.getCode(), pushKeepAccountsReqDto.getAccountingResult())) {
            detailEo.setAccountingResult(AccountRuleEnum.ACCOUNT_FAIL.getCode());
        } else {
            detailEo.setAccountingResult(AccountRuleEnum.ACCOUNTING.getCode());
        }
        if (null != pushKeepAccountsReqDto.getChargeDate()) {
            detailEo.setChargeDate(pushKeepAccountsReqDto.getChargeDate());
        }
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getInvoiceNo())) {
            detailEo.setInvoiceNo(pushKeepAccountsReqDto.getInvoiceNo());
        }
        if (Objects.nonNull(pushKeepAccountsReqDto.getCompleteTime())) {
            detailEo.setCompleteTime(pushKeepAccountsReqDto.getCompleteTime());
        }
        if (Objects.nonNull(pushKeepAccountsReqDto.getAccountingCompleteTime())) {
            detailEo.setAccountingCompleteTime(pushKeepAccountsReqDto.getAccountingCompleteTime());
        }
        if (Objects.nonNull(pushKeepAccountsReqDto.getU9ConversionOrderNo())) {
            detailEo.setU9ConversionOrderNo(pushKeepAccountsReqDto.getU9ConversionOrderNo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public String detailKingdeeAccounting(Map<String, KeepAccountsDetailEo> addKeepMap, Map<String, KeepAccountsDetailEo> updateKeepMap, List<KeepAccountsDetailEo> accountsDetailEos, Map<String, KeepAccountsDetailEo> keepAccountsDetailEoMap, PushKeepAccountsEo pushKeepAccountsEo) {
        ArrayList chargeCodes = Lists.newArrayList();
        if (null != keepAccountsDetailEoMap) {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType() + "_" + k.getOrderType();
                KeepAccountsDetailEo accountsDetailEo = new KeepAccountsDetailEo();
                KeepAccountsDetailEo detailEo = (KeepAccountsDetailEo)keepAccountsDetailEoMap.get(code);
                if (Objects.nonNull(detailEo)) {
                    detailEo.setItemNum(k.getItemNum());
                    detailEo.setItemType(k.getItemType());
                    detailEo.setItemPrice(k.getItemPrice());
                    detailEo.setProductType(k.getProductType());
                    detailEo.setLineOrderType(k.getLineOrderType());
                    detailEo.setOrderId(k.getOrderId());
                    detailEo.setOrderItemId(k.getOrderItemId());
                    detailEo.setOrderType(k.getOrderType());
                    detailEo.setVoucherType(k.getVoucherType());
                    detailEo.setConditionType(k.getConditionType());
                    detailEo.setOrderInterface(k.getOrderInterface());
                    detailEo.setBillingInterface(k.getBillingInterface());
                    detailEo.setChargeAccountName(k.getChargeAccountName());
                    detailEo.setBillAccountName(k.getBillAccountName());
                    detailEo.setSaleOrderType(k.getSaleOrderType());
                    detailEo.setPlaceTime(k.getPlaceTime());
                    detailEo.setOrderNo(k.getOrderNo());
                    detailEo.setPlatformNo(k.getPlatformNo());
                    detailEo.setWarehouseCode(k.getWarehouseCode());
                    detailEo.setCostCenter(k.getCostCenter());
                    detailEo.setPlatformCreateTime(k.getPlatformCreateTime());
                    detailEo.setWmsItemNo(k.getWmsItemNo());
                    detailEo.setWmsOrderNo(k.getWmsOrderNo());
                    detailEo.setSingle(k.getSingle());
                    updateKeepMap.put(code, detailEo);
                    chargeCodes.add(k.getChargeCode());
                } else {
                    CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                    addKeepMap.put(code, accountsDetailEo);
                    chargeCodes.add(k.getChargeCode());
                }
            });
        } else {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType() + "_" + k.getOrderType();
                KeepAccountsDetailEo accountsDetailEo = new KeepAccountsDetailEo();
                CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                addKeepMap.put(code, accountsDetailEo);
                chargeCodes.add(k.getChargeCode());
            });
        }
        ArrayList<KeepAccountsDetailEo> keepAccountsDetailEos = new ArrayList<KeepAccountsDetailEo>(addKeepMap.values());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            KeepAccountsDetailMapper mapper = (KeepAccountsDetailMapper)session.getMapper(KeepAccountsDetailMapper.class);
            try {
                keepAccountsDetailEos.forEach(v -> mapper.insert(v));
                session.commit();
                session.close();
                session.clearCache();
            }
            finally {
                session.close();
            }
            this.pushKeepAccountsDas.insert((BaseEo)pushKeepAccountsEo);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(updateKeepMap)) {
            updateKeepMap.forEach((k, v) -> this.keepAccountsDetailDas.updateSelective((BaseEo)v));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandlerAuditRespDto retryPushKingdee(List<RetryKeepReqDto> retryKeepReqDtos) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(retryKeepReqDtos)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (retryKeepReqDtos.size() < 1) {
            return handlerAuditRespDto;
        }
        Long successNum = 0L;
        Long failNum = 0L;
        String pushPerson = null != retryKeepReqDtos.get(0) ? retryKeepReqDtos.get(0).getPushPerson() : null;
        for (RetryKeepReqDto v : retryKeepReqDtos) {
            Long l;
            Long l2;
            PushKeepAccountsEo pushKeepAccountsEo;
            Mutex mutex;
            block15: {
                mutex = null;
                mutex = this.lockService.lock(TABLENAME_SAP, Convert.toStr((Object)v.getId()), 10, 20, TimeUnit.SECONDS);
                pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"id", (Object)v.getId())).in((Object)"keeping_result", Arrays.asList(KeepResultEnum.FAIL.getCode(), KeepResultEnum.PENDING.getCode()))).one();
                if (!Objects.isNull(pushKeepAccountsEo)) break block15;
                log.error("{}\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object)v.getId());
                l2 = failNum;
                l = failNum = Long.valueOf(failNum + 1L);
                if (mutex == null) continue;
                this.lockService.unlock(mutex);
                continue;
            }
            try {
                block16: {
                    if (null == mutex) {
                        log.error("\u91cd\u65b0\u751f\u6210\u4ea4\u8d27\u8bb0\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                        throw new BizException("\u91cd\u65b0\u751f\u6210\u4ea4\u8d27\u8bb0\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    PushKeepAccountsReqDto pushKeepAccountsReqDto = new PushKeepAccountsReqDto();
                    pushKeepAccountsReqDto.setChargeCode(pushKeepAccountsEo.getChargeCode());
                    pushKeepAccountsReqDto.setPushPerson(pushPerson);
                    Object xsckNumber = null;
                    Object saleNo = null;
                    Object message = null;
                    String interfaceName = pushKeepAccountsEo.getOrderInterface();
                    String chargeCode = pushKeepAccountsEo.getChargeCode();
                    List keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"charge_code", (Object)pushKeepAccountsEo.getChargeCode())).list();
                    List outResultDetailEos = ((ExtQueryChainWrapper)this.keepOutResultDetailDas.filter().eq((Object)"charge_code", (Object)pushKeepAccountsEo.getChargeCode())).list();
                    try {
                        if (!Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), pushKeepAccountsEo.getVoucherType()) && Objects.equals(VoucherTypeEnum.INVOICE.getCode(), pushKeepAccountsEo.getVoucherType())) {
                            this.modifyPushKeepAndKeepDetail(pushKeepAccountsReqDto);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u8bf7\u6c42\u91d1\u8776\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u63a5\u53e3\u5931\u8d25\uff1a{}", (Throwable)e);
                        pushKeepAccountsReqDto.setReason(e.getMessage());
                        pushKeepAccountsReqDto.setPushStatus(PushStatusEnum.PUSH_FAIL.getCode());
                        pushKeepAccountsReqDto.setKeepingResult(KeepResultEnum.FAIL.getCode());
                        this.modifyPushKeepAndKeepDetail(pushKeepAccountsReqDto);
                        Long l3 = failNum;
                        Long l4 = failNum = Long.valueOf(failNum + 1L);
                        if (!e.getMessage().contains("Read timed out executing")) break block16;
                        KeepTimeOutReqDto timeOutReqDto = new KeepTimeOutReqDto();
                        timeOutReqDto.setChargeCode(chargeCode);
                        timeOutReqDto.setStatus(Integer.valueOf(1));
                        if (Objects.equals(BillTypeEnum.SALE_LIST.getCode(), pushKeepAccountsEo.getOrderType())) {
                            timeOutReqDto.setBusinessType("order");
                        } else {
                            timeOutReqDto.setBusinessType("after");
                        }
                        this.keepTimeOutService.addKeepTimeOut(timeOutReqDto);
                    }
                }
                if (mutex == null) continue;
            }
            catch (Exception e) {
                try {
                    log.error("\u91cd\u65b0\u63a8\u9001SAP\u8d27\u8bb0\u8d26\u5355\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                    l2 = failNum;
                    l = failNum = Long.valueOf(failNum + 1L);
                    if (mutex == null) continue;
                }
                catch (Throwable throwable) {
                    if (mutex != null) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                continue;
            }
            this.lockService.unlock(mutex);
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        return handlerAuditRespDto;
    }

    private Map<String, String> getXSCKNumber(RestResponse restResponse) {
        String xsckNumber = null;
        StringBuffer buffer = new StringBuffer();
        String message = null;
        List datas = JSON.parseList((String)restResponse.getData().toString(), JSONObject.class);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)datas)) {
            for (JSONObject data : datas) {
                String number = data.getString("Number");
                if (StrUtil.isNotBlank((CharSequence)number) && number.startsWith("XS")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u9500\u552e\u51fa\u5e93\u5355\u521b\u5efa\u6210\u529f";
                }
                if (StrUtil.isNotBlank((CharSequence)number) && !number.startsWith("XS")) {
                    buffer.append(number);
                    buffer.append(";");
                    message = "\u91d1\u8776\u9500\u552e\u8ba2\u5355\u521b\u5efa\u6210\u529f";
                }
                if (!StrUtil.isNotBlank((CharSequence)number) || !StrUtil.isBlank((CharSequence)xsckNumber)) continue;
                if (number.startsWith("QTCK")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u5176\u4ed6\u51fa\u5e93\u5355\u521b\u5efa\u6210\u529f";
                }
                if (number.startsWith("FBDC")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u5206\u6b65\u5f0f\u8c03\u51fa\u5355\u521b\u5efa\u6210\u529f";
                }
                if (!number.startsWith("ZJDB")) continue;
                xsckNumber = number;
                message = "\u91d1\u8776\u76f4\u63a5\u8c03\u62e8\u5355\u521b\u5efa\u6210\u529f";
            }
        }
        message = StrUtil.isNotBlank(message) ? message : "\u91d1\u8776\u7cfb\u7edf\u5355\u53f7\u83b7\u53d6\u5931\u8d25";
        HashMap<String, String> xsckResult = new HashMap<String, String>();
        xsckResult.put("xsckNumber", xsckNumber);
        xsckResult.put("saleNo", StringUtils.isNotBlank((CharSequence)buffer) ? buffer.deleteCharAt(buffer.toString().length() - 1).toString() : null);
        xsckResult.put("message", message);
        return xsckResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairKeepAccountDocumentNo(BookKeepingRepairReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"id", (Object)reqDto.getId())).one();
        AssertUtils.notNull((Object)reqDto, (String)"\u8bb0\u8d26\u5355\u4e0d\u5b58\u5728!");
        if (!Objects.equals(BillTypeEnum.RETURN_BASE.getCode(), pushKeepAccountsEo.getOrderType()) && !Objects.equals(BillTypeEnum.EXCHANGE.getCode(), pushKeepAccountsEo.getOrderType())) {
            throw new BizException("\u8be5\u8bb0\u8d26\u5355\u4e0d\u662f\u9000\u8d27\u9000\u6b3e\u6216\u6362\u8d27\u8bb0\u8d26\u5355");
        }
        if (Objects.equals(KeepResultEnum.SUCCESS.getCode(), pushKeepAccountsEo.getKeepingResult())) {
            throw new BizException("\u8bb0\u8d26\u5355\u5df2\u8bb0\u8d26\u6210\u529f\uff0c\u65e0\u6cd5\u4fee\u6539\u51fa\u5165\u5e93\u5355\u636e\u53f7");
        }
        PushKeepAccountsEo accountsEo = new PushKeepAccountsEo();
        pushKeepAccountsEo.setId(reqDto.getId());
        pushKeepAccountsEo.setDocumentNo(reqDto.getDocumentNo());
        pushKeepAccountsEo.setUpdatePerson(reqDto.getUpdatePerson());
        this.pushKeepAccountsDas.updateSelective((BaseEo)accountsEo);
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", new Object[]{pushKeepAccountsEo.getChargeCode()})).eq((Object)"book_keeping", (Object)BookKeepingType.NOT_DEAL.getCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) {
            keepAccountsDetailEos.forEach(v -> {
                KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                detailEo.setId(v.getId());
                detailEo.setDocumentNo(reqDto.getDocumentNo());
                detailEo.setUpdatePerson(reqDto.getUpdatePerson());
                this.keepAccountsDetailDas.updateSelective((BaseEo)detailEo);
            });
        }
    }

    @Override
    public void pushInterfacePlatform(KeepAccountBillReqDto keepAccountBillReqDto) {
        log.info("\u8bf7\u6c42ERP\u63a5\u53e3\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)keepAccountBillReqDto));
        try {
            KeepAccountBillRespDto keepAccountBillRespDto = this.dynamicIKeepAccountBillSyncApiOpenApi.IKeepAccountBillSyncApi(keepAccountBillReqDto);
            log.info("\u8bf7\u6c42ERP\u63a5\u53e3,\u54cd\u5e94\u7ed3\u679c:{}", (Object)com.alibaba.fastjson.JSON.toJSONString((Object)keepAccountBillRespDto));
            if (Objects.nonNull(keepAccountBillRespDto)) {
                PushKeepAccountsReqDto pushKeepAccountsReqDto = new PushKeepAccountsReqDto();
                CubeBeanUtils.copyProperties((Object)pushKeepAccountsReqDto, (Object)keepAccountBillRespDto, (String[])new String[0]);
                this.pushKeepAccountsService.modifyPushKeepAndKeepDetail(pushKeepAccountsReqDto);
            }
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42ERP\u63a5\u53e3,\u5bf9\u63a5\u5931\u8d25");
            e.printStackTrace();
        }
    }

    @Override
    public RestResponse<BatchModifyPushKeepAccount> modifyPushKeepAccountOfAfterSaleOrder(PushKeepAccountsReqDto pushKeepAccountsReqDto) {
        List ids = pushKeepAccountsReqDto.getIds();
        String outSaleOrderNo = pushKeepAccountsReqDto.getOutSaleOrderNo();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ids)) {
            throw new BizException("\u4fee\u6539\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int failCount = 0;
        int succCount = 0;
        ArrayList<BatchModifyPushKeepAccount.ResMsg> resMsgs = new ArrayList<BatchModifyPushKeepAccount.ResMsg>();
        for (Long id : ids) {
            String msg;
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)this.pushKeepAccountsDas.selectByPrimaryKey(id);
            String accountingResult = pushKeepAccountsEo.getAccountingResult();
            String orderType = pushKeepAccountsEo.getOrderType();
            Integer afterSaleOrderType = pushKeepAccountsEo.getAfterSaleOrderType();
            if (!accountingResult.equals(AccountRuleEnum.ACCOUNT_FAIL.getCode()) && !accountingResult.equals(AccountRuleEnum.ACCOUNTING.getCode())) {
                msg = id + ":\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a: " + accountingResult + " \u4e0d\u5141\u8bb8\u4fee\u6539\u9500\u552e\u5355\u53f7";
                failCount = PushKeepAccountsServiceImpl.savaFailMesg(failCount, resMsgs, msg);
                continue;
            }
            if (!orderType.equals(AccountRuleEnum.RETURN_BASE.getCode()) && !orderType.equals(AccountRuleEnum.EXCHANGE.getCode())) {
                msg = id + ":\u5f53\u524d\u5355\u636e\u7c7b\u578b\u4e3a: " + orderType + " \u4e0d\u5141\u8bb8\u4fee\u6539\u9500\u552e\u5355\u53f7";
                failCount = PushKeepAccountsServiceImpl.savaFailMesg(failCount, resMsgs, msg);
                continue;
            }
            if (afterSaleOrderType == 0) {
                msg = id + ":\u5f53\u524d\u5355\u636e\u7c7b\u578b\u4e3a\u6709\u6e90\u5355,\u4e0d\u5141\u8bb8\u4fee\u6539\u9500\u552e\u5355\u53f7";
                failCount = PushKeepAccountsServiceImpl.savaFailMesg(failCount, resMsgs, msg);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)outSaleOrderNo)) {
                pushKeepAccountsEo.setSaleNo(outSaleOrderNo);
            }
            if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getXfSalesOrderNo())) {
                pushKeepAccountsEo.setXfSalesOrderNo(pushKeepAccountsReqDto.getXfSalesOrderNo());
            }
            this.pushKeepAccountsDas.updateSelective((BaseEo)pushKeepAccountsEo);
            ++succCount;
        }
        BatchModifyPushKeepAccount batchModifyPushKeepAccount = new BatchModifyPushKeepAccount();
        batchModifyPushKeepAccount.setFailCount(failCount);
        batchModifyPushKeepAccount.setSuccCount(succCount);
        batchModifyPushKeepAccount.setResMsgList(resMsgs);
        return new RestResponse((Object)batchModifyPushKeepAccount);
    }

    private static int savaFailMesg(int failCount, ArrayList<BatchModifyPushKeepAccount.ResMsg> resMsgs, String msg) {
        BatchModifyPushKeepAccount.ResMsg resMsg = new BatchModifyPushKeepAccount.ResMsg();
        resMsg.setMsg(msg);
        resMsgs.add(resMsg);
        return ++failCount;
    }

    @Override
    public RestResponse<List<PushOutsideSysAccountDto>> queryPushKeepAccountByChargeCode(PushKeepAccountsReqDto pushKeepAccountsReqDto) {
        List chargeCodes = pushKeepAccountsReqDto.getChargeCodes();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)chargeCodes)) {
            throw new BizException("\u67e5\u8be2\u8bb0\u8d26\u53f7\u4e3a\u7a7a");
        }
        List<PushKeepAccountsEo> pushKeepAccountsEos = this.getPushKeepAccountsEos(chargeCodes);
        String voucherType = pushKeepAccountsEos.get(0).getVoucherType();
        Map pushAccountsEoMap = pushKeepAccountsEos.stream().collect(Collectors.toMap(PushKeepAccountsEo::getChargeCode, Function.identity()));
        List<KeepAccountsDetailEo> keepAccountsDetailEos = this.getKeepAccountsDetailEos(chargeCodes);
        Map<String, List<KeepAccountsDetailEo>> collected = keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode));
        ArrayList addPushKeepAccountsEos = new ArrayList();
        collected.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty((Collection)v)) {
                KeepAccountsDetailEo accountsDetailEo = (KeepAccountsDetailEo)v.get(0);
                String chargeCode = accountsDetailEo.getChargeCode();
                PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)pushAccountsEoMap.get(chargeCode);
                PushOutsideSysAccountDto pushOutsideSysAccountDto = new PushOutsideSysAccountDto();
                PushKeepAccountVo pushKeepAccountVo = new PushKeepAccountVo();
                CubeBeanUtils.copyProperties((Object)pushKeepAccountVo, (Object)pushKeepAccountsEo, (String[])new String[0]);
                pushKeepAccountVo.setItemType(accountsDetailEo.getItemType());
                pushOutsideSysAccountDto.setPushKeepAccountVo(pushKeepAccountVo);
                ArrayList<PushKeepAccountDetailVo> keepAccountVos = new ArrayList<PushKeepAccountDetailVo>();
                for (KeepAccountsDetailEo detailEo : v) {
                    PushKeepAccountDetailVo temp = new PushKeepAccountDetailVo();
                    CubeBeanUtils.copyProperties((Object)temp, (Object)detailEo, (String[])new String[0]);
                    keepAccountVos.add(temp);
                }
                pushOutsideSysAccountDto.setPushKeepAccountDetailVos(keepAccountVos);
                addPushKeepAccountsEos.add(pushOutsideSysAccountDto);
            }
        });
        return new RestResponse(addPushKeepAccountsEos);
    }

    @Override
    public RestResponse<Void> modifyPushKeepAccountByChargeCode(List<PushKeepAccountsReqDto> pushKeepAccountsReqDtos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(pushKeepAccountsReqDtos)) {
            throw new BizException("\u66f4\u65b0\u8bb0\u8d26\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PushKeepAccountsReqDto pushKeepAccountsReqDto : pushKeepAccountsReqDtos) {
            int length;
            PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
            pushKeepAccountsEo.setChargeCode(pushKeepAccountsReqDto.getChargeCode());
            PushKeepAccountsEo accountsEo = (PushKeepAccountsEo)this.pushKeepAccountsDas.selectOne((BaseEo)pushKeepAccountsEo);
            if (null == accountsEo) continue;
            PushKeepAccountsEo keepAccountsEo = PushKeepAccountsServiceImpl.assemblyPushKeepAccountsEo(pushKeepAccountsReqDto, accountsEo);
            this.pushKeepAccountsDas.updateSelective((BaseEo)keepAccountsEo);
            List keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"charge_code", (Object)pushKeepAccountsReqDto.getChargeCode())).list();
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) continue;
            ArrayList accountsDetailEos = Lists.newArrayList();
            keepAccountsDetailEos.forEach(v -> {
                KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                detailEo.setId(v.getId());
                PushKeepAccountsServiceImpl.AssemblyAccountsDetailEos(pushKeepAccountsReqDto, detailEo);
                accountsDetailEos.add(detailEo);
            });
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) continue;
            int i = 0;
            for (length = accountsDetailEos.size(); length > 500; length -= 500) {
                this.keepAccountsDetailDas.batchUpdateKeepAccountsDetail(accountsDetailEos.subList(i, i + 500));
                i += 500;
            }
            if (length <= 0) continue;
            this.keepAccountsDetailDas.batchUpdateKeepAccountsDetail(accountsDetailEos.subList(i, i + length));
        }
        return RestResponse.VOID;
    }

    private static PushKeepAccountsEo assemblyPushKeepAccountsEo(PushKeepAccountsReqDto pushKeepAccountsReqDto, PushKeepAccountsEo accountsEo) {
        PushKeepAccountsEo keepAccountsEo = new PushKeepAccountsEo();
        keepAccountsEo.setId(accountsEo.getId());
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getSaleNo())) {
            keepAccountsEo.setSaleNo(pushKeepAccountsReqDto.getSaleNo());
        }
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getOutSaleOrderType())) {
            keepAccountsEo.setExternalOrderType(pushKeepAccountsReqDto.getOutSaleOrderType());
        }
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getDeliveryNote())) {
            keepAccountsEo.setDeliveryNote(pushKeepAccountsReqDto.getDeliveryNote());
        }
        if (null != pushKeepAccountsReqDto.getChargeDate()) {
            keepAccountsEo.setChargeDate(pushKeepAccountsReqDto.getChargeDate());
        }
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getReason())) {
            keepAccountsEo.setReason(pushKeepAccountsReqDto.getReason());
        }
        if (null != pushKeepAccountsReqDto.getDeliveryPushTime()) {
            keepAccountsEo.setDeliveryPushTime(pushKeepAccountsReqDto.getDeliveryPushTime());
        }
        if (null != pushKeepAccountsReqDto.getInvoicePushTime()) {
            keepAccountsEo.setInvoicePushTime(pushKeepAccountsReqDto.getInvoicePushTime());
        }
        if (Objects.equals(AccountRuleEnum.ACCOUNT_SUCCESS.getCode(), pushKeepAccountsReqDto.getAccountingResult())) {
            keepAccountsEo.setReason("-");
            keepAccountsEo.setAccountingResult(AccountRuleEnum.ACCOUNT_SUCCESS.getCode());
        } else if (Objects.equals(AccountRuleEnum.PUSHING.getCode(), pushKeepAccountsReqDto.getAccountingResult())) {
            keepAccountsEo.setAccountingResult(AccountRuleEnum.PUSHING.getCode());
        } else if (Objects.equals(AccountRuleEnum.ACCOUNT_FAIL.getCode(), pushKeepAccountsReqDto.getAccountingResult())) {
            keepAccountsEo.setAccountingResult(AccountRuleEnum.ACCOUNT_FAIL.getCode());
        } else {
            keepAccountsEo.setAccountingResult(AccountRuleEnum.ACCOUNTING.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getPushPerson())) {
            keepAccountsEo.setPushPerson(pushKeepAccountsReqDto.getPushPerson());
        }
        keepAccountsEo.setPushStatus(pushKeepAccountsReqDto.getPushStatus());
        keepAccountsEo.setKeepingResult(pushKeepAccountsReqDto.getKeepingResult());
        if (StringUtils.isNotBlank((CharSequence)pushKeepAccountsReqDto.getInvoiceNo())) {
            keepAccountsEo.setInvoiceNo(pushKeepAccountsReqDto.getInvoiceNo());
        }
        if (Objects.nonNull(pushKeepAccountsReqDto.getCompleteTime())) {
            keepAccountsEo.setCompleteTime(pushKeepAccountsReqDto.getCompleteTime());
        }
        if (Objects.nonNull(pushKeepAccountsReqDto.getAccountingCompleteTime())) {
            keepAccountsEo.setAccountingCompleteTime(pushKeepAccountsReqDto.getAccountingCompleteTime());
        }
        if (Objects.nonNull(pushKeepAccountsReqDto.getGroupReceiveOrder())) {
            keepAccountsEo.setGroupReceiveOrder(pushKeepAccountsReqDto.getGroupReceiveOrder());
        }
        if (Objects.nonNull(pushKeepAccountsReqDto.getU9ConversionOrderNo())) {
            keepAccountsEo.setU9ConversionOrderNo(pushKeepAccountsReqDto.getU9ConversionOrderNo());
        }
        return keepAccountsEo;
    }

    @Override
    @Transactional
    public void updateAccountStatusByChargeCodes(Set<String> chargeCodeList, String keepingResult, String accountingResult) {
        if (CollectionUtil.isEmpty(chargeCodeList) || Objects.isNull(keepingResult) || Objects.isNull(accountingResult)) {
            return;
        }
        this.pushKeepAccountsDas.updateAccountStatusByChargeCodes(chargeCodeList, keepingResult, accountingResult);
        this.keepAccountsDetailDas.updateAccountStatusByChargeCodes(chargeCodeList, accountingResult);
    }

    @Override
    public Boolean createInternalOrder(String chargeCode) {
        log.info("\u521b\u5efa\u8bb0\u8d26\u5355\u5185\u90e8\u4ea4\u6613\uff08\u91cd\u65b0\u63a8\u4f7f\u7528\uff09\uff1a{}", (Object)chargeCode);
        List detailEoList = ((ExtQueryChainWrapper)this.keepAccountsDetailDomain.filter().eq((Object)"charge_code", (Object)chargeCode)).list();
        OrderRuleRespDto orderRuleRespDto = new OrderRuleRespDto();
        orderRuleRespDto.setInsiderTransactionAction("yes");
        orderRuleRespDto.setIsSendMQ(Boolean.valueOf(false));
        KeepNodeRuleParam param = new KeepNodeRuleParam();
        param.setOrderRuleRespDto(orderRuleRespDto);
        return this.fianceInsiderTransactionService.insertInnerOrder(detailEoList, param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void updateBalanceProcessingResult(String chargeCode, String result) {
        this.pushKeepAccountsDomain.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(PushKeepAccountsEo.class).eq(PushKeepAccountsEo::getChargeCode, (Object)chargeCode)).set(PushKeepAccountsEo::getBalanceProcessingResult, (Object)result)).set(BaseEo::getUpdateTime, (Object)new Date()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void updateQueryPriceResultSuccess(String chargeCode) {
        this.pushKeepAccountsDomain.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(PushKeepAccountsEo.class).eq(PushKeepAccountsEo::getChargeCode, (Object)chargeCode)).set(PushKeepAccountsEo::getQueryPriceResult, (Object)"SUCCESS")).set(BaseEo::getUpdateTime, (Object)new Date()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAccountResultPushing(List<String> chargeCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(chargeCodes)) {
            return;
        }
        List lists = Lists.partition(chargeCodes, (int)1000);
        lists.forEach(codes -> {
            this.pushKeepAccountsDomain.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(PushKeepAccountsEo.class).in(PushKeepAccountsEo::getChargeCode, (Collection)codes)).eq(PushKeepAccountsEo::getAccountingResult, (Object)AccountRuleEnum.ACCOUNTING.getCode())).set(PushKeepAccountsEo::getAccountingResult, (Object)AccountRuleEnum.PUSHING.getCode())).set(BaseEo::getUpdateTime, (Object)new Date())).set(BaseEo::getUpdatePerson, (Object)ServiceContext.getContext().getRequestUserCode()));
            this.keepAccountsDetailDomain.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(KeepAccountsDetailEo.class).in(KeepAccountsDetailEo::getChargeCode, (Collection)codes)).eq(KeepAccountsDetailEo::getAccountingResult, (Object)AccountRuleEnum.ACCOUNTING.getCode())).set(KeepAccountsDetailEo::getAccountingResult, (Object)AccountRuleEnum.PUSHING.getCode())).set(BaseEo::getUpdateTime, (Object)new Date())).set(BaseEo::getUpdatePerson, (Object)ServiceContext.getContext().getRequestUserCode()));
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> submitPushKeepAccount(List<SaleOrderItemVo> saleOrderItemVos) {
        log.info("\u5bf9\u63a5\u5916\u90e8\u53c2\u6570\u8bf7\u6c42dto:{}", (Object)com.alibaba.fastjson.JSON.toJSONString(saleOrderItemVos));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderItemVos)) {
            throw new BizException("\u8bb0\u8d26\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KeepNodeRuleParam keepNodeRuleParam = new KeepNodeRuleParam();
        this.extractedAssemblyDate(keepNodeRuleParam);
        this.keepNodeCommonService.summaryGroupingKeepNode(keepNodeRuleParam, saleOrderItemVos);
        this.keepNodeCommonService.insertPushKeepAccountAndDetail(saleOrderItemVos, keepNodeRuleParam);
        this.keepNodeCommonService.handlerPushKeepAccountsAmount(saleOrderItemVos);
        List orderNo = saleOrderItemVos.stream().map(SaleOrderItemVo::getOrderNo).collect(Collectors.toList());
        List pushKeepAccountsEos = ((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in(org.apache.commons.collections.CollectionUtils.isEmpty(orderNo), (Object)"order_no", orderNo)).list();
        List<String> chargCodes = pushKeepAccountsEos.stream().map(PushKeepAccountsEo::getChargeCode).collect(Collectors.toList());
        this.iKeepNodeCommonService.sendPushKeepAccountMessage(chargCodes);
        return RestResponse.SUCCEED;
    }

    @Override
    public void updateAccountCompleteTime(PushKeepAccountsReqDto pushReqDto) {
        if (Objects.isNull(pushReqDto) || Objects.isNull(pushReqDto.getChargeCode()) || Objects.isNull(pushReqDto.getCompleteTime())) {
            return;
        }
        PushKeepAccountsEo accountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)pushReqDto.getChargeCode())).one();
        if (Objects.isNull(accountsEo)) {
            return;
        }
        PushKeepAccountsEo updateAccountsEo = new PushKeepAccountsEo();
        updateAccountsEo.setId(accountsEo.getId());
        updateAccountsEo.setCompleteTime(pushReqDto.getCompleteTime());
        this.pushKeepAccountsDas.updateSelective((BaseEo)updateAccountsEo);
        List details = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"charge_code", (Object)accountsEo.getChargeCode())).list();
        if (CollectionUtil.isEmpty((Collection)details)) {
            return;
        }
        for (KeepAccountsDetailEo detail : details) {
            KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
            detailEo.setId(detail.getId());
            detailEo.setCompleteTime(pushReqDto.getCompleteTime());
            this.keepAccountsDetailDas.updateSelective((BaseEo)detailEo);
        }
    }

    private void extractedAssemblyDate(KeepNodeRuleParam keepNodeRuleParam) {
        OrderRuleRespDto orderRuleRespDto = this.orderRuleService.queryOrderRule(new OrderRuleReqDto());
        RuleParamReqDto paramReqDto = new RuleParamReqDto();
        String voucherType = "0";
        keepNodeRuleParam.setParamReqDto(paramReqDto);
        paramReqDto.setVoucherType(voucherType);
        keepNodeRuleParam.setOrderRuleRespDto(orderRuleRespDto);
        keepNodeRuleParam.setAction(true);
        keepNodeRuleParam.setCreator("system");
    }

    private List<PushKeepAccountsEo> getPushKeepAccountsEos(List<String> chargeCodes) {
        List pushKeepAccountsEoList;
        int length;
        ArrayList pushKeepAccountsEos = Lists.newArrayList();
        if (CollectionUtil.isEmpty(chargeCodes)) {
            return pushKeepAccountsEos;
        }
        int i = 0;
        for (length = chargeCodes.size(); length > 1000; length -= 1000) {
            pushKeepAccountsEoList = ((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + 1000))).list();
            pushKeepAccountsEos.addAll(pushKeepAccountsEoList);
            i += 1000;
        }
        if (length > 0) {
            pushKeepAccountsEoList = ((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).list();
            pushKeepAccountsEos.addAll(pushKeepAccountsEoList);
        }
        return pushKeepAccountsEos;
    }

    private List<KeepAccountsDetailEo> getKeepAccountsDetailEos(List<String> chargeCodes) {
        int length;
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        if (CollectionUtil.isEmpty(chargeCodes)) {
            return keepAccountsDetailEos;
        }
        int i = 0;
        for (length = chargeCodes.size(); length > 1000; length -= 1000) {
            List keepAccountsDetailEoList = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + 1000))).list();
            keepAccountsDetailEos.addAll(keepAccountsDetailEoList);
            i += 1000;
        }
        if (length > 0) {
            List pushKeepAccountsEoList = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).list();
            keepAccountsDetailEos.addAll(pushKeepAccountsEoList);
        }
        return keepAccountsDetailEos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public HandlerAuditRespDto batchDeleteBookKeeping(List<String> chargeCodes) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(chargeCodes)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long successNum = 0L;
        Long failNum = 0L;
        String updatePerson = ServiceContext.getContext().getRequestUserCode();
        for (String v : chargeCodes) {
            Long l;
            Long l2;
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)v)).in((Object)"accounting_result", Arrays.asList("ACCOUNTING", "ACCOUNT_FAIL"))).one();
            log.info("pushKeepAccountsEo:{}", (Object)JSONObject.toJSONString((Object)pushKeepAccountsEo));
            if (Objects.isNull(pushKeepAccountsEo)) {
                log.error("{}\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object)v);
                continue;
            }
            Mutex mutex = null;
            try {
                mutex = this.lockService.lock(DELETE_KEEP, v, 10, 20, TimeUnit.SECONDS);
                if (null == mutex) {
                    log.error("\u8bb0\u8d26\u5355\u5220\u9664\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    throw new BizException("\u8bb0\u8d26\u5355\u5220\u9664\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                this.pushKeepAccountsDas.logicDeleteById(pushKeepAccountsEo.getId());
                List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", Arrays.asList(pushKeepAccountsEo.getChargeCode()))).in((Object)"accounting_result", Arrays.asList("ACCOUNTING", "ACCOUNT_FAIL"))).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) {
                    List codes = keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getChargeCode).distinct().collect(Collectors.toList());
                    this.pushKeepAccountsDas.batchRemoveKeepDetail(codes, updatePerson);
                }
                l2 = successNum;
                l = successNum = Long.valueOf(successNum + 1L);
                if (mutex == null) continue;
            }
            catch (Exception e) {
                try {
                    log.error("\u5220\u9664\u8bb0\u8d26\u5355\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                    l2 = failNum;
                    l = failNum = Long.valueOf(failNum + 1L);
                    if (mutex == null) continue;
                }
                catch (Throwable throwable) {
                    if (mutex != null) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                continue;
            }
            this.lockService.unlock(mutex);
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        return handlerAuditRespDto;
    }

    private void generateRefundOnlyKeep(List<String> orderNos, String updatePerson) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderNos)) {
            return;
        }
        List afterSaleOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().in((Object)"sale_order_no", orderNos)).eq((Object)"status", (Object)OmsSaleOrderStatus.FINISH.getCode())).eq((Object)"after_sale_order_type", (Object)AfterSaleOrderTypeEnum.FHHTK.getCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)afterSaleOrderEos)) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u5355\uff1a{}", (Object)JSONObject.toJSONString(orderNos));
            return;
        }
        List<String> afterSaleOrderNos = afterSaleOrderEos.stream().map(AfterSaleOrderEo::getAfterSaleOrderNo).collect(Collectors.toList());
        List afterSaleOrderIs = afterSaleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List afterSaleOrderItemEos = ((ExtQueryChainWrapper)this.afterSaleOrderItemDomain.filter().in((Object)"after_sale_order_id", afterSaleOrderIs)).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)afterSaleOrderItemEos)) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u5355\u660e\u7ec6\uff1a{}", (Object)JSONObject.toJSONString(orderNos));
            return;
        }
        List orderItemIds = afterSaleOrderItemEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).in((Object)"order_item_id", orderItemIds)).in((Object)"order_no", afterSaleOrderNos)).eq((Object)"order_type", (Object)BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())).list();
        HashSet<String> afterSaleNos = new HashSet<String>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)keepAccountsDetailEos)) {
            afterSaleNos.addAll(afterSaleOrderNos);
        } else {
            Map<String, List<KeepAccountsDetailEo>> collect = keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getOrderNo));
            afterSaleOrderNos.forEach(v -> {
                if (!collect.containsKey(v)) {
                    afterSaleNos.add((String)v);
                }
            });
        }
        MamualKeepAccountReqDto keepAccountReqDto = new MamualKeepAccountReqDto();
        keepAccountReqDto.setType(KeepTypeEnum.REAL.getCode());
        keepAccountReqDto.setAccountType(KeepTypeEnum.REAL.getCode());
        keepAccountReqDto.setGeneratePerson(updatePerson);
        log.info("\u9700\u8981\u751f\u6210\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u7684\u5355\u636e\uff1a{}", (Object)JSONObject.toJSONString(afterSaleNos));
        afterSaleNos.forEach(v -> {
            keepAccountReqDto.setOrderType(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode());
            keepAccountReqDto.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
            keepAccountReqDto.setInnerOrderNo(v);
            log.info("\u6b63\u5411\u5f00\u7968\u8bb0\u8d26\u6210\u529f\uff0c\u9006\u5411\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u5f00\u7968\u8bb0\u8d26\uff1a{}", (Object)JSONObject.toJSONString((Object)keepAccountReqDto));
            this.syncKeepAccountingService.manualGenerateBookAccount(keepAccountReqDto);
        });
    }

    private static void setAttachmentAsync(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ServiceContext.getContext().setAttachment(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public HandlerAuditRespDto modifySalesAreaSalesDepartmentDto(ModifySalesAreaSalesDepartmentDto dto) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        if (Objects.isNull(dto) || CollectionUtil.isEmpty((Collection)dto.getChargeCodeList())) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long successNum = 0L;
        Long failNum = 0L;
        String updatePerson = ServiceContext.getContext().getRequestUserCode();
        List pushKeepAccountsEos = ((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"charge_code", (Collection)dto.getChargeCodeList())).list();
        AssertUtils.notEmpty((Collection)pushKeepAccountsEos, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8bb0\u8d26\u5355");
        ArrayList pushIds = Lists.newArrayList();
        ArrayList chargeCodes = Lists.newArrayList();
        StringBuffer buffer = new StringBuffer();
        Map pushKeepAccountsEoMap = pushKeepAccountsEos.stream().collect(Collectors.toMap(PushKeepAccountsEo::getChargeCode, Function.identity(), (v1, v2) -> v1));
        block3: for (Map.Entry entry : pushKeepAccountsEoMap.entrySet()) {
            Long l;
            Long l2;
            String key = entry.getKey();
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)entry.getValue();
            BillTypeEnum billTypeEnum = BillTypeEnum.getEnum((String)pushKeepAccountsEo.getOrderType());
            log.info("billTypeEnum:{},{}", (Object)pushKeepAccountsEo.getChargeCode(), (Object)JSONObject.toJSONString((Object)billTypeEnum));
            switch (billTypeEnum) {
                case SALE_LIST: 
                case RETURN_BASE: 
                case EXCHANGE: {
                    if ("SALES_ORDER_MAIN".equals(pushKeepAccountsEo.getChargeAccountCode()) || "RETURN_REFUND_MAIN".equals(pushKeepAccountsEo.getChargeAccountCode()) || "EXCHANGE_ORDER_MAIN".equals(pushKeepAccountsEo.getChargeAccountCode())) {
                        if (!YesOrNoEnum.YES.getCode().equals(pushKeepAccountsEo.getGroupAccounting())) {
                            buffer.append(key + " \u4fee\u6539\u5931\u8d25\uff1a\u539f\u56e0\uff1a\u975e\u4e0b\u6c89\u6e20\u9053\u5df2\u5206\u7ec4\u8bb0\u8d26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01;\n").append(";");
                            l2 = failNum;
                            l = failNum = Long.valueOf(failNum + 1L);
                            continue block3;
                        }
                        if (!AccountRuleEnum.ACCOUNT_FAIL.getCode().equals(pushKeepAccountsEo.getAccountingResult()) && !AccountRuleEnum.ACCOUNTING.getCode().equals(pushKeepAccountsEo.getAccountingResult())) {
                            buffer.append(key + " \u4fee\u6539\u5931\u8d25\uff1a\u539f\u56e0\uff1a\u975e\u8bb0\u8d26\u5931\u8d25\u6216\u5f85\u8bb0\u8d26\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01;\n").append(";");
                            l2 = failNum;
                            l = failNum = Long.valueOf(failNum + 1L);
                            continue block3;
                        }
                        pushIds.add(pushKeepAccountsEo.getId());
                        chargeCodes.add(key);
                        continue block3;
                    }
                    buffer.append(key + " \u4fee\u6539\u5931\u8d25\uff1a\u539f\u56e0\uff1a\u975e\u4e0b\u6c89\u6e20\u9053\u5df2\u5206\u7ec4\u8bb0\u8d26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01;\n").append(";");
                    l2 = failNum;
                    l = failNum = Long.valueOf(failNum + 1L);
                    continue block3;
                }
            }
            buffer.append(key + " \u4fee\u6539\u5931\u8d25\uff1a\u539f\u56e0\uff1a\u975e\u4e0b\u6c89\u6e20\u9053\u5df2\u5206\u7ec4\u8bb0\u8d26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01;\n").append(";");
            l2 = failNum;
            l = failNum = Long.valueOf(failNum + 1L);
        }
        if (CollectionUtil.isNotEmpty((Collection)pushIds)) {
            successNum = Convert.toLong((Object)pushIds.size());
            pushIds.forEach(v -> {
                PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
                pushKeepAccountsEo.setId(v);
                pushKeepAccountsEo.setSaleAreaId(dto.getSaleAreaId());
                pushKeepAccountsEo.setSaleAreaCode(dto.getSaleAreaCode());
                pushKeepAccountsEo.setSaleAreaName(dto.getSaleAreaName());
                pushKeepAccountsEo.setSaleDeptId(dto.getSaleDeptId());
                pushKeepAccountsEo.setSaleDeptCode(dto.getSaleDeptCode());
                pushKeepAccountsEo.setSaleDeptName(dto.getSaleDeptName());
                pushKeepAccountsEo.setUpdatePerson(updatePerson);
                pushKeepAccountsEo.setUpdateTime(new Date());
                pushKeepAccountsEo.setIdentity("0");
                this.pushKeepAccountsDas.updateSelective((BaseEo)pushKeepAccountsEo);
            });
            List details = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", (Collection)chargeCodes)).list();
            details.forEach(v -> {
                KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                detailEo.setId(v.getId());
                detailEo.setSaleAreaId(dto.getSaleAreaId());
                detailEo.setSaleAreaCode(dto.getSaleAreaCode());
                detailEo.setSaleAreaName(dto.getSaleAreaName());
                detailEo.setSaleDeptId(dto.getSaleDeptId());
                detailEo.setSaleDeptCode(dto.getSaleDeptCode());
                detailEo.setSaleDeptName(dto.getSaleDeptName());
                detailEo.setUpdatePerson(updatePerson);
                detailEo.setUpdateTime(new Date());
                detailEo.setProvinceCityMapping(Convert.toStr((Object)Boolean.TRUE));
                detailEo.setProvinceCityMappingContent("");
                this.keepAccountsDetailDas.updateSelective((BaseEo)detailEo);
            });
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        handlerAuditRespDto.setMessage(StringUtils.isNotBlank((CharSequence)buffer.toString()) ? buffer.toString() : null);
        return handlerAuditRespDto;
    }
}

