/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.center.finance.dao.das.IOrderRuleDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IShopRuleDomain;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.mq.DeliveryItemDto;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.response.AfterSaleOrderRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.eo.OrderRuleEo;
import com.yunxi.dg.base.center.finance.service.entity.IAfterSaleOrderItemService;
import com.yunxi.dg.base.center.finance.service.entity.IAfterSaleOrderService;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepAccountsDetailService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IRealTimeAccountingService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepAccountRuleFactory;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoOutNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RealTimeAccountingServiceImpl
implements IRealTimeAccountingService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IAfterSaleOrderService afterSaleOrderService;
    @Resource
    private IAfterSaleOrderItemService afterSaleOrderItemService;
    @Resource
    private IOrderRuleService orderRuleService;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IShopRuleDomain shopRuleDomain;
    @Resource
    private IKeepAccountsDetailService keepAccountsDetailService;
    @Resource
    private IBookKeepAccountService bookKeepAccountService;
    @Resource
    private ILockService lockService;
    @Resource
    private IOrderRuleDas orderRuleDas;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgPerformOrderInfoOutNoticeSyncRecordDomain dgPerformOrderInfoOutNoticeSyncRecordDomain;
    @Value(value="${keep.polling:5}")
    private Integer polling;
    private static final String TABLENAME = "mq_after_sale_order_status_keep_change#";
    private static final String TABLENAME_SALE = "mq_sale_order_status_keep_change#";
    private static final String message = "\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\u4e0d\u7b26\u5408\u8bb0\u8d26";

    @Override
    public void execute(String afterSaleOrderNo, String status, String mode, String orderType) {
        this.logger.info("\u5b9e\u65f6\u8bb0\u8d26\u552e\u540e\u5355\u53f7:{}", (Object)afterSaleOrderNo);
        Mutex mutex = null;
        try {
            String primaryKey = afterSaleOrderNo;
            mutex = this.lockService.lock(TABLENAME, primaryKey);
            if (null == mutex) {
                throw new BizException(String.format("\u63a5\u6536\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5b9e\u65f6\u9000\u8d27\u9000\u6b3e,\u6362\u8d27\u5355\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,primaryKey:\u3010%s\u3011", primaryKey));
            }
            AfterSaleOrderRespDto afterSaleOrderRespDto = this.getOrderNo(afterSaleOrderNo, null, null);
            this.logger.info("\u8f6e\u8be2\u540e\u552e\u540e\u5355\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)afterSaleOrderRespDto));
            if (!Objects.equals(afterSaleOrderRespDto.getIfRecord(), 1)) {
                this.logger.info("\u552e\u540e\u5355\u5355\u53f7\uff1a{}\uff0c\u4e0d\u8bb0\u8d26\uff1a{}", (Object)afterSaleOrderRespDto.getAfterSaleOrderNo(), (Object)afterSaleOrderRespDto.getIfRecord());
                return;
            }
            String afterOrderType = "";
            if (AfterSaleOrderTypeEnum.THTK.getCode().equals(orderType)) {
                afterOrderType = BillTypeEnum.RETURN_BASE.getCode();
            } else if (AfterSaleOrderTypeEnum.HH.getCode().equals(orderType)) {
                afterOrderType = BillTypeEnum.EXCHANGE.getCode();
            } else if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(orderType)) {
                afterOrderType = BillTypeEnum.DELIVERY_REFUND_ONLY.getCode();
            }
            Boolean ifOriginal = StringUtils.isNotBlank((CharSequence)afterSaleOrderRespDto.getSaleOrderNo());
            MamualKeepAccountReqDto mamualKeepAccountReqDto = new MamualKeepAccountReqDto();
            ArrayList<String> innerOrder = new ArrayList<String>();
            innerOrder.add(afterSaleOrderNo);
            mamualKeepAccountReqDto.setInnerOrderNos(innerOrder);
            mamualKeepAccountReqDto.setType(KeepTypeEnum.REAL.getCode());
            OrderRuleEo orderRuleEo = (OrderRuleEo)this.orderRuleDas.filter().one();
            this.logger.info("\u8bb0\u8d26\u57fa\u7840\u8bbe\u7f6e\uff1a{}", (Object)orderRuleEo);
            if (orderRuleEo != null && orderRuleEo.getMonthCycle() != null) {
                mamualKeepAccountReqDto.setChargeDate(this.calculateAccountingDate(orderRuleEo.getMonthCycle()));
            }
            this.logger.info("\u8bb0\u8d26\u65e5\u671f\u662f{}", (Object)JSON.toJSONString((Object)mamualKeepAccountReqDto.getChargeDate()));
            KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), afterSaleOrderRespDto.getAfterSaleOrderType());
            keepNodeRuleParam.setOrderType(afterOrderType);
            keepNodeRuleParam.getParamReqDto().setOrderType(afterOrderType);
            keepNodeRuleParam.getParamReqDto().setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            keepNodeRuleParam.setAction(true);
            List<KeepNodeRule> keepNodeRules = KeepAccountRuleFactory.getRefundsBaseNodeList(VoucherTypeEnum.DELIVERY.getCode(), afterOrderType, mode, ifOriginal);
            keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
            if (Objects.nonNull(afterSaleOrderRespDto) && Objects.nonNull(afterSaleOrderRespDto.getShopCode())) {
                List shopRuleEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopRuleDomain.filter().eq((Object)"shop_code", (Object)afterSaleOrderRespDto.getShopCode())).eq((Object)"shop_type", (Object)AccountRuleEnum.ACCOUNT_BY_INVOICE.getCode())).list();
                if (CollectionUtil.isNotEmpty((Collection)shopRuleEos)) {
                    keepNodeRules.clear();
                    keepNodeRuleParam.getParamReqDto().setVoucherType(VoucherTypeEnum.INVOICE.getCode());
                    List<KeepNodeRule> keepNodeInvocieRules = KeepAccountRuleFactory.getRefundsBaseNodeList(VoucherTypeEnum.INVOICE.getCode(), afterOrderType, mode, ifOriginal);
                    keepNodeInvocieRules.forEach(rule -> rule.execute(keepNodeRuleParam));
                } else {
                    this.logger.info("\u6ca1\u6709\u914d\u7f6e\u5e97\u94fa\u5f00\u7968\u8bb0\u8d26");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5b9e\u65f6\u9000\u8d27\u9000\u6b3e,\u6362\u8d27\u5355\u8bb0\u8d26\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            throw new BizException(String.format("\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5b9e\u65f6\u9000\u8d27\u9000\u6b3e,\u6362\u8d27\u5355\u8bb0\u8d26\u5f02\u5e38:\u3010%s\u3011", e.getMessage()));
        }
        finally {
            if (mutex != null) {
                this.lockService.unlock(mutex);
            }
        }
    }

    public AfterSaleOrderRespDto getOrderNo(String afterSaleOrderNo, String mode, String afterSaleOrderType) {
        AfterSaleOrderRespDto afterSaleOrderRespDto = new AfterSaleOrderRespDto();
        int i = 0;
        boolean isPolling = true;
        while (isPolling) {
            try {
                List afterSaleOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).in((Object)"status", Arrays.asList(OmsOrderStatusEnum.FINISH.getCode(), OmsOrderStatusEnum.COMPLETE.getCode(), OmsOrderStatusEnum.IN_WAREHOUSE.getCode()))).list();
                this.logger.info("\u5df2\u5165\u5e93\u548c\u5df2\u5b8c\u6210\u7684\u552e\u540e\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)afterSaleOrderEos));
                if (CollectionUtil.isNotEmpty((Collection)afterSaleOrderEos)) {
                    BeanUtil.copyProperties(afterSaleOrderEos.get(0), (Object)afterSaleOrderRespDto, (String[])new String[0]);
                    isPolling = false;
                    break;
                }
                if (i > this.polling) {
                    this.logger.info("\u8f6e\u8be25\u6b21\u67e5\u8be2\u552e\u540e\u5355\u4fe1\u606f\u4e3a\u7a7a\uff1a{},{}", (Object)afterSaleOrderNo, (Object)i);
                    String extension = "\u552e\u540e\u5355\uff1a" + afterSaleOrderNo + " \u8f6e\u8be2\u8d85\u8fc75\u6b21\u65e0\u6cd5\u67e5\u8be2\u5230\u552e\u540e\u5355\u4fe1\u606f";
                    this.addExceptionDetail(afterSaleOrderNo, extension);
                    isPolling = false;
                    break;
                }
                Thread.sleep(1000L);
                ++i;
            }
            catch (Exception e) {
                this.logger.error("\u8f6e\u8be2\u4e09\u6b21\u67e5\u8be2\u552e\u540e\u5355\u4fe1\u606f\u62a5\u9519\uff1a{}\uff0c{}", (Object)afterSaleOrderNo, (Object)e.getMessage());
                this.addExceptionDetail(afterSaleOrderNo, e.getMessage());
                isPolling = false;
            }
        }
        return afterSaleOrderRespDto;
    }

    private void addExceptionDetail(String afterSaleOrderNo, String message) {
        ArrayList<KeepExceptionDetailEo> exceptionDetailEos = new ArrayList<KeepExceptionDetailEo>();
        exceptionDetailEos.add(this.setKeepException(afterSaleOrderNo, message, BillTypeEnum.RETURN_BASE.getCode()));
        this.bookKeepAccountService.batchInsertKeepExceptionDetail(exceptionDetailEos);
    }

    private KeepExceptionDetailEo setKeepException(String afterSaleOrderNo, String extension, String orderType) {
        KeepExceptionDetailEo exceptionDetailEo = new KeepExceptionDetailEo();
        exceptionDetailEo.setOrderNo(afterSaleOrderNo);
        exceptionDetailEo.setExtension(extension);
        exceptionDetailEo.setOrderType(orderType);
        exceptionDetailEo.setStatus(Integer.valueOf(0));
        return exceptionDetailEo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saleExecute(String saleOrderNo, String status, String mode, String platformOrderNo, List<DeliveryItemDto> goodsObjectList) {
        this.logger.info("\u9500\u552e\u5355\u5b9e\u65f6\u8bb0\u8d26\u5185\u90e8\u5355\u53f7\uff1a{}===>>>{}===>>>{}", new Object[]{saleOrderNo, status, null});
        Mutex mutex = null;
        try {
            String primaryKey = saleOrderNo + status;
            mutex = this.lockService.lock(TABLENAME_SALE, primaryKey);
            if (null == mutex) {
                throw new BizException(String.format("\u9500\u552e\u5355\u5b9e\u65f6\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,primaryKey:\u3010%s\u3011", primaryKey));
            }
            HashMap<String, String> saleOrderMap = new HashMap<String, String>();
            String shopCode = this.getSaleOrderNo(saleOrderNo, status, saleOrderMap);
            String autoNode = "0";
            OrderRuleEo orderRuleEo = (OrderRuleEo)this.orderRuleDas.filter().one();
            this.logger.info("\u8bb0\u8d26\u57fa\u7840\u8bbe\u7f6e\uff1a{}", (Object)orderRuleEo);
            if (!CollectionUtils.isEmpty(saleOrderMap)) {
                MamualKeepAccountReqDto mamualKeepAccountReqDto = new MamualKeepAccountReqDto();
                ArrayList nos = new ArrayList(saleOrderMap.keySet());
                mamualKeepAccountReqDto.setInnerOrderNos(nos);
                mamualKeepAccountReqDto.setType(KeepTypeEnum.REAL.getCode());
                mamualKeepAccountReqDto.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
                if (orderRuleEo != null && orderRuleEo.getMonthCycle() != null) {
                    mamualKeepAccountReqDto.setChargeDate(this.calculateAccountingDate(orderRuleEo.getMonthCycle()));
                }
                this.logger.info("\u8bb0\u8d26\u65e5\u671f\u662f{}", (Object)JSON.toJSONString((Object)mamualKeepAccountReqDto.getChargeDate()));
                KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), BillTypeEnum.SALE_LIST.getCode());
                keepNodeRuleParam.setAction(true);
                OrderRuleRespDto orderRuleRespDto = keepNodeRuleParam.getOrderRuleRespDto();
                List<KeepNodeRule> keepNodeRules = KeepAccountRuleFactory.getSaleKeepNodeRuleList(autoNode, BillTypeEnum.SALE_LIST.getCode(), mode);
                keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
            }
            if (mutex == null) return;
        }
        catch (Exception e) {
            try {
                this.logger.error("\u9500\u552e\u5355\u5b9e\u65f6\u8bb0\u8d26\u8bb0\u8d26\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (mutex == null) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return;
    }

    private String calculateAccountingDate(int N) {
        Calendar today = Calendar.getInstance();
        if (N == 0) {
            return new SimpleDateFormat("yyyy-MM-dd").format(today.getTime());
        }
        int year = today.get(1);
        int month = today.get(2);
        int day = today.get(5);
        Calendar lastDayOfMonth = Calendar.getInstance();
        lastDayOfMonth.set(year, month + 1, 1);
        lastDayOfMonth.add(5, -1);
        Calendar startOfLastNDays = (Calendar)lastDayOfMonth.clone();
        startOfLastNDays.add(5, -N);
        if (today.after(startOfLastNDays) && today.before(lastDayOfMonth) || today.equals(lastDayOfMonth)) {
            Calendar firstDayOfNextMonth = (Calendar)lastDayOfMonth.clone();
            firstDayOfNextMonth.add(2, 1);
            firstDayOfNextMonth.set(5, 1);
            return new SimpleDateFormat("yyyy-MM-dd").format(firstDayOfNextMonth.getTime());
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(today.getTime());
    }

    public String getSaleOrderNo(String saleOrderNo, String orderStatus, Map<String, String> saleOrderMap) {
        String shopCode = "";
        int i = 0;
        boolean isPolling = true;
        while (isPolling) {
            try {
                HashSet<String> financeOrderStatus = new HashSet<String>();
                financeOrderStatus.add(OmsSaleOrderStatus.DELIVERY_PART.getCode());
                financeOrderStatus.add(OmsSaleOrderStatus.COMPLETE.getCode());
                financeOrderStatus.add(OmsSaleOrderStatus.DELIVERED.getCode());
                financeOrderStatus.add(OmsSaleOrderStatus.DELIVERY_ALL.getCode());
                financeOrderStatus.add(OmsSaleOrderStatus.DELIVERED.getCode());
                DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).in((Object)"order_status", financeOrderStatus)).one();
                if (Objects.nonNull(performOrderInfoEo)) {
                    this.logger.info("\u5df2\u53d1\u8d27\u5df2\u5b8c\u6210\u7684\u9500\u552e\u5355\u4fe1\u606f:{},{},{}", new Object[]{saleOrderNo, orderStatus, JSON.toJSONString((Object)performOrderInfoEo)});
                    saleOrderMap.put(performOrderInfoEo.getSaleOrderNo(), BillTypeEnum.SALE_LIST.getCode());
                    List snapshotEos = ((ExtQueryChainWrapper)this.dgPerformOrderSnapshotDomain.filter().eq((Object)"order_id", (Object)performOrderInfoEo.getId())).list(Integer.valueOf(1));
                    if (CollectionUtil.isNotEmpty((Collection)snapshotEos)) {
                        shopCode = CollectionUtil.isNotEmpty((Collection)snapshotEos) ? ((DgPerformOrderSnapshotEo)snapshotEos.get(0)).getShopCode() : shopCode;
                    }
                    isPolling = false;
                }
                if (i > this.polling) {
                    this.logger.info("\u8f6e\u8be25\u6b21\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff1a{},{}", (Object)saleOrderNo, (Object)i);
                    ArrayList<KeepExceptionDetailEo> exceptionDetailEos = new ArrayList<KeepExceptionDetailEo>();
                    String extension = "\u9500\u552e\u5355\uff1a" + saleOrderNo + " \u8f6e\u8be2\u8d85\u8fc75\u6b21\u65e0\u6cd5\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f";
                    exceptionDetailEos.add(this.setKeepException(saleOrderNo, extension, BillTypeEnum.SALE_LIST.getCode()));
                    this.bookKeepAccountService.batchInsertKeepExceptionDetail(exceptionDetailEos);
                    isPolling = false;
                }
                Thread.sleep(1000L);
                ++i;
            }
            catch (Exception e) {
                this.logger.error("\u8f6e\u8be25\u6b21\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u62a5\u9519\uff1a{}\uff0c{}", (Object)saleOrderNo, (Object)e);
                ArrayList<KeepExceptionDetailEo> exceptionDetailEos = new ArrayList<KeepExceptionDetailEo>();
                exceptionDetailEos.add(this.setKeepException(saleOrderNo, e.getMessage(), BillTypeEnum.SALE_LIST.getCode()));
                this.bookKeepAccountService.batchInsertKeepExceptionDetail(exceptionDetailEos);
                isPolling = false;
            }
        }
        return shopCode;
    }

    private List<String> getSaleOrderNosByPlatformNo(String platformNo) {
        return null;
    }
}

