/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.dto.AccountAugmentOrderDto;
import com.dtyunxi.yundt.cube.center.account.dto.AccountAugmentOrderPageReqDto;
import com.dtyunxi.yundt.cube.center.account.proxy.IAccountAugmentOrderApiProxy;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.ReconciliationOrderConverter;
import com.yunxi.dg.base.center.finance.dao.das.IDgPerformOrderAddrDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAccountDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IAccountFlowDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICsCustomerAreaDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICsRRelationShopDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationAccountRangeDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationBillDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationBillDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationCustomerConditionDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationDataRangeDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderTotalDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationRejectCustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationRuleDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationShopCustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillAuditReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsRRelationShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.finance.dto.entity.DynamicHeadDto;
import com.yunxi.dg.base.center.finance.dto.entity.GenerateReconciliationReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.OrderAndAddressDetailDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationAccountRangeDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationBillDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationBillPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationDataRangeDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationOrderDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationOrderPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ShopCustomerReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountFlowTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillsTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OperatorTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationBillStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.StAccountOrderReqDto;
import com.yunxi.dg.base.center.finance.dto.response.HandlerAuditRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationOrderDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationOrderRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationOrderSummaryDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationOrderSummaryRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ShopCustomerDto;
import com.yunxi.dg.base.center.finance.dto.response.StAccountOrderRespDto;
import com.yunxi.dg.base.center.finance.eo.AccountEo;
import com.yunxi.dg.base.center.finance.eo.AccountFlowEo;
import com.yunxi.dg.base.center.finance.eo.CsCustomerAreaEo;
import com.yunxi.dg.base.center.finance.eo.CsRRelationShopEo;
import com.yunxi.dg.base.center.finance.eo.CustomerEo;
import com.yunxi.dg.base.center.finance.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationAccountRangeEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationBillDetailEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationBillEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationCustomerConditionEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationDataRangeEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationOrderDetailEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationOrderEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationRejectCustomerEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationRuleEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationShopCustomerEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationOrderService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.DateUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationOrderServiceImpl
extends BaseServiceImpl<ReconciliationOrderDto, ReconciliationOrderEo, IReconciliationOrderDomain>
implements IReconciliationOrderService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationOrderServiceImpl.class);
    @Resource
    private IReconciliationRuleDomain ruleDomain;
    @Resource
    private IReconciliationDataRangeDomain dataRangeDomain;
    @Resource
    private IAccountDomain accountDomain;
    @Resource
    private IAccountFlowDomain accountFlowDomain;
    @Resource
    private IReconciliationShopCustomerDomain shopCustomerDomain;
    @Resource
    private IReconciliationCustomerConditionDomain customerConditionDomain;
    @Resource
    private IReconciliationRejectCustomerDomain rejectCustomerDomain;
    @Resource
    private IShopDomain shopDomain;
    @Resource
    private ICustomerDomain customerDomain;
    @Resource
    private ICsRRelationShopDomain relationShopDomain;
    @Resource
    private IReconciliationBillDomain billDomain;
    @Resource
    private ILockService lockService;
    @Resource
    private IReconciliationOrderDetailDomain orderDetailDomain;
    @Resource
    private ICsCustomerAreaDomain iDgCustomerAreaDomain;
    @Resource
    private IAccountAugmentOrderApiProxy proxy;
    @Resource
    private IReconciliationAccountRangeDomain accountRangeDomain;
    @Resource
    private IReconciliationOrderTotalDomain orderTotalDomain;
    @Resource
    private IReconciliationBillDetailDomain billDetailDomain;
    @Resource
    private IDgPerformOrderAddrDas performOrderAddrDas;
    @Resource
    private IDgPerformOrderInfoDas performOrderInfoDas;

    public ReconciliationOrderServiceImpl(IReconciliationOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ReconciliationOrderDto, ReconciliationOrderEo> converter() {
        return ReconciliationOrderConverter.INSTANCE;
    }

    @Override
    public PageInfo<ShopCustomerDto> queryShopCustomer(ShopCustomerReqDto reqDto) {
        return ((IReconciliationOrderDomain)this.domain).queryShopCustomer(reqDto);
    }

    @Override
    public RestResponse<PageInfo<ReconciliationBillDto>> queryBillPage(ReconciliationBillPageReqDto reqDto) {
        log.info("\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        Integer pageNum = reqDto.getPageNum();
        Integer pageSize = reqDto.getPageSize();
        AssertUtils.isTrue((Objects.nonNull(pageNum) && pageNum > 0 ? 1 : 0) != 0, (String)"\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtils.isTrue((Objects.nonNull(pageSize) && pageSize > 0 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.billDomain.filter().orderByDesc((Object)"id");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getShopCodes())) {
            sqlFilters.in((Object)"shop_code", (Collection)reqDto.getShopCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getShopCode())) {
            sqlFilters.like((Object)"shop_code", (Object)reqDto.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            sqlFilters.like((Object)"customer_name", (Object)reqDto.getCustomerName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerCode())) {
            sqlFilters.like((Object)"customer_code", (Object)reqDto.getCustomerCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getCustomerCodes())) {
            sqlFilters.in((Object)"customer_code", (Collection)reqDto.getCustomerCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBillDate())) {
            sqlFilters.eq((Object)"bill_date", (Object)reqDto.getBillDate());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBillStartDay())) {
            sqlFilters.ge((Object)"bill_day", (Object)reqDto.getBillStartDay());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBillEndDay())) {
            sqlFilters.le((Object)"bill_day", (Object)reqDto.getBillEndDay());
        }
        sqlFilters.in((Object)"status", Arrays.asList("NOT_GERERATE", "CLOSE"));
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), ReconciliationBillDto.class);
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<ReconciliationOrderDetailRespDto> detail(Long id) {
        ReconciliationOrderDetailRespDto detailRespDto = new ReconciliationOrderDetailRespDto();
        ReconciliationOrderEo orderEo = (ReconciliationOrderEo)((ExtQueryChainWrapper)((IReconciliationOrderDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        AssertUtils.notNull((Object)orderEo, (String)"\u5bf9\u8d26\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        detailRespDto.setOrderNo(orderEo.getOrderNo());
        detailRespDto.setOrderName(orderEo.getOrderName());
        detailRespDto.setCustomerCode(orderEo.getCustomerCode());
        detailRespDto.setCustomerName(orderEo.getCustomerName());
        detailRespDto.setShopCode(orderEo.getShopCode());
        detailRespDto.setShopName(orderEo.getShopName());
        detailRespDto.setBillDate(orderEo.getBillDate());
        detailRespDto.setStatus(orderEo.getStatus());
        List<Object> summaryRespDtos = Lists.newArrayList();
        List orderTotalEos = ((ExtQueryChainWrapper)this.orderTotalDomain.filter().eq((Object)"order_no", (Object)orderEo.getOrderNo())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderTotalEos)) {
            summaryRespDtos = orderTotalEos.stream().map(v -> {
                ReconciliationOrderSummaryRespDto summaryRespDto = new ReconciliationOrderSummaryRespDto();
                CubeBeanUtils.copyProperties((Object)summaryRespDto, (Object)v, (String[])new String[0]);
                if (null != v.getBalanceType()) {
                    summaryRespDto.setBalanceTypeName(0 == v.getBalanceType() ? "\u91d1\u989d" : "\u6570\u91cf");
                }
                summaryRespDto.setCurrencyName("\u4eba\u6c11\u5e01");
                return summaryRespDto;
            }).collect(Collectors.toList());
        }
        detailRespDto.setSummaryRespDtos((List)summaryRespDtos);
        List billDetailEos = this.billDetailDomain.queryBillDetailList(orderEo.getOrderNo());
        ArrayList summaryDetailRespDtos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billDetailEos)) {
            List accountRangeEos = this.accountRangeDomain.getAccountRangeByOrderNo(orderEo.getOrderNo());
            Map<Object, Object> collectRanggeMap = Maps.newHashMap();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountRangeEos)) {
                collectRanggeMap = accountRangeEos.stream().collect(Collectors.toMap(x -> x.getAccountType() + ";" + x.getSaleCompanyCode(), Function.identity(), (k1, k2) -> k1));
            }
            List orderNoList = billDetailEos.stream().map(ReconciliationBillDetailEo::getOrderNo).distinct().collect(Collectors.toList());
            List customerCodeList = billDetailEos.stream().map(ReconciliationBillDetailEo::getCustomerCode).distinct().collect(Collectors.toList());
            List shopCodeList = billDetailEos.stream().map(ReconciliationBillDetailEo::getShopCode).distinct().collect(Collectors.toList());
            List accountTypeList = billDetailEos.stream().map(ReconciliationBillDetailEo::getAccountType).distinct().collect(Collectors.toList());
            Map<Object, Object> rangeEoMap = Maps.newHashMap();
            ReconciliationAccountRangeDto rangeDto = new ReconciliationAccountRangeDto();
            rangeDto.setOrderNoList(orderNoList);
            rangeDto.setCustomerCodeList(customerCodeList);
            rangeDto.setShopCodeList(shopCodeList);
            rangeDto.setAccountTypeList(accountTypeList);
            List accountRangeEoList = this.accountRangeDomain.getAccountRangeNewList(rangeDto);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountRangeEoList)) {
                rangeEoMap = accountRangeEoList.stream().collect(Collectors.toMap(x -> x.getOrderNo() + ";" + x.getAccountType() + ";" + x.getCustomerCode() + ";" + x.getShopCode() + ";" + x.getRelevanceNo() + ";" + x.getSaleCompanyCode(), Function.identity(), (k1, k2) -> k1));
            }
            HashMap finalRangeEoMap = rangeEoMap;
            Map<Object, Object> finalCollectRanggeMap = collectRanggeMap;
            List<String> relevanceNos = billDetailEos.stream().filter(x -> BillsTypeEnum.BILLS_TYPE_00.getCode().equals(x.getOrderType())).map(ReconciliationBillDetailEo::getRelevanceNo).distinct().collect(Collectors.toList());
            Map<String, OrderAndAddressDetailDto> addressDetailDtoMap = this.getReceiveNameAndConfirmTime(relevanceNos);
            billDetailEos.forEach(v -> {
                ReconciliationOrderSummaryDetailRespDto respDto = new ReconciliationOrderSummaryDetailRespDto();
                respDto.setOrderNo(v.getOrderNo());
                respDto.setOrderType(v.getOrderType());
                respDto.setOrderTypeName(ReconciliationBillTypeEnum.getName((String)v.getOrderType()));
                respDto.setOrderName(v.getOrderName());
                respDto.setRelevanceNo(v.getRelevanceNo());
                respDto.setBusinessDate(v.getBusinessDate());
                respDto.setShopCode(v.getShopCode());
                respDto.setShopName(v.getShopName());
                respDto.setCustomerCode(v.getCustomerCode());
                respDto.setCustomerName(v.getCustomerName());
                respDto.setSaleAmount(v.getSaleAmount());
                respDto.setSaleCompanyCode(v.getSaleCompanyCode());
                respDto.setSaleCompanyName(v.getSaleCompanyName());
                respDto.setRemarkAbstract(v.getRemarkAbstract());
                respDto.setSaleAmount(v.getSaleAmount());
                log.info("setRelevanceNo:{},{}", (Object)v.getRelevanceNo(), (Object)v.getOrderType());
                if (addressDetailDtoMap.containsKey(v.getRelevanceNo()) && BillsTypeEnum.BILLS_TYPE_00.getCode().equals(v.getOrderType())) {
                    OrderAndAddressDetailDto dto = (OrderAndAddressDetailDto)addressDetailDtoMap.get(v.getRelevanceNo());
                    respDto.setReceiveName(Objects.isNull(dto) ? null : dto.getReceiveName());
                    respDto.setConfirmReceiveTime(Objects.isNull(dto) ? null : dto.getConfirmReceiveTime());
                }
                ArrayList dynamicHeadDtos = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Map)finalCollectRanggeMap)) {
                    finalCollectRanggeMap.forEach((i, j) -> {
                        List<String> accountType = Arrays.asList(i.split(";"));
                        DynamicHeadDto headDto = new DynamicHeadDto();
                        headDto.setAccountType(accountType.get(0));
                        headDto.setAccountTypeName(j.getAccountTypeName());
                        if ("YFK".equals(accountType.get(0))) {
                            headDto.setAccountTypeName(j.getAccountTypeName() + "(" + j.getSaleCompanyName() + ")");
                        }
                        ReconciliationAccountRangeDto accountRangeDto = new ReconciliationAccountRangeDto();
                        accountRangeDto.setAccountType(accountType.get(0));
                        accountRangeDto.setAccountTypeName(j.getAccountTypeName());
                        if ("YFK".equals(accountType.get(0))) {
                            accountRangeDto.setAccountTypeName(j.getAccountTypeName() + "(" + j.getSaleCompanyName() + ")");
                        }
                        accountRangeDto.setOrderNo(v.getOrderNo());
                        accountRangeDto.setShopCode(v.getShopCode());
                        accountRangeDto.setCustomerCode(v.getCustomerCode());
                        accountRangeDto.setRelevanceNo(v.getRelevanceNo());
                        String key = v.getOrderNo() + ";" + accountType.get(0) + ";" + v.getCustomerCode() + ";" + v.getShopCode() + ";" + v.getRelevanceNo() + ";" + accountType.get(1);
                        if (finalRangeEoMap.containsKey(key)) {
                            ReconciliationAccountRangeDto reconciliationAccountRangeDto = (ReconciliationAccountRangeDto)finalRangeEoMap.get(key);
                            accountRangeDto.setAmount(reconciliationAccountRangeDto.getAmount());
                            accountRangeDto.setAmountBusinessType(reconciliationAccountRangeDto.getAmountBusinessType());
                            accountRangeDto.setSaleCompanyCode(reconciliationAccountRangeDto.getSaleCompanyCode());
                            accountRangeDto.setSaleCompanyName(reconciliationAccountRangeDto.getSaleCompanyName());
                            accountRangeDto.setShopCode(reconciliationAccountRangeDto.getShopCode());
                        }
                        headDto.setAccountRangeDto(accountRangeDto);
                        dynamicHeadDtos.add(headDto);
                    });
                }
                respDto.setHeadDtos(this.handleHeadMerge(dynamicHeadDtos));
                summaryDetailRespDtos.add(respDto);
            });
        }
        detailRespDto.setSummaryDetailRespDtos((List)summaryDetailRespDtos);
        return new RestResponse((Object)detailRespDto);
    }

    @Override
    public RestResponse<ReconciliationOrderDetailRespDto> queryBillList(ReconciliationOrderDto dto) {
        ReconciliationOrderDetailRespDto detailRespDto = new ReconciliationOrderDetailRespDto();
        ReconciliationOrderEo orderEo = (ReconciliationOrderEo)((ExtQueryChainWrapper)((IReconciliationOrderDomain)this.domain).filter().eq((Object)"id", (Object)dto.getId())).one();
        AssertUtils.notNull((Object)orderEo, (String)"\u5bf9\u8d26\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        detailRespDto.setOrderNo(orderEo.getOrderNo());
        detailRespDto.setOrderName(orderEo.getOrderName());
        detailRespDto.setCustomerCode(orderEo.getCustomerCode());
        detailRespDto.setCustomerName(orderEo.getCustomerName());
        detailRespDto.setShopCode(orderEo.getShopCode());
        detailRespDto.setShopName(orderEo.getShopName());
        detailRespDto.setBillDate(orderEo.getBillDate());
        detailRespDto.setStatus(orderEo.getStatus());
        List summaryRespDtos = ((IReconciliationOrderDomain)this.domain).queryBillSummary(orderEo.getId());
        detailRespDto.setSummaryRespDtos(summaryRespDtos);
        List summaryDetailRespDtos = ((IReconciliationOrderDomain)this.domain).queryBillDetailList(dto);
        summaryDetailRespDtos.forEach(v -> v.setOrderTypeName(AccountFlowTypeEnum.getNameByCode((String)v.getOrderType())));
        detailRespDto.setSummaryDetailRespDtos(summaryDetailRespDtos);
        return new RestResponse((Object)detailRespDto);
    }

    @Override
    public RestResponse<PageInfo<ReconciliationOrderRespDto>> queryPage(ReconciliationOrderPageReqDto dto) {
        log.info("\u5bf9\u8d26\u5355\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        Integer pageNum = dto.getPageNum();
        Integer pageSize = dto.getPageSize();
        AssertUtils.isTrue((Objects.nonNull(pageNum) && pageNum > 0 ? 1 : 0) != 0, (String)"\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtils.isTrue((Objects.nonNull(pageSize) && pageSize > 0 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageInfo eoPageInfo = ((IReconciliationOrderDomain)this.domain).queryPage(dto);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (Objects.nonNull(eoPageInfo) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            ArrayList<ReconciliationOrderRespDto> dtoList = new ArrayList<ReconciliationOrderRespDto>();
            CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), ReconciliationOrderRespDto.class);
            this.setArea(dtoList);
            dtoPageInfo.setList(dtoList);
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    private void setArea(List<ReconciliationOrderRespDto> list) {
        list.forEach(v -> {
            List shopIdList = null;
            List customerIdList = null;
            List shopCodes = list.stream().map(ReconciliationOrderRespDto::getShopCode).distinct().collect(Collectors.toList());
            List customerCodes = list.stream().map(ReconciliationOrderRespDto::getCustomerCode).distinct().collect(Collectors.toList());
            List shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", shopCodes)).list();
            List customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", customerCodes)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopEos)) {
                shopIdList = shopEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerEos)) {
                customerIdList = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            }
            CsOrgCustomerRelationPageReqDto pageReqDto = new CsOrgCustomerRelationPageReqDto();
            pageReqDto.setShopIdList(shopIdList);
            pageReqDto.setCustomerIdList(customerIdList);
            List customerRelationDtos = (List)RestResponseHelper.extractData(this.queryList(pageReqDto));
            Map<Long, List<DgBusinessAreaLevelDto>> areaLevelMap = this.mapAreaLevel(customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getAreaId).collect(Collectors.toList()));
            List relationIds = customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getId).distinct().collect(Collectors.toList());
            List rRelationShopEos = ((ExtQueryChainWrapper)this.relationShopDomain.filter().in((Object)"relation_id", relationIds)).list();
            List shopIds = rRelationShopEos.stream().map(CsRRelationShopEo::getShopId).distinct().collect(Collectors.toList());
            Map shopEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"id", shopIds)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
            customerRelationDtos.forEach(o -> {
                o.setShopList(rRelationShopEos.stream().map(e -> {
                    ShopEo shopEo = (ShopEo)shopEoMap.get(e.getShopId());
                    CsRRelationShopDto shopDto = new CsRRelationShopDto();
                    if (Objects.isNull(shopEo)) {
                        return shopDto;
                    }
                    shopDto.setShopId(e.getShopId());
                    shopDto.setShopCode(shopEo.getCode());
                    shopDto.setShopName(shopEo.getName());
                    return shopDto;
                }).collect(Collectors.toList()));
                o.setBusinessAreaLevelList(Objects.isNull(o.getAreaId()) ? null : (List)areaLevelMap.get(o.getAreaId()));
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerRelationDtos)) {
                String shopCode = v.getShopCode();
                for (CsOrgCustomerRelationDto customerRelationDto : customerRelationDtos) {
                    if (!customerRelationDto.getShopCode().equals(shopCode)) continue;
                    v.setBusinessAreaLevelList(customerRelationDto.getBusinessAreaLevelList());
                }
            }
        });
    }

    public Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel(List<Long> areaIdList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(areaIdList)) {
            return Collections.emptyMap();
        }
        List respDtoList = ((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", areaIdList)).list();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)respDtoList)) {
            return Collections.emptyMap();
        }
        List indexPathIdList = respDtoList.stream().filter(dto -> Objects.nonNull(dto.getIndexPath())).map(dto -> Arrays.stream(dto.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<Long, List> indexPathIdsMap = respDtoList.stream().collect(Collectors.toMap(BaseEo::getId, o -> Arrays.stream(o.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList()), (k1, k2) -> k1));
        Map indexPathEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", indexPathIdList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        HashMap<Long, List<DgBusinessAreaLevelDto>> resultMap = new HashMap<Long, List<DgBusinessAreaLevelDto>>();
        for (Long areaId : areaIdList) {
            List indexPathIds = indexPathIdsMap.get(areaId);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)indexPathIds)) continue;
            ArrayList<DgBusinessAreaLevelDto> levelDtoList = new ArrayList<DgBusinessAreaLevelDto>();
            for (Long indexPathId : indexPathIds) {
                if (Objects.equals(indexPathId, 0L)) continue;
                CsCustomerAreaEo customerAreaEo = (CsCustomerAreaEo)indexPathEoMap.get(indexPathId);
                DgBusinessAreaLevelDto levelDto = (DgBusinessAreaLevelDto)BeanUtil.toBean((Object)customerAreaEo, DgBusinessAreaLevelDto.class);
                levelDtoList.add(levelDto);
            }
            resultMap.put(areaId, levelDtoList);
        }
        return resultMap;
    }

    @Override
    public RestResponse<Map<String, Integer>> queryCount(ReconciliationOrderPageReqDto dto) {
        List orderEoList = ((IReconciliationOrderDomain)this.domain).queryList(dto);
        Map<String, List<ReconciliationOrderRespDto>> collect = orderEoList.stream().collect(Collectors.groupingBy(ReconciliationOrderRespDto::getStatus));
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode(), null != collect.get(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode()) ? collect.get(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode(), null != collect.get(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode()) ? collect.get(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode(), null != collect.get(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode()) ? collect.get(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.COMPLETE.getCode(), null != collect.get(ReconciliationBillStatusEnum.COMPLETE.getCode()) ? collect.get(ReconciliationBillStatusEnum.COMPLETE.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.CLOSE.getCode(), null != collect.get(ReconciliationBillStatusEnum.CLOSE.getCode()) ? collect.get(ReconciliationBillStatusEnum.CLOSE.getCode()).size() : 0);
        return new RestResponse((Object)resultMap);
    }

    @Override
    public void generateReconciliation(List<GenerateReconciliationReqDto> dtos) {
        String currentDate = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        dtos.forEach(v -> {
            List customerEos;
            List shopEos;
            List<String> shopCodes = Arrays.asList(v.getShopCode());
            List<String> customerCodes = Arrays.asList(v.getCustomerCode());
            List ruleEoList = this.ruleDomain.queryList(customerCodes, shopCodes, currentDate);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ruleEoList)) {
                log.info("\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u89c4\u5219");
                return;
            }
            ReconciliationRuleEo ruleEo = (ReconciliationRuleEo)ruleEoList.get(0);
            List<String> ruleCOdes = Arrays.asList(ruleEo.getRuleCode());
            List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDomain.filter().in((Object)"rule_code", ruleCOdes)).list();
            List<String> accountTypes = dataRangeEoList.stream().map(ReconciliationDataRangeEo::getRangeCode).distinct().collect(Collectors.toList());
            List collectShopList = null;
            if (1 == ruleEo.getApplicableShopRange()) {
                collectShopList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDomain.filter().in((Object)"rule_code", ruleCOdes)).eq((Object)"applicable_range", (Object)0)).list();
            }
            List collectCustomerList = null;
            if (2 == ruleEo.getApplicableCustomerRange()) {
                collectCustomerList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDomain.filter().in((Object)"rule_code", ruleCOdes)).eq((Object)"applicable_range", (Object)1)).list();
            }
            List conditionEos = null;
            List rejectCustomerEoList = null;
            if (1 == ruleEo.getApplicableCustomerRange()) {
                conditionEos = ((ExtQueryChainWrapper)this.customerConditionDomain.filter().in((Object)"rule_code", ruleCOdes)).list();
                rejectCustomerEoList = ((ExtQueryChainWrapper)this.rejectCustomerDomain.filter().in((Object)"rule_code", ruleCOdes)).list();
            }
            List<Object> rejectCustomerCodes = Lists.newArrayList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)collectShopList)) {
                shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", (Collection)collectShopList.stream().map(ReconciliationShopCustomerEo::getShopCode).distinct().collect(Collectors.toList()))).list();
                shopCodes = shopEos.stream().map(ShopEo::getCode).distinct().collect(Collectors.toList());
            } else {
                shopEos = this.shopDomain.selectAll();
                shopCodes = shopEos.stream().map(ShopEo::getCode).distinct().collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)collectCustomerList)) {
                customerCodes = collectCustomerList.stream().map(ReconciliationShopCustomerEo::getCustomerCode).distinct().collect(Collectors.toList());
            } else {
                customerEos = this.customerDomain.selectAll();
                customerCodes = customerEos.stream().map(CustomerEo::getCode).distinct().collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionEos)) {
                String typeIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerTypeIds).distinct().collect(Collectors.joining(","));
                String areaIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerAreaCodes).distinct().collect(Collectors.joining(","));
                String levelIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerLevelIds).distinct().collect(Collectors.joining(","));
                String groupIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerGroupIds).distinct().collect(Collectors.joining(","));
                ArrayList custimerTypeIds = StringUtils.isBlank((CharSequence)typeIds) ? new ArrayList() : Arrays.stream(typeIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                ArrayList customerAreaIds = StringUtils.isBlank((CharSequence)areaIds) ? new ArrayList() : Arrays.stream(areaIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                ArrayList customerLevelIds = StringUtils.isBlank((CharSequence)levelIds) ? new ArrayList() : Arrays.stream(levelIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                ArrayList customerGroupIds = StringUtils.isBlank((CharSequence)groupIds) ? new ArrayList() : Arrays.stream(groupIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
                reqDto.setCustomerTypeIds(custimerTypeIds);
                reqDto.setAreaIds(customerAreaIds);
                reqDto.setLevelIds(customerLevelIds);
                reqDto.setCustomerGroupIds(customerGroupIds);
                List customerRelationDtos = ((IReconciliationOrderDomain)this.domain).queryList(reqDto);
                log.info("\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtos));
                customerCodes = customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getCustomerCode).distinct().collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rejectCustomerEoList)) {
                customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", (Collection)rejectCustomerEoList.stream().map(ReconciliationRejectCustomerEo::getCustomerCode).distinct().collect(Collectors.toList()))).list();
                rejectCustomerCodes = customerEos.stream().map(CustomerEo::getCode).distinct().collect(Collectors.toList());
            }
            List<AccountEo> accountEoList = this.getAccountEoList(customerCodes, shopCodes, rejectCustomerCodes, accountTypes);
            Map<String, List<AccountEo>> accountListMap = accountEoList.stream().collect(Collectors.groupingBy(x -> {
                StringBuffer buffer = new StringBuffer();
                buffer.append(x.getCustomerNo()).append(";");
                buffer.append(x.getShopCode());
                return buffer.toString();
            }));
            accountListMap.forEach((k, j) -> {
                List<String> key = Arrays.asList(k.split(";"));
                String customerNo = key.get(0);
                String shopCode = key.get(1);
                int year = Integer.parseInt(v.getBillDate().substring(0, 4));
                int month = Integer.parseInt(v.getBillDate().substring(5, v.getBillDate().length()));
                Calendar calendar = Calendar.getInstance();
                calendar.set(year, month - 1, 1);
                int lastDay = calendar.getActualMaximum(5);
                Date monthBegin = null;
                Date monthEnd = null;
                try {
                    calendar.set(5, 1);
                    monthBegin = DateUtils.parseString(DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd") + " 00:00:00", "yyyy-MM-dd HH:mi:ss");
                    calendar.set(5, lastDay);
                    monthEnd = DateUtils.parseString(DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd") + " 23:59:59", "yyyy-MM-dd HH:mi:ss");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                }
                this.execute(customerNo, shopCode, monthBegin, monthEnd, ruleEo, (List<AccountEo>)j);
            });
        });
    }

    @Override
    public void autoGenerateBill() {
        List customerEos;
        List shopEos;
        Date date = new Date();
        Date newDate = DateUtil.addMonths((Date)date, (int)-1);
        Date monthBegin = DateUtil.getMonthBegin((Date)newDate);
        Date monthEnd = DateUtil.getMonthEnd((Date)newDate);
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.ruleDomain.filter().orderByDesc((Object)"create_time");
        sqlFilters.eq((Object)"auto_generate_bill", (Object)1);
        List ruleEoList = sqlFilters.list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ruleEoList)) {
            log.error("\u5bf9\u8d26\u89c4\u5219\u672a\u914d\u7f6e\u4e3a\u81ea\u52a8\u751f\u6210\u5bf9\u8d26\u5355");
            return;
        }
        ReconciliationRuleEo ruleEo = (ReconciliationRuleEo)ruleEoList.get(0);
        List<String> ruleCOdes = Arrays.asList(ruleEo.getRuleCode());
        List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDomain.filter().in((Object)"rule_code", ruleCOdes)).list();
        List<String> accountTypes = dataRangeEoList.stream().map(ReconciliationDataRangeEo::getRangeCode).distinct().collect(Collectors.toList());
        List collectShopList = null;
        if (1 == ruleEo.getApplicableShopRange()) {
            collectShopList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDomain.filter().in((Object)"rule_code", ruleCOdes)).eq((Object)"applicable_range", (Object)0)).list();
        }
        List collectCustomerList = null;
        if (2 == ruleEo.getApplicableCustomerRange()) {
            collectCustomerList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDomain.filter().in((Object)"rule_code", ruleCOdes)).eq((Object)"applicable_range", (Object)1)).list();
        }
        List conditionEos = null;
        List rejectCustomerEoList = null;
        if (1 == ruleEo.getApplicableCustomerRange()) {
            conditionEos = ((ExtQueryChainWrapper)this.customerConditionDomain.filter().in((Object)"rule_code", ruleCOdes)).list();
            rejectCustomerEoList = ((ExtQueryChainWrapper)this.rejectCustomerDomain.filter().in((Object)"rule_code", ruleCOdes)).list();
        }
        List<Object> shopCodes = Lists.newArrayList();
        List<Object> customerCodes = Lists.newArrayList();
        List<Object> rejectCustomerCodes = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)collectShopList)) {
            shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", (Collection)collectShopList.stream().map(ReconciliationShopCustomerEo::getShopCode).distinct().collect(Collectors.toList()))).list();
            shopCodes = shopEos.stream().map(ShopEo::getCode).distinct().collect(Collectors.toList());
        } else {
            shopEos = this.shopDomain.selectAll();
            shopCodes = shopEos.stream().map(ShopEo::getCode).distinct().collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)collectCustomerList)) {
            customerCodes = collectCustomerList.stream().map(ReconciliationShopCustomerEo::getCustomerCode).distinct().collect(Collectors.toList());
        } else {
            customerEos = this.customerDomain.selectAll();
            customerCodes = customerEos.stream().map(CustomerEo::getCode).distinct().collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionEos)) {
            String typeIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerTypeIds).distinct().collect(Collectors.joining(","));
            String areaIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerAreaCodes).distinct().collect(Collectors.joining(","));
            String levelIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerLevelIds).distinct().collect(Collectors.joining(","));
            String groupIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerGroupIds).distinct().collect(Collectors.joining(","));
            ArrayList custimerTypeIds = StringUtils.isBlank((CharSequence)typeIds) ? new ArrayList() : Arrays.stream(typeIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            ArrayList customerAreaIds = StringUtils.isBlank((CharSequence)areaIds) ? new ArrayList() : Arrays.stream(areaIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            ArrayList customerLevelIds = StringUtils.isBlank((CharSequence)levelIds) ? new ArrayList() : Arrays.stream(levelIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            ArrayList customerGroupIds = StringUtils.isBlank((CharSequence)groupIds) ? new ArrayList() : Arrays.stream(groupIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
            reqDto.setCustomerTypeIds(custimerTypeIds);
            reqDto.setAreaIds(customerAreaIds);
            reqDto.setLevelIds(customerLevelIds);
            reqDto.setCustomerGroupIds(customerGroupIds);
            List customerRelationDtos = ((IReconciliationOrderDomain)this.domain).queryList(reqDto);
            log.info("\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtos));
            customerCodes = customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getCustomerCode).distinct().collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rejectCustomerEoList)) {
            customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", (Collection)rejectCustomerEoList.stream().map(ReconciliationRejectCustomerEo::getCustomerCode).distinct().collect(Collectors.toList()))).list();
            rejectCustomerCodes = customerEos.stream().map(CustomerEo::getCode).distinct().collect(Collectors.toList());
        }
        List<AccountEo> accountEoList = this.getAccountEoList(customerCodes, shopCodes, rejectCustomerCodes, accountTypes);
        Map<String, List<AccountEo>> accountListMap = accountEoList.stream().collect(Collectors.groupingBy(x -> {
            StringBuffer buffer = new StringBuffer();
            buffer.append(x.getCustomerNo()).append(";");
            buffer.append(x.getShopCode());
            return buffer.toString();
        }));
        accountListMap.forEach((k, v) -> {
            List<String> key = Arrays.asList(k.split(";"));
            String customerNo = key.get(0);
            String shopCode = key.get(1);
            this.execute(customerNo, shopCode, monthBegin, monthEnd, ruleEo, (List<AccountEo>)v);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void execute(String customerNo, String shopCode, Date monthBegin, Date monthEnd, ReconciliationRuleEo ruleEo, List<AccountEo> accountEoList) {
        ReconciliationOrderEo reconciliationOrderEo = new ReconciliationOrderEo();
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_RECONCILIATION_ORDER.getCode());
        String orderNo = generateCodeService.getCode("DZD");
        reconciliationOrderEo.setOrderNo(orderNo);
        reconciliationOrderEo.setOrderName(ruleEo.getRuleName());
        reconciliationOrderEo.setBillDate(DateUtils.getPrevMonth(new Date(), 1));
        reconciliationOrderEo.setCustomerCode(customerNo);
        reconciliationOrderEo.setCustomerName(accountEoList.get(0).getCustomerName());
        reconciliationOrderEo.setShopCode(shopCode);
        reconciliationOrderEo.setShopName(accountEoList.get(0).getShopName());
        reconciliationOrderEo.setStatus("WAIT_AUDIT");
        ((IReconciliationOrderDomain)this.domain).insert((BaseEo)reconciliationOrderEo);
        ArrayList orderDetailEos = Lists.newArrayList();
        accountEoList.forEach(v -> {
            ReconciliationOrderDetailEo detailEo = new ReconciliationOrderDetailEo();
            detailEo.setOrderNo(orderNo);
            detailEo.setOrderName(ruleEo.getRuleName());
            detailEo.setBusinessDate(v.getCreateTime());
            detailEo.setShopCode(shopCode);
            detailEo.setCustomerCode(customerNo);
            detailEo.setShopName(v.getShopName());
            detailEo.setCustomerName(v.getCustomerName());
            detailEo.setCurrency(v.getCurrency());
            detailEo.setBalanceType(v.getBalanceType());
            detailEo.setAccountType(v.getAccountType());
            detailEo.setAccountTypeName(v.getAccountTypeName());
            detailEo.setSaleCompanyCode(v.getSaleCompanyCode());
            detailEo.setSaleCompanyName(v.getSaleCompanyName());
            detailEo.setStatus("WAIT_AUDIT");
            List accountFlowEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountFlowDomain.filter().ge((Object)"create_time", (Object)monthBegin)).le((Object)"create_time", (Object)monthEnd)).eq((Object)"customer_no", (Object)customerNo)).eq((Object)"account_type", (Object)v.getAccountType())).eq((Object)"shop_code", (Object)shopCode)).in((Object)"amount_business_type", Arrays.asList("income", "disburse"))).eq((Object)"account_id", (Object)v.getId())).orderByAsc((Object)"create_time")).list();
            BigDecimal beforeBalance = BigDecimal.ZERO;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountFlowEos)) {
                beforeBalance = ((AccountFlowEo)accountFlowEos.get(0)).getBeforeBalance();
            }
            detailEo.setBeforeAmount(beforeBalance);
            List inComeAccountFlowEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountFlowDomain.filter().ge((Object)"create_time", (Object)monthBegin)).le((Object)"create_time", (Object)monthEnd)).eq((Object)"customer_no", (Object)customerNo)).eq((Object)"account_id", (Object)v.getId())).eq((Object)"account_type", (Object)v.getAccountType())).eq((Object)"shop_code", (Object)shopCode)).in((Object)"amount_business_type", Arrays.asList("income"))).list();
            BigDecimal inComeAmount = BigDecimal.ZERO;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)inComeAccountFlowEos)) {
                inComeAmount = inComeAccountFlowEos.stream().map(AccountFlowEo::getTradeAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            }
            detailEo.setCurrentIncomeAmount(inComeAmount);
            List disburseAccountFlowEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountFlowDomain.filter().ge((Object)"create_time", (Object)monthBegin)).le((Object)"create_time", (Object)monthEnd)).eq((Object)"customer_no", (Object)customerNo)).eq((Object)"account_id", (Object)v.getId())).eq((Object)"account_type", (Object)v.getAccountType())).eq((Object)"shop_code", (Object)shopCode)).in((Object)"amount_business_type", Arrays.asList("income"))).list();
            BigDecimal disburseAmount = BigDecimal.ZERO;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)inComeAccountFlowEos)) {
                disburseAmount = disburseAccountFlowEos.stream().map(AccountFlowEo::getTradeAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            }
            detailEo.setCurrentDisburseAmount(disburseAmount);
            BigDecimal endAmount = beforeBalance.add(inComeAmount).subtract(disburseAmount);
            detailEo.setEndAmount(endAmount);
            StAccountOrderReqDto reqDto = new StAccountOrderReqDto();
            reqDto.setStartTime(DateUtil.getDateFormat((Date)monthBegin, (String)"yyyy-MM-dd HH:mm:ss"));
            reqDto.setEndTime(DateUtil.getDateFormat((Date)monthEnd, (String)"yyyy-MM-dd HH:mm:ss"));
            reqDto.setCustomerNo(customerNo);
            reqDto.setAccountType(v.getAccountType());
            reqDto.setShopCode(shopCode);
            List orderRespDtos = ((IReconciliationOrderDomain)this.domain).queryAccountFlowOrder(reqDto);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderRespDtos)) {
                StAccountOrderRespDto stAccountOrderRespDto = (StAccountOrderRespDto)orderRespDtos.get(0);
                detailEo.setOrderType(stAccountOrderRespDto.getOrderType());
                detailEo.setRelevanceNo(stAccountOrderRespDto.getOrderNo());
                if ("08".equals(stAccountOrderRespDto.getChangeType()) || "09".equals(stAccountOrderRespDto.getChangeType())) {
                    AccountAugmentOrderPageReqDto pageReqDto = new AccountAugmentOrderPageReqDto();
                    pageReqDto.setApplyOrderNo(stAccountOrderRespDto.getOrderNo());
                    pageReqDto.setTradeTypeList("08".equals(stAccountOrderRespDto.getChangeType()) ? Arrays.asList("08") : Arrays.asList("09"));
                    try {
                        PageInfo orderDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.proxy.page(pageReqDto));
                        if (Objects.nonNull(orderDtoPageInfo) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderDtoPageInfo.getList())) {
                            AccountAugmentOrderDto accountAugmentOrderDto = (AccountAugmentOrderDto)orderDtoPageInfo.getList().get(0);
                            detailEo.setRemarkAbstract(accountAugmentOrderDto.getRemark());
                        }
                    }
                    catch (Exception e) {
                        log.error("\u67e5\u8be2\u8d26\u6237\u4e2d\u5fc3\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                    }
                }
            }
            orderDetailEos.add(detailEo);
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderDetailEos)) {
            this.orderDetailDomain.insertBatch((List)orderDetailEos);
        }
    }

    private List<AccountEo> getAccountEoList(List<String> customerCodes, List<String> shopCodes, List<String> rejectCustomerCodes, List<String> accountTypes) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.accountDomain.filter().orderByDesc((Object)"id");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerCodes)) {
            sqlFilters.in((Object)"customer_no", customerCodes);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopCodes)) {
            sqlFilters.in((Object)"shop_code", shopCodes);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rejectCustomerCodes)) {
            sqlFilters.ne((Object)"customer_no", rejectCustomerCodes);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(accountTypes)) {
            sqlFilters.in((Object)"account_type", accountTypes);
        }
        List accountEoList = sqlFilters.list();
        return accountEoList;
    }

    private List<AccountFlowEo> getAccountFlowEoList(List<String> customerCodes, List<String> shopCodes, List<String> rejectCustomerCodes, List<String> accountTypes) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.accountFlowDomain.filter().orderByDesc((Object)"id");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerCodes)) {
            sqlFilters.in((Object)"customer_no", customerCodes);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopCodes)) {
            sqlFilters.in((Object)"shop_code", shopCodes);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rejectCustomerCodes)) {
            sqlFilters.ne((Object)"customer_no", rejectCustomerCodes);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(accountTypes)) {
            sqlFilters.in((Object)"account_type", accountTypes);
        }
        List accountEoList = sqlFilters.list();
        return accountEoList;
    }

    private ReconciliationRuleEo getReconciliationRuleEo(String time) {
        ExtQueryChainWrapper sqlFilters = this.ruleDomain.filter();
        sqlFilters.eq((Object)"bill_cycle", (Object)0);
        sqlFilters.last(" AND DATE_FORMAT(create_time,'%Y-%m')='" + time + "'");
        List reconciliationRuleEos = sqlFilters.list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reconciliationRuleEos)) {
            return reconciliationRuleEos.stream().max(Comparator.comparing(BaseEo::getCreateTime)).get();
        }
        return null;
    }

    private List<ReconciliationDataRangeDto> getReconciliationDataRangeDtoByRuleCode(String ruleCode) {
        List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDomain.filter().eq((Object)"rule_code", (Object)ruleCode)).list();
        ArrayList dataRangeDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dataRangeDtos, (Collection)dataRangeEoList, ReconciliationDataRangeDto.class);
        return dataRangeDtos;
    }

    @Override
    public RestResponse<List<CsOrgCustomerRelationDto>> queryList(CsOrgCustomerRelationPageReqDto reqDto) {
        return new RestResponse((Object)((IReconciliationOrderDomain)this.domain).queryList(reqDto));
    }

    @Override
    public void generateTradeRealation(List<String> ruleCodes) {
        List shopEos;
        String currentDate = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.ruleDomain.filter().orderByDesc((Object)"create_time");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(ruleCodes)) {
            sqlFilters.in((Object)"rule_code", ruleCodes);
        }
        List ruleEoList = sqlFilters.list();
        List codes = ruleEoList.stream().map(ReconciliationRuleEo::getRuleCode).distinct().collect(Collectors.toList());
        List shopCustomerEos = ((ExtQueryChainWrapper)this.shopCustomerDomain.filter().in((Object)"rule_code", codes)).list();
        List collectShopList = shopCustomerEos.stream().filter(x -> 0 == x.getApplicableRange()).collect(Collectors.toList());
        List collectCustomerList = shopCustomerEos.stream().filter(x -> 1 == x.getApplicableRange()).collect(Collectors.toList());
        List conditionEos = ((ExtQueryChainWrapper)this.customerConditionDomain.filter().in((Object)"rule_code", codes)).list();
        List rejectCustomerEoList = ((ExtQueryChainWrapper)this.rejectCustomerDomain.filter().in((Object)"rule_code", codes)).list();
        List<Object> shopIdList = Lists.newArrayList();
        List<Object> customerIdList = Lists.newArrayList();
        List<Object> rejectCustomerIdList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collectShopList)) {
            shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", (Collection)collectShopList.stream().map(ReconciliationShopCustomerEo::getShopCode).distinct().collect(Collectors.toList()))).list();
            shopIdList = shopEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        } else {
            shopEos = this.shopDomain.selectAll();
            shopIdList = shopEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collectCustomerList)) {
            List customerCodes = collectCustomerList.stream().map(ReconciliationShopCustomerEo::getCustomerCode).distinct().collect(Collectors.toList());
            List customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", customerCodes)).list();
            customerIdList = customerEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionEos)) {
            String typeIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerTypeIds).distinct().collect(Collectors.joining(","));
            String areaIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerAreaCodes).distinct().collect(Collectors.joining(","));
            String levelIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerLevelIds).distinct().collect(Collectors.joining(","));
            String groupIds = conditionEos.stream().map(ReconciliationCustomerConditionEo::getCustomerGroupIds).distinct().collect(Collectors.joining(","));
            ArrayList custimerTypeIds = StringUtils.isBlank((CharSequence)typeIds) ? new ArrayList() : Arrays.stream(typeIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            ArrayList customerAreaIds = StringUtils.isBlank((CharSequence)areaIds) ? new ArrayList() : Arrays.stream(areaIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            ArrayList customerLevelIds = StringUtils.isBlank((CharSequence)levelIds) ? new ArrayList() : Arrays.stream(levelIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            ArrayList customerGroupIds = StringUtils.isBlank((CharSequence)groupIds) ? new ArrayList() : Arrays.stream(groupIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
            reqDto.setCustomerTypeIds(custimerTypeIds);
            reqDto.setAreaIds(customerAreaIds);
            reqDto.setLevelIds(customerLevelIds);
            reqDto.setCustomerGroupIds(customerGroupIds);
            List customerRelationDtos = ((IReconciliationOrderDomain)this.domain).queryList(reqDto);
            log.info("\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtos));
            customerIdList = customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getCustomerId).distinct().collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rejectCustomerEoList)) {
            List customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", (Collection)rejectCustomerEoList.stream().map(ReconciliationRejectCustomerEo::getCustomerCode).distinct().collect(Collectors.toList()))).list();
            rejectCustomerIdList = customerEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        }
        CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
        reqDto.setShopIdList((List)shopIdList);
        reqDto.setCustomerIdList((List)customerIdList);
        reqDto.setRejectCustomerIdList((List)rejectCustomerIdList);
        List customerRelationDtos = ((IReconciliationOrderDomain)this.domain).queryList(reqDto);
        log.info("\u5e97\u94fa+\u5ba2\u6237\u5b58\u5728\u4ea4\u6613\u5173\u7cfb\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtos));
        List relationIds = customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getId).distinct().collect(Collectors.toList());
        List rRelationShopEos = ((ExtQueryChainWrapper)this.relationShopDomain.filter().in((Object)"relation_id", relationIds)).list();
        List shopIds = rRelationShopEos.stream().map(CsRRelationShopEo::getShopId).distinct().collect(Collectors.toList());
        Map shopEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"id", shopIds)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        customerRelationDtos.forEach(v -> v.setShopList(rRelationShopEos.stream().map(e -> {
            ShopEo shopEo = (ShopEo)shopEoMap.get(e.getShopId());
            CsRRelationShopDto shopDto = new CsRRelationShopDto();
            if (Objects.isNull(shopEo)) {
                return shopDto;
            }
            shopDto.setShopId(e.getShopId());
            shopDto.setShopCode(shopEo.getCode());
            shopDto.setShopName(shopEo.getName());
            return shopDto;
        }).collect(Collectors.toList())));
        log.info("\u5e97\u94fa+\u5ba2\u6237\u5b58\u5728\u4ea4\u6613\u5173\u7cfb\u7684\u6570\u636ecustomerRelationDtos:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtos));
        this.saveReconciliationBillEo(customerRelationDtos, currentDate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveReconciliationBillEo(List<CsOrgCustomerRelationDto> customerRelationDtos, String currentDate) {
        ArrayList reconciliationBillEos = Lists.newArrayList();
        customerRelationDtos.forEach(v -> {
            List shopCodes;
            List<String> customerCodes = Arrays.asList(v.getCustomerCode());
            List ruleEoList = this.ruleDomain.queryList(customerCodes, shopCodes = v.getShopList().stream().map(CsRRelationShopDto::getShopCode).distinct().collect(Collectors.toList()), currentDate);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ruleEoList)) {
                ReconciliationRuleEo ruleEo = (ReconciliationRuleEo)ruleEoList.get(0);
                ReconciliationBillEo billEo = new ReconciliationBillEo();
                billEo.setBillDate(DateUtils.getPrevMonth(new Date(), 1));
                billEo.setBillDay(DateUtils.getPrevMonth(new Date(), 1) + "-" + String.format("%02d", ruleEo.getBillDay()));
                billEo.setShopCode(((CsRRelationShopDto)v.getShopList().get(0)).getShopCode());
                billEo.setShopName(((CsRRelationShopDto)v.getShopList().get(0)).getShopName());
                billEo.setCustomerCode(v.getCustomerCode());
                billEo.setCustomerName(v.getCustomerName());
                billEo.setStatus("NOT_GERERATE");
                reconciliationBillEos.add(billEo);
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reconciliationBillEos)) {
            this.billDomain.insertBatch((List)reconciliationBillEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public HandlerAuditRespDto operatorBill(BillAuditReqDto dto) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getOperatorType(), (String)"\u64cd\u4f5c\u65b9\u5f0f\u4e0d\u80fd\u7a7a");
        if (dto.getIds().size() < 1) {
            return handlerAuditRespDto;
        }
        handlerAuditRespDto = this.operator(dto);
        return handlerAuditRespDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public HandlerAuditRespDto operator(BillAuditReqDto dto) {
        HandlerAuditRespDto handlerAuditRespDto = new HandlerAuditRespDto();
        Long successNum = 0L;
        Long failNum = 0L;
        for (Long v : dto.getIds()) {
            Long l;
            Long l2;
            ReconciliationOrderEo orderEo;
            OperatorTypeEnum operatorTypeEnum;
            Mutex mutex;
            block22: {
                mutex = null;
                mutex = this.lockService.lock("bill" + dto.getOperatorType(), Convert.toStr((Object)v), 10, 20, TimeUnit.SECONDS);
                operatorTypeEnum = OperatorTypeEnum.forCode((String)dto.getOperatorType());
                orderEo = (ReconciliationOrderEo)((ExtQueryChainWrapper)((IReconciliationOrderDomain)this.domain).filter().eq((Object)"id", (Object)v)).one();
                if (!Objects.isNull(orderEo)) break block22;
                log.error("\u5bf9\u8d26\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728:{}", (Object)v);
                l2 = failNum;
                l = failNum = Long.valueOf(failNum + 1L);
                if (mutex == null) continue;
                this.lockService.unlock(mutex);
                continue;
            }
            try {
                if (OperatorTypeEnum.DELETE.getCode().equalsIgnoreCase(dto.getOperatorType()) && !orderEo.getStatus().equals(ReconciliationBillStatusEnum.CLOSE.getCode())) {
                    throw new BizException("\u5bf9\u8d26\u5355\uff1a" + orderEo.getOrderNo() + "\u72b6\u6001\u4e0d\u662f\u5df2\u5173\u95ed\u72b6\u6001,\u65e0\u6cd5\u5220\u9664");
                }
                if (null == mutex) {
                    log.error("\u5ba1\u6838\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    throw new BizException("\u5ba1\u6838\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                ReconciliationOrderEo eo = new ReconciliationOrderEo();
                eo.setId(orderEo.getId());
                if (StringUtils.isNotBlank((CharSequence)dto.getAuditRemark())) {
                    eo.setAuditRemark(dto.getAuditRemark());
                }
                eo.setAuditStatus(dto.getAuditStatus());
                switch (operatorTypeEnum) {
                    case AUDIT: {
                        eo.setStatus(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode());
                        eo.setStatus(1 == dto.getAuditStatus() ? ReconciliationBillStatusEnum.CLOSE.getCode() : ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode());
                        break;
                    }
                    case PUBLISH: {
                        eo.setStatus(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode());
                        break;
                    }
                    case INVALIDATE: {
                        eo.setStatus(ReconciliationBillStatusEnum.CLOSE.getCode());
                        break;
                    }
                    case CONFIRM: {
                        eo.setStatus(ReconciliationBillStatusEnum.COMPLETE.getCode());
                        break;
                    }
                    case DELETE: {
                        List rangeEos;
                        ReconciliationOrderEo reconciliationOrderEo = new ReconciliationOrderEo();
                        reconciliationOrderEo.setId(orderEo.getId());
                        ((IReconciliationOrderDomain)this.domain).logicDelete((BaseEo)reconciliationOrderEo);
                        List orderDetailEos = ((ExtQueryChainWrapper)this.orderDetailDomain.filter().eq((Object)"order_no", (Object)orderEo.getOrderNo())).list();
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderDetailEos)) {
                            ReconciliationOrderDetailEo detailEo = new ReconciliationOrderDetailEo();
                            detailEo.setOrderNo(orderEo.getOrderNo());
                            this.orderDetailDomain.logicDelete((BaseEo)detailEo);
                        }
                        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(rangeEos = ((ExtQueryChainWrapper)this.accountRangeDomain.filter().eq((Object)"order_no", (Object)orderEo.getOrderNo())).list()))) break;
                        ReconciliationAccountRangeEo accountRangeEo = new ReconciliationAccountRangeEo();
                        accountRangeEo.setOrderNo(orderEo.getOrderNo());
                        this.accountRangeDomain.logicDelete((BaseEo)accountRangeEo);
                        break;
                    }
                    case CANCEL: {
                        eo.setStatus(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode());
                        break;
                    }
                }
                if (!OperatorTypeEnum.DELETE.getCode().equals(dto.getOperatorType())) {
                    List billEos;
                    ((IReconciliationOrderDomain)this.domain).updateSelective((BaseEo)eo);
                    List billDetailEos = ((ExtQueryChainWrapper)this.billDetailDomain.filter().eq((Object)"order_no", (Object)orderEo.getOrderNo())).list();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billDetailEos)) {
                        billDetailEos.forEach(j -> {
                            ReconciliationBillDetailEo detailEo = new ReconciliationBillDetailEo();
                            detailEo.setId(j.getId());
                            detailEo.setStatus(eo.getStatus());
                            this.billDetailDomain.updateSelective((BaseEo)detailEo);
                        });
                    }
                    if (ReconciliationBillStatusEnum.CLOSE.getCode().equals(eo.getStatus()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(billEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billDomain.filter().eq((Object)"order_no", (Object)orderEo.getOrderNo())).eq((Object)"bill_date", (Object)orderEo.getBillDate())).list()))) {
                        billEos.forEach(b -> {
                            ReconciliationBillEo reconciliationBillEo = new ReconciliationBillEo();
                            reconciliationBillEo.setId(b.getId());
                            reconciliationBillEo.setStatus(ReconciliationBillStatusEnum.CLOSE.getCode());
                            this.billDomain.updateSelective((BaseEo)reconciliationBillEo);
                        });
                    }
                }
                l = successNum;
                Long l3 = successNum = Long.valueOf(successNum + 1L);
                if (mutex == null) continue;
            }
            catch (Exception e) {
                try {
                    log.error("\u5ba1\u6838\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                    Long l4 = failNum;
                    l2 = failNum = Long.valueOf(failNum + 1L);
                    throw new BizException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (mutex != null) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
            }
            this.lockService.unlock(mutex);
        }
        handlerAuditRespDto.setSuccessNum(successNum);
        handlerAuditRespDto.setFailNum(failNum);
        return handlerAuditRespDto;
    }

    private List<DynamicHeadDto> handleHeadMerge(List<DynamicHeadDto> headDtos) {
        ArrayList<DynamicHeadDto> dtoList = headDtos.stream().filter(e -> e.getAccountType().equals("YFK")).collect(Collectors.toList());
        Map headDtoMap = headDtos.stream().filter(e -> !e.getAccountType().equals("YFK")).collect(Collectors.toMap(DynamicHeadDto::getAccountType, Function.identity(), (v1, v2) -> {
            BigDecimal v1Amount = v1.getAccountRangeDto().getAmount();
            BigDecimal v2Amount = v2.getAccountRangeDto().getAmount();
            if (v1Amount == null && v2Amount == null) {
                return v1;
            }
            v1Amount = v1Amount == null ? BigDecimal.ZERO : v1Amount;
            v2Amount = v2Amount == null ? BigDecimal.ZERO : v2Amount;
            v1.getAccountRangeDto().setAmount(v1Amount.add(v2Amount));
            return v1;
        }));
        ArrayList<DynamicHeadDto> arrayList = dtoList = org.apache.commons.collections.CollectionUtils.isNotEmpty(dtoList) ? dtoList : new ArrayList<DynamicHeadDto>();
        if (CollUtil.isNotEmpty(headDtoMap)) {
            dtoList.addAll(headDtoMap.values());
        }
        this.handleDynamicHeadAmount(dtoList);
        return dtoList;
    }

    private void handleDynamicHeadAmount(List<DynamicHeadDto> headDtos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(headDtos)) {
            headDtos.forEach(v -> v.setAmount(null != v.getAccountRangeDto() ? v.getAccountRangeDto().getAmount() : null));
        }
    }

    private Map<String, OrderAndAddressDetailDto> getReceiveNameAndConfirmTime(List<String> orderNos) {
        HashMap resultMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderNos)) {
            return resultMap;
        }
        List performOrderInfoEos = ((ExtQueryChainWrapper)this.performOrderInfoDas.filter().in((Object)"sale_order_no", orderNos)).select(new String[]{"id,sale_order_no,confirm_receive_time"}).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)performOrderInfoEos)) {
            log.info("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return resultMap;
        }
        Map performOrderInfoEoMap = performOrderInfoEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        List orderIds = performOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List performOrderAddrEos = ((ExtQueryChainWrapper)this.performOrderAddrDas.filter().in((Object)"order_id", orderIds)).select(new String[]{"id,order_id,order_no,receive_name,receive_phone,receive_address"}).list();
        Map<Object, Object> performOrderAddrEoMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)performOrderAddrEos)) {
            performOrderAddrEoMap = performOrderAddrEos.stream().collect(Collectors.toMap(DgPerformOrderAddrEo::getOrderId, Function.identity(), (k1, k2) -> k1));
        }
        HashMap finalPerformOrderAddrEoMap = performOrderAddrEoMap;
        performOrderInfoEoMap.forEach((k, v) -> {
            OrderAndAddressDetailDto dto = new OrderAndAddressDetailDto();
            dto.setOrderNo(v.getSaleOrderNo());
            if (null != v.getConfirmReceiveTime()) {
                dto.setConfirmReceiveTime(DateUtil.getDateFormat((Date)v.getConfirmReceiveTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (finalPerformOrderAddrEoMap.containsKey(k)) {
                DgPerformOrderAddrEo dgPerformOrderAddrEo = (DgPerformOrderAddrEo)finalPerformOrderAddrEoMap.get(k);
                dto.setReceiveName(Objects.isNull(dgPerformOrderAddrEo) ? null : dgPerformOrderAddrEo.getReceiveName());
            }
            resultMap.put(v.getSaleOrderNo(), dto);
        });
        log.info("\u67e5\u8be2\u8ba2\u5355\u6536\u8d27\u4ebaOrderAndAddressDetailDto:{}", (Object)JSONObject.toJSONString((Object)resultMap));
        return resultMap;
    }
}

