/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.generate;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.EInvoiceTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BillInvoiceTypeConvert {
    private static final Logger log = LoggerFactory.getLogger(BillInvoiceTypeConvert.class);
    @Resource
    private IBillApplyDas billApplyDas;

    public String invoiceTypeConvert(String platformOrderNo, BillStrategyRespDto billStrategyRespDto, SaleOrderBillRecordDto saleOrderBillRecordRespDto, BillInfoEo billInfoEo, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        log.info("\u53d1\u7968\u79cd\u7c7b\u5904\u7406\u5165\u53c2\uff1a{},{},{},{}", new Object[]{platformOrderNo, JSONObject.toJSONString((Object)billStrategyRespDto), JSONObject.toJSONString((Object)saleOrderBillRecordRespDto), JSONObject.toJSONString((Object)billInfoGenerateReqDto)});
        String invoiceType = saleOrderBillRecordRespDto.getInvoiceType();
        if ("all".equals(billStrategyRespDto.getBillObject())) {
            log.info("\u5f00\u7968\u5bf9\u8c61:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getBillObject());
            if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getInvoiceType()) && EInvoiceTypeEnum.E_ALL.getCode().equals(billStrategyRespDto.getInvoiceType())) {
                log.info("\u5f00\u7968\u7c7b\u578b:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getInvoiceType());
                if (BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(saleOrderBillRecordRespDto.getInvoiceType()) || BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(saleOrderBillRecordRespDto.getInvoiceType()) || BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(saleOrderBillRecordRespDto.getInvoiceType())) {
                    invoiceType = BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode();
                } else {
                    log.info("\u5f00\u7968\u7c7b\u578b:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getInvoiceType());
                    invoiceType = billStrategyRespDto.getBillRuleType();
                    List<BillApplyEo> applyEoList = this.getBillApplyEoList(platformOrderNo);
                    log.info("\u6240\u6709\u8ba2\u5355\u5b58\u5728\u7533\u8bf7\u5355\uff0c\u5168\u7535\u4e13\u7528\u7528\u7968:{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString(applyEoList));
                    if (CollectionUtils.isNotEmpty(applyEoList)) {
                        BillApplyEo billApplyEo = applyEoList.get(0);
                        billInfoEo.setTitleType(billApplyEo.getTitleType());
                        billInfoEo.setBillTitle(billApplyEo.getBillTitle());
                        billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
                        billInfoEo.setRegisteredAddress(billApplyEo.getRegisteredAddress());
                        billInfoEo.setRegisteredPhone(billApplyEo.getRegisteredPhone());
                        billInfoEo.setBankAccount(billApplyEo.getBankAccount());
                        billInfoEo.setBank(billApplyEo.getBank());
                        billInfoEo.setApplyNo(billApplyEo.getApplyNo());
                        billInfoEo.setMailbox(billApplyEo.getMailbox());
                        billInfoEo.setPhone(billApplyEo.getPhone());
                        billInfoEo.setBillPersonPhone(billApplyEo.getBillPersonPhone());
                        billInfoEo.setBillPersonName(billApplyEo.getBillPersonName());
                        invoiceType = this.getShopAllElectricInfo(billApplyEo);
                    } else {
                        invoiceType = BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode();
                    }
                }
            } else {
                log.info("\u5f00\u7968\u7c7b\u578b:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getInvoiceType());
                invoiceType = billStrategyRespDto.getBillRuleType();
                List<BillApplyEo> applyEoList = this.getBillApplyEoList(platformOrderNo);
                log.info("\u6240\u6709\u8ba2\u5355\u5b58\u5728\u7533\u8bf7\u5355\uff0c\u5168\u7535\u4e13\u7528\u7528\u7968:{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString(applyEoList));
                if (CollectionUtils.isNotEmpty(applyEoList)) {
                    BillApplyEo billApplyEo = applyEoList.get(0);
                    billInfoEo.setTitleType(billApplyEo.getTitleType());
                    billInfoEo.setBillTitle(billApplyEo.getBillTitle());
                    billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
                    billInfoEo.setRegisteredAddress(billApplyEo.getRegisteredAddress());
                    billInfoEo.setRegisteredPhone(billApplyEo.getRegisteredPhone());
                    billInfoEo.setBankAccount(billApplyEo.getBankAccount());
                    billInfoEo.setBank(billApplyEo.getBank());
                    billInfoEo.setApplyNo(billApplyEo.getApplyNo());
                    billInfoEo.setMailbox(billApplyEo.getMailbox());
                    billInfoEo.setPhone(billApplyEo.getPhone());
                    billInfoEo.setBillPersonPhone(billApplyEo.getBillPersonPhone());
                    billInfoEo.setBillPersonName(billApplyEo.getBillPersonName());
                    invoiceType = billApplyEo.getBillType();
                }
                if (!billInfoGenerateReqDto.getApplyFlag().booleanValue()) {
                    invoiceType = billStrategyRespDto.getBillRuleType();
                }
            }
        } else if ("apply".equals(billStrategyRespDto.getBillObject())) {
            log.info("\u5f00\u7968\u5bf9\u8c61:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getBillObject());
            if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getInvoiceType()) && EInvoiceTypeEnum.E_ALL.getCode().equals(billStrategyRespDto.getInvoiceType())) {
                log.info("\u5f00\u7968\u7c7b\u578b:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getInvoiceType());
                if (BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(saleOrderBillRecordRespDto.getInvoiceType()) || BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(saleOrderBillRecordRespDto.getInvoiceType()) || BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(saleOrderBillRecordRespDto.getInvoiceType())) {
                    invoiceType = BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode();
                } else {
                    log.info("\u5f00\u7968\u7c7b\u578b:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getInvoiceType());
                    List<BillApplyEo> applyEoList = this.getBillApplyEoList(platformOrderNo);
                    log.info("\u7533\u8bf7\u5355\u53d1\u7968\u79cd\u7c7b:{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString(applyEoList));
                    if (CollectionUtils.isNotEmpty(applyEoList)) {
                        BillApplyEo billApplyEo = applyEoList.get(0);
                        billInfoEo.setTitleType(billApplyEo.getTitleType());
                        billInfoEo.setBillTitle(billApplyEo.getBillTitle());
                        billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
                        billInfoEo.setRegisteredAddress(billApplyEo.getRegisteredAddress());
                        billInfoEo.setRegisteredPhone(billApplyEo.getRegisteredPhone());
                        billInfoEo.setBankAccount(billApplyEo.getBankAccount());
                        billInfoEo.setBank(billApplyEo.getBank());
                        billInfoEo.setApplyNo(billApplyEo.getApplyNo());
                        billInfoEo.setMailbox(billApplyEo.getMailbox());
                        billInfoEo.setPhone(billApplyEo.getPhone());
                        billInfoEo.setBillPersonPhone(billApplyEo.getBillPersonPhone());
                        billInfoEo.setBillPersonName(billApplyEo.getBillPersonName());
                        invoiceType = this.getShopAllElectricInfo(billApplyEo);
                    }
                }
            } else {
                log.info("\u5f00\u7968\u7c7b\u578b:{},{}", (Object)platformOrderNo, (Object)billStrategyRespDto.getInvoiceType());
                List<BillApplyEo> applyEoList = this.getBillApplyEoList(platformOrderNo);
                log.info("\u7533\u8bf7\u5355\u53d1\u7968\u79cd\u7c7b:{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString(applyEoList));
                if (CollectionUtils.isNotEmpty(applyEoList)) {
                    BillApplyEo billApplyEo = applyEoList.get(0);
                    billInfoEo.setTitleType(billApplyEo.getTitleType());
                    billInfoEo.setBillTitle(billApplyEo.getBillTitle());
                    billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
                    billInfoEo.setRegisteredAddress(billApplyEo.getRegisteredAddress());
                    billInfoEo.setRegisteredPhone(billApplyEo.getRegisteredPhone());
                    billInfoEo.setBankAccount(billApplyEo.getBankAccount());
                    billInfoEo.setBank(billApplyEo.getBank());
                    billInfoEo.setApplyNo(billApplyEo.getApplyNo());
                    billInfoEo.setMailbox(billApplyEo.getMailbox());
                    billInfoEo.setPhone(billApplyEo.getPhone());
                    billInfoEo.setBillPersonPhone(billApplyEo.getBillPersonPhone());
                    billInfoEo.setBillPersonName(billApplyEo.getBillPersonName());
                    invoiceType = billApplyEo.getBillType();
                }
            }
        }
        log.info("\u8f6c\u6362\u540e\u53d1\u7968\u79cd\u7c7b\uff1a{},{},{}", new Object[]{platformOrderNo, invoiceType, JSONObject.toJSONString((Object)billInfoEo)});
        return invoiceType;
    }

    private List<BillApplyEo> getBillApplyEoList(String platformOrderNo) {
        List applyEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).orderByDesc((Object)"id")).list();
        return applyEoList;
    }

    public String getShopAllElectricInfo(BillApplyEo billApplyEo) {
        String invoiceType = null;
        log.info("\u67e5\u8be2\u662f\u5426\u4e3a\u5168\u7535\u5e97\u94fa:{}", (Object)JSONObject.toJSONString((Object)billApplyEo));
        switch (billApplyEo.getBillType()) {
            case "electronic_general_invoice": 
            case "paper_general_invoice": 
            case "all_electronic_general_invoice": {
                invoiceType = BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode();
                break;
            }
            case "special_paper_invoice": 
            case "all_electronic_special_invoice": 
            case "electronic_special_invoice": {
                invoiceType = BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode();
                break;
            }
        }
        return invoiceType;
    }
}

