/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyChangeTypeEnum;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillApplyReconvertService;
import com.yunxi.dg.base.center.finance.service.entity.IBillApplyService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillApplyReconvertServiceImpl
implements IBillApplyReconvertService {
    private static final Logger log = LoggerFactory.getLogger(BillApplyReconvertServiceImpl.class);
    @Resource
    private IBillApplyDas billApplyDas;
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillApplyService billApplyService;

    @Override
    public void billApplyReconvert(List<String> applyNoList) {
        log.info("\u53d1\u7968\u91cd\u65b0\u8f6c\u6362\u5165\u53c2:{}", (Object)JSONObject.toJSONString(applyNoList));
        List waitHandleList = Lists.newArrayList();
        ArrayList<String> changeTypeList = new ArrayList<String>();
        changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
        changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
        waitHandleList = CollectionUtils.isNotEmpty(applyNoList) ? ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"apply_no", applyNoList)).in((Object)"change_type", changeTypeList)).lt((Object)"reconvert_num", (Object)3)).list() : ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"change_type", changeTypeList)).lt((Object)"reconvert_num", (Object)3)).list();
        if (CollectionUtils.isEmpty((Collection)waitHandleList)) {
            log.info("\u4e0d\u5b58\u5728\u9700\u8981\u8f6c\u6362\u7684\u7533\u8bf7\u5355");
            return;
        }
        List<BillApplyEo> applyEoList = waitHandleList.stream().filter(eo -> eo.getReconvertNum() < 3 && this.judgeTime(eo.getCreateTime())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(applyEoList)) {
            log.info("\u8fc7\u6ee4\u5df2\u7ecf\u8f6c\u6362\u4e86\u4e09\u6b21\u7684\u7533\u8bf7\u5355 \u5e76\u4e14\u521b\u5efa\u65f6\u95f4\u9694\u5f53\u524d\u65f6\u95f4\u4e09\u5206\u949f\u4ee5\u4e0a");
            return;
        }
        List applyNos = applyEoList.stream().map(BillApplyEo::getApplyNo).collect(Collectors.toList());
        List platformOrderNos = applyEoList.stream().map(BillApplyEo::getPlatformOrderNo).distinct().collect(Collectors.toList());
        List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"apply_no", applyNos)).list();
        List billInfoEos = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNos)).list();
        HashSet waitChangeApplyNos = new HashSet();
        HashSet waitPlatformOrderNos = new HashSet();
        billInfoEoList.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getApplyNo()) && !applyNos.contains(v.getApplyNo())) {
                waitChangeApplyNos.add(v.getApplyNo());
            }
        });
        log.info("waitChangeApplyNos:{}", (Object)JSONObject.toJSONString(waitChangeApplyNos));
        billInfoEos.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getPlatformOrderNo()) && !platformOrderNos.contains(v.getPlatformOrderNo())) {
                waitPlatformOrderNos.add(v.getPlatformOrderNo());
            }
        });
        log.info("waitPlatformOrderNos:{}", (Object)JSONObject.toJSONString(waitChangeApplyNos));
        ArrayList needApplyList = Lists.newArrayList();
        applyEoList.forEach(v -> {
            if (waitChangeApplyNos.contains(v.getApplyNo()) && waitPlatformOrderNos.contains(v.getPlatformOrderNo())) {
                needApplyList.add(v.getApplyNo());
            }
        });
        log.info("\u8c03\u5ea6\u4efb\u52a1\u9700\u8981\u8f6c\u6362\u7684\u7533\u8bf7\u5355\u53f7:{}", (Object)JSONObject.toJSONString((Object)needApplyList));
        if (CollectionUtils.isNotEmpty((Collection)needApplyList)) {
            this.billApplyService.transformBillApply(needApplyList);
            this.updateApplyReconvertNum(applyEoList);
            this.updateApplyChangeType(applyEoList);
        }
    }

    public boolean judgeTime(Date createTime) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.add(12, -3);
        Date threeMinutesAge = instance.getTime();
        return !threeMinutesAge.before(createTime);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplyReconvertNum(List<BillApplyEo> applyEoList) {
        applyEoList.forEach(info -> {
            BillApplyEo billApplyEo = new BillApplyEo();
            billApplyEo.setId(info.getId());
            billApplyEo.setReconvertNum(Integer.valueOf(info.getReconvertNum() + 1));
            this.billApplyDas.updateSelective((BaseEo)billApplyEo);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplyChangeType(List<BillApplyEo> applyEoList) {
        List idList = applyEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(idList)) {
            this.billApplyDas.updateChangeType(idList);
        }
    }
}

