/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.dto.entity.SaleOrderBillRecordReqProxyDto;
import com.dtyunxi.yundt.cube.center.trade.proxy.entity.ISaleOrderBillRecordApiProxy;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.BillApplyConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillBusinessRelPlatformDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillEntityDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillApplyMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IBillApplyDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.finance.dto.BillApplyInfoToInvoiceDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillApplyDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderSnapshotDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyChangeTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyOrderPointEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTitleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.PlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.RelBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderInvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SubsidiesTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.WhetherMergeBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyImportErrorDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyPageQueryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyQueryParamReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillApplyRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.dto.response.GenerateBillResultRespDto;
import com.yunxi.dg.base.center.finance.dto.response.UserSystemBillApplyRespDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.eo.BillBusinessRelPlatformEo;
import com.yunxi.dg.base.center.finance.eo.BillEntityEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillApplyService;
import com.yunxi.dg.base.center.finance.service.entity.IBillBusinessRelPlatformService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.finance.service.entity.ISaleOrderBillRecordService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.finance.service.utils.LogUtils;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillApplyServiceImpl
extends BaseServiceImpl<BillApplyDto, BillApplyEo, IBillApplyDomain>
implements IBillApplyService {
    private static final Logger log = LoggerFactory.getLogger(BillApplyServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(BillApplyServiceImpl.class);
    @Resource
    private IBillApplyDas billApplyDas;
    @Autowired
    private BillApplyMapper billApplyMapper;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IPerformOrderInfoService performOrderInfoService;
    @Resource
    private ISaleOrderBillRecordService saleOrderBillRecordService;
    @Resource
    private IBillEntityDas billEntityDas;
    @Resource
    private ILockService lockService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IBillBusinessRelPlatformDas billBusinessRelPlatformDas;
    @Resource
    private IBillBusinessRelPlatformService billBusinessRelPlatformService;
    @Resource
    private IBillApplyDomain billApplyDomain;
    @Resource
    private ISaleOrderBillRecordApiProxy saleOrderBillRecordApiProxy;
    @Resource
    private IKeepAccountsDetailDomain iKeepAccountsDetailDomain;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    private static final String TABLENAME = "mq_sale_order_status_change#";
    private static final String IS_IMPORT_BILL_APPLY = "IS_IMPORT_BILL_APPLY";

    public BillApplyServiceImpl(IBillApplyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillApplyDto, BillApplyEo> converter() {
        return BillApplyConverter.INSTANCE;
    }

    @Override
    public Long addBillApply(BillApplyReqDto addReqDto) {
        BillApplyEo billApplyEo = new BillApplyEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billApplyEo);
        this.billApplyDas.insert((BaseEo)billApplyEo);
        return billApplyEo.getId();
    }

    @Override
    public void modifyBillApply(BillApplyReqDto modifyReqDto) {
        BillApplyEo billApplyEo = new BillApplyEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billApplyEo);
        this.billApplyDas.updateSelective((BaseEo)billApplyEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillApply(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.billApplyDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BillApplyRespDto queryById(Long id) {
        BillApplyEo billApplyEo = (BillApplyEo)this.billApplyDas.selectByPrimaryKey(id);
        BillApplyRespDto billApplyRespDto = new BillApplyRespDto();
        DtoHelper.eo2Dto((BaseEo)billApplyEo, (BaseVo)billApplyRespDto);
        return billApplyRespDto;
    }

    @Override
    public PageInfo<BillApplyRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        BillApplyReqDto billApplyReqDto = (BillApplyReqDto)JSON.parseObject((String)filter, BillApplyReqDto.class);
        BillApplyEo billApplyEo = new BillApplyEo();
        DtoHelper.dto2Eo((BaseVo)billApplyReqDto, (BaseEo)billApplyEo);
        PageInfo eoPageInfo = this.billApplyDomain.selectPage((BaseEo)billApplyEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillApplyRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public UserSystemBillApplyRespDto generateBillApply(BillApplyGenerateReqDto billApplyGenerateReqDto) {
        this.resetApplyPerson();
        this.logger.info("generateBillApply==>\u521b\u5efa\u53d1\u7968\u7533\u8bf7,billApplyGenerateReqDto:{}", (Object)LogUtils.buildLogContent(billApplyGenerateReqDto));
        this.checkParams(billApplyGenerateReqDto);
        return this.generateInfo(billApplyGenerateReqDto);
    }

    private void resetApplyPerson() {
        String oldApplyPerson = ServiceContext.getContext().getRequestUserCode();
        if (StrUtil.isNotBlank((CharSequence)oldApplyPerson)) {
            return;
        }
        String newApplyPerson = "\u7cfb\u7edf";
        this.logger.info("\u91cd\u8bbe\u53d1\u7968\u7533\u8bf7\u4eba\uff1a{} -> {}", (Object)oldApplyPerson, (Object)newApplyPerson);
        ServiceContext.getContext().setAttachment("yes.req.userCode", newApplyPerson);
    }

    private boolean filterWaitHandled(List<String> platformOrderNoList) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).in((Object)"platform_order_no", platformOrderNoList)).list();
        List billApplyEoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List applyList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            ArrayList<String> changeTypeList = new ArrayList<String>();
            changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
            billApplyEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"apply_no", applyList)).in((Object)"change_type", changeTypeList)).list();
        }
        return billApplyEoList.size() > 0;
    }

    @Override
    public PageInfo<BillApplyRespDto> queryPage(BillApplyPageQueryReqDto billApplyPageQueryReqDto) {
        this.logger.info("queryPage==>\u5206\u9875\u67e5\u8be2,billApplyPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(billApplyPageQueryReqDto));
        this.checkParams(billApplyPageQueryReqDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryWrapper(billApplyPageQueryReqDto, (QueryWrapper<BillApplyEo>)queryWrapper);
        queryWrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)billApplyPageQueryReqDto.getPageNum(), (int)billApplyPageQueryReqDto.getPageSize());
        List billApplyEoList = this.billApplyMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)billApplyEoList)) {
            return new PageInfo();
        }
        List<BillApplyRespDto> respDtoList = billApplyEoList.stream().map(e -> {
            BillApplyRespDto billApplyRespDto = new BillApplyRespDto();
            CubeBeanUtils.copyProperties((Object)billApplyRespDto, (Object)e, (String[])new String[0]);
            return billApplyRespDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(billApplyEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        Map<String, List<BillApplyRespDto>> map = respDtoList.stream().collect(Collectors.groupingBy(BillApplyRespDto::getPlatformOrderNo));
        respDtoList.forEach(resp -> {
            if (map.containsKey(resp.getPlatformOrderNo())) {
                List billApplyRespDtos = (List)map.get(resp.getPlatformOrderNo());
                BillApplyRespDto billApplyRespDto = (BillApplyRespDto)billApplyRespDtos.stream().sorted(Comparator.comparing(BillApplyRespDto::getId).reversed()).collect(Collectors.toList()).get(0);
                if (resp.getId().compareTo(billApplyRespDto.getId()) == 0) {
                    resp.setIsLatestOrder(Boolean.TRUE);
                }
            }
        });
        result.setList(respDtoList);
        return result;
    }

    @Override
    public List<BillApplyImportErrorDto> importBillApply(List<BillApplyGenerateReqDto> billApplyGenerateReqDtoList) {
        this.logger.info("importBillApply==>\u5bfc\u5165\u53d1\u7968\u7533\u8bf7,billApplyGenerateReqDto:{}", (Object)LogUtils.buildLogContent(billApplyGenerateReqDtoList));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(billApplyGenerateReqDtoList), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<BillApplyImportErrorDto> billApplyImportErrorDtoList = new ArrayList<BillApplyImportErrorDto>();
        long s = System.currentTimeMillis();
        ServiceContext.getContext().set(IS_IMPORT_BILL_APPLY, (Object)"1");
        billApplyGenerateReqDtoList.forEach(apply -> {
            try {
                this.generateBillApply((BillApplyGenerateReqDto)apply);
            }
            catch (Exception e) {
                BillApplyImportErrorDto errorDto = new BillApplyImportErrorDto();
                errorDto.setPlatformOrderNo((String)apply.getPlatformOrderNoList().get(0));
                errorDto.setErrorMsg(e.getMessage());
                billApplyImportErrorDtoList.add(errorDto);
            }
        });
        ServiceContext.getContext().remove(IS_IMPORT_BILL_APPLY);
        this.logger.info("importBillApply==>\u5bfc\u5165\u53d1\u7968\u7533\u8bf7:{}", (Object)(System.currentTimeMillis() - s));
        this.logger.info("importBillApply==>\u5bfc\u5165\u53d1\u7968\u7533\u8bf7,billApplyImportErrorDtoList:{}", (Object)JSON.toJSONString(billApplyImportErrorDtoList));
        return billApplyImportErrorDtoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transformBillApply(List<String> billApplyNoList) {
        this.logger.info("transformBillApply==>\u53d1\u7968\u7533\u8bf7\u5355\u91cd\u65b0\u8f6c\u6362,billApplyNoList:{}", (Object)LogUtils.buildLogContent(billApplyNoList));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(billApplyNoList), "\u53d1\u7968\u7533\u8bf7\u5355\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ids /* !! */  = new ArrayList<E>();
        mutex = null;
        try {
            mutex = this.lockService.lock("bill_apply_reconvert", "bill_apply_reconvert_primary_key", 10, 20, TimeUnit.SECONDS);
            if (null == mutex) {
                throw new BizException("\u91cd\u65b0\u8f6c\u6362\u7533\u8bf7\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            billApplyEoQueryWrapper = new QueryWrapper();
            billApplyEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            billApplyEoQueryWrapper.in((Object)"apply_no", billApplyNoList);
            changeTypeList = new ArrayList<String>();
            changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
            billApplyEoQueryWrapper.in((Object)"change_type", changeTypeList);
            billApplyEos = this.billApplyMapper.selectList((Wrapper)billApplyEoQueryWrapper);
            this.logger.info("\u67e5\u8be2\u7533\u8bf7\u5355\u5f85\u5904\u7406\u7684\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)billApplyEos));
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)billApplyEos), "\u6839\u636e\u53d1\u7968\u7533\u8bf7\u5355\u53f7\u67e5\u8be2\u4e0d\u5230\u7533\u8bf7\u5355\u76f8\u5173\u6570\u636e");
            ids /* !! */  = billApplyEos.stream().map((Function<BillApplyEo, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/yunxi/dg/base/center/finance/eo/BillApplyEo;)Ljava/lang/Long;)()).collect(Collectors.toList());
            platformOrderNoList = billApplyEos.stream().map((Function<BillApplyEo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPlatformOrderNo(), (Lcom/yunxi/dg/base/center/finance/eo/BillApplyEo;)Ljava/lang/String;)()).distinct().collect(Collectors.toList());
            list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).in((Object)"platform_order_no", platformOrderNoList)).list();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                billFlowNo = list.stream().map((Function<BillBusinessRelPlatformEo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBusinessOrderNo(), (Lcom/yunxi/dg/base/center/finance/eo/BillBusinessRelPlatformEo;)Ljava/lang/String;)()).distinct().collect(Collectors.toList());
                invoiceStatus = new ArrayList<String>();
                invoiceStatus.add(InvoiceStateEnum.CANCELLED.getCode());
                invoiceStatus.add(InvoiceStateEnum.RED_FLUSH.getCode());
                billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNo)).notIn((Object)"invoice_state", invoiceStatus)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).list();
                if (billInfoEoList.stream().anyMatch((Predicate<BillInfoEo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$transformBillApply$3(com.yunxi.dg.base.center.finance.eo.BillInfoEo ), (Lcom/yunxi/dg/base/center/finance/eo/BillInfoEo;)Z)())) {
                    throw new BizException("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u65e0\u6cd5\u8fdb\u884c\u8f6c\u6362");
                }
            }
            for (BillApplyEo eo : billApplyEos) {
                billApplyEoQueryWrapper.clear();
                billApplyEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                billApplyEoQueryWrapper.eq((Object)"platform_order_no", (Object)eo.getPlatformOrderNo());
                billApplyEoQueryWrapper.in((Object)"change_type", changeTypeList);
                billApplyEoQueryWrapper.orderByDesc((Object)"id");
                billApplyEoList = this.billApplyMapper.selectList((Wrapper)billApplyEoQueryWrapper);
                this.logger.info("\u6839\u636e\u5e73\u53f0\u5355\u53f7\u67e5\u8be2\u5230\u7533\u8bf7\u5355\u5f85\u8f6c\u6362\u7684\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)billApplyEoList));
                AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)billApplyEoList), String.format("\u6839\u636e\u3010%s\u3011\u53d1\u7968\u7533\u8bf7\u5355\u627e\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4fe1\u606f", new Object[]{eo.getApplyNo()}));
                this.conversionAgain(billApplyEoList);
            }
            ** if (mutex == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                this.logger.error("\u91cd\u65b0\u8f6c\u6362\u7533\u8bf7\u5355\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                ** if (mutex == null) goto lbl-1000
            }
            catch (Throwable var12_13) {
                if (mutex != null) {
                    this.lockService.unlock(mutex);
                }
                throw var12_13;
            }
lbl-1000:
            // 1 sources

            {
                this.lockService.unlock(mutex);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.lockService.unlock(mutex);
        }
lbl-1000:
        // 2 sources

        {
        }
        updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", ids /* !! */ );
        applyEo = new BillApplyEo();
        applyEo.setConversionTime(new Date());
        this.billApplyMapper.update((Object)applyEo, (Wrapper)updateWrapper);
    }

    @Override
    public List<BillApplyRespDto> queryParam(BillApplyQueryParamReqDto billApplyQueryParamReqDto) {
        this.logger.info("queryParam==>\u591a\u6761\u4ef6\u67e5\u8be2,billApplyQueryParamReqDto:{}", (Object)LogUtils.buildLogContent(billApplyQueryParamReqDto));
        AssertUtil.isTrue(null != billApplyQueryParamReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryParamWrapper(billApplyQueryParamReqDto, (QueryWrapper<BillApplyEo>)queryWrapper);
        List billApplyEoList = this.billApplyMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)billApplyEoList)) {
            return Lists.newArrayList();
        }
        ArrayList billApplyRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)billApplyRespDtoList, (Collection)billApplyEoList, BillApplyRespDto.class);
        return billApplyRespDtoList;
    }

    private void buildQueryParamWrapper(BillApplyQueryParamReqDto billApplyQueryParamReqDto, QueryWrapper<BillApplyEo> queryWrapper) {
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        String applyNo = billApplyQueryParamReqDto.getApplyNo();
        if (StringUtils.isNotBlank((CharSequence)applyNo)) {
            queryWrapper.eq((Object)"apply_no", (Object)YesNoEnum.NO.getValue());
        }
        if (CollectionUtils.isNotEmpty((Collection)billApplyQueryParamReqDto.getApplyNoList())) {
            queryWrapper.in((Object)"apply_no", (Collection)billApplyQueryParamReqDto.getApplyNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)billApplyQueryParamReqDto.getPlatformOrderNoList())) {
            queryWrapper.in((Object)"platform_order_no", (Collection)billApplyQueryParamReqDto.getPlatformOrderNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)billApplyQueryParamReqDto.getPlatformOrderNo())) {
            queryWrapper.eq((Object)"platform_order_no", (Object)billApplyQueryParamReqDto.getPlatformOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billApplyQueryParamReqDto.getApplyChannel())) {
            queryWrapper.eq((Object)"apply_channel", (Object)billApplyQueryParamReqDto.getApplyChannel());
        }
        if (StringUtils.isNotBlank((CharSequence)billApplyQueryParamReqDto.getShopCode())) {
            queryWrapper.eq((Object)"shop_code", (Object)billApplyQueryParamReqDto.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)billApplyQueryParamReqDto.getChangeType())) {
            queryWrapper.eq((Object)"change_type", (Object)billApplyQueryParamReqDto.getChangeType());
        }
    }

    private void conversionAgain(List<BillApplyEo> billApplyEoList) {
        this.logger.info("conversionAgain==>\u91cd\u65b0\u8f6c\u6362,billApplyEoList:{}", (Object)LogUtils.buildLogContent(billApplyEoList));
        BillApplyEo billApplyEo = billApplyEoList.stream().max(Comparator.comparing(BaseEo::getCreateTime)).orElseThrow(() -> new BizException("\u627e\u4e0d\u5230\u7533\u8bf7\u5355"));
        String platformOrderNo = billApplyEo.getPlatformOrderNo();
        List<String> platformOrderNoList = Arrays.asList(platformOrderNo.split(","));
        PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
        performOrderInfoPageReqDto.setPlatformOrderNo(platformOrderNo);
        performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
        List<PerformOrderInfoDto> saleOrderRespDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
        this.getExcludingPerformOrderInfoDtoList(saleOrderRespDtoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(saleOrderRespDtoList), String.format("\u3010%s\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f", platformOrderNo));
        PerformOrderInfoDto saleOrderRespDto = saleOrderRespDtoList.get(0);
        String shopCode = ((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode();
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        this.logger.info("handleBatchOrder==>billStrategyRespDto:{}", (Object)LogUtils.buildLogContent(billStrategyRespDto));
        AssertUtil.isTrue(null != billStrategyRespDto.getId(), "\u5e97\u94fa\u672a\u7ed1\u5b9a\u5f00\u7968\u7b56\u7565");
        BillApplyGenerateReqDto billApplyGenerateReqDto = new BillApplyGenerateReqDto();
        billApplyGenerateReqDto.setBillApplyType(billApplyEo.getApplyType());
        billApplyGenerateReqDto.setBillType(billApplyEo.getBillType());
        billApplyGenerateReqDto.setBillTitle(billApplyEo.getBillTitle());
        billApplyGenerateReqDto.setEnterprise(billApplyEo.getEnterprise());
        billApplyGenerateReqDto.setTaxesCode(billApplyEo.getTaxesCode());
        billApplyGenerateReqDto.setRegisteredAddress(billApplyEo.getRegisteredAddress());
        billApplyGenerateReqDto.setRegisteredPhone(billApplyEo.getRegisteredPhone());
        billApplyGenerateReqDto.setBankAccount(billApplyEo.getBankAccount());
        billApplyGenerateReqDto.setBank(billApplyEo.getBank());
        billApplyGenerateReqDto.setTitleType(billApplyEo.getTitleType());
        billApplyGenerateReqDto.setMailbox(billApplyEo.getMailbox());
        billApplyGenerateReqDto.setPhone(billApplyEo.getPhone());
        billApplyGenerateReqDto.setWhetherMergeBill(billApplyEo.getWhetherMergeBill());
        billApplyGenerateReqDto.setIsUserSystem(billApplyEo.getIsUserSystem());
        billApplyGenerateReqDto.setBillAddress(billApplyEo.getBillAddress());
        billApplyGenerateReqDto.setBillPersonName(billApplyEo.getBillPersonName());
        billApplyGenerateReqDto.setBillPersonPhone(billApplyEo.getBillPersonPhone());
        Boolean aBoolean = this.changeBillApplyInfoNew(billApplyEo, saleOrderRespDtoList, platformOrderNoList, billStrategyRespDto, billApplyGenerateReqDto, true);
        List ids = billApplyEoList.stream().map(e -> e.getId()).collect(Collectors.toList());
        this.logger.info("\u66f4\u65b0\u6d89\u53ca\u7684\u7533\u8bf7\u5355id\uff1a\u3010{}\u3011\u4e3a\u5df2\u5904\u7406", (Object)JSON.toJSONString(ids));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", ids);
        BillApplyEo applyEo = new BillApplyEo();
        applyEo.setChangeType(aBoolean != false ? BillApplyChangeTypeEnum.HANDLED.getCode() : BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
        this.billApplyMapper.update((Object)applyEo, (Wrapper)updateWrapper);
    }

    private void buildQueryWrapper(BillApplyPageQueryReqDto billApplyPageQueryReqDto, QueryWrapper<BillApplyEo> queryWrapper) {
        Long shopId;
        String applyNo;
        Date conversionEndTime;
        Date conversionBeginTime;
        String endApplyTime;
        String beginApplyTime;
        String changeType;
        String applyChannel;
        String billType;
        String shopCode;
        String site;
        String applyType;
        String businessOrderNo;
        List applyNoList;
        List list;
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        String platformOrderNo = billApplyPageQueryReqDto.getPlatformOrderNo();
        if (StringUtils.isNotBlank((CharSequence)platformOrderNo)) {
            list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).list();
            if (CollectionUtils.isEmpty((Collection)list)) {
                queryWrapper.eq((Object)"platform_order_no", (Object)platformOrderNo);
            } else {
                applyNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                queryWrapper.in((Object)"apply_no", applyNoList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)billApplyPageQueryReqDto.getPlatformOrderNoList())) {
            list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().in((Object)"platform_order_no", (Collection)billApplyPageQueryReqDto.getPlatformOrderNoList())).eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).list();
            if (CollectionUtils.isEmpty((Collection)list)) {
                queryWrapper.in((Object)"platform_order_no", (Collection)billApplyPageQueryReqDto.getPlatformOrderNoList());
            } else {
                applyNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                queryWrapper.in((Object)"apply_no", applyNoList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(businessOrderNo = billApplyPageQueryReqDto.getBusinessOrderNo()))) {
            queryWrapper.eq((Object)"business_order_no", (Object)businessOrderNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(applyType = billApplyPageQueryReqDto.getApplyType()))) {
            queryWrapper.eq((Object)"apply_type", (Object)applyType);
        }
        if (StringUtils.isNotBlank((CharSequence)(site = billApplyPageQueryReqDto.getSite()))) {
            queryWrapper.eq((Object)"site", (Object)site);
        }
        if (StringUtils.isNotBlank((CharSequence)(shopCode = billApplyPageQueryReqDto.getShopCode()))) {
            queryWrapper.eq((Object)"shop_code", (Object)shopCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(billType = billApplyPageQueryReqDto.getBillType()))) {
            queryWrapper.eq((Object)"bill_type", (Object)billType);
        }
        if (StringUtils.isNotBlank((CharSequence)(applyChannel = billApplyPageQueryReqDto.getApplyChannel()))) {
            queryWrapper.eq((Object)"apply_channel", (Object)applyChannel);
        }
        if (StringUtils.isNotBlank((CharSequence)(changeType = billApplyPageQueryReqDto.getChangeType()))) {
            queryWrapper.eq((Object)"change_type", (Object)changeType);
        }
        if (StringUtils.isNotBlank((CharSequence)(beginApplyTime = billApplyPageQueryReqDto.getBeginApplyTime()))) {
            queryWrapper.ge((Object)"apply_time", (Object)(beginApplyTime + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)(endApplyTime = billApplyPageQueryReqDto.getEndApplyTime()))) {
            queryWrapper.le((Object)"apply_time", (Object)(endApplyTime + " 23:59:59"));
        }
        if (null != (conversionBeginTime = billApplyPageQueryReqDto.getConversionBeginTime())) {
            queryWrapper.ge((Object)"conversion_time", (Object)conversionBeginTime);
        }
        if (null != (conversionEndTime = billApplyPageQueryReqDto.getConversionEndTime())) {
            queryWrapper.le((Object)"conversion_time", (Object)conversionEndTime);
        }
        if (StringUtils.isNotBlank((CharSequence)(applyNo = billApplyPageQueryReqDto.getApplyNo()))) {
            queryWrapper.like((Object)"apply_no", (Object)applyNo);
        }
        if (Objects.nonNull(shopId = billApplyPageQueryReqDto.getShopId())) {
            queryWrapper.eq((Object)"shop_id", (Object)shopId);
        }
        if (CollectionUtils.isNotEmpty((Collection)billApplyPageQueryReqDto.getApplyChannelList())) {
            queryWrapper.in((Object)"apply_channel", (Collection)billApplyPageQueryReqDto.getApplyChannelList());
        }
        if (null != billApplyPageQueryReqDto.getWhetherMergeBill()) {
            queryWrapper.eq((Object)"whether_merge_bill", (Object)billApplyPageQueryReqDto.getWhetherMergeBill());
        }
        if (StringUtils.isNotBlank((CharSequence)billApplyPageQueryReqDto.getCreatePerson())) {
            queryWrapper.like((Object)"create_person", (Object)billApplyPageQueryReqDto.getCreatePerson());
        }
        queryWrapper.eq(billApplyPageQueryReqDto.getSubsidiesType() != null, (Object)"subsidies_type", (Object)billApplyPageQueryReqDto.getSubsidiesType());
    }

    private void checkParams(BillApplyPageQueryReqDto billApplyPageQueryReqDto) {
        AssertUtil.isTrue(null != billApplyPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer pageNum = billApplyPageQueryReqDto.getPageNum();
        Integer pageSize = billApplyPageQueryReqDto.getPageSize();
        AssertUtil.isTrue(null != pageNum && pageNum > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != pageSize && pageSize > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
    }

    private UserSystemBillApplyRespDto generateInfo(BillApplyGenerateReqDto billApplyGenerateReqDto) {
        UserSystemBillApplyRespDto userSystemBillApplyRespDto = new UserSystemBillApplyRespDto();
        userSystemBillApplyRespDto.setStatus("2");
        List platformOrderNoList = billApplyGenerateReqDto.getPlatformOrderNoList();
        log.info("\u67e5\u8be2\u5e73\u53f0\u5355\u53f7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)platformOrderNoList));
        if (WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(billApplyGenerateReqDto.getWhetherMergeBill()) || null == billApplyGenerateReqDto.getWhetherMergeBill()) {
            List relPlatformList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).in((Object)"platform_order_no", (Collection)platformOrderNoList)).list();
            if (CollectionUtils.isNotEmpty((Collection)relPlatformList)) {
                List applyNoList = relPlatformList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                List billApplyEoList = ((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"apply_no", (Collection)applyNoList)).list();
                if (CollectionUtils.isNotEmpty((Collection)billApplyEoList) && billApplyEoList.stream().anyMatch(x -> WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(x.getWhetherMergeBill()))) {
                    throw new BizException("\u5e73\u53f0\u5355\u5df2\u5b58\u5728\u5408\u5e76\u5f00\u7968\u7684\u5355\u636e\u65e0\u6cd5\u7ee7\u7eed\u7533\u8bf7");
                }
            }
            for (String platformOrderNo : platformOrderNoList) {
                PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
                performOrderInfoPageReqDto.setPlatformOrderNo(platformOrderNo);
                performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
                performOrderInfoPageReqDto.setBillApplyType(billApplyGenerateReqDto.getBillApplyType());
                List<PerformOrderInfoDto> performOrderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
                this.logger.info(String.format("\u6839\u636e\u5e73\u53f0\u5355\u53f7\uff1a\u3010%s\u3011\u67e5\u8be2\u5230\u914d\u8d27\u8ba2\u5355\u4fe1\u606f\uff1a\u3010%s\u3011", platformOrderNo, JSON.toJSONString(performOrderInfoDtoList)));
                this.getExcludingPerformOrderInfoDtoList(performOrderInfoDtoList);
                this.logger.info("\u5254\u9664\u6362\u8d27\u5355\u5bf9\u5e94\u7684\u552e\u540e\u5355\u672a\u5b8c\u6210\u6570\u636e:{}", (Object)JSONObject.toJSONString(performOrderInfoDtoList));
                AssertUtil.isTrue(CollectionUtils.isNotEmpty(performOrderInfoDtoList), String.format("\u3010%s\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f", platformOrderNo));
                Boolean aBoolean = this.handleBatchOrder(platformOrderNo, billApplyGenerateReqDto, performOrderInfoDtoList, null, userSystemBillApplyRespDto);
                if (!aBoolean.booleanValue()) continue;
                userSystemBillApplyRespDto.setStatus("1");
            }
        } else {
            Boolean aBoolean;
            this.logger.info("\u5408\u5e76\u5f00\u7968");
            if (platformOrderNoList.size() > 50) {
                throw new BizException("\u5408\u5e76\u5f00\u7968\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc750\u5355");
            }
            PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
            performOrderInfoPageReqDto.setPlatformOrderNoList(platformOrderNoList);
            performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
            List<PerformOrderInfoDto> saleOrderRespDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
            this.validateMerge(saleOrderRespDtoList);
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).in((Object)"platform_order_no", (Collection)platformOrderNoList)).list();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List billFlowNo = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                ArrayList<String> invoiceStatus = new ArrayList<String>();
                invoiceStatus.add(InvoiceStateEnum.CANCELLED.getCode());
                invoiceStatus.add(InvoiceStateEnum.RED_FLUSH.getCode());
                List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNo)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).notIn((Object)"invoice_state", invoiceStatus)).list();
                if (CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                    throw new BizException(String.format("%s:\u5b58\u5728\u6b63\u5e38\u7684\u5f00\u7968\u4fe1\u606f\u65e0\u6cd5\u7533\u8bf7\u5408\u5e76\u5f00\u7968", billInfoEoList.stream().map(BillInfoEo::getPlatformOrderNo).distinct().collect(Collectors.joining(","))));
                }
            }
            if ((aBoolean = this.handleMergeOrder(platformOrderNoList, billApplyGenerateReqDto, saleOrderRespDtoList, userSystemBillApplyRespDto)).booleanValue()) {
                userSystemBillApplyRespDto.setStatus("1");
            }
        }
        return userSystemBillApplyRespDto;
    }

    private void validateMerge(List<PerformOrderInfoDto> saleOrderRespDtoList) {
        boolean hasSubsidies;
        if (saleOrderRespDtoList.size() > 1 && (hasSubsidies = saleOrderRespDtoList.stream().anyMatch(this::isCountrySubsidies))) {
            throw new BizException("\u56fd\u8865\u8ba2\u5355\u4e0d\u80fd\u5408\u5e76\u5f00\u7968");
        }
    }

    private boolean isCountrySubsidies(PerformOrderInfoDto saleOrderRespDto) {
        return SubsidiesTypeEnum.COUNTRY_SUBSIDIES.getCode().equals(saleOrderRespDto.getSubsidiesType());
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean handleBatchOrder(String platformOrderNo, BillApplyGenerateReqDto billApplyGenerateReqDto, List<PerformOrderInfoDto> saleOrderRespDtoList, Object tfOrderRespDto, UserSystemBillApplyRespDto userSystemBillApplyRespDto) {
        this.logger.info("handleBatchOrder==>\u6279\u91cf\u5904\u7406\u8ba2\u5355,platformOrderNo:{},billApplyGenerateReqDto:{},saleOrderRespDtoList:{}", new Object[]{platformOrderNo, LogUtils.buildLogContent(billApplyGenerateReqDto), LogUtils.buildLogContent(saleOrderRespDtoList)});
        PerformOrderInfoDto saleOrderRespDto = saleOrderRespDtoList.get(0);
        List collect = saleOrderRespDtoList.stream().filter(x -> null != x.getSubsidiesType() && 1 == x.getSubsidiesType()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            saleOrderRespDto.setSubsidiesType(Integer.valueOf(1));
        }
        String shopCode = ((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode();
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        this.logger.info("handleBatchOrder==>billStrategyRespDto:{}", (Object)LogUtils.buildLogContent(billStrategyRespDto));
        AssertUtil.isTrue(null != billStrategyRespDto.getId(), "\u5e97\u94fa\u672a\u7ed1\u5b9a\u5f00\u7968\u7b56\u7565");
        BillApplyEo billApplyEo = this.saveBillApplyInfo(platformOrderNo, billApplyGenerateReqDto, saleOrderRespDtoList, billStrategyRespDto, tfOrderRespDto);
        userSystemBillApplyRespDto.setApplyNo(billApplyEo.getApplyNo());
        ArrayList<String> platformOrderNoList = new ArrayList<String>();
        platformOrderNoList.add(platformOrderNo);
        boolean existWaitHandleBillApply = this.filterWaitHandled(platformOrderNoList);
        this.logger.info("\u662f\u5426\u5df2\u5b58\u5728\u5f85\u8f6c\u6362\u7684\u5f00\u7968\u7533\u8bf7\u5355:{}", (Object)JSON.toJSONString((Object)existWaitHandleBillApply));
        if (existWaitHandleBillApply) {
            this.logger.info("\u5e73\u53f0\u5355\u53f7\uff1a{}\u5df2\u5b58\u5728\u5f85\u8f6c\u6362\u7684\u5f00\u7968\u7533\u8bf7\u5355,\u4e0d\u5904\u7406", (Object)platformOrderNo);
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
            return false;
        }
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
        Object o = ServiceContext.getContext().get(IS_IMPORT_BILL_APPLY);
        if (Objects.nonNull(o)) {
            log.info("\u4e0d\u5b58\u5728\uff0c\u5c06\u53d1\u7968\u7533\u8bf7\u5355\u8f6c\u6362\uff0c\u5e76\u4e14\u751f\u6210\u5f00\u7968\u4fe1\u606f\uff0c\u53d1\u9001mq:{}", (Object)billApplyEo.getApplyNo());
            BillApplyInfoToInvoiceDto billApplyInfoToInvoiceDto = new BillApplyInfoToInvoiceDto(billApplyEo, saleOrderRespDtoList, platformOrderNoList, billStrategyRespDto, billApplyGenerateReqDto);
            this.commonsMqService.sendSingleMessage("BILL_APPLY_INFO_TO_INVOICE", (Object)JSON.toJSONString((Object)((Object)billApplyInfoToInvoiceDto)));
            return true;
        }
        return this.changeBillApplyInfoNew(billApplyEo, saleOrderRespDtoList, platformOrderNoList, billStrategyRespDto, billApplyGenerateReqDto, false);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean handleMergeOrder(List<String> platformOrderNoList, BillApplyGenerateReqDto billApplyGenerateReqDto, List<PerformOrderInfoDto> saleOrderRespDtoList, UserSystemBillApplyRespDto userSystemBillApplyRespDto) {
        this.logger.info("handleBatchOrder==>\u6279\u91cf\u5904\u7406\u8ba2\u5355,platformOrderNo:{},billApplyGenerateReqDto:{},saleOrderRespDtoList:{}", new Object[]{LogUtils.buildLogContent(platformOrderNoList), LogUtils.buildLogContent(billApplyGenerateReqDto), LogUtils.buildLogContent(saleOrderRespDtoList)});
        Set set = saleOrderRespDtoList.stream().map(x -> ((PerformOrderSnapshotDto)x.getPerformOrderSnapshotDtoList().get(0)).getShopCode()).collect(Collectors.toSet());
        AssertUtil.isTrue(set.size() == 1, "\u5408\u5e76\u5f00\u7968\u7684\u8ba2\u5355\u5b58\u5728\u591a\u4e2a\u5e97\u94fa\u4e0d\u5141\u8bb8\u5408\u5e76");
        PerformOrderInfoDto saleOrderRespDto = saleOrderRespDtoList.get(0);
        String shopCode = ((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode();
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        this.logger.info("handleBatchOrder==>billStrategyRespDto:{}", (Object)LogUtils.buildLogContent(billStrategyRespDto));
        AssertUtil.isTrue(null != billStrategyRespDto.getId(), "\u5e97\u94fa\u672a\u7ed1\u5b9a\u5f00\u7968\u7b56\u7565");
        BillApplyEo billApplyEo = this.saveBillApplyInfo(String.join((CharSequence)",", platformOrderNoList), billApplyGenerateReqDto, saleOrderRespDtoList, billStrategyRespDto, new Object());
        userSystemBillApplyRespDto.setApplyNo(billApplyEo.getApplyNo());
        boolean existWaitHandleBillApply = this.filterWaitHandled(platformOrderNoList);
        this.logger.info("\u662f\u5426\u5df2\u5b58\u5728\u5f85\u8f6c\u6362\u7684\u5f00\u7968\u7533\u8bf7\u5355:{}", (Object)JSON.toJSONString((Object)existWaitHandleBillApply));
        if (existWaitHandleBillApply) {
            this.logger.info("\u5df2\u5b58\u5728\u5f85\u8f6c\u6362\u7684\u5f00\u7968\u7533\u8bf7\u5355\u4e0d\u5904\u7406");
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
            return false;
        }
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
        return this.changeBillApplyInfoNew(billApplyEo, saleOrderRespDtoList, platformOrderNoList, billStrategyRespDto, billApplyGenerateReqDto, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean changeBillApplyInfoNew(BillApplyEo billApplyEo, List<PerformOrderInfoDto> saleOrderRespDtoList, List<String> platformOrderNoList, BillStrategyRespDto billStrategyRespDto, BillApplyGenerateReqDto billApplyGenerateReqDto, boolean isConversionAgain) {
        List billInfoEoList;
        this.logger.info("changeBillApplyInfo==>\u5c06\u53d1\u7968\u7533\u8bf7\u5355\u8f6c\u6362\uff0c\u5e76\u4e14\u751f\u6210\u5f00\u7968\u4fe1\u606f,billApplyEo:{},saleOrderRespDtoList:{},platformOrderNo:{}", new Object[]{LogUtils.buildLogContent(billApplyEo), LogUtils.buildLogContent(saleOrderRespDtoList), LogUtils.buildLogContent(platformOrderNoList)});
        Boolean flag = false;
        if ((WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(billApplyEo.getWhetherMergeBill()) || null == billApplyEo.getWhetherMergeBill()) && CollectionUtils.isNotEmpty((Collection)(billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)platformOrderNoList.get(0))).eq((Object)"bill_type", (Object)"blue_ticket")).list()))) {
            this.logger.info("billInfoEoList:{}", (Object)JSON.toJSONString((Object)billInfoEoList));
            if (billInfoEoList.stream().anyMatch(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState()))) {
                this.logger.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u8fdb\u884c\u8f6c\u6362");
                return false;
            }
        }
        Mutex lock = null;
        try {
            String platformOrderKey = String.format("invoice:key:%s", platformOrderNoList.get(0));
            Thread.sleep(RandomUtil.randomLong((long)100L, (long)200L));
            lock = this.lockService.lock(TABLENAME, platformOrderKey);
            String billOrderPoint = billStrategyRespDto.getBillOrderPoint();
            if (BillStrategyOrderPointEnum.DELIVER.getCode().equals(billOrderPoint)) {
                this.logger.info("handleBatchOrder==>\u5df2\u53d1\u8d27\u7b56\u7565");
                flag = this.applyOrderDeliverStrategy(saleOrderRespDtoList, billApplyEo, billStrategyRespDto, billApplyGenerateReqDto, platformOrderNoList);
            } else if (BillStrategyOrderPointEnum.COMPLETE.getCode().equals(billOrderPoint)) {
                this.logger.info("handleBatchOrder==>\u5df2\u5b8c\u6210\u7b56\u7565");
                flag = this.applyOrderCompleteStrategy(saleOrderRespDtoList, billApplyEo, billStrategyRespDto, billApplyGenerateReqDto, platformOrderNoList);
            } else {
                this.logger.info("handleBatchOrder==>\u8bb0\u8d26\u5b8c\u6210\u7b56\u7565");
                List<String> orderStatusList = Arrays.asList(OmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_PICK.getCode(), OmsSaleOrderStatus.PICKED.getCode(), OmsSaleOrderStatus.WAIT_DELIVERY.getCode(), OmsSaleOrderStatus.WAIT_ASSIGN.getCode(), OmsSaleOrderStatus.CANCEL.getCode(), OmsSaleOrderStatus.OBSOLETE.getCode(), OmsSaleOrderStatus.LACK.getCode(), OmsSaleOrderStatus.DELIVERED.getCode());
                List saleOrderNos = saleOrderRespDtoList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOrderStatus()) && !orderStatusList.contains(x.getOrderStatus())).map(PerformOrderInfoDto::getSaleOrderNo).distinct().collect(Collectors.toList());
                this.logger.info("saleOrderNos\uff1a{}", (Object)JSONObject.toJSONString(saleOrderNos));
                this.logger.info("saleOrderRespDtoList:{}", (Object)JSONObject.toJSONString(saleOrderRespDtoList));
                if (CollectionUtils.isEmpty(saleOrderNos)) {
                    List saleOrderNosList = saleOrderRespDtoList.stream().map(PerformOrderInfoDto::getSaleOrderNo).distinct().collect(Collectors.toList());
                    log.error("\u9500\u552e\u8ba2\u5355\u4e0d\u662f\u5df2\u53d1\u8d27\u6216\u5df2\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u5f00\u7968\uff1a{}", saleOrderNosList);
                    throw new BizException("\u9500\u552e\u8ba2\u5355\u4e0d\u662f\u5df2\u53d1\u8d27\u6216\u5df2\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u5f00\u7968 orderNo:" + JSONObject.toJSONString(saleOrderNosList));
                }
                List invoiceVoucherSuccess = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iKeepAccountsDetailDomain.filter().select(new String[]{"id"}).in((Object)"order_no", saleOrderNos)).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"accounting_result", (Object)AccountRuleEnum.ACCOUNT_SUCCESS.getCode())).groupBy((Object)"order_no")).list();
                if (CollUtil.isEmpty((Collection)invoiceVoucherSuccess)) {
                    log.error("\u5f00\u7968\u8bb0\u8d26\u8fd8\u6ca1\u6210\u529f\uff0c\u4e0d\u5f00\u7968 orderNo\uff1a{}", saleOrderNos);
                    throw new BizException("\u5f00\u7968\u8bb0\u8d26\u8fd8\u6ca1\u6210\u529f\uff0c\u4e0d\u5f00\u7968 orderNo:" + JSONObject.toJSONString(saleOrderNos));
                }
                if (saleOrderNos.size() != invoiceVoucherSuccess.size()) {
                    log.error("\u5f00\u7968\u8bb0\u8d26\u6ca1\u6709\u5168\u90e8\u6210\u529f\uff0c\u4e0d\u5f00\u7968 orderNo\uff1a{}\uff0c {}", saleOrderNos, (Object)invoiceVoucherSuccess);
                    throw new BizException("\u5f00\u7968\u8bb0\u8d26\u6ca1\u6709\u5168\u90e8\u6210\u529f\uff0c\u4e0d\u5f00\u7968 orderNo:" + JSONObject.toJSONString(saleOrderNos));
                }
                List<PerformOrderInfoDto> performOrderInfoDtos = saleOrderRespDtoList.stream().filter(x -> Objects.equals(OmsSaleOrderStatus.COMPLETE.getCode(), x.getOrderStatus())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(performOrderInfoDtos)) {
                    log.error("\u4e0d\u5b58\u5728\u5df2\u5b8c\u6210\u7684\u8ba2\u5355\uff0c\u4e0d\u5f00\u7968 orderNo\uff1a{}", saleOrderNos);
                    throw new BizException("\u4e0d\u5b58\u5728\u5df2\u5b8c\u6210\u7684\u8ba2\u5355\uff0c\u4e0d\u5f00\u7968 orderNo:" + JSONObject.toJSONString(saleOrderNos));
                }
                flag = this.applyOrderCompleteStrategy(performOrderInfoDtos, billApplyEo, billStrategyRespDto, billApplyGenerateReqDto, platformOrderNoList);
            }
            if (lock == null) return flag;
        }
        catch (BusinessRuntimeException e) {
            this.logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25:{},{}", (Object)e, (Object)e.getMessage());
            flag = false;
            billApplyEo.setReason(e.getMessage());
            billApplyEo.setChangeType("handle_fail");
            this.billApplyDas.updateSelective((BaseEo)billApplyEo);
            if (lock == null) return flag;
            this.lockService.unlock(lock);
            return flag;
        }
        catch (Exception e2) {
            this.logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25:{},{}", (Object)e2, (Object)e2.getMessage());
            flag = false;
            billApplyEo.setReason(e2.getMessage());
            billApplyEo.setChangeType("handle_fail");
            this.billApplyDas.updateSelective((BaseEo)billApplyEo);
            if (lock == null) return flag;
            {
                catch (Throwable throwable) {
                    if (lock == null) throw throwable;
                    this.lockService.unlock(lock);
                    throw throwable;
                }
            }
            this.lockService.unlock(lock);
            return flag;
        }
        this.lockService.unlock(lock);
        return flag;
    }

    public Boolean applyOrderDeliverStrategy(List<PerformOrderInfoDto> saleOrderRespDtoList, BillApplyEo billApplyEo, BillStrategyRespDto billStrategyRespDto, BillApplyGenerateReqDto billApplyGenerateReqDto, List<String> platformOrderNoList) {
        if (WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(billApplyEo.getWhetherMergeBill()) || null == billApplyEo.getWhetherMergeBill()) {
            for (PerformOrderInfoDto tempOrderDto : saleOrderRespDtoList) {
                this.saveSaleOrderBillRecordInfo(tempOrderDto, billApplyEo, billStrategyRespDto, billApplyGenerateReqDto);
                BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
                billInfoGenerateReqDto.setApplyFlag(Boolean.TRUE);
                billInfoGenerateReqDto.setOrderStatus(tempOrderDto.getOrderStatus());
                billInfoGenerateReqDto.setSaleOrderNo(tempOrderDto.getSaleOrderNo());
                billInfoGenerateReqDto.setApplyNo(billApplyEo.getApplyNo());
                billInfoGenerateReqDto.setOrderType(tempOrderDto.getOrderType());
                billInfoGenerateReqDto.setWhetherMergeBill(billApplyEo.getWhetherMergeBill());
                billInfoGenerateReqDto.setPlatformOrderNoList(platformOrderNoList);
                if (billApplyGenerateReqDto != null) {
                    billInfoGenerateReqDto.setBillPersonName(billApplyGenerateReqDto.getBillPersonName());
                    billInfoGenerateReqDto.setBillPersonPhone(billApplyGenerateReqDto.getBillPersonPhone());
                    billInfoGenerateReqDto.setBillAddress(billApplyGenerateReqDto.getBillAddress());
                }
                this.logger.info("handleBatchOrder==>\u5df2\u53d1\u8d27\u7b56\u7565,billInfoGenerateReqDto:{}", (Object)LogUtils.buildLogContent(billInfoGenerateReqDto));
                GenerateBillResultRespDto result = this.billInfoService.generateBillInfoReturnMsg(billInfoGenerateReqDto);
                if (result.getSuccess().booleanValue()) continue;
                throw new BizException(result.getErrorMessage());
            }
        } else {
            Boolean genFlag = Boolean.TRUE;
            for (PerformOrderInfoDto tempOrderDto : saleOrderRespDtoList) {
                String orderStatus = tempOrderDto.getOrderStatus();
                if (!this.orderTypeFilter(tempOrderDto.getOrderType()).booleanValue() || OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus) || OmsSaleOrderStatus.CANCEL.getCode().equals(orderStatus) || OmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus) || OmsSaleOrderStatus.OBSOLETE.getCode().equals(orderStatus)) continue;
                genFlag = Boolean.FALSE;
            }
            for (PerformOrderInfoDto tempOrderDto : saleOrderRespDtoList) {
                this.saveSaleOrderBillRecordInfo(tempOrderDto, billApplyEo, billStrategyRespDto, billApplyGenerateReqDto);
            }
            if (genFlag.booleanValue()) {
                BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
                billInfoGenerateReqDto.setApplyFlag(Boolean.TRUE);
                billInfoGenerateReqDto.setOrderStatus(saleOrderRespDtoList.get(0).getOrderStatus());
                billInfoGenerateReqDto.setSaleOrderNo(saleOrderRespDtoList.get(0).getSaleOrderNo());
                billInfoGenerateReqDto.setApplyNo(billApplyEo.getApplyNo());
                billInfoGenerateReqDto.setWhetherMergeBill(billApplyEo.getWhetherMergeBill());
                billInfoGenerateReqDto.setPlatformOrderNoList(platformOrderNoList);
                billInfoGenerateReqDto.setOrderType(saleOrderRespDtoList.get(0).getOrderType());
                if (null != billApplyGenerateReqDto) {
                    billInfoGenerateReqDto.setBillPersonName(billApplyGenerateReqDto.getBillPersonName());
                    billInfoGenerateReqDto.setBillPersonPhone(billApplyGenerateReqDto.getBillPersonPhone());
                    billInfoGenerateReqDto.setBillAddress(billApplyGenerateReqDto.getBillAddress());
                }
                this.logger.info("applyOrderDeliverStrategy==>\u5df2\u5b8c\u6210\u7b56\u7565,billInfoGenerateReqDto:{}", (Object)LogUtils.buildLogContent(billInfoGenerateReqDto));
                GenerateBillResultRespDto result = this.billInfoService.generateBillInfoReturnMsg(billInfoGenerateReqDto);
                if (!result.getSuccess().booleanValue()) {
                    throw new BizException(result.getErrorMessage());
                }
            } else {
                this.logger.info("\u5408\u5e76\u5f00\u7968\u8ba2\u5355\u53d1\u8d27\u8282\u70b9\u5f00\u7968-\u5e73\u53f0\u5355\u914d\u8d27\u8ba2\u5355\u672a\u5168\u90e8\u53d1\u8d27");
                throw new BizException("\u5408\u5e76\u5f00\u7968\u8ba2\u5355\u53d1\u8d27\u8282\u70b9\u5f00\u7968-\u5e73\u53f0\u5355\u914d\u8d27\u8ba2\u5355\u672a\u5168\u90e8\u53d1\u8d27");
            }
        }
        billApplyEo.setChangeType(BillApplyChangeTypeEnum.HANDLED.getCode());
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"apply_no", (Object)billApplyEo.getApplyNo());
        this.billApplyMapper.update((Object)billApplyEo, (Wrapper)updateWrapper);
        return true;
    }

    public Boolean applyOrderCompleteStrategy(List<PerformOrderInfoDto> saleOrderRespDtoList, BillApplyEo billApplyEo, BillStrategyRespDto billStrategyRespDto, BillApplyGenerateReqDto billApplyGenerateReqDto, List<String> platformOrderNoList) {
        Boolean genFlag = Boolean.TRUE;
        for (PerformOrderInfoDto tempOrderDto : saleOrderRespDtoList) {
            String orderStatus = tempOrderDto.getOrderStatus();
            if (!this.orderTypeFilter(tempOrderDto.getOrderType()).booleanValue() || OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus) || OmsSaleOrderStatus.OBSOLETE.getCode().equals(orderStatus) || OmsSaleOrderStatus.CANCEL.getCode().equals(orderStatus)) continue;
            genFlag = Boolean.FALSE;
        }
        for (PerformOrderInfoDto tempOrderDto : saleOrderRespDtoList) {
            this.saveSaleOrderBillRecordInfo(tempOrderDto, billApplyEo, billStrategyRespDto, billApplyGenerateReqDto);
        }
        if (genFlag.booleanValue()) {
            BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
            billInfoGenerateReqDto.setApplyFlag(Boolean.TRUE);
            List<String> orderStatusList = Arrays.asList(OmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_PICK.getCode(), OmsSaleOrderStatus.PICKED.getCode(), OmsSaleOrderStatus.WAIT_DELIVERY.getCode(), OmsSaleOrderStatus.WAIT_ASSIGN.getCode(), OmsSaleOrderStatus.CANCEL.getCode(), OmsSaleOrderStatus.OBSOLETE.getCode(), OmsSaleOrderStatus.LACK.getCode());
            List collect = saleOrderRespDtoList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOrderStatus()) && !orderStatusList.contains(x.getOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                List saleOrderNosList = saleOrderRespDtoList.stream().map(PerformOrderInfoDto::getSaleOrderNo).distinct().collect(Collectors.toList());
                log.error("\u9500\u552e\u8ba2\u5355\u4e0d\u662f\u5df2\u53d1\u8d27\u6216\u5df2\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u5f00\u7968\uff1a{}", saleOrderNosList);
                throw new BizException("\u9500\u552e\u8ba2\u5355\u4e0d\u662f\u5df2\u53d1\u8d27\u6216\u5df2\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u5f00\u7968 orderNo:" + JSONObject.toJSONString(saleOrderNosList));
            }
            billInfoGenerateReqDto.setOrderStatus(((PerformOrderInfoDto)collect.get(0)).getOrderStatus());
            billInfoGenerateReqDto.setSaleOrderNo(((PerformOrderInfoDto)collect.get(0)).getSaleOrderNo());
            billInfoGenerateReqDto.setApplyNo(billApplyEo.getApplyNo());
            billInfoGenerateReqDto.setWhetherMergeBill(billApplyEo.getWhetherMergeBill());
            billInfoGenerateReqDto.setPlatformOrderNoList(platformOrderNoList);
            billInfoGenerateReqDto.setOrderType(((PerformOrderInfoDto)collect.get(0)).getOrderType());
            if (null != billApplyGenerateReqDto) {
                billInfoGenerateReqDto.setBillPersonName(billApplyGenerateReqDto.getBillPersonName());
                billInfoGenerateReqDto.setBillPersonPhone(billApplyGenerateReqDto.getBillPersonPhone());
                billInfoGenerateReqDto.setBillAddress(billApplyGenerateReqDto.getBillAddress());
            }
            this.logger.info("handleBatchOrder==>\u5df2\u5b8c\u6210\u7b56\u7565,billInfoGenerateReqDto:{}", (Object)LogUtils.buildLogContent(billInfoGenerateReqDto));
            GenerateBillResultRespDto result = this.billInfoService.generateBillInfoReturnMsg(billInfoGenerateReqDto);
            if (!result.getSuccess().booleanValue()) {
                throw new BizException(result.getErrorMessage());
            }
        } else {
            this.logger.info("\u8ba2\u5355\u5b8c\u6210\u8282\u70b9\u5f00\u7968-\u5e73\u53f0\u5355\u914d\u8d27\u8ba2\u5355\u90fd\u672a\u5b8c\u6210");
            throw new BizException("\u8ba2\u5355\u5b8c\u6210\u8282\u70b9\u5f00\u7968-\u5e73\u53f0\u5355\u914d\u8d27\u8ba2\u5355\u90fd\u672a\u5b8c\u6210");
        }
        billApplyEo.setChangeType(BillApplyChangeTypeEnum.HANDLED.getCode());
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"apply_no", (Object)billApplyEo.getApplyNo());
        this.billApplyMapper.update((Object)billApplyEo, (Wrapper)updateWrapper);
        return true;
    }

    private void saveSaleOrderBillRecordInfo(PerformOrderInfoDto tempOrderDto, BillApplyEo billApplyEo, BillStrategyRespDto billStrategyRespDto, BillApplyGenerateReqDto billApplyGenerateReqDto) {
        BillEntityEo billEntity;
        SaleOrderBillRecordPageReqDto saleOrderBillRecordPageReqDto = new SaleOrderBillRecordPageReqDto();
        saleOrderBillRecordPageReqDto.setSaleOrderNo(tempOrderDto.getSaleOrderNo());
        List<SaleOrderBillRecordDto> saleOrderBillRecordDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordPageReqDto);
        this.logger.info("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u5f55:{}", (Object)JSON.toJSONString(saleOrderBillRecordDtoList));
        String whetherInvoice = SaleOrderInvoiceStateEnum.APPLIED.getCode();
        SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
        CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billApplyEo, (String[])new String[]{"id"});
        saleOrderBillRecordReqDto.setSaleOrderNo(tempOrderDto.getSaleOrderNo());
        saleOrderBillRecordReqDto.setSaleOrderId(Objects.nonNull(tempOrderDto.getId()) ? tempOrderDto.getId().toString() : null);
        if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getBillEntityCode()) && Objects.nonNull(billEntity = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billStrategyRespDto.getBillEntityCode())).one())) {
            saleOrderBillRecordReqDto.setEntityId(billEntity.getId());
            saleOrderBillRecordReqDto.setDistributorRegisteredAddress(billEntity.getRegisteredAddress());
            saleOrderBillRecordReqDto.setDistributorRegisteredPhone(billEntity.getRegisteredPhone());
            saleOrderBillRecordReqDto.setDistributorBank(billEntity.getBank());
            saleOrderBillRecordReqDto.setDistributorBankAccount(billEntity.getBankAccount());
            saleOrderBillRecordReqDto.setDistributorTaxesCode(billEntity.getTaxesCode());
            saleOrderBillRecordReqDto.setCollectPerson(billEntity.getCollectPerson());
            saleOrderBillRecordReqDto.setBillPerson(billEntity.getBillPerson());
            saleOrderBillRecordReqDto.setReviewPerson(billEntity.getReviewPerson());
        }
        saleOrderBillRecordReqDto.setBillChannel(billStrategyRespDto.getBillChannel());
        saleOrderBillRecordReqDto.setWhetherInvoice(whetherInvoice);
        saleOrderBillRecordReqDto.setInvoiceType(billApplyEo.getBillType());
        saleOrderBillRecordReqDto.setWhetherMergeBill(billApplyEo.getWhetherMergeBill());
        saleOrderBillRecordReqDto.setBillPersonPhone(billApplyGenerateReqDto.getBillPersonPhone());
        saleOrderBillRecordReqDto.setBillPersonName(billApplyGenerateReqDto.getBillPersonName());
        saleOrderBillRecordReqDto.setBillAddress(billApplyGenerateReqDto.getBillAddress());
        saleOrderBillRecordReqDto.setPhone(billApplyGenerateReqDto.getPhone());
        saleOrderBillRecordReqDto.setMailbox(billApplyGenerateReqDto.getMailbox());
        this.logger.info("saleOrderBillRecordReqDto:{}", (Object)JSON.toJSONString((Object)saleOrderBillRecordReqDto));
        if (CollectionUtils.isEmpty(saleOrderBillRecordDtoList)) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderBillRecordApiProxy.addSaleOrderBillRecord(saleOrderBillRecordReqDto));
        } else {
            saleOrderBillRecordDtoList.forEach(bill -> {
                saleOrderBillRecordReqDto.setId(bill.getId());
                RestResponseHelper.extractData((RestResponse)this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto));
            });
        }
    }

    private BillApplyEo saveBillApplyInfo(String documentNo, BillApplyGenerateReqDto billApplyGenerateReqDto, List<PerformOrderInfoDto> saleOrderRespDtoList, BillStrategyRespDto billStrategyRespDto, Object tfOrderRespDto) {
        PerformOrderInfoDto saleOrderRespDto = saleOrderRespDtoList.get(0);
        Set platformOrderNoList = saleOrderRespDtoList.stream().map(PerformOrderInfoDto::getSaleOrderNo).collect(Collectors.toSet());
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_APPLY.getCode());
        String applyNo = generateCodeService.getCode("BA");
        BillApplyEo billApplyEo = new BillApplyEo();
        billApplyEo.setBusinessOrderNo(String.join((CharSequence)",", platformOrderNoList));
        billApplyEo.setApplyNo(applyNo);
        billApplyEo.setPlatformOrderNo(documentNo);
        if (!BillApplyTypeEnum.APPLY_BILL.getCode().equals(billApplyGenerateReqDto.getBillApplyType())) {
            billApplyEo.setBusinessOrderNo(saleOrderRespDto.getSaleOrderNo());
        }
        billApplyEo.setSite(((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
        billApplyEo.setShopId(((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getShopId());
        billApplyEo.setShopCode(((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
        billApplyEo.setShopName(((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getShopName());
        billApplyEo.setPlatformOrderStatus(saleOrderRespDto.getCovertOrderStatus());
        billApplyEo.setApplyChannel(((PerformOrderSnapshotDto)saleOrderRespDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
        billApplyEo.setApplyType(billApplyGenerateReqDto.getBillApplyType());
        billApplyEo.setBillType(billApplyGenerateReqDto.getBillType());
        billApplyEo.setBillTitle(billApplyGenerateReqDto.getBillTitle());
        billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
        billApplyEo.setApplyTime(new Date());
        billApplyEo.setEnterprise(billApplyGenerateReqDto.getEnterprise());
        billApplyEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyGenerateReqDto.getTaxesCode()) ? billApplyGenerateReqDto.getTaxesCode().replace(" ", "") : null);
        billApplyEo.setRegisteredAddress(billApplyGenerateReqDto.getRegisteredAddress());
        billApplyEo.setRegisteredPhone(billApplyGenerateReqDto.getRegisteredPhone());
        billApplyEo.setBankAccount(billApplyGenerateReqDto.getBankAccount());
        billApplyEo.setBank(billApplyGenerateReqDto.getBank());
        billApplyEo.setTitleType(billApplyGenerateReqDto.getTitleType());
        billApplyEo.setMailbox(billApplyGenerateReqDto.getMailbox());
        billApplyEo.setPhone(billApplyGenerateReqDto.getPhone());
        billApplyEo.setStrategyCode(billStrategyRespDto.getStrategyCode());
        billApplyEo.setStrategyName(billStrategyRespDto.getStrategyName());
        billApplyEo.setWhetherMergeBill(billApplyGenerateReqDto.getWhetherMergeBill());
        billApplyEo.setIsUserSystem(billApplyGenerateReqDto.getIsUserSystem());
        billApplyEo.setBillAddress(billApplyGenerateReqDto.getBillAddress());
        billApplyEo.setBillPersonName(billApplyGenerateReqDto.getBillPersonName());
        billApplyEo.setBillPersonPhone(billApplyGenerateReqDto.getBillPersonPhone());
        billApplyEo.setConversionTime(new Date());
        billApplyEo.setFileUrl(billApplyGenerateReqDto.getFileUrl());
        billApplyEo.setRemark(billApplyGenerateReqDto.getRemark());
        if (this.isCountrySubsidies(saleOrderRespDto)) {
            billApplyEo.setSubsidiesType(SubsidiesTypeEnum.COUNTRY_SUBSIDIES.getCode());
        }
        this.billApplyMapper.insert((Object)billApplyEo);
        return billApplyEo;
    }

    private void checkParams(BillApplyGenerateReqDto billApplyGenerateReqDto) {
        String billApplyType;
        String taxesCode;
        String enterprise;
        List platformOrderNoList = billApplyGenerateReqDto.getPlatformOrderNoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)platformOrderNoList), "\u5e73\u53f0\u5355\u53f7\u96c6\u5408\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet platformOrderNoSet = new HashSet();
        HashSet repeatPlatformOrderNoSet = new HashSet();
        platformOrderNoList.forEach(orderNo -> {
            if (platformOrderNoSet.contains(orderNo)) {
                repeatPlatformOrderNoSet.add(orderNo);
            } else {
                platformOrderNoSet.add(orderNo);
            }
        });
        if (CollectionUtils.isNotEmpty(repeatPlatformOrderNoSet)) {
            String join = String.join((CharSequence)",", repeatPlatformOrderNoSet);
            throw new BizException("\u5e73\u53f0\u8ba2\u5355\u53f7\u91cd\u590d:" + join);
        }
        if (StringUtils.isNotBlank((CharSequence)billApplyGenerateReqDto.getPhone()) && !billApplyGenerateReqDto.getPhone().matches("1[3-9]\\d{9}")) {
            throw new BizException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
        }
        String billType = billApplyGenerateReqDto.getBillType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billType) && null != BillInfoTypeEnum.getEnumByCode((String)billType), "\u53d1\u7968\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String titleType = billApplyGenerateReqDto.getTitleType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)titleType) && null != BillTitleTypeEnum.getEnumByCode((String)titleType), "\u53d1\u7968\u62ac\u5934\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        if (BillTitleTypeEnum.PERSON.getCode().equals(titleType)) {
            String billTitle = billApplyGenerateReqDto.getBillTitle();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billTitle), "\u53d1\u7968\u62ac\u5934\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BillTitleTypeEnum.COMPANY.getCode().equals(titleType)) {
            enterprise = billApplyGenerateReqDto.getEnterprise();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)enterprise), "\u4f01\u4e1a\u540d\u79f0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            taxesCode = billApplyGenerateReqDto.getTaxesCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)taxesCode), "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billType) || BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billType) || BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billType)) {
            enterprise = billApplyGenerateReqDto.getEnterprise();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)enterprise), "\u4f01\u4e1a\u540d\u79f0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            taxesCode = billApplyGenerateReqDto.getTaxesCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)taxesCode), "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String registeredAddress = billApplyGenerateReqDto.getRegisteredAddress();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)registeredAddress), "\u6ce8\u518c\u5730\u5740\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String registeredPhone = billApplyGenerateReqDto.getRegisteredPhone();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)registeredPhone), "\u6ce8\u518c\u7535\u8bdd\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String bankAccount = billApplyGenerateReqDto.getBankAccount();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)bankAccount), "\u5f00\u6237\u8d26\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String bank = billApplyGenerateReqDto.getBank();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)bank), "\u5f00\u6237\u94f6\u884c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)(billApplyType = billApplyGenerateReqDto.getBillApplyType()))) {
            billApplyGenerateReqDto.setBillApplyType(BillApplyTypeEnum.APPLY_BILL.getCode());
        }
        if (null == billApplyGenerateReqDto.getWhetherMergeBill()) {
            billApplyGenerateReqDto.setWhetherMergeBill(WhetherMergeBillTypeEnum.NO_MERGE.getCode());
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billApplyType) && null != BillApplyTypeEnum.getByCode((String)billApplyType), "\u53d1\u7968\u7533\u8bf7\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
    }

    public Boolean orderTypeFilter(String orderType) {
        if (SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.CONSIGNMENT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.PROXY_SALE.getType().equals(orderType) || SaleOrderTypeEnum.GIFT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.SHIPMENT_CLAIM_ORDER.getType().equals(orderType)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void getExcludingPerformOrderInfoDtoList(List<PerformOrderInfoDto> performOrderInfoDtoList) {
        this.logger.info("getExcludingPerformOrderInfoDtoList:{}", (Object)JSONObject.toJSONString(performOrderInfoDtoList));
        List performOrderInfoDtos = performOrderInfoDtoList.stream().filter(x -> SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(x.getOrderType())).collect(Collectors.toList());
        this.logger.info("performOrderInfoDtos:{}", (Object)JSONObject.toJSONString(performOrderInfoDtos));
        if (CollectionUtils.isNotEmpty(performOrderInfoDtos)) {
            List collect = performOrderInfoDtos.stream().map(PerformOrderInfoDto::getSaleOrderNo).collect(Collectors.toList());
            List afterSaleOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().eq((Object)"relate_to_platform_order", (Object)0)).in((Object)"exchange_sale_order_no", collect)).list();
            Map afterSaleOrderEoMap = afterSaleOrderEos.stream().collect(Collectors.toMap(x -> x.getExchangeSaleOrderNo(), Function.identity(), (k1, k2) -> k1));
            this.logger.info("afterSaleOrderEoMap:{}", (Object)JSONObject.toJSONString(afterSaleOrderEoMap));
            Iterator<PerformOrderInfoDto> iterator = performOrderInfoDtoList.iterator();
            while (iterator.hasNext()) {
                PerformOrderInfoDto next = iterator.next();
                if (org.springframework.util.CollectionUtils.isEmpty(afterSaleOrderEoMap) || !afterSaleOrderEoMap.containsKey(next.getSaleOrderNo())) continue;
                AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)afterSaleOrderEoMap.get(next.getSaleOrderNo());
                if (Objects.equals(AfterSaleOrderStatusEnum.FINISH.getCode(), afterSaleOrderEo.getStatus()) || !SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(next.getOrderType())) continue;
                iterator.remove();
            }
        }
    }

    private static /* synthetic */ boolean lambda$transformBillApply$3(BillInfoEo bill) {
        return InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState());
    }
}

