/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.BillBusinessRelPlatformConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillBusinessRelPlatformDas;
import com.yunxi.dg.base.center.finance.domain.entity.IBillBusinessRelPlatformDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillBusinessRelPlatformDto;
import com.yunxi.dg.base.center.finance.dto.request.BillBusinessRelPlatformReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillBusinessRelPlatformRespDto;
import com.yunxi.dg.base.center.finance.eo.BillBusinessRelPlatformEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillBusinessRelPlatformService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillBusinessRelPlatformServiceImpl
extends BaseServiceImpl<BillBusinessRelPlatformDto, BillBusinessRelPlatformEo, IBillBusinessRelPlatformDomain>
implements IBillBusinessRelPlatformService {
    private final Logger logger = LoggerFactory.getLogger(BillBusinessRelPlatformServiceImpl.class);
    @Resource
    private IBillBusinessRelPlatformDas billBusinessRelPlatformDas;
    @Resource
    private IBillBusinessRelPlatformDomain billBusinessRelPlatformDomain;

    public BillBusinessRelPlatformServiceImpl(IBillBusinessRelPlatformDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillBusinessRelPlatformDto, BillBusinessRelPlatformEo> converter() {
        return BillBusinessRelPlatformConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBillBusinessRelPlatform(List<String> platformOrderNoList, String businessOrderNo, String businessType) {
        this.logger.info("\u7533\u8bf7\u5355\u6dfb\u52a0\u5e73\u53f0\u5173\u7cfb:{},{},{}", new Object[]{JSON.toJSONString(platformOrderNoList), businessOrderNo, businessType});
        ArrayList billBusinessRelPlatformEoList = new ArrayList();
        platformOrderNoList.forEach(platformOrderNo -> {
            BillBusinessRelPlatformEo billBusinessRelPlatformEo = new BillBusinessRelPlatformEo();
            billBusinessRelPlatformEo.setPlatformOrderNo(platformOrderNo);
            billBusinessRelPlatformEo.setBusinessOrderNo(businessOrderNo);
            billBusinessRelPlatformEo.setBusinessType(businessType);
            billBusinessRelPlatformEoList.add(billBusinessRelPlatformEo);
        });
        if (CollectionUtils.isNotEmpty(billBusinessRelPlatformEoList)) {
            this.billBusinessRelPlatformDas.insertBatch(billBusinessRelPlatformEoList);
        }
    }

    @Override
    public Long addBillBusinessRelPlatform(BillBusinessRelPlatformReqDto addReqDto) {
        BillBusinessRelPlatformEo billBusinessRelPlatformEo = new BillBusinessRelPlatformEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billBusinessRelPlatformEo);
        this.billBusinessRelPlatformDas.insert((BaseEo)billBusinessRelPlatformEo);
        return billBusinessRelPlatformEo.getId();
    }

    @Override
    public void modifyBillBusinessRelPlatform(BillBusinessRelPlatformReqDto modifyReqDto) {
        BillBusinessRelPlatformEo billBusinessRelPlatformEo = new BillBusinessRelPlatformEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billBusinessRelPlatformEo);
        this.billBusinessRelPlatformDas.updateSelective((BaseEo)billBusinessRelPlatformEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillBusinessRelPlatform(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.billBusinessRelPlatformDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BillBusinessRelPlatformRespDto queryById(Long id) {
        BillBusinessRelPlatformEo billBusinessRelPlatformEo = (BillBusinessRelPlatformEo)this.billBusinessRelPlatformDas.selectByPrimaryKey(id);
        BillBusinessRelPlatformRespDto billBusinessRelPlatformRespDto = new BillBusinessRelPlatformRespDto();
        DtoHelper.eo2Dto((BaseEo)billBusinessRelPlatformEo, (BaseVo)billBusinessRelPlatformRespDto);
        return billBusinessRelPlatformRespDto;
    }

    @Override
    public PageInfo<BillBusinessRelPlatformRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        BillBusinessRelPlatformReqDto billBusinessRelPlatformReqDto = (BillBusinessRelPlatformReqDto)JSON.parseObject((String)filter, BillBusinessRelPlatformReqDto.class);
        BillBusinessRelPlatformEo billBusinessRelPlatformEo = new BillBusinessRelPlatformEo();
        DtoHelper.dto2Eo((BaseVo)billBusinessRelPlatformReqDto, (BaseEo)billBusinessRelPlatformEo);
        PageInfo eoPageInfo = this.billBusinessRelPlatformDomain.selectPage((BaseEo)billBusinessRelPlatformEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillBusinessRelPlatformRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

