/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.BillRuleShopConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillRuleShopDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillRuleShopMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IBillRuleShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillRuleShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillRuleShopPageReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillRuleShopReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillRuleShopRespDto;
import com.yunxi.dg.base.center.finance.eo.BillRuleShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillRuleShopService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillRuleShopServiceImpl
extends BaseServiceImpl<BillRuleShopDto, BillRuleShopEo, IBillRuleShopDomain>
implements IBillRuleShopService {
    @Resource
    private IBillRuleShopDas billRuleShopDas;
    @Resource
    private BillRuleShopMapper billRuleShopMapper;

    public BillRuleShopServiceImpl(IBillRuleShopDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillRuleShopDto, BillRuleShopEo> converter() {
        return BillRuleShopConverter.INSTANCE;
    }

    @Override
    public Long addBillRuleShop(BillRuleShopReqDto addReqDto) {
        BillRuleShopEo billRuleShopEo = new BillRuleShopEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billRuleShopEo);
        this.billRuleShopDas.insert((BaseEo)billRuleShopEo);
        return billRuleShopEo.getId();
    }

    @Override
    public void modifyBillRuleShop(BillRuleShopReqDto modifyReqDto) {
        BillRuleShopEo billRuleShopEo = new BillRuleShopEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billRuleShopEo);
        this.billRuleShopDas.updateSelective((BaseEo)billRuleShopEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillRuleShop(List<Long> ids) {
        for (Long id : ids) {
            this.billRuleShopDas.logicDeleteById(id);
        }
    }

    @Override
    public BillRuleShopRespDto queryById(Long id) {
        BillRuleShopEo billRuleShopEo = (BillRuleShopEo)this.billRuleShopDas.selectByPrimaryKey(id);
        BillRuleShopRespDto billRuleShopRespDto = new BillRuleShopRespDto();
        DtoHelper.eo2Dto((BaseEo)billRuleShopEo, (BaseVo)billRuleShopRespDto);
        return billRuleShopRespDto;
    }

    @Override
    public PageInfo<BillRuleShopRespDto> queryByPage(BillRuleShopPageReqDto reqDto) {
        AssertUtil.isTrue(null != reqDto, "\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Integer pageNum = reqDto.getPageNum();
        Integer pageSize = reqDto.getPageSize();
        AssertUtil.isTrue(null != pageNum && pageNum > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != pageSize && pageSize > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        QueryWrapper queryWrapper = new QueryWrapper();
        Long billRuleId = reqDto.getBillRuleId();
        String shopCode = reqDto.getShopCode();
        String shopName = reqDto.getShopName();
        if (null != billRuleId) {
            queryWrapper.eq((Object)"bill_rule_id", (Object)billRuleId);
        }
        if (StringUtils.isNotBlank((CharSequence)shopCode)) {
            queryWrapper.like((Object)"shop_code", (Object)shopCode);
        }
        if (StringUtils.isNotBlank((CharSequence)shopName)) {
            queryWrapper.like((Object)"shop_name", (Object)shopName);
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByDesc((Object)"update_time");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List billRuleShopEos = this.billRuleShopMapper.selectList((Wrapper)queryWrapper);
        PageInfo eoPageInfo = new PageInfo(billRuleShopEos);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillRuleShopRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

