/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.GroupKeepAccountsConfigConverter;
import com.yunxi.dg.base.center.finance.domain.entity.IGroupKeepAccountsConfigDomain;
import com.yunxi.dg.base.center.finance.dto.entity.GroupKeepAccountsConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.GroupKeepAccountsConfigPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.GroupKeepAccountsShopDto;
import com.yunxi.dg.base.center.finance.dto.request.GroupKeepReplaceAllReqDto;
import com.yunxi.dg.base.center.finance.dto.response.GroupKeepAccountsReplaceRespDto;
import com.yunxi.dg.base.center.finance.dto.response.GroupKeepReplaceAllRespDto;
import com.yunxi.dg.base.center.finance.dto.response.GroupKeepValidateRespDto;
import com.yunxi.dg.base.center.finance.eo.GroupKeepAccountsConfigEo;
import com.yunxi.dg.base.center.finance.service.entity.IGroupKeepAccountsConfigService;
import com.yunxi.dg.base.center.finance.service.entity.IGroupKeepAccountsShopService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupKeepAccountsConfigServiceImpl
extends BaseServiceImpl<GroupKeepAccountsConfigDto, GroupKeepAccountsConfigEo, IGroupKeepAccountsConfigDomain>
implements IGroupKeepAccountsConfigService {
    private static final Logger log = LoggerFactory.getLogger(GroupKeepAccountsConfigServiceImpl.class);
    @Resource
    private IGroupKeepAccountsShopService groupKeepAccountsShopService;
    @Resource
    private ILockService lockService;

    public GroupKeepAccountsConfigServiceImpl(IGroupKeepAccountsConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<GroupKeepAccountsConfigDto, GroupKeepAccountsConfigEo> converter() {
        return GroupKeepAccountsConfigConverter.INSTANCE;
    }

    @Override
    public GroupKeepValidateRespDto validate(String shopCode, String provinceCode, String cityCode) {
        GroupKeepAccountsShopDto shop = this.groupKeepAccountsShopService.getByShopCode(shopCode);
        GroupKeepAccountsConfigDto config = (GroupKeepAccountsConfigDto)this.converter().toDto((BaseEo)((IGroupKeepAccountsConfigDomain)this.domain).queryByProvinceCodeAndCityCode(provinceCode, cityCode));
        if (config == null) {
            GroupKeepValidateRespDto result = new GroupKeepValidateRespDto();
            result.setValidateShop(Boolean.valueOf(shop != null));
            result.setValidateArea(Boolean.valueOf(false));
            result.setValidate(Boolean.valueOf(result.getValidateShop() != false && result.getValidateArea() != false));
            return result;
        }
        GroupKeepValidateRespDto result = GroupKeepAccountsConfigConverter.INSTANCE.toValidateDto(config);
        result.setValidateShop(Boolean.valueOf(shop != null));
        result.setValidateArea(Boolean.valueOf(true));
        result.setValidate(Boolean.valueOf(result.getValidateShop() != false && result.getValidateArea() != false));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Long> insert(GroupKeepAccountsConfigDto dto) {
        RestResponse restResponse;
        block4: {
            Mutex lock = null;
            try {
                lock = this.lockService.lock("GroupKeepAccountsConfig", dto.getProvinceCode() + "_" + dto.getCityCode());
                GroupKeepAccountsConfigEo dbConfig = ((IGroupKeepAccountsConfigDomain)this.domain).queryByProvinceCodeAndCityCode(dto.getProvinceCode(), dto.getCityCode());
                if (dbConfig != null) {
                    throw new BizException("\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e\u5df2\u5b58\u5728");
                }
                GroupKeepAccountsConfigEo eo = (GroupKeepAccountsConfigEo)this.converter().toEo((BaseDto)dto);
                ((IGroupKeepAccountsConfigDomain)this.domain).insert((BaseEo)eo);
                restResponse = new RestResponse((Object)eo.getId());
                if (lock == null) break block4;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    this.lockService.unlock(lock);
                }
                throw throwable;
            }
            this.lockService.unlock(lock);
        }
        return restResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Integer> update(GroupKeepAccountsConfigDto dto) {
        RestResponse restResponse;
        block4: {
            Mutex lock = null;
            try {
                lock = this.lockService.lock("GroupKeepAccountsConfig", dto.getProvinceCode() + "_" + dto.getCityCode());
                GroupKeepAccountsConfigEo dbConfig = ((IGroupKeepAccountsConfigDomain)this.domain).queryByProvinceCodeAndCityCode(dto.getProvinceCode(), dto.getCityCode());
                if (dbConfig != null && !dbConfig.getId().equals(dto.getId())) {
                    throw new BizException("\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e\u5df2\u5b58\u5728");
                }
                GroupKeepAccountsConfigEo eo = (GroupKeepAccountsConfigEo)this.converter().toEo((BaseDto)dto);
                ((IGroupKeepAccountsConfigDomain)this.domain).updateSelective((BaseEo)eo);
                restResponse = new RestResponse();
                if (lock == null) break block4;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    this.lockService.unlock(lock);
                }
                throw throwable;
            }
            this.lockService.unlock(lock);
        }
        return restResponse;
    }

    @Override
    public PageInfo<GroupKeepAccountsConfigDto> page(GroupKeepAccountsConfigPageReqDto dto) {
        return PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((IGroupKeepAccountsConfigDomain)this.domain).queryList(dto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GroupKeepReplaceAllRespDto replaceAll(GroupKeepReplaceAllReqDto dto) {
        List<GroupKeepAccountsReplaceRespDto> configs = GroupKeepAccountsConfigConverter.INSTANCE.toReplaceList(dto.getConfigs());
        boolean success = true;
        HashMap<String, List> map = new HashMap<String, List>();
        for (GroupKeepAccountsReplaceRespDto groupKeepAccountsReplaceRespDto : configs) {
            boolean validate = groupKeepAccountsReplaceRespDto.validate();
            success &= validate;
            String key = groupKeepAccountsReplaceRespDto.getProvinceCode() + "_" + groupKeepAccountsReplaceRespDto.getCityCode();
            List list = map.computeIfAbsent(key, k -> new ArrayList());
            list.add(groupKeepAccountsReplaceRespDto);
        }
        for (Map.Entry entry : map.entrySet()) {
            List vs = (List)entry.getValue();
            if (vs.size() <= 1) continue;
            success = false;
            vs.forEach(v -> v.getErrors().add("\u7701\u4efd+\u57ce\u5e02\u5fc5\u987b\u552f\u4e00"));
        }
        if (!success) {
            return new GroupKeepReplaceAllRespDto(Boolean.valueOf(false), configs);
        }
        log.info("\u66ff\u6362\u6240\u6709\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e: \u5f00\u59cb\u6e05\u7406\u5386\u53f2\u914d\u7f6e");
        ((IGroupKeepAccountsConfigDomain)this.domain).logicDeleteAll();
        log.info("\u66ff\u6362\u6240\u6709\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e: \u6e05\u7406\u5386\u53f2\u914d\u7f6e\u5b8c\u6210\uff0c\u5f00\u59cb\u63d2\u5165\u6570\u636e\uff0c\u5171 {} \u6761", (Object)configs.size());
        List eoList = configs.stream().map(config -> (GroupKeepAccountsConfigEo)this.converter().toEo((BaseDto)config)).collect(Collectors.toList());
        ((IGroupKeepAccountsConfigDomain)this.domain).insertBatch(eoList);
        return new GroupKeepReplaceAllRespDto(Boolean.valueOf(true), configs);
    }
}

