/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.collect.Maps;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.openapi.proxy.finance.IFinanceExternalApiProxy;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepOutResultDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.das.impl.HckAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.vo.HckSummaryKeepAccountVo;
import com.yunxi.dg.base.center.finance.dto.PushKeepAccountDetailVo;
import com.yunxi.dg.base.center.finance.dto.PushKeepAccountVo;
import com.yunxi.dg.base.center.finance.dto.PushOutsideSysAccountDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAccountsDetailDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BookKeepingType;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepResultEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushSapEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.ConnectorOrderReturnReqDto;
import com.yunxi.dg.base.center.finance.dto.request.ConnectorOtherOutboundReqDto;
import com.yunxi.dg.base.center.finance.dto.request.ConnectorSaleOrderReturnReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeDirectTransferAllotReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeOfflineConsignmentDeliveryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeOrderCompleteReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeOrderOutStockReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeOutboundReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeProxySaleDeliveryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeSupplierOrderOutStockReqDto;
import com.yunxi.dg.base.center.finance.dto.request.PushKeepAccountsReqDto;
import com.yunxi.dg.base.center.finance.dto.request.RuleParamReqDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepOutResultDetailEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IHckBookKeepService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepNodeCommonService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HckBookKeepServiceImpl
implements IHckBookKeepService {
    private static final Logger log = LoggerFactory.getLogger(HckBookKeepServiceImpl.class);
    @Resource
    private HckAccountsDetailDas hckAccountsDetailDas;
    @Resource
    private ILockService lockService;
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private IKeepNodeCommonService iKeepNodeCommonService;
    @Resource
    private IBookKeepAccountService bookKeepAccountService;
    @Resource
    private IKeepOutResultDetailDas outResultDetailDas;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IPushKeepAccountsService iPushKeepAccountsService;
    @Resource
    private IFinanceExternalApiProxy financeExternalApiProxy;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IShopService shopService;
    private static final String TABLENAME_DELIVERY = "keep_create_delivery";
    private static final String TABLENAME_BILL = "keep_create_invoice";
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;

    @Override
    public Map<String, PushOutsideSysAccountDto> groupBySummaryToErp(RuleParamReqDto paramReqDto) {
        long start = System.currentTimeMillis();
        log.info("\u6c47\u603b\u4ea4\u8d27\u5355\u7ef4\u5ea6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        Map<Object, Object> pushErpMap = Maps.newLinkedHashMap();
        log.info("\u5f53\u524d\u63a8\u9001\u7b2c\u4e09\u65b9\u8bf7\u6c42,\u65e5\u5fd7\u6570\u636e:{}", (Object)JSON.toJSONString((Object)paramReqDto));
        pushErpMap = this.groupBySaleOrderKeep(paramReqDto);
        log.info("\u5f53\u524d\u63a8\u9001\u7b2c\u4e09\u65b9\u8bf7\u6c42,\u8bf7\u6c42\u5355\u636e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)pushErpMap));
        return pushErpMap;
    }

    @Override
    public Map<String, Object> groupByBillingSummaryToErp(RuleParamReqDto paramReqDto) {
        List innerOrderNo = paramReqDto.getInnerOrderNos();
        long start = System.currentTimeMillis();
        String orderType = paramReqDto.getOrderType();
        String voucherType = paramReqDto.getVoucherType();
        List list = this.hckAccountsDetailDas.groupByKeepDetails(innerOrderNo, orderType, voucherType);
        log.info("\u6c47\u603b\u4ea4\u8d27\u5355\u7ef4\u5ea6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        Map<Object, Object> pushErpMap = Maps.newLinkedHashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            pushErpMap = this.groupByBillingSaleOrderKeep(list, paramReqDto);
        }
        return pushErpMap;
    }

    @Override
    public Map<String, PushOutsideSysAccountDto> groupBySaleOrderKeep(RuleParamReqDto paramReqDto) {
        KeepAccountsDetailDto keepAccountsDetailDto = new KeepAccountsDetailDto();
        keepAccountsDetailDto.setOrderType(paramReqDto.getOrderType());
        keepAccountsDetailDto.setVoucherType(paramReqDto.getVoucherType());
        keepAccountsDetailDto.setOrderNos(paramReqDto.getInnerOrderNos());
        List<KeepAccountsDetailEo> keepAccountsDetailEos = this.getKeepAccountDetail(keepAccountsDetailDto);
        List accountResult = keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getAccountingResult).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountResult) && accountResult.contains(AccountRuleEnum.ACCOUNT_FAIL.getCode())) {
            log.info("\u5185\u90e8\u4ea4\u6613\u8bb0\u8d26\u5931\u8d25\u62e6\u622a,\u4e0d\u63a8\u9001\u7b2c\u4e09\u65b9");
            return null;
        }
        Map<String, List<KeepAccountsDetailEo>> collected = keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode));
        List businessNos = keepAccountsDetailEos.stream().distinct().filter(e -> Objects.nonNull(e.getBusinessNo())).map(KeepAccountsDetailEo::getBusinessNo).collect(Collectors.toList());
        List detailEoList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(businessNos)) {
            detailEoList = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_no", businessNos)).list();
        }
        Map<Object, Object> outSideSaleOrderNoMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            outSideSaleOrderNoMap = detailEoList.stream().filter(e -> null != e.getOrderNo() && null != e.getSaleNo()).collect(Collectors.toMap(KeepAccountsDetailEo::getOrderNo, KeepAccountsDetailEo::getSaleNo, (k1, k2) -> k1));
        }
        LinkedHashMap pushErpMap = Maps.newLinkedHashMap();
        HashMap finalOutSideSaleOrderNoMap = outSideSaleOrderNoMap;
        if (CollectionUtil.isNotEmpty(collected)) {
            collected.forEach((k, v) -> {
                if (CollectionUtils.isNotEmpty((Collection)v)) {
                    KeepAccountsDetailEo accountsDetailEo = (KeepAccountsDetailEo)v.get(0);
                    PushKeepAccountsEo pushKeepAccountsEo = this.iKeepNodeCommonService.initKeepAccounts((List<KeepAccountsDetailEo>)v, paramReqDto.getVoucherType());
                    PushOutsideSysAccountDto hckKeepAccountVo = new PushOutsideSysAccountDto();
                    PushKeepAccountVo pushKeepAccountVo = new PushKeepAccountVo();
                    CubeBeanUtils.copyProperties((Object)pushKeepAccountVo, (Object)pushKeepAccountsEo, (String[])new String[0]);
                    ArrayList<PushKeepAccountDetailVo> keepAccountVos = new ArrayList<PushKeepAccountDetailVo>();
                    for (KeepAccountsDetailEo detailEo : v) {
                        String s;
                        PushKeepAccountDetailVo temp = new PushKeepAccountDetailVo();
                        CubeBeanUtils.copyProperties((Object)temp, (Object)detailEo, (String[])new String[0]);
                        if (StringUtils.isEmpty((CharSequence)temp.getSaleNo()) && StringUtils.isNotEmpty((CharSequence)(s = (String)finalOutSideSaleOrderNoMap.get(detailEo.getBusinessNo())))) {
                            temp.setSaleNo(s);
                        }
                        keepAccountVos.add(temp);
                    }
                    pushKeepAccountVo.setItemType(accountsDetailEo.getItemType());
                    hckKeepAccountVo.setPushKeepAccountVo(pushKeepAccountVo);
                    hckKeepAccountVo.setPushKeepAccountDetailVos(keepAccountVos);
                    pushErpMap.put(k, hckKeepAccountVo);
                }
            });
        }
        return pushErpMap;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public int savePushKeepAccounts(PushKeepAccountsEo pushKeepAccountsEo) {
        int pushKeepId = 0;
        PushKeepAccountsEo accountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)pushKeepAccountsEo.getChargeCode())).one();
        if (Objects.isNull(accountsEo)) {
            pushKeepId = this.pushKeepAccountsDas.insert((BaseEo)pushKeepAccountsEo);
        }
        return pushKeepId;
    }

    @Override
    public KingdeeOrderOutStockReqDto getConnectorSaleOrderOutStockReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        KingdeeOrderOutStockReqDto saleOrderOutStockReqDto = new KingdeeOrderOutStockReqDto();
        KingdeeOrderOutStockReqDto.SaleOrder saleOrder = new KingdeeOrderOutStockReqDto.SaleOrder();
        saleOrder.setBillTypeNumber("XSDD14_SYS");
        saleOrder.setChannelOrderNo(keepAccountsDetailEos.get(0).getPlatformNo());
        saleOrder.setOrderNo(keepAccountsDetailEos.get(0).getOrderNo());
        saleOrder.setOrganizationCode(keepAccountsDetailEos.get(0).getShopOrganizationCode());
        saleOrder.setBuyerRemark(keepAccountsDetailEos.get(0).getBuyerRemark());
        saleOrder.setShopCode(keepAccountsDetailEos.get(0).getCustomerCode());
        saleOrder.setPlaceTime(keepAccountsDetailEos.get(0).getPlatformCreateTime());
        ArrayList saleOrderDetailList = Lists.newArrayList();
        keepAccountsDetailEos.forEach(detailEo -> {
            KingdeeOrderOutStockReqDto.SaleOrderDetail saleOrderDetail = new KingdeeOrderOutStockReqDto.SaleOrderDetail();
            saleOrderDetail.setSkuCode(detailEo.getItemCode());
            saleOrderDetail.setItemNum(new BigDecimal(detailEo.getItemNum()));
            saleOrderDetail.setItemPrice(detailEo.getItemPrice());
            saleOrderDetail.setIsFree(detailEo.getItemPrice().compareTo(BigDecimal.ZERO) == 0 ? Boolean.TRUE : Boolean.FALSE);
            saleOrderDetail.setRemark(detailEo.getBuyerRemark());
            saleOrderDetailList.add(saleOrderDetail);
        });
        saleOrder.setSaleOrderDetailList((List)saleOrderDetailList);
        saleOrderOutStockReqDto.setSaleOrder(saleOrder);
        KingdeeOrderOutStockReqDto.StorageOrder storageOrder = new KingdeeOrderOutStockReqDto.StorageOrder();
        storageOrder.setBillTypeNumber("XSCKD14_SYS");
        storageOrder.setCreateTime(keepAccountsDetailEos.get(0).getOutResultCreateTime());
        storageOrder.setStorageOrderId(keepAccountsDetailEos.get(0).getDocumentNo());
        storageOrder.setShippingNo(keepAccountsDetailEos.get(0).getShippingNo());
        ArrayList storageOrderDetailList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(outResultDetailEos)) {
            keepAccountsDetailEos.forEach(detailEo -> {
                KingdeeOrderOutStockReqDto.StorageOrderDetail storageOrderDetail = new KingdeeOrderOutStockReqDto.StorageOrderDetail();
                storageOrderDetail.setWarehouseOrgCode(((KeepAccountsDetailEo)keepAccountsDetailEos.get(0)).getOrganizationCode());
                storageOrderDetail.setCargoCode(detailEo.getItemCode());
                storageOrderDetail.setNum(new BigDecimal(detailEo.getItemNum()));
                storageOrderDetail.setWarehouseCode(((KeepAccountsDetailEo)keepAccountsDetailEos.get(0)).getWarehouseCode());
                storageOrderDetail.setIsFree(detailEo.getItemPrice().compareTo(BigDecimal.ZERO) == 0 ? Boolean.TRUE : Boolean.FALSE);
                storageOrderDetailList.add(storageOrderDetail);
            });
        } else {
            outResultDetailEos.forEach(detailEo -> {
                KingdeeOrderOutStockReqDto.StorageOrderDetail storageOrderDetail = new KingdeeOrderOutStockReqDto.StorageOrderDetail();
                storageOrderDetail.setWarehouseOrgCode(((KeepAccountsDetailEo)keepAccountsDetailEos.get(0)).getOrganizationCode());
                storageOrderDetail.setCargoCode(detailEo.getItemCode());
                storageOrderDetail.setNum(new BigDecimal(detailEo.getItemNum()));
                storageOrderDetail.setWarehouseCode(((KeepAccountsDetailEo)keepAccountsDetailEos.get(0)).getWarehouseCode());
                storageOrderDetail.setIsFree(detailEo.getItemPrice().compareTo(BigDecimal.ZERO) == 0 ? Boolean.TRUE : Boolean.FALSE);
                storageOrderDetailList.add(storageOrderDetail);
            });
        }
        storageOrder.setStorageOrderDetailList((List)storageOrderDetailList);
        saleOrderOutStockReqDto.setStorageOrder(storageOrder);
        return saleOrderOutStockReqDto;
    }

    @Override
    public KingdeeSupplierOrderOutStockReqDto getConnectorSupplierSaleOrderOutStockReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        KingdeeSupplierOrderOutStockReqDto supplierSaleOrderOutStockReqDto = new KingdeeSupplierOrderOutStockReqDto();
        KingdeeSupplierOrderOutStockReqDto.SaleOrder saleOrder = new KingdeeSupplierOrderOutStockReqDto.SaleOrder();
        saleOrder.setBillTypeNumber("XSDD14_SYS");
        saleOrder.setChannelOrderNo(keepAccountsDetailEos.get(0).getPlatformNo());
        saleOrder.setOrderNo(keepAccountsDetailEos.get(0).getOrderNo());
        saleOrder.setOrganizationCode(keepAccountsDetailEos.get(0).getShopOrganizationCode());
        saleOrder.setShopCode(keepAccountsDetailEos.get(0).getCustomerCode());
        saleOrder.setPlaceTime(keepAccountsDetailEos.get(0).getPlatformCreateTime());
        saleOrder.setBuyerRemark(keepAccountsDetailEos.get(0).getBuyerRemark());
        ArrayList saleOrderDetailList = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            KingdeeSupplierOrderOutStockReqDto.SaleOrderDetail saleOrderDetail = new KingdeeSupplierOrderOutStockReqDto.SaleOrderDetail();
            saleOrderDetail.setWarehouseOrgCode(v.getOrganizationCode());
            saleOrderDetail.setSkuCode(v.getItemCode());
            saleOrderDetail.setItemNum(new BigDecimal(v.getItemNum()));
            saleOrderDetail.setItemPrice(v.getItemPrice());
            saleOrderDetail.setRemark(v.getBuyerRemark());
            saleOrderDetailList.add(saleOrderDetail);
        });
        saleOrder.setSaleOrderDetailList((List)saleOrderDetailList);
        supplierSaleOrderOutStockReqDto.setSaleOrder(saleOrder);
        KingdeeSupplierOrderOutStockReqDto.StorageOrder storageOrder = new KingdeeSupplierOrderOutStockReqDto.StorageOrder();
        storageOrder.setBillTypeNumber("XSCKD14_SYS");
        storageOrder.setStorageOrderId(keepAccountsDetailEos.get(0).getDocumentNo());
        storageOrder.setCreateTime(keepAccountsDetailEos.get(0).getOutResultCreateTime());
        ArrayList storageOrderDetailList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(outResultDetailEos)) {
            keepAccountsDetailEos.forEach(v -> {
                KingdeeSupplierOrderOutStockReqDto.StorageOrderDetail storageOrderDetail = new KingdeeSupplierOrderOutStockReqDto.StorageOrderDetail();
                storageOrderDetail.setCargoCode(v.getItemCode());
                storageOrderDetail.setNum(new BigDecimal(v.getItemNum()));
                storageOrderDetail.setWarehouseCode(((KeepAccountsDetailEo)keepAccountsDetailEos.get(0)).getWarehouseCode());
                storageOrderDetailList.add(storageOrderDetail);
            });
        } else {
            outResultDetailEos.forEach(v -> {
                KingdeeSupplierOrderOutStockReqDto.StorageOrderDetail storageOrderDetail = new KingdeeSupplierOrderOutStockReqDto.StorageOrderDetail();
                storageOrderDetail.setCargoCode(v.getItemCode());
                storageOrderDetail.setNum(new BigDecimal(v.getItemNum()));
                storageOrderDetail.setWarehouseCode(((KeepAccountsDetailEo)keepAccountsDetailEos.get(0)).getWarehouseCode());
                storageOrderDetailList.add(storageOrderDetail);
            });
        }
        storageOrder.setStorageOrderDetailList((List)storageOrderDetailList);
        supplierSaleOrderOutStockReqDto.setStorageOrder(storageOrder);
        return supplierSaleOrderOutStockReqDto;
    }

    @Override
    public KingdeeOfflineConsignmentDeliveryReqDto getKingdeeOfflineConsignmentDeliveryReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        KingdeeOfflineConsignmentDeliveryReqDto consignmentDeliveryReqDto = new KingdeeOfflineConsignmentDeliveryReqDto();
        consignmentDeliveryReqDto.setDeliveryNo(keepAccountsDetailEos.get(0).getPlatformNo());
        consignmentDeliveryReqDto.setFDate(keepAccountsDetailEos.get(0).getOutResultCreateTime());
        consignmentDeliveryReqDto.setF_QWZE_CourierNumber(keepAccountsDetailEos.get(0).getShippingNo());
        consignmentDeliveryReqDto.setF_QWZE_BillNoPT(keepAccountsDetailEos.get(0).getDocumentNo());
        ArrayList deliveryItems = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            KingdeeOfflineConsignmentDeliveryReqDto.KingdeeOfflineConsignmentDeliveryDetailReqDto deliveryItem = new KingdeeOfflineConsignmentDeliveryReqDto.KingdeeOfflineConsignmentDeliveryDetailReqDto();
            deliveryItem.setFMaterialNumber(v.getItemCode());
            deliveryItem.setFQty(new BigDecimal(v.getItemNum()).setScale(2, RoundingMode.HALF_UP));
            deliveryItems.add(deliveryItem);
        });
        consignmentDeliveryReqDto.setFDeliveryNoticeEntry((List)deliveryItems);
        return consignmentDeliveryReqDto;
    }

    @Override
    public KingdeeProxySaleDeliveryReqDto getKingdeeProxySaleDeliveryReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        KingdeeProxySaleDeliveryReqDto proxySaleDeliveryReqDto = new KingdeeProxySaleDeliveryReqDto();
        proxySaleDeliveryReqDto.setDeliveryNoticeBillNo(keepAccountsDetailEos.get(0).getPlatformNo());
        proxySaleDeliveryReqDto.setFDate(keepAccountsDetailEos.get(0).getOutResultCreateTime());
        proxySaleDeliveryReqDto.setF_QWZE_CourierNumber(keepAccountsDetailEos.get(0).getShippingNo());
        proxySaleDeliveryReqDto.setF_QWZE_BillNoPT(keepAccountsDetailEos.get(0).getDocumentNo());
        ArrayList deliveryItems = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            KingdeeProxySaleDeliveryReqDto.KingdeeProxySaleDeliveryDetailReqDto deliveryItem = new KingdeeProxySaleDeliveryReqDto.KingdeeProxySaleDeliveryDetailReqDto();
            deliveryItem.setFMaterialNumber(v.getItemCode());
            deliveryItem.setFQty(new BigDecimal(v.getItemNum()).setScale(2, RoundingMode.HALF_UP));
            deliveryItem.setFStockNumber(v.getWarehouseCode());
            deliveryItem.setFEntryId(v.getPlatformOrderItemNo());
            deliveryItems.add(deliveryItem);
        });
        proxySaleDeliveryReqDto.setFDeliveryNoticeEntry((List)deliveryItems);
        return proxySaleDeliveryReqDto;
    }

    @Override
    public ConnectorOtherOutboundReqDto getConnectorOtherOutboundReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        ConnectorOtherOutboundReqDto otherOutboundReqDto = new ConnectorOtherOutboundReqDto();
        otherOutboundReqDto.setWarehouseCode(keepAccountsDetailEos.get(0).getWarehouseCode());
        otherOutboundReqDto.setShopCode(keepAccountsDetailEos.get(0).getCustomerCode());
        otherOutboundReqDto.setUpdateTime(keepAccountsDetailEos.get(0).getOutResultUpdateTime());
        otherOutboundReqDto.setRemark(keepAccountsDetailEos.get(0).getRemark());
        otherOutboundReqDto.setOrderNo(keepAccountsDetailEos.get(0).getDocumentNo());
        if (Objects.equals(SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType(), keepAccountsDetailEos.get(0).getSaleOrderType())) {
            String originOrderNo = Arrays.asList(keepAccountsDetailEos.get(0).getPlatformNo().split("-")).get(0);
            otherOutboundReqDto.setOrderSrcNo(originOrderNo);
        }
        otherOutboundReqDto.setOrgCode(keepAccountsDetailEos.get(0).getOrganizationCode());
        ArrayList otherOutboundDetailReqDtos = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            ConnectorOtherOutboundReqDto.OtherOutboundDetailReqDto orderDetail = new ConnectorOtherOutboundReqDto.OtherOutboundDetailReqDto();
            orderDetail.setCargoCode(v.getItemCode());
            orderDetail.setNum(new BigDecimal(v.getItemNum()));
            orderDetail.setRemark(v.getRemark());
            otherOutboundDetailReqDtos.add(orderDetail);
        });
        otherOutboundReqDto.setOtherOutboundDetailReqDtos((List)otherOutboundDetailReqDtos);
        return otherOutboundReqDto;
    }

    @Override
    public KingdeeOutboundReqDto getKingdeeOutboundReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        KingdeeOutboundReqDto otherOutboundReqDto = new KingdeeOutboundReqDto();
        otherOutboundReqDto.setFStockOrgNumber(keepAccountsDetailEos.get(0).getOrganizationCode());
        otherOutboundReqDto.setFPickOrgNumber(keepAccountsDetailEos.get(0).getShopOrganizationCode());
        otherOutboundReqDto.setFCustNumber(keepAccountsDetailEos.get(0).getCustomerCode());
        otherOutboundReqDto.setFCustNumber(keepAccountsDetailEos.get(0).getCustomerCode());
        otherOutboundReqDto.setFDate(DateUtil.getDateFormat((Date)keepAccountsDetailEos.get(0).getOutResultUpdateTime(), (String)"yyyy-MM-dd"));
        otherOutboundReqDto.setFNote(keepAccountsDetailEos.get(0).getRemark());
        otherOutboundReqDto.setF_QWZE_OtherSysBillNo(keepAccountsDetailEos.get(0).getDocumentNo());
        if (Objects.equals(SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType(), keepAccountsDetailEos.get(0).getSaleOrderType())) {
            String originOrderNo = Arrays.asList(keepAccountsDetailEos.get(0).getPlatformNo().split("-")).get(0);
            otherOutboundReqDto.setFBillNoOutStockApply(originOrderNo);
        }
        ArrayList otherOutboundDetailReqDtos = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            KingdeeOutboundReqDto.KingdeeOutboundDetailReqDto orderDetail = new KingdeeOutboundReqDto.KingdeeOutboundDetailReqDto();
            orderDetail.setFEntryId(v.getPlatformOrderItemNo());
            orderDetail.setFMaterialNumber(v.getItemCode());
            orderDetail.setFQty(new BigDecimal(v.getItemNum()));
            orderDetail.setFStockNumber(v.getWarehouseCode());
            orderDetail.setFEntryNote(v.getRemark());
            otherOutboundDetailReqDtos.add(orderDetail);
        });
        otherOutboundReqDto.setFEntity((List)otherOutboundDetailReqDtos);
        return otherOutboundReqDto;
    }

    @Override
    public ConnectorSaleOrderReturnReqDto getConnectorSaleOrderReturnReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        ConnectorSaleOrderReturnReqDto saleOrderReturnReqDto = new ConnectorSaleOrderReturnReqDto();
        saleOrderReturnReqDto.setReturnNo(Convert.toStr((Object)keepAccountsDetailEos.get(0).getOrderId()));
        saleOrderReturnReqDto.setPlatformNo(keepAccountsDetailEos.get(0).getPlatformNo());
        String returnWarehouseCode = keepAccountsDetailEos.get(0).getWarehouseCode();
        if (StringUtils.isBlank((CharSequence)returnWarehouseCode)) {
            returnWarehouseCode = "019";
        }
        saleOrderReturnReqDto.setWarehouseCode(keepAccountsDetailEos.get(0).getOutWarehouseCode());
        saleOrderReturnReqDto.setReturnWarehouseCode(returnWarehouseCode);
        saleOrderReturnReqDto.setReturnType(Objects.equals(BillTypeEnum.RETURN_BASE.getCode(), keepAccountsDetailEos.get(0).getOrderType()) ? "THLX01_SYS" : "THLX02_SYS");
        ArrayList saleOrderReturnLineDtos = new ArrayList();
        keepAccountsDetailEos.forEach(v -> {
            ConnectorSaleOrderReturnReqDto.ConnectorSaleOrderReturnLineDto saleOrderReturnLineDto = new ConnectorSaleOrderReturnReqDto.ConnectorSaleOrderReturnLineDto();
            saleOrderReturnLineDto.setCargoCode(v.getItemCode());
            saleOrderReturnLineDto.setNum(new BigDecimal(v.getItemNum()));
            saleOrderReturnLineDtos.add(saleOrderReturnLineDto);
        });
        saleOrderReturnReqDto.setSaleOrderReturnLineDtos(saleOrderReturnLineDtos);
        return saleOrderReturnReqDto;
    }

    @Override
    public ConnectorOrderReturnReqDto getConnectorOrderReturnReqDto(PushKeepAccountsEo pushKeepAccountsEo, List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        ConnectorOrderReturnReqDto connectorOrderReturnReqDto = new ConnectorOrderReturnReqDto();
        connectorOrderReturnReqDto.setRequestId(pushKeepAccountsEo.getId());
        connectorOrderReturnReqDto.setBillNoPT(keepAccountsDetailEos.get(0).getPlatformNo());
        connectorOrderReturnReqDto.setF_QWZE_BillNoOmsXSCK(keepAccountsDetailEos.get(0).getDocumentNo());
        ArrayList returnDetailReqDtos = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            ConnectorOrderReturnReqDto.ConnectorOrderReturnDetailReqDto detailReqDto = new ConnectorOrderReturnReqDto.ConnectorOrderReturnDetailReqDto();
            detailReqDto.setFMaterialNumber(v.getItemCode());
            detailReqDto.setFStockNumber(v.getOutWarehouseCode());
            detailReqDto.setFReturnStockNumber(v.getWarehouseCode());
            detailReqDto.setFQty(new BigDecimal(v.getItemNum()));
            detailReqDto.setFReturnTypeNumber(Objects.equals(BillTypeEnum.RETURN_BASE.getCode(), ((KeepAccountsDetailEo)keepAccountsDetailEos.get(0)).getOrderType()) ? "THLX01_SYS" : "THLX02_SYS");
            returnDetailReqDtos.add(detailReqDto);
        });
        connectorOrderReturnReqDto.setOrderReturnDetailReqDtos((List)returnDetailReqDtos);
        return connectorOrderReturnReqDto;
    }

    @Override
    public KingdeeDirectTransferAllotReqDto getKingdeeDirectTransferAllotReqDto(PushKeepAccountsEo pushKeepAccountsEo, List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos) {
        KingdeeDirectTransferAllotReqDto transferAllotReqDto = new KingdeeDirectTransferAllotReqDto();
        transferAllotReqDto.setFYXOutBillNo(pushKeepAccountsEo.getDocumentNo());
        transferAllotReqDto.setFDate(DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        transferAllotReqDto.setRequestId(Convert.toLong((Object)pushKeepAccountsEo.getYxId()));
        String originOrderNo = Arrays.asList(keepAccountsDetailEos.get(0).getPlatformNo().split("-")).get(0);
        transferAllotReqDto.setFStkTransferApplyBillNo(originOrderNo);
        ArrayList transferAllotDetailReqDtos = Lists.newArrayList();
        keepAccountsDetailEos.forEach(v -> {
            KingdeeDirectTransferAllotReqDto.KingdeeDirectTransferAllotDetailReqDto detailReqDto = new KingdeeDirectTransferAllotReqDto.KingdeeDirectTransferAllotDetailReqDto();
            detailReqDto.setSrcEntryId(v.getPlatformOrderItemNo());
            detailReqDto.setFQty(new BigDecimal(v.getItemNum()).setScale(2, RoundingMode.HALF_DOWN));
            detailReqDto.setFSrcStockNumber(v.getWarehouseCode());
            transferAllotDetailReqDtos.add(detailReqDto);
        });
        transferAllotReqDto.setTransferStorageOutLineDto((List)transferAllotDetailReqDtos);
        return transferAllotReqDto;
    }

    public List<KeepAccountsDetailEo> getKeepAccountDetail(KeepAccountsDetailDto keepAccountsDetailDto) {
        ExtQueryChainWrapper sqlFilters = this.keepAccountsDetailDas.filter();
        sqlFilters.eq((Object)"voucher_type", (Object)keepAccountsDetailDto.getVoucherType());
        if (Objects.nonNull(keepAccountsDetailDto.getWarehouseCode())) {
            sqlFilters.eq((Object)"warehouse_code", (Object)keepAccountsDetailDto.getWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)keepAccountsDetailDto.getOrderNo()) && !"null".equals(keepAccountsDetailDto.getOrderNo())) {
            sqlFilters.eq((Object)"order_no", (Object)keepAccountsDetailDto.getOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)keepAccountsDetailDto.getOrderNos())) {
            sqlFilters.in((Object)"order_no", (Collection)keepAccountsDetailDto.getOrderNos());
        }
        sqlFilters.eq((Object)"book_keeping", (Object)BookKeepingType.NOT_DEAL.getCode());
        sqlFilters.eq(StringUtils.isNotBlank((CharSequence)keepAccountsDetailDto.getBatchNo()), (Object)"batch_no", (Object)keepAccountsDetailDto.getBatchNo());
        sqlFilters.eq(StringUtils.isNotBlank((CharSequence)keepAccountsDetailDto.getOrderType()), (Object)"order_type", (Object)keepAccountsDetailDto.getOrderType());
        sqlFilters.eq(StringUtils.isNotBlank((CharSequence)keepAccountsDetailDto.getChargeCode()), (Object)"charge_code", (Object)keepAccountsDetailDto.getChargeCode());
        List keepAccountsDetailEos = sqlFilters.list();
        if (CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) {
            return keepAccountsDetailEos;
        }
        return new ArrayList<KeepAccountsDetailEo>();
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }

    public List<KeepOutResultDetailEo> getKeepOutResultDetailEo(String orderType, String chargeCode, String voucherType) {
        ExtQueryChainWrapper sqlFilters = this.outResultDetailDas.filter();
        sqlFilters.eq((Object)"order_type", (Object)orderType);
        sqlFilters.eq((Object)"charge_code", (Object)chargeCode);
        sqlFilters.eq((Object)"voucher_type", (Object)voucherType);
        sqlFilters.eq((Object)"book_keeping", (Object)BookKeepingType.NOT_DEAL.getCode());
        List keepOutResultDetailEos = sqlFilters.list();
        if (CollectionUtils.isNotEmpty((Collection)keepOutResultDetailEos)) {
            return keepOutResultDetailEos;
        }
        return new ArrayList<KeepOutResultDetailEo>();
    }

    public Map<String, Object> groupByBillingSaleOrderKeep(List<HckSummaryKeepAccountVo> list, RuleParamReqDto paramReqDto) {
        long start = System.currentTimeMillis();
        LinkedHashMap pushErpMap = Maps.newLinkedHashMap();
        list.forEach(i -> {
            LinkedList<PushKeepAccountsEo> keepAccountsEos = new LinkedList<PushKeepAccountsEo>();
            Mutex mutex = null;
            try {
                String chargeCode = i.getChargeCode();
                mutex = this.lockService.lock(TABLENAME_BILL, chargeCode, 10, 20, TimeUnit.SECONDS);
                if (null == mutex) {
                    throw new BizException("\u91cd\u65b0\u751f\u6210\u5f00\u7968\u8bb0\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                KeepAccountsDetailDto keepAccountsDetailDto = new KeepAccountsDetailDto();
                keepAccountsDetailDto.setOrderType(paramReqDto.getOrderType());
                keepAccountsDetailDto.setChargeCode(chargeCode);
                keepAccountsDetailDto.setVoucherType(paramReqDto.getVoucherType());
                List<KeepAccountsDetailEo> keepAccountsDetailEos = this.getKeepAccountDetail(keepAccountsDetailDto);
                if (CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
                    PushKeepAccountsEo pushKeepAccountsEo = this.getBillingPushKeepAccounts(chargeCode, keepAccountsDetailDto.getOrderType(), keepAccountsDetailEos, null, null);
                    keepAccountsEos.add(pushKeepAccountsEo);
                }
                if (CollectionUtils.isNotEmpty(keepAccountsEos)) {
                    this.bookKeepAccountService.savePushKeepAccounts(keepAccountsEos);
                }
                if (mutex == null) return;
            }
            catch (Exception e) {
                try {
                    log.error("\u91cd\u65b0\u751f\u6210\u5f00\u7968\u8bb0\u8d26\u5355\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                    throw new BizException(String.format("\u91cd\u65b0\u751f\u6210\u5f00\u7968\u8bb0\u8d26\u5355\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5:\u3010%s\u3011\uff0c\u3010%s\u3011", e.getMessage(), e));
                }
                catch (Throwable throwable) {
                    if (mutex == null) throw throwable;
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
            }
            this.lockService.unlock(mutex);
            return;
        });
        log.info("\u5206\u7ec4\u5904\u7406\u8bb0\u8d26\u6570\u636e\u751f\u6210\u8bb0\u8d26\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return pushErpMap;
    }

    @Override
    public KingdeeOrderCompleteReqDto getConnectorSaleOrderCompleteReqDto(List<KeepAccountsDetailEo> keepAccountsDetailEos) {
        KingdeeOrderCompleteReqDto completeReqDto = new KingdeeOrderCompleteReqDto();
        completeReqDto.setOmsOrderNo(keepAccountsDetailEos.get(0).getPlatformNo());
        if (null != keepAccountsDetailEos.get(0).getPlatformCompleteTime()) {
            completeReqDto.setOmsDate(keepAccountsDetailEos.get(0).getPlatformCompleteTime());
        }
        return completeReqDto;
    }

    private PushKeepAccountsEo getBillingPushKeepAccounts(String chargeCode, String orderType, List<KeepAccountsDetailEo> list, String generatePerson, Integer realTimeFlag) {
        PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
        pushKeepAccountsEo.setOrderType(orderType);
        pushKeepAccountsEo.setChargeCode(chargeCode);
        pushKeepAccountsEo.setGenerateTime(new Date());
        pushKeepAccountsEo.setVoucherType(VoucherTypeEnum.INVOICE.getCode());
        pushKeepAccountsEo.setCustomerId(list.get(0).getCustomerId());
        pushKeepAccountsEo.setCustomerCode(list.get(0).getCustomerCode());
        pushKeepAccountsEo.setCustomerName(list.get(0).getCustomerName());
        pushKeepAccountsEo.setSapCode(list.get(0).getSapCode());
        pushKeepAccountsEo.setWarehouseCode(list.get(0).getWarehouseCode());
        Integer itemNum = list.stream().map(KeepAccountsDetailEo::getItemNum).reduce(Integer::sum).get();
        pushKeepAccountsEo.setItemNum(itemNum);
        BigDecimal totalAmount = list.stream().filter(x -> null != x.getItemPrice()).map(KeepAccountsDetailEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
        pushKeepAccountsEo.setItemPrice(totalAmount);
        pushKeepAccountsEo.setKeepingResult(KeepResultEnum.PENDING.getCode());
        pushKeepAccountsEo.setYxId(Convert.toStr((Object)this.getId()));
        pushKeepAccountsEo.setOrderInterface(list.get(0).getOrderInterface());
        pushKeepAccountsEo.setBillingInterface(list.get(0).getBillingInterface());
        pushKeepAccountsEo.setConditionType(ConditionTypeEnum.SALE_CREATE_BILLING.getCode());
        pushKeepAccountsEo.setPushStatus(PushStatusEnum.NOT_PUSH.getCode());
        pushKeepAccountsEo.setPlaceTime(null != list.get(0).getPlaceTime() ? com.dtyunxi.util.DateUtil.format((Date)list.get(0).getPlaceTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
        pushKeepAccountsEo.setShopCode(list.get(0).getShopCode());
        pushKeepAccountsEo.setShopName(list.get(0).getShopName());
        pushKeepAccountsEo.setSiteCode(list.get(0).getSiteCode());
        pushKeepAccountsEo.setSiteName(list.get(0).getSiteName());
        pushKeepAccountsEo.setPlatformNo(list.get(0).getPlatformNo());
        pushKeepAccountsEo.setDeliveryTime(list.get(0).getDeliveryTime());
        pushKeepAccountsEo.setCompleteTime(list.get(0).getCompleteTime());
        pushKeepAccountsEo.setOrganizationCode(list.get(0).getOrganizationCode());
        pushKeepAccountsEo.setOrganizationName(list.get(0).getOrganizationName());
        pushKeepAccountsEo.setShopOrganizationCode(list.get(0).getShopOrganizationCode());
        pushKeepAccountsEo.setShopOrganizationName(list.get(0).getShopOrganizationName());
        pushKeepAccountsEo.setGeneratePerson(generatePerson);
        pushKeepAccountsEo.setRealTimeFlag(realTimeFlag);
        pushKeepAccountsEo.setErpOrderType(list.get(0).getErpOrderType());
        pushKeepAccountsEo.setDocumentId(list.get(0).getDocumentId());
        pushKeepAccountsEo.setDocumentNo(list.get(0).getDocumentNo());
        pushKeepAccountsEo.setOutResultCreateTime(list.get(0).getOutResultCreateTime());
        pushKeepAccountsEo.setOutResultUpdateTime(list.get(0).getOutResultUpdateTime());
        pushKeepAccountsEo.setShippingNo(list.get(0).getShippingNo());
        pushKeepAccountsEo.setChargeAccountName(list.get(0).getChargeAccountName());
        pushKeepAccountsEo.setBillAccountName(list.get(0).getBillAccountName());
        pushKeepAccountsEo.setDeliveryNote(list.get(0).getDeliveryNote());
        pushKeepAccountsEo.setSaleNo(list.get(0).getSaleNo());
        pushKeepAccountsEo.setSaleOrderType(list.get(0).getSaleOrderType());
        pushKeepAccountsEo.setPlatformCompleteTime(list.get(0).getPlatformCompleteTime());
        return pushKeepAccountsEo;
    }

    @Override
    public boolean setPushKeepAccountsReqDto(PushKeepAccountsReqDto pushKeepAccountsReqDto, RestResponse restResponse) {
        boolean flag = false;
        if ("0".equals(restResponse.getResultCode())) {
            Map<String, String> xsckResult = HckBookKeepServiceImpl.getXSCKNumber(restResponse);
            String xsckNumber = xsckResult.get("xsckNumber");
            String saleNo = xsckResult.get("saleNo");
            String message = xsckResult.get("message");
            pushKeepAccountsReqDto.setDeliveryNote(xsckNumber);
            pushKeepAccountsReqDto.setSaleNo(saleNo);
            pushKeepAccountsReqDto.setChargeDate(new Date());
            pushKeepAccountsReqDto.setPushStatus(PushStatusEnum.PUSH_SUCC.getCode());
            pushKeepAccountsReqDto.setKeepingResult(KeepResultEnum.SUCCESS.getCode());
            pushKeepAccountsReqDto.setDeliveryPushTime(new Date());
            flag = true;
        } else {
            pushKeepAccountsReqDto.setReason(restResponse.getResultMsg());
            pushKeepAccountsReqDto.setPushStatus(PushStatusEnum.PUSH_FAIL.getCode());
            pushKeepAccountsReqDto.setKeepingResult(KeepResultEnum.FAIL.getCode());
        }
        return flag;
    }

    private static Map<String, String> getXSCKNumber(RestResponse restResponse) {
        String xsckNumber = null;
        StringBuffer buffer = new StringBuffer();
        String message = null;
        List datas = com.dtyunxi.huieryun.core.util.JSON.parseList((String)restResponse.getData().toString(), JSONObject.class);
        if (CollectionUtils.isNotEmpty((Collection)datas)) {
            for (JSONObject data : datas) {
                String number = data.getString("Number");
                if (StrUtil.isNotBlank((CharSequence)number) && number.startsWith("XS")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u9500\u552e\u51fa\u5e93\u5355\u521b\u5efa\u6210\u529f";
                }
                if (StrUtil.isNotBlank((CharSequence)number) && !number.startsWith("XS")) {
                    buffer.append(number);
                    buffer.append(";");
                    message = "\u91d1\u8776\u9500\u552e\u8ba2\u5355\u521b\u5efa\u6210\u529f";
                }
                if (!StrUtil.isNotBlank((CharSequence)number) || !StrUtil.isBlank((CharSequence)xsckNumber)) continue;
                if (number.startsWith("QTCK")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u5176\u4ed6\u51fa\u5e93\u5355\u521b\u5efa\u6210\u529f";
                }
                if (number.startsWith("FBDC")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u5206\u6b65\u5f0f\u8c03\u51fa\u5355\u521b\u5efa\u6210\u529f";
                }
                if (!number.startsWith("ZJDB")) continue;
                xsckNumber = number;
                message = "\u91d1\u8776\u76f4\u63a5\u8c03\u62e8\u5355\u521b\u5efa\u6210\u529f";
            }
        }
        message = StrUtil.isNotBlank(message) ? message : "\u91d1\u8776\u7cfb\u7edf\u5355\u53f7\u83b7\u53d6\u5931\u8d25";
        HashMap<String, String> xsckResult = new HashMap<String, String>();
        xsckResult.put("xsckNumber", xsckNumber);
        xsckResult.put("saleNo", StringUtils.isNotBlank((CharSequence)buffer) ? buffer.deleteCharAt(buffer.toString().length() - 1).toString() : null);
        xsckResult.put("message", message);
        return xsckResult;
    }

    @Override
    public void rePushOpenapiNew(OrderRuleRespDto orderRuleRespDto, KeepNodeRuleParam context, String type, Map<String, PushOutsideSysAccountDto> pushErpMap) {
        if (CollUtil.isEmpty(pushErpMap)) {
            throw new BizException("\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u4e3a\u7a7a");
        }
        long start = System.currentTimeMillis();
        log.info("\u6c47\u603b\u4ea4\u8d27\u5355\u7ef4\u5ea6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        if (CollectionUtils.isNotEmpty(pushErpMap.values())) {
            ArrayList<PushOutsideSysAccountDto> hckKeepAccountVos = new ArrayList<PushOutsideSysAccountDto>(pushErpMap.values());
            if (null != orderRuleRespDto && Objects.equals(PushSapEnum.TRUE.getCode(), orderRuleRespDto.getDeliveryPushSap())) {
                if ("AJR".equals(this.keepSystem)) {
                    List chargeCodeList = hckKeepAccountVos.stream().flatMap(hckKeepAccountVo -> Stream.of(hckKeepAccountVo.getPushKeepAccountVo().getChargeCode())).collect(Collectors.toList());
                    log.info("\u5f53\u524d\u63a8\u9001\u7684\u5355\u636e\uff1a{}", (Object)JSON.toJSONString(chargeCodeList));
                    Map<String, ShopEo> shopMap = this.getShopMap(hckKeepAccountVos);
                    this.pushKeepAccountsService.updateAccountStatusByChargeCodes(new HashSet<String>(chargeCodeList), KeepResultEnum.PUSHING.getCode(), AccountRuleEnum.PUSHING.getCode());
                    for (PushOutsideSysAccountDto hckKeepAccountVo2 : hckKeepAccountVos) {
                        PushKeepAccountVo vo = hckKeepAccountVo2.getPushKeepAccountVo();
                        ShopEo shop = Objects.nonNull(shopMap.get(vo.getShopCode())) ? shopMap.get(vo.getShopCode()) : new ShopEo();
                        vo.setDepartCode(shop.getOrganizationCode());
                        MessageVo message = new MessageVo();
                        message.setData(JSON.toJSON((Object)hckKeepAccountVo2));
                        try {
                            this.iPushKeepAccountsService.pushErp(hckKeepAccountVo2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.info("\u63a8\u9001erp\u5931\u8d25===============>");
                        }
                    }
                }
                ArrayList<String> chargCodes = new ArrayList<String>(pushErpMap.keySet());
                this.iKeepNodeCommonService.sendPushKeepAccountMessage(chargCodes);
            }
        } else {
            log.info("\u5f53\u524d\u81ea\u52a8\u63a8\u9001\u914d\u7f6e\u4e3a\u4e0d\u81ea\u52a8\u63a8\u9001");
        }
    }

    private Map<String, ShopEo> getShopMap(List<PushOutsideSysAccountDto> hckKeepAccountVos) {
        List<ShopEo> shopEos;
        HashSet<String> shopCodeList = new HashSet<String>();
        for (PushOutsideSysAccountDto hckKeepAccountVo : hckKeepAccountVos) {
            PushKeepAccountVo vo = hckKeepAccountVo.getPushKeepAccountVo();
            if (!Objects.nonNull(vo) || !Objects.nonNull(vo.getShopCode())) continue;
            shopCodeList.add(vo.getShopCode());
        }
        Map<String, Object> shopEoMap = new HashMap<String, ShopEo>();
        if (CollectionUtil.isNotEmpty(shopCodeList) && CollectionUtil.isNotEmpty(shopEos = this.shopService.selectShopByCodes(new ArrayList<String>(shopCodeList)))) {
            shopEoMap = shopEos.stream().collect(Collectors.toMap(ShopEo::getCode, Function.identity(), (v1, v2) -> v2));
        }
        return shopEoMap;
    }
}

