/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.dto.request.DgEnterpriseInventoryOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.dto.response.DgEnterpriseInventoryOrgRelationOrgRespDto;
import com.dtyunxi.yundt.cube.center.customer.dto.response.DgEnterpriseInventoryOrgRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.dto.response.DgInventoryOrgRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.proxy.query.IDgInventoryOrgQueryApiProxy;
import com.dtyunxi.yundt.cube.center.price.dto.item.PriceItemSkuSectionRespDto;
import com.dtyunxi.yundt.cube.center.price.dto.request.SkuPurchasePriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.dto.request.SkuPurchasePriceSupplierQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.dto.response.SkuPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.proxy.query.IDgPricePurchaseQueryApiProxy;
import com.dtyunxi.yundt.cube.center.shop.dto.request.DgShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.dto.response.DgShopRespDto;
import com.dtyunxi.yundt.cube.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.dtyunxi.yundt.cube.center.user.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.proxy.IDgOrganizationApiProxy;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepExceptionDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPushKeepAccountsDomain;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.FinanceExceptionCode;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.IFianceInsiderTransactionService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepInternalOrderService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IFianceInsiderTransactionServiceImpl
implements IFianceInsiderTransactionService {
    private static final Logger log = LoggerFactory.getLogger(IFianceInsiderTransactionServiceImpl.class);
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    @Resource
    private IDgInventoryOrgQueryApiProxy dgInventoryOrgQueryApiProxy;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgPricePurchaseQueryApiProxy dgPricePurchaseQueryApiProxy;
    @Resource
    private IPushKeepAccountsDomain pushKeepAccountsDomain;
    @Resource
    private IPushKeepInternalOrderService pushKeepInternalOrderService;
    @Resource
    private IKeepExceptionDetailDomain keepExceptionDetailDomain;
    @Resource
    private IDgOrganizationApiProxy dgOrganizationApiProxy;
    @Resource
    private IOrderRuleService orderRuleService;
    @Resource
    private IKeepAccountsDetailDomain keepAccountsDetailDomain;

    @Override
    public DgShopRespDto querySaleCompanyCodeByShopCode(String shopCode, SaleOrderItemVo saleOrderItemVo) {
        log.info("\u83b7\u53d6\u9500\u552e\u516c\u53f8,\u5e97\u94fa\u7f16\u7801\u4e3a\uff1a" + shopCode);
        DgShopQueryReqDto dgShopQueryReqDto = new DgShopQueryReqDto();
        dgShopQueryReqDto.setPageSize(Integer.valueOf(1000));
        dgShopQueryReqDto.setStoreCode(shopCode);
        PageInfo dgShopRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgShopQueryApiProxy.queryPageShop(dgShopQueryReqDto));
        List list = dgShopRespDtoPageInfo.getList();
        if (CollUtil.isNotEmpty((Collection)list)) {
            DgShopRespDto dgShopRespDto = (DgShopRespDto)list.get(0);
            String saleCompanyCode = dgShopRespDto.getSaleCompanyCode();
            saleOrderItemVo.setSaleCompanyCode(saleCompanyCode);
            String saleCompanyName = dgShopRespDto.getSaleCompanyName();
            saleOrderItemVo.setSaleCompanyName(saleCompanyName);
            saleOrderItemVo.setCustomerCodeBelongShop(dgShopRespDto.getCustomerCode());
            saleOrderItemVo.setCustomerNameBelongShop(dgShopRespDto.getCustomerName());
            Long aLong = this.extractedGetId(saleOrderItemVo);
            saleOrderItemVo.setSaleCompanyId(aLong);
            dgShopRespDto.setSaleCompanyId(aLong);
            return dgShopRespDto;
        }
        return null;
    }

    private Long extractedGetId(SaleOrderItemVo saleOrderItemVo) {
        DgEnterpriseInventoryOrgRelationQueryReqDto dgEnterpriseInventoryOrgRelationQueryReqDto = new DgEnterpriseInventoryOrgRelationQueryReqDto();
        ArrayList<String> saleCompanyCodeList = new ArrayList<String>();
        String saleCompanyCode = saleOrderItemVo.getSaleCompanyCode();
        saleCompanyCodeList.add(saleCompanyCode);
        dgEnterpriseInventoryOrgRelationQueryReqDto.setEnterpriseCodeList(saleCompanyCodeList);
        List dgInventoryOrgRelationRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventoryOrgQueryApiProxy.queryList(dgEnterpriseInventoryOrgRelationQueryReqDto));
        if (CollUtil.isNotEmpty((Collection)dgInventoryOrgRelationRespDtos)) {
            DgInventoryOrgRelationRespDto dgInventoryOrgRelationRespDto = (DgInventoryOrgRelationRespDto)dgInventoryOrgRelationRespDtos.get(0);
            Long enterpriseId = dgInventoryOrgRelationRespDto.getEnterpriseId();
            return enterpriseId;
        }
        return null;
    }

    @Override
    public boolean whetherInternalOrganization(SaleOrderItemVo saleOrderItemVo) {
        log.info("\u5224\u65ad\u662f\u5426\u662f\u5185\u90e8\u7ec4\u7ec7: \u9500\u552e\u8ba2\u5355\u660e\u7ec6\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)saleOrderItemVo));
        if (null == saleOrderItemVo.getSaleCompanyCode()) {
            saleOrderItemVo.setCrossOrganizationalTransaction("yes");
            return false;
        }
        if (null == saleOrderItemVo.getOrganizationCode()) {
            saleOrderItemVo.setCrossOrganizationalTransaction("yes");
            return false;
        }
        if (null == saleOrderItemVo.getSaleCompanyId()) {
            saleOrderItemVo.setCrossOrganizationalTransaction("yes");
            return false;
        }
        RestResponse response = this.dgInventoryOrgQueryApiProxy.queryEnterpriseInventoryOrgRelationByEnterpriseId(saleOrderItemVo.getSaleCompanyId());
        DgEnterpriseInventoryOrgRelationRespDto data = (DgEnterpriseInventoryOrgRelationRespDto)response.getData();
        List orgList = null;
        if (null != data && CollUtil.isNotEmpty((Collection)(orgList = data.getOrgList()))) {
            log.info("\u5f53\u524d\u9500\u552e\u516c\u53f8\u7684\u8d27\u6743\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString((Object)orgList));
            List orgCode = orgList.stream().map(DgEnterpriseInventoryOrgRelationOrgRespDto::getOrgName).distinct().collect(Collectors.toList());
            if (orgCode.contains(saleOrderItemVo.getOrganizationCode())) {
                saleOrderItemVo.setCrossOrganizationalTransaction("no");
                return false;
            }
            saleOrderItemVo.setCrossOrganizationalTransaction("yes");
            return true;
        }
        saleOrderItemVo.setCrossOrganizationalTransaction("yes");
        return true;
    }

    @Override
    public boolean insertInnerOrder(List<KeepAccountsDetailEo> detailEoList, KeepNodeRuleParam context) {
        OrderRuleRespDto orderRuleRespDto = context.getOrderRuleRespDto();
        String insiderTransactionAction = orderRuleRespDto.getInsiderTransactionAction();
        StringBuilder builder = new StringBuilder();
        builder.append("\u5f53\u524d\u5355\u636e\u7f16\u7801:").append(context.getOrderNo()).append(",\u7cfb\u7edf\u914d\u7f6e\u662f\u5426\u5f00\u542f\u5185\u90e8\u4ea4\u6613:").append(orderRuleRespDto.getInsiderTransactionAction()).append(",\u662f\u5426\u8de8\u7ec4\u7ec7").append(insiderTransactionAction);
        log.info(builder.toString());
        if (orderRuleRespDto.getInsiderTransactionAction().equals("no")) {
            return true;
        }
        boolean action = false;
        if (!detailEoList.get(0).getOrderType().equals(BillTypeEnum.SALE_LIST.getCode())) {
            action = this.getPurchasePriceFromOrderFirst(detailEoList);
        }
        if (!action) {
            action = this.purchasePriceJudgment(detailEoList, context);
        }
        if (!action) {
            context.setReason("\u5b58\u5728\u90e8\u5206\u5546\u54c1\u91c7\u8d2d\u4ef7\u4e3a\u7a7a,\u751f\u6210\u5185\u90e8\u5355\u636e\u5931\u8d25");
            return false;
        }
        try {
            this.innerOrderAccountingAction(insiderTransactionAction, detailEoList);
            log.info("\u5185\u90e8\u4ea4\u6613\u5355\u636e\u521b\u5efa\u5b8c\u6210");
            if (ObjectUtils.isNotEmpty((Object)orderRuleRespDto) && ObjectUtils.isNotEmpty((Object)orderRuleRespDto.getIsSendMQ()) && !orderRuleRespDto.getIsSendMQ().booleanValue()) {
                log.info("\u4e0d\u53d1\u9001MQ");
            } else {
                try {
                    Map<String, List<KeepAccountsDetailEo>> collect = detailEoList.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode));
                    this.pushOutSideSystem(collect);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u8bb0\u8d26\u5355\u53f7MQ\u6d88\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.info("\u751f\u6210\u5185\u90e8\u4ea4\u6613\u5f02\u5e38", (Throwable)e);
            context.setReason("\u751f\u6210\u5185\u90e8\u4ea4\u6613\u5f02\u5e38");
            KeepExceptionDetailEo keepExceptionDetailEo = new KeepExceptionDetailEo();
            keepExceptionDetailEo.setOrderNo(context.getOrderNo());
            keepExceptionDetailEo.setConditionType("8");
            keepExceptionDetailEo.setExtension(e.toString());
            keepExceptionDetailEo.setExceptionCode(FinanceExceptionCode.INSERT_INNER_ORDER.getCode());
            keepExceptionDetailEo.setExceptionName(FinanceExceptionCode.INSERT_INNER_ORDER.getMsg());
            this.keepExceptionDetailDomain.insert((BaseEo)keepExceptionDetailEo);
            return false;
        }
        return true;
    }

    public void pushOutSideSystem(Map<String, List<KeepAccountsDetailEo>> keepAccountMap) {
        log.info("\u53d1\u9001\u8bb0\u8d26\u5355\u53f7MQ\u6d88\u606f:{}", (Object)JSON.toJSONString(keepAccountMap));
        OrderRuleRespDto orderRuleRespDto = this.orderRuleService.selectOrderRule();
        keepAccountMap.forEach((k, v) -> {
            KeepAccountsDetailEo detailEo = (KeepAccountsDetailEo)v.get(0);
            if (detailEo.getVoucherType().equals(VoucherTypeEnum.DELIVERY.getCode()) && StringUtils.isNotBlank((CharSequence)orderRuleRespDto.getDeliveryPushSap()) && orderRuleRespDto.getDeliveryPushSap().equals("true")) {
                MessageVo message = new MessageVo();
                message.setCenterType("\u8d22\u52a1\u4e2d\u5fc3");
                message.setSingleOr("\u5355\u53d1");
                message.setData((Object)JSON.toJSONString((Object)Lists.newArrayList((Object[])new String[]{k})));
                log.info("\u53d1\u9001\u4ea4\u8d27\u8bb0\u8d26MQ\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
                MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("PUSH_KEEP_INNER_ORDER_ACCOUNT", (Object)message);
                log.info("\u53d1\u9001\u4ea4\u8d27\u8bb0\u8d26MQ\u6d88\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)messageResponse));
            } else if (detailEo.getVoucherType().equals(VoucherTypeEnum.INVOICE.getCode()) && StringUtils.isNotBlank((CharSequence)orderRuleRespDto.getInvoicePushSap()) && orderRuleRespDto.getInvoicePushSap().equals("true")) {
                MessageVo message = new MessageVo();
                message.setCenterType("\u8d22\u52a1\u4e2d\u5fc3");
                message.setSingleOr("\u5355\u53d1");
                message.setData((Object)JSON.toJSONString((Object)Lists.newArrayList((Object[])new String[]{k})));
                log.info("\u53d1\u9001\u5f00\u7968\u8bb0\u8d26MQ\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
                MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("PUSH_KEEP_INNER_ORDER_ACCOUNT", (Object)message);
                log.info("\u53d1\u9001\u5f00\u7968\u8bb0\u8d26MQ\u6d88\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)messageResponse));
            } else {
                log.info("\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6\uff1a{}\uff0c{}", k, (Object)detailEo.getVoucherType());
            }
        });
    }

    public void innerOrderAccountingAction(String insiderTransactionAction, List<KeepAccountsDetailEo> detailEoList) {
        log.info("\u5185\u90e8\u4ea4\u6613\u5355\u521b\u5efainnerOrderAccountingAction\uff1a{}", (Object)JSON.toJSONString(detailEoList));
        Map<String, List<KeepAccountsDetailEo>> collect = detailEoList.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode));
        log.info("\u4ea4\u8d27\u8bb0\u8d26\uff0c\u662f\u5426\u8de8\u7ec4\u7ec7:" + insiderTransactionAction);
        collect.forEach((k, v) -> {
            PushKeepInternalOrderReqDto pushKeepInternalOrderReqDto = this.getPushKeepInternalOrderReqDto(insiderTransactionAction, (List<KeepAccountsDetailEo>)v);
            ArrayList<PushKeepInternalOrderDetailReqDto> pushKeepInternalOrderDetailReqDtos = new ArrayList<PushKeepInternalOrderDetailReqDto>();
            for (KeepAccountsDetailEo accountsDetailEo : v) {
                PushKeepInternalOrderDetailReqDto pushKeepInternalOrderDetailReqDto = new PushKeepInternalOrderDetailReqDto();
                pushKeepInternalOrderDetailReqDto.setSkuCode(accountsDetailEo.getItemCode());
                pushKeepInternalOrderDetailReqDto.setSkuName(accountsDetailEo.getItemName());
                pushKeepInternalOrderDetailReqDto.setSkuId(accountsDetailEo.getItemId());
                pushKeepInternalOrderDetailReqDto.setItemUnit(accountsDetailEo.getItemUnit());
                pushKeepInternalOrderDetailReqDto.setTotalAmount(accountsDetailEo.getItemPrice());
                pushKeepInternalOrderDetailReqDto.setItemNum(new BigDecimal(accountsDetailEo.getItemNum()));
                pushKeepInternalOrderDetailReqDto.setExtension(accountsDetailEo.getExtension());
                Map extFields = accountsDetailEo.getExtFields();
                BigDecimal bigDecimal = (BigDecimal)extFields.get(accountsDetailEo.getItemCode());
                Optional.ofNullable(bigDecimal).orElse(BigDecimal.ZERO);
                pushKeepInternalOrderDetailReqDto.setItemPrice(accountsDetailEo.getItemPrice().divide(new BigDecimal(accountsDetailEo.getItemNum()), 2, 4));
                pushKeepInternalOrderDetailReqDto.setItemPurchasePrice(bigDecimal);
                pushKeepInternalOrderDetailReqDto.setItemPurchaseTotalAmount(bigDecimal.multiply(new BigDecimal(accountsDetailEo.getItemNum())));
                pushKeepInternalOrderDetailReqDtos.add(pushKeepInternalOrderDetailReqDto);
                if (!accountsDetailEo.getOrderType().equals(BillTypeEnum.SALE_LIST.getCode())) continue;
                JSONObject extensionJson = JSONObject.parseObject((String)accountsDetailEo.getExtension());
                extensionJson.put("itemPurchasePrice", (Object)bigDecimal);
                accountsDetailEo.setExtension(JSONObject.toJSONString((Object)extensionJson));
            }
            BigDecimal reduce = pushKeepInternalOrderDetailReqDtos.stream().map(PushKeepInternalOrderDetailReqDto::getItemPurchaseTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            pushKeepInternalOrderReqDto.setPurchasePrice(reduce);
            pushKeepInternalOrderReqDto.setDtos(pushKeepInternalOrderDetailReqDtos);
            this.pushKeepInternalOrderService.insert(pushKeepInternalOrderReqDto);
        });
    }

    @NotNull
    private PushKeepInternalOrderReqDto getPushKeepInternalOrderReqDto(String insiderTransactionAction, List<KeepAccountsDetailEo> v) {
        BigDecimal itemNum = v.stream().map(e -> new BigDecimal(e.getItemNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal itemPrice = v.stream().map(KeepAccountsDetailEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        KeepAccountsDetailEo keepAccountsDetailEo = v.get(0);
        PushKeepInternalOrderReqDto pushKeepInternalOrderReqDto = new PushKeepInternalOrderReqDto();
        CubeBeanUtils.copyProperties((Object)pushKeepInternalOrderReqDto, (Object)keepAccountsDetailEo, (String[])new String[0]);
        pushKeepInternalOrderReqDto.setId(null);
        pushKeepInternalOrderReqDto.setItemNum(itemNum);
        pushKeepInternalOrderReqDto.setChargeAmount(itemPrice);
        pushKeepInternalOrderReqDto.setTotalAmount(itemPrice);
        pushKeepInternalOrderReqDto.setPurchasePrice(new BigDecimal(0));
        pushKeepInternalOrderReqDto.setSalesOrderNo(keepAccountsDetailEo.getPlatformOrderNo());
        pushKeepInternalOrderReqDto.setBusinessNo(keepAccountsDetailEo.getOrderNo());
        pushKeepInternalOrderReqDto.setChannelCode(keepAccountsDetailEo.getSiteCode());
        pushKeepInternalOrderReqDto.setChannelName(keepAccountsDetailEo.getSiteName());
        pushKeepInternalOrderReqDto.setChargeResult(AccountRuleEnum.ACCOUNTING.getCode());
        pushKeepInternalOrderReqDto.setDeliveryDate(keepAccountsDetailEo.getDeliveryTime());
        pushKeepInternalOrderReqDto.setStepOrgTrade(Integer.valueOf(insiderTransactionAction.equals("yes") ? 1 : 0));
        pushKeepInternalOrderReqDto.setOrgCode(keepAccountsDetailEo.getSaleCompanyCode());
        pushKeepInternalOrderReqDto.setOrgName(keepAccountsDetailEo.getSaleCompanyName());
        pushKeepInternalOrderReqDto.setGenerateTime(keepAccountsDetailEo.getChargeDate());
        pushKeepInternalOrderReqDto.setCompleteDate(keepAccountsDetailEo.getCompleteTime());
        pushKeepInternalOrderReqDto.setCustomerCode(keepAccountsDetailEo.getCustomerCodeBelongShop());
        pushKeepInternalOrderReqDto.setCustomerName(keepAccountsDetailEo.getCustomerNameBelongShop());
        pushKeepInternalOrderReqDto.setChargeNo(keepAccountsDetailEo.getChargeCode());
        String saleCompanyCode = keepAccountsDetailEo.getSaleCompanyCode();
        String saleCompanyName = keepAccountsDetailEo.getSaleCompanyName();
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgOrganizationApiProxy.queryOrgListByCode(Collections.singletonList(keepAccountsDetailEo.getOrganizationCode())));
        if (CollUtil.isNotEmpty((Collection)organizationDtos)) {
            List ids = organizationDtos.stream().map(OrganizationDto::getId).collect(Collectors.toList());
            DgEnterpriseInventoryOrgRelationQueryReqDto queryParam = new DgEnterpriseInventoryOrgRelationQueryReqDto();
            queryParam.setInventoryOrgIdList(ids);
            List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventoryOrgQueryApiProxy.queryList(queryParam));
            log.info("\u67e5\u8be2\u8d27\u6743\u7ec4\u7ec7\uff1a{}\u5bf9\u5e94\u7684\u9500\u552e\u516c\u53f8\u4fe1\u606f\u4e3a\uff1a{}", (Object)keepAccountsDetailEo.getOrganizationCode(), (Object)JSONObject.toJSONString((Object)respDtos));
            if (CollUtil.isNotEmpty((Collection)respDtos)) {
                saleCompanyCode = ((DgInventoryOrgRelationRespDto)respDtos.get(0)).getEnterpriseCode();
                saleCompanyName = ((DgInventoryOrgRelationRespDto)respDtos.get(0)).getEnterpriseName();
            }
        }
        if (keepAccountsDetailEo.getOrderType().equals(BillTypeEnum.SALE_LIST.getCode())) {
            pushKeepInternalOrderReqDto.setOrderPath(Integer.valueOf(0));
            pushKeepInternalOrderReqDto.setCargoOrgCode(saleCompanyCode);
            pushKeepInternalOrderReqDto.setCargoOrgName(saleCompanyName);
        } else {
            pushKeepInternalOrderReqDto.setOrderPath(Integer.valueOf(1));
            pushKeepInternalOrderReqDto.setReturnCargoOrgName(saleCompanyName);
            pushKeepInternalOrderReqDto.setReturnCargoOrgCode(saleCompanyCode);
        }
        return pushKeepInternalOrderReqDto;
    }

    private boolean getPurchasePriceFromOrderFirst(List<KeepAccountsDetailEo> detailEoList) {
        KeepAccountsDetailEo keepAccountsDetailEo = detailEoList.get(0);
        String platformOrderNo = keepAccountsDetailEo.getPlatformOrderNo();
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDomain.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"order_type", (Object)BillTypeEnum.SALE_LIST.getCode())).list();
        if (CollUtil.isEmpty((Collection)list)) {
            return false;
        }
        Map<String, BigDecimal> itemCode2purchasePriceMap = list.stream().map(x -> {
            JSONObject extensionJson = JSONObject.parseObject((String)x.getExtension());
            return new AbstractMap.SimpleEntry<String, Object>(x.getItemCode(), (extensionJson != null && extensionJson.containsKey((Object)"itemPurchasePrice") ? extensionJson.getBigDecimal("itemPurchasePrice") : null));
        }).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
        boolean account = true;
        for (KeepAccountsDetailEo accountsDetailEo : detailEoList) {
            if (!itemCode2purchasePriceMap.containsKey(accountsDetailEo.getItemCode())) {
                account = false;
                continue;
            }
            accountsDetailEo.getExtFields().putIfAbsent(accountsDetailEo.getItemCode(), itemCode2purchasePriceMap.get(accountsDetailEo.getItemCode()));
        }
        return account;
    }

    @Override
    public boolean purchasePriceJudgment(List<KeepAccountsDetailEo> detailEoList, KeepNodeRuleParam context) {
        KeepAccountsDetailEo keepAccountsDetailEo = detailEoList.get(0);
        String saleCompanyCode = keepAccountsDetailEo.getSaleCompanyCode();
        String organizationCode = keepAccountsDetailEo.getOrganizationCode();
        SkuPurchasePriceSupplierQueryReqDto skuPurchasePriceSupplierQueryReqDto = new SkuPurchasePriceSupplierQueryReqDto();
        skuPurchasePriceSupplierQueryReqDto.setSaleCompanyCode(saleCompanyCode);
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgOrganizationApiProxy.queryOrgListByCode(Collections.singletonList(keepAccountsDetailEo.getOrganizationCode())));
        if (CollUtil.isNotEmpty((Collection)organizationDtos)) {
            List ids = organizationDtos.stream().map(OrganizationDto::getId).collect(Collectors.toList());
            DgEnterpriseInventoryOrgRelationQueryReqDto queryParam = new DgEnterpriseInventoryOrgRelationQueryReqDto();
            queryParam.setInventoryOrgIdList(ids);
            List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventoryOrgQueryApiProxy.queryList(queryParam));
            log.info("\u67e5\u8be2\u8d27\u6743\u7ec4\u7ec7\uff1a{}\u5bf9\u5e94\u7684\u9500\u552e\u516c\u53f8\u4fe1\u606f\u4e3a\uff1a{}", (Object)keepAccountsDetailEo.getOrganizationCode(), (Object)JSONObject.toJSONString((Object)respDtos));
            if (CollUtil.isNotEmpty((Collection)respDtos)) {
                organizationCode = ((DgInventoryOrgRelationRespDto)respDtos.get(0)).getEnterpriseCode();
            }
        }
        skuPurchasePriceSupplierQueryReqDto.setSupplierCode(organizationCode);
        ArrayList<SkuPurchasePriceQueryReqDto> skuPurchasePriceQueryReqDtos = new ArrayList<SkuPurchasePriceQueryReqDto>();
        for (KeepAccountsDetailEo accountsDetailEo : detailEoList) {
            SkuPurchasePriceQueryReqDto skuPurchasePriceQueryReqDto = new SkuPurchasePriceQueryReqDto();
            skuPurchasePriceQueryReqDto.setSkuId(accountsDetailEo.getItemId());
            skuPurchasePriceQueryReqDto.setCurrency("CNY");
            skuPurchasePriceQueryReqDtos.add(skuPurchasePriceQueryReqDto);
        }
        skuPurchasePriceSupplierQueryReqDto.setSkuReqDtoList(skuPurchasePriceQueryReqDtos);
        Map<Long, String> itemMap = detailEoList.stream().collect(Collectors.toMap(KeepAccountsDetailEo::getItemId, KeepAccountsDetailEo::getItemCode, (k1, k2) -> k1));
        try {
            log.info("\u8bf7\u6c42\u67e5\u8be2\u91c7\u8d2d\u4ef7\u7684\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)skuPurchasePriceSupplierQueryReqDto));
            List skuPolicyPriceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPricePurchaseQueryApiProxy.querySaleCompanySkuPolicyPurchasePrice(skuPurchasePriceSupplierQueryReqDto));
            if (CollUtil.isEmpty((Collection)skuPolicyPriceRespDtos)) {
                return false;
            }
            Map policyPriceRespDtoMap = skuPolicyPriceRespDtos.stream().collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuCode, Function.identity()));
            log.info("\u67e5\u8be2\u91c7\u8d2d\u4ef7\u54cd\u5e94\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)skuPolicyPriceRespDtos));
            log.info("\u5546\u54c1id\u548c\u7f16\u7801\u7684\u5173\u7cfb:{}", (Object)JSON.toJSONString(itemMap));
            for (KeepAccountsDetailEo accountsDetailEo : detailEoList) {
                if (!policyPriceRespDtoMap.containsKey(accountsDetailEo.getItemCode())) {
                    throw new BizException("\u67e5\u8be2\u5230\u7684\u91c7\u8d2d\u4ef7\u548c\u5f53\u524d\u7684\u8bb0\u8d26\u5355\u636e\u4e0d\u4e00\u81f4:{}", accountsDetailEo.getItemCode());
                }
                SkuPolicyPriceRespDto skuPolicyPriceRespDto = (SkuPolicyPriceRespDto)policyPriceRespDtoMap.get(accountsDetailEo.getItemCode());
                BigDecimal supplyPrice = BigDecimal.ZERO;
                Map extFields = accountsDetailEo.getExtFields();
                supplyPrice = CollUtil.isNotEmpty((Collection)skuPolicyPriceRespDto.getSkuPriceLimitList()) ? skuPolicyPriceRespDto.getSkuPriceLimitList().stream().filter(skuPriceLimit -> skuPriceLimit.getLowerLimit().compareTo(accountsDetailEo.getItemNum()) <= 0 && (skuPriceLimit.getUpperLimit() == null || skuPriceLimit.getUpperLimit().compareTo(accountsDetailEo.getItemNum()) >= 0)).map(PriceItemSkuSectionRespDto::getItemPrice).findFirst().orElse(skuPolicyPriceRespDto.getSupplyPrice()) : skuPolicyPriceRespDto.getSupplyPrice();
                if (extFields.containsKey(accountsDetailEo.getItemCode())) continue;
                extFields.put(accountsDetailEo.getItemCode(), supplyPrice);
            }
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u91c7\u8d2d\u4ef7\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }
}

