/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.InvoiceShopRuleConverter;
import com.yunxi.dg.base.center.finance.dao.das.IInvoiceShopRuleDas;
import com.yunxi.dg.base.center.finance.domain.entity.IInvoiceShopRuleDomain;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceShopRuleDto;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceShopRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceShopRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.InvoiceShopRuleEo;
import com.yunxi.dg.base.center.finance.service.entity.IInvoiceShopRuleService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvoiceShopRuleServiceImpl
extends BaseServiceImpl<InvoiceShopRuleDto, InvoiceShopRuleEo, IInvoiceShopRuleDomain>
implements IInvoiceShopRuleService {
    @Resource
    private IInvoiceShopRuleDas invoiceShopRuleDas;
    @Resource
    private IInvoiceShopRuleDomain invoiceShopRuleDomain;

    public InvoiceShopRuleServiceImpl(IInvoiceShopRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InvoiceShopRuleDto, InvoiceShopRuleEo> converter() {
        return InvoiceShopRuleConverter.INSTANCE;
    }

    @Override
    public Long addInvoiceShopRule(InvoiceShopRuleReqDto addReqDto) {
        InvoiceShopRuleEo invoceShopRuleEo = new InvoiceShopRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)invoceShopRuleEo);
        this.invoiceShopRuleDas.insert((BaseEo)invoceShopRuleEo);
        return invoceShopRuleEo.getId();
    }

    @Override
    public void modifyInvoiceShopRule(InvoiceShopRuleReqDto modifyReqDto) {
        InvoiceShopRuleEo invoceShopRuleEo = new InvoiceShopRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)invoceShopRuleEo);
        this.invoiceShopRuleDas.updateSelective((BaseEo)invoceShopRuleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInvoiceShopRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.invoiceShopRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InvoiceShopRuleRespDto queryById(Long id) {
        InvoiceShopRuleEo invoceShopRuleEo = (InvoiceShopRuleEo)this.invoiceShopRuleDas.selectByPrimaryKey(id);
        InvoiceShopRuleRespDto invoceShopRuleRespDto = new InvoiceShopRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)invoceShopRuleEo, (BaseVo)invoceShopRuleRespDto);
        return invoceShopRuleRespDto;
    }

    @Override
    public PageInfo<InvoiceShopRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InvoiceShopRuleReqDto invoceShopRuleReqDto = (InvoiceShopRuleReqDto)JSON.parseObject((String)filter, InvoiceShopRuleReqDto.class);
        InvoiceShopRuleEo invoceShopRuleEo = new InvoiceShopRuleEo();
        DtoHelper.dto2Eo((BaseVo)invoceShopRuleReqDto, (BaseEo)invoceShopRuleEo);
        PageInfo eoPageInfo = this.invoiceShopRuleDomain.selectPage((BaseEo)invoceShopRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InvoiceShopRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<String, InvoiceShopRuleRespDto> getInvoiceShopRule(String billShopType) {
        List invoiceShopRuleEos = ((ExtQueryChainWrapper)this.invoiceShopRuleDas.filter().eq((Object)"bill_shop_type", (Object)billShopType)).list();
        ArrayList invoiceShopRuleRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)invoiceShopRuleRespDtos, (Collection)invoiceShopRuleEos, InvoiceShopRuleRespDto.class);
        Map<String, InvoiceShopRuleRespDto> invoiceShopRuleRespDtoMap = invoiceShopRuleRespDtos.stream().collect(Collectors.toMap(InvoiceShopRuleRespDto::getShopCode, Function.identity(), (k1, k2) -> k1));
        return invoiceShopRuleRespDtoMap;
    }
}

