/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderDas;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.entity.AfterSaleOrderItemDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAmountCalcuatedDto;
import com.yunxi.dg.base.center.finance.dto.entity.MatchRelatedTradeShopKeepDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountPriceTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.CaculatedTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.FinanceItemTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IInvoicingBookKeepingService;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InvoicingBookKeepingServiceImpl
implements IInvoicingBookKeepingService {
    private static final Logger log = LoggerFactory.getLogger(InvoicingBookKeepingServiceImpl.class);
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IDgPerformOrderInfoDas performOrderInfoDas;
    @Resource
    private IAfterSaleOrderDas afterSaleOrderDas;
    @Resource
    private IAfterSaleOrderItemDas afterSaleOrderItemDas;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Value(value="${keep.account.refund.amount:0.01}")
    private BigDecimal refundAmount;

    @Override
    public Map<String, Object> calculatedAmount(ShopEo shopEo, AfterSaleOrderEo afterSaleOrderEo, AfterSaleOrderItemDto item, Map<Long, KeepAccountsDetailEo> saleDetailMap) {
        HashMap resultMap = Maps.newHashMap();
        BigDecimal itemPrice = BigDecimal.ZERO;
        BigDecimal businessAmount = BigDecimal.ZERO;
        BigDecimal remainingRefundableAmount = BigDecimal.ZERO;
        Integer remainingRefundableNum = 0;
        Boolean needKeep = Boolean.TRUE;
        String message = null;
        if (Objects.equals(shopEo.getManageType(), 1)) {
            if (Objects.nonNull(afterSaleOrderEo.getSaleOrderId())) {
                if (Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.FHHTK.getCode()) || Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.fhhtk.getCode())) {
                    KeepAccountsDetailEo detailEo = saleDetailMap.get(item.getSaleOrderItemId());
                    log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u6b63\u5411\u8bb0\u8d26\u660e\u7ec6\uff1a{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)detailEo));
                    if (Objects.nonNull(detailEo)) {
                        List<KeepAccountsDetailEo> afterAccountsDetailEo = this.getAfterKeepAccountsDetailList(detailEo.getOrderItemId(), detailEo.getOrderNo(), VoucherTypeEnum.INVOICE.getCode());
                        log.info("\u83b7\u53d6\u6b63\u5411\u9500\u552e\u8ba2\u5355\u5bf9\u5e94\u5176\u4ed6\u552e\u540e\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6:{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), detailEo.getOrderNo(), JSONObject.toJSONString(afterAccountsDetailEo)});
                        businessAmount = item.getRefundAmount();
                        BigDecimal sumAfterAmount = CollectionUtil.isEmpty(afterAccountsDetailEo) ? BigDecimal.ZERO : afterAccountsDetailEo.stream().filter(x -> null != x.getItemPrice()).map(KeepAccountsDetailEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
                        log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e-\u5176\u4ed6\u552e\u540e\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6\u91d1\u989d\uff1a{}", (Object)sumAfterAmount);
                        BigDecimal zxItemPrice = detailEo.getItemPrice();
                        remainingRefundableAmount = remainingRefundableAmount.add(zxItemPrice.compareTo(BigDecimal.ZERO) == 0 ? sumAfterAmount : zxItemPrice.subtract(sumAfterAmount));
                        log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e-\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u91d1\u989d\uff1a{}", (Object)remainingRefundableAmount);
                        List keepAccountsDetailEos = afterAccountsDetailEo.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOrderType()) && !Objects.equals(x.getOrderType(), BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())).collect(Collectors.toList());
                        Integer itemNum = CollectionUtil.isEmpty(keepAccountsDetailEos) ? Integer.valueOf(0) : keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getItemNum).reduce(Integer::sum).get();
                        log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e-\u9000\u8d27\u9000\u6b3e/\u6362\u8d27\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff1a{}", (Object)itemNum);
                        remainingRefundableNum = detailEo.getItemNum() - itemNum;
                        log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e-\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\uff1a{}", (Object)remainingRefundableNum);
                        if (remainingRefundableAmount.compareTo(BigDecimal.ZERO) > 0) {
                            itemPrice = item.getRefundAmount();
                            businessAmount = item.getRefundAmount();
                            if (remainingRefundableAmount.compareTo(item.getRefundAmount()) <= 0) {
                                if (0 == remainingRefundableNum) {
                                    itemPrice = remainingRefundableAmount;
                                    needKeep = Boolean.TRUE;
                                } else if (0 < remainingRefundableNum) {
                                    itemPrice = remainingRefundableAmount.subtract(this.refundAmount);
                                    needKeep = Boolean.TRUE;
                                } else {
                                    log.info("\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\u5c0f\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo());
                                    needKeep = Boolean.FALSE;
                                    message = "\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\u5c0f\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a" + afterSaleOrderEo.getAfterSaleOrderNo();
                                }
                            } else {
                                itemPrice = item.getRefundAmount();
                                businessAmount = item.getRefundAmount();
                                needKeep = Boolean.TRUE;
                            }
                        } else {
                            log.info("\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo());
                            needKeep = Boolean.FALSE;
                            message = "\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a" + afterSaleOrderEo.getAfterSaleOrderNo();
                        }
                    } else {
                        itemPrice = item.getRefundAmount();
                        businessAmount = item.getRefundAmount();
                    }
                    resultMap.put("itemPrice", itemPrice);
                    resultMap.put("businessAmount", businessAmount);
                    resultMap.put("remainingRefundableAmount", remainingRefundableAmount);
                    resultMap.put("remainingRefundableNum", remainingRefundableNum);
                    resultMap.put("needKeep", needKeep);
                    resultMap.put("message", message);
                    resultMap.put("zxSaleOrderItemId", Objects.isNull(detailEo) ? null : detailEo.getOrderItemId());
                    resultMap.put("relateToPlatformOrder", 0);
                    resultMap.put("caculatedType", CaculatedTypeEnum.ONE.getValue());
                } else {
                    KeepAccountsDetailEo detailEo = saleDetailMap.get(item.getSaleOrderItemId());
                    log.info("\u9000\u8d27\u9000\u6b3e\u6362\u8d27\u6b63\u5411\u8bb0\u8d26\u660e\u7ec6\uff1a{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)detailEo));
                    if (Objects.nonNull(detailEo)) {
                        List<KeepAccountsDetailEo> afterAccountsDetailEo = this.getAfterKeepAccountsDetailList(detailEo.getOrderItemId(), detailEo.getOrderNo(), VoucherTypeEnum.INVOICE.getCode());
                        log.info("\u83b7\u53d6\u6b63\u5411\u9500\u552e\u8ba2\u5355\u5bf9\u5e94\u5176\u4ed6\u552e\u540e\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6:{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), detailEo.getOrderNo(), JSONObject.toJSONString(afterAccountsDetailEo)});
                        businessAmount = item.getRefundAmount();
                        BigDecimal sumAfterAmount = CollectionUtil.isEmpty(afterAccountsDetailEo) ? BigDecimal.ZERO : afterAccountsDetailEo.stream().filter(x -> null != x.getItemPrice()).map(KeepAccountsDetailEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
                        log.info("\u9000\u8d27\u9000\u6b3e\u6362\u8d27-\u5176\u4ed6\u552e\u540e\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6\u91d1\u989d\uff1a{}", (Object)sumAfterAmount);
                        BigDecimal zxItemPrice = detailEo.getItemPrice();
                        remainingRefundableAmount = remainingRefundableAmount.add(zxItemPrice.compareTo(BigDecimal.ZERO) == 0 ? sumAfterAmount : zxItemPrice.subtract(sumAfterAmount));
                        log.info("\u9000\u8d27\u9000\u6b3e\u6362\u8d27-\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u91d1\u989d\uff1a{}", (Object)remainingRefundableAmount);
                        List keepAccountsDetailEos = afterAccountsDetailEo.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOrderType()) && !Objects.equals(x.getOrderType(), BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())).collect(Collectors.toList());
                        Integer itemNum = CollectionUtil.isEmpty(keepAccountsDetailEos) ? Integer.valueOf(0) : keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getItemNum).reduce(Integer::sum).get();
                        log.info("\u9000\u8d27\u9000\u6b3e\u6362\u8d27-\u9000\u8d27\u9000\u6b3e/\u6362\u8d27\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff1a{}", (Object)itemNum);
                        remainingRefundableNum = detailEo.getItemNum() - itemNum;
                        log.info("\u9000\u8d27\u9000\u6b3e\u6362\u8d27-\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\uff1a{}", (Object)remainingRefundableNum);
                        if (remainingRefundableNum < 0) {
                            log.info("\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\u5c0f\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo());
                            needKeep = Boolean.FALSE;
                            message = "\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\u5c0f\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a" + afterSaleOrderEo.getAfterSaleOrderNo();
                        } else if (remainingRefundableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                            if (null != item.getGift() && (item.getGift().equals(FinanceItemTypeEnum.GIFT.getCode()) || item.getRefundAmount().compareTo(BigDecimal.ZERO) == 0)) {
                                needKeep = Boolean.TRUE;
                            } else {
                                log.info("\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo());
                                needKeep = Boolean.FALSE;
                                message = "\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\u5c0f\u4e8e0\u4e0d\u751f\u6210\u8bb0\u8d26\u5355\uff1a" + afterSaleOrderEo.getAfterSaleOrderNo();
                            }
                        } else {
                            BigDecimal multiply = detailEo.getItemUnitPrice().multiply(new BigDecimal(item.getItemNum()));
                            itemPrice = remainingRefundableAmount.compareTo(multiply) > 0 ? multiply : remainingRefundableAmount;
                            needKeep = Boolean.TRUE;
                        }
                    } else {
                        itemPrice = item.getRefundAmount();
                        businessAmount = item.getRefundAmount();
                    }
                    resultMap.put("itemPrice", itemPrice);
                    resultMap.put("businessAmount", businessAmount);
                    resultMap.put("remainingRefundableAmount", remainingRefundableAmount);
                    resultMap.put("remainingRefundableNum", remainingRefundableNum);
                    resultMap.put("needKeep", needKeep);
                    resultMap.put("message", message);
                    resultMap.put("zxSaleOrderItemId", Objects.isNull(detailEo) ? null : detailEo.getOrderItemId());
                    resultMap.put("relateToPlatformOrder", 0);
                    resultMap.put("caculatedType", CaculatedTypeEnum.TWO.getValue());
                }
            } else {
                itemPrice = item.getRefundAmount();
                resultMap.put("itemPrice", itemPrice);
                resultMap.put("businessAmount", item.getRefundAmount());
                resultMap.put("remainingRefundableAmount", remainingRefundableAmount);
                resultMap.put("remainingRefundableNum", remainingRefundableNum);
                resultMap.put("relateToPlatformOrder", 1);
                resultMap.put("needKeep", Boolean.FALSE);
                resultMap.put("message", "\u65e0\u539f\u5355\u4e0d\u751f\u6210\u5f00\u7968\u8bb0\u8d26");
                resultMap.put("caculatedType", CaculatedTypeEnum.THREE.getValue());
            }
        } else {
            if (Objects.nonNull(afterSaleOrderEo.getSaleOrderId())) {
                itemPrice = item.getSupplyPrice();
                resultMap.put("needKeep", needKeep);
                resultMap.put("relateToPlatformOrder", 0);
            } else {
                itemPrice = item.getRefundAmount();
                resultMap.put("needKeep", Boolean.FALSE);
                resultMap.put("message", "\u65e0\u539f\u5355\u4e0d\u751f\u6210\u5f00\u7968\u8bb0\u8d26");
                resultMap.put("relateToPlatformOrder", 1);
            }
            resultMap.put("itemPrice", itemPrice);
            resultMap.put("businessAmount", item.getRefundAmount());
            resultMap.put("caculatedType", CaculatedTypeEnum.FOUR.getValue());
        }
        log.info("\u552e\u540e\u8bb0\u8d26\u91d1\u989dresultMap:{}", (Object)JSONObject.toJSONString((Object)resultMap));
        log.info("\u552e\u540e\u8bb0\u8d26\u91d1\u989d\uff1a{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getId(), itemPrice});
        return resultMap;
    }

    private KeepAccountsDetailEo getSaleKeepAccountsDetail(Long saleOrderItemId, String saleOrderNo, String voucherType) {
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"order_item_id", (Object)saleOrderItemId)).eq((Object)"order_no", (Object)saleOrderNo)).eq((Object)"voucher_type", (Object)voucherType)).list();
        if (CollectionUtil.isEmpty((Collection)keepAccountsDetailEos)) {
            return new KeepAccountsDetailEo();
        }
        return (KeepAccountsDetailEo)keepAccountsDetailEos.get(0);
    }

    private List<KeepAccountsDetailEo> getAfterKeepAccountsDetailList(Long saleOrderItemId, String saleOrderNo, String voucherType) {
        List afterSaleOrderEos = ((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).list();
        if (CollectionUtil.isEmpty((Collection)afterSaleOrderEos)) {
            log.info("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u552e\u540e\u5355\u4fe1\u606f:{},{}", (Object)saleOrderNo, (Object)saleOrderItemId);
            return Lists.newArrayList();
        }
        List afterSaleOrderIds = afterSaleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List afterSaleOrderItemEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderItemDas.filter().eq((Object)"after_sale_order_item_type", (Object)0)).eq((Object)"sale_order_item_id", (Object)saleOrderItemId)).in((Object)"after_sale_order_id", afterSaleOrderIds)).list();
        if (CollectionUtil.isEmpty((Collection)afterSaleOrderItemEos)) {
            log.info("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u552e\u540e\u5355\u5546\u54c1\u884c\u4fe1\u606f:{},{}", (Object)saleOrderNo, (Object)saleOrderItemId);
            return Lists.newArrayList();
        }
        List orderNos = afterSaleOrderEos.stream().map(AfterSaleOrderEo::getAfterSaleOrderNo).collect(Collectors.toList());
        List afterSaleOrderItemIds = afterSaleOrderItemEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", afterSaleOrderItemIds)).in((Object)"order_no", orderNos)).eq((Object)"voucher_type", (Object)voucherType)).list();
        if (CollectionUtil.isEmpty((Collection)keepAccountsDetailEos)) {
            log.info("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u552e\u540e\u5355\u8bb0\u8d26\u5546\u54c1\u884c\u4fe1\u606f:{},{}", (Object)saleOrderNo, (Object)saleOrderItemId);
            return Lists.newArrayList();
        }
        return keepAccountsDetailEos;
    }

    @Override
    public Map<String, Object> calculatedExchangeSaleOrderKeepAmount(DgPerformOrderInfoEo performOrderInfoEo, ShopEo shopEo, List<DgPerformOrderLineAmountEo> dgPerformOrderLineAmountEos, DgPerformOrderLineDto itemDto, Integer accountPriceType) {
        HashMap resultMap = Maps.newHashMap();
        BigDecimal realPayAmount = BigDecimal.ZERO;
        String message = null;
        String accountType = "";
        accountType = Objects.nonNull(shopEo) && Objects.equals(1, shopEo.getManageType()) ? (Objects.equals(accountPriceType, AccountPriceTypeEnum.ACTUAL_PRICE.getCode()) ? DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode() : DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode()) : DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode();
        if (KeepSaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(performOrderInfoEo.getOrderType())) {
            log.info("\u6362\u8d27\u53d1\u51fa\u7684\u8ba2\u5355\uff1a{},{}", (Object)performOrderInfoEo.getSaleOrderNo(), (Object)performOrderInfoEo.getExchangeOrderNo());
            String exchangeOrderNo = performOrderInfoEo.getExchangeOrderNo();
            AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().eq((Object)"after_sale_order_no", (Object)exchangeOrderNo)).one();
            log.info("\u6362\u8d27\u552e\u540e\u8ba2\u5355\u4fe1\u606f:{},{}", (Object)performOrderInfoEo.getSaleOrderNo(), (Object)JSONObject.toJSONString((Object)afterSaleOrderEo));
            if (Objects.isNull(afterSaleOrderEo) || null == afterSaleOrderEo.getSaleOrderId() || null != afterSaleOrderEo.getRelateToPlatformOrder() && 1 == afterSaleOrderEo.getRelateToPlatformOrder()) {
                realPayAmount = this.getRealPayAmount(dgPerformOrderLineAmountEos, itemDto.getId(), accountType);
                log.info("\u6362\u8d27\u53d1\u8d27\u8ba2\u5355\u5bf9\u5e94\u552e\u540e\u5355\u4e3a\u65e0\u539f\u5355,\u6216\u5bf9\u5e94\u7684\u552e\u540e\u5355\u4e0d\u5b58\u5728\uff1a{}", (Object)realPayAmount);
                resultMap.put("realPayAmount", realPayAmount);
                resultMap.put("needKeep", Boolean.TRUE);
                resultMap.put("commission", "");
                resultMap.put("actualPayment", null);
            } else {
                List afterSaleOrderItemEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderItemDas.filter().eq((Object)"after_sale_order_id", (Object)afterSaleOrderEo.getId())).eq((Object)"after_sale_order_item_type", (Object)0)).list();
                if (CollectionUtil.isEmpty((Collection)afterSaleOrderItemEos)) {
                    log.info("\u67e5\u8be2\u552e\u540e\u9000\u8d27\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u5b58\u5728:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)afterSaleOrderItemEos));
                    resultMap.put("needKeep", Boolean.FALSE);
                    message = "\u67e5\u8be2\u552e\u540e\u9000\u8d27\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u5b58\u5728:" + afterSaleOrderEo.getAfterSaleOrderNo();
                    resultMap.put("message", message);
                } else {
                    List afterSaleOrderItemIds = afterSaleOrderItemEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
                    List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"order_no", (Object)afterSaleOrderEo.getAfterSaleOrderNo())).in((Object)"order_item_id", afterSaleOrderItemIds)).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).list();
                    if (CollectionUtil.isEmpty((Collection)keepAccountsDetailEos)) {
                        log.info("\u6362\u8d27\u5355\u672a\u751f\u6210\u5f00\u7968\u8bb0\u8d26\u5355\u5219\u6362\u8d27\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u4e0d\u751f\u6210:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)keepAccountsDetailEos));
                        resultMap.put("needKeep", Boolean.FALSE);
                        message = "\u6362\u8d27\u5355\u672a\u751f\u6210\u5f00\u7968\u8bb0\u8d26\u5355\u5219\u6362\u8d27\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u4e0d\u751f\u6210:" + afterSaleOrderEo.getAfterSaleOrderNo();
                        resultMap.put("message", message);
                    } else {
                        Map keepAccountsDetailEoMap = keepAccountsDetailEos.stream().collect(Collectors.toMap(x -> x.getOrderNo() + ";" + x.getItemCode(), Function.identity(), (k1, k2) -> k1));
                        log.info("\u6362\u8d27\u552e\u540e\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6keepAccountsDetailEoMap:{}", (Object)JSONObject.toJSONString(keepAccountsDetailEoMap));
                        String key = exchangeOrderNo + ";" + itemDto.getSkuCode();
                        KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
                        keepAccountsDetailEo = keepAccountsDetailEoMap.containsKey(key) ? (KeepAccountsDetailEo)keepAccountsDetailEoMap.get(key) : (KeepAccountsDetailEo)keepAccountsDetailEos.get(0);
                        realPayAmount = null == keepAccountsDetailEo.getItemUnitPrice() ? BigDecimal.ZERO.multiply(null != itemDto.getItemNum() ? itemDto.getItemNum() : BigDecimal.ZERO) : keepAccountsDetailEo.getItemUnitPrice().multiply(itemDto.getItemNum()).setScale(2, RoundingMode.HALF_UP);
                        resultMap.put("realPayAmount", realPayAmount);
                        resultMap.put("needKeep", Boolean.TRUE);
                        resultMap.put("commission", keepAccountsDetailEo.getCommission());
                        resultMap.put("actualPayment", keepAccountsDetailEo.getActualPayment());
                    }
                }
            }
        }
        return resultMap;
    }

    private BigDecimal getRealPayAmount(List<DgPerformOrderLineAmountEo> dgPerformOrderLineAmountEos, Long orderLineId, String accountType) {
        log.info("dgPerformOrderLineAmountEos:{},{},{}", new Object[]{orderLineId, accountType, JSONObject.toJSONString(dgPerformOrderLineAmountEos)});
        BigDecimal realPayAmount = BigDecimal.ZERO;
        for (DgPerformOrderLineAmountEo dgPerformOrderLineAmountEo : dgPerformOrderLineAmountEos) {
            if (!Objects.equals(dgPerformOrderLineAmountEo.getOrderLineId(), orderLineId) || !Objects.equals(accountType, dgPerformOrderLineAmountEo.getAccountType())) continue;
            realPayAmount = dgPerformOrderLineAmountEo.getAmount();
        }
        return realPayAmount;
    }

    @Override
    public KeepAmountCalcuatedDto calculatedKeepAmount(ShopEo shopEo, AfterSaleOrderEo afterSaleOrderEo, SaleOrderItemVo saleOrderItemVo, AfterSaleOrderItemDto item, Map<Long, KeepAccountsDetailEo> saleDetailMap, String voucherType) {
        List keepAccountsDetailEoList;
        List collect;
        KeepAccountsDetailEo detailEo = saleDetailMap.get(item.getSaleOrderItemId());
        if (Objects.isNull(detailEo)) {
            return new KeepAmountCalcuatedDto();
        }
        log.info("\u4e00\u54c1\u591a\u5730\u6b63\u5411\u8ba2\u5355\u8bb0\u8d26\u4fe1\u606f\uff1a\u9500\u552e\u5355\u53f7{}\uff1a\u5b9e\u4ed8\u91d1\u989d\uff1a{},\u4f63\u91d1\u6bd4\u4f8b\uff1a{}\uff0c\u5dee\u4ef7\uff1a{}", new Object[]{saleOrderItemVo.getSaleOrderNo(), detailEo.getActualPayment(), detailEo.getCommission(), detailEo.getDifferential()});
        BigDecimal saleActualPayment = Optional.ofNullable(detailEo.getActualPayment()).orElse(BigDecimal.ZERO);
        BigDecimal saleItemPrice = detailEo.getItemPrice();
        String commission = null != detailEo.getCommission() ? detailEo.getCommission() : "0";
        Integer zxItemNum = detailEo.getItemNum();
        BigDecimal commissionPrice = new BigDecimal(commission).divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal saleDifferential = null != detailEo.getDifferential() ? detailEo.getDifferential() : BigDecimal.ZERO;
        Integer remainingRefundableNum = 0;
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u552e\u540e\u8bb0\u8d26\u5e97\u94fa\uff1a{},{},\u7c7b\u578b\uff1a{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getId(), shopEo.getManageType()});
        BigDecimal refundActualPayment = Objects.equals(shopEo.getManageType(), 1) ? item.getRefundAmount() : item.getSupplyPrice();
        refundActualPayment = Optional.ofNullable(refundActualPayment).orElse(BigDecimal.ZERO);
        KeepAmountCalcuatedDto calcuatedDto = new KeepAmountCalcuatedDto();
        calcuatedDto.setCommission(commission);
        calcuatedDto.setOrderNo(afterSaleOrderEo.getAfterSaleOrderNo());
        calcuatedDto.setZxOrderItemId(detailEo.getOrderItemId());
        calcuatedDto.setSaleActualPayment(saleActualPayment);
        calcuatedDto.setOrderItemId(item.getId());
        calcuatedDto.setPlatformOrderNo(afterSaleOrderEo.getPlatformOrderNo());
        calcuatedDto.setSaleItemPrice(saleItemPrice);
        calcuatedDto.setSaleDifferential(saleDifferential);
        calcuatedDto.setAfterSaleOrderType(afterSaleOrderEo.getAfterSaleOrderType());
        calcuatedDto.setRelatedTradeShopKeepDto(this.getMatchRelatedTradeShopKeepDto(detailEo));
        if (refundActualPayment.compareTo(BigDecimal.ZERO) == 0) {
            calcuatedDto.setItemPrice(refundActualPayment);
            calcuatedDto.setActualPayment(refundActualPayment);
            calcuatedDto.setNeedKeep(Boolean.TRUE);
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u662f\u5426\u4e3a\u8d60\u54c1:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)calcuatedDto));
            return calcuatedDto;
        }
        if (Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.FHHTK.getCode()) || Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.fhhtk.getCode())) {
            BigDecimal subtract;
            List collect2;
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u6b63\u5411\u8bb0\u8d26\u660e\u7ec6\uff1a{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)detailEo));
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u552e\u540e\u6b63\u5411\u5bf9\u5e94\u5b9e\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6bd4\u8f83\uff1a{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), saleActualPayment, detailEo.getOrderNo()});
            if (null != saleActualPayment && saleActualPayment.compareTo(BigDecimal.ZERO) > 0 && refundActualPayment.compareTo(saleActualPayment) > 0) {
                log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u552e\u540e\u8bb0\u8d26\u91d1\u989d\u5927\u4e8e\u539f\u5355\u5546\u54c1\u884c\u5b9e\u4ed8\u91d1\u989d,\u4e0d\u8fdb\u884c\u8bb0\u8d26:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)item.getId());
                calcuatedDto.setNeedKeep(Boolean.FALSE);
                calcuatedDto.setActualPayment(refundActualPayment);
                calcuatedDto.setItemPrice(refundActualPayment);
                return calcuatedDto;
            }
            List<KeepAccountsDetailEo> afterAccountsDetailEo = this.getAfterKeepAccountsDetailList(detailEo.getOrderItemId(), detailEo.getOrderNo(), voucherType);
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u83b7\u53d6\u6b63\u5411\u9500\u552e\u8ba2\u5355\u5bf9\u5e94\u5176\u4ed6\u552e\u540e\u5355\u8bb0\u8d26\u660e\u7ec6:{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), detailEo.getOrderNo(), JSONObject.toJSONString(afterAccountsDetailEo)});
            BigDecimal sumAfterAmount = BigDecimal.ZERO;
            if (CollectionUtil.isNotEmpty(afterAccountsDetailEo) && CollectionUtil.isNotEmpty(collect2 = afterAccountsDetailEo.stream().filter(x -> null != x.getActualPayment()).collect(Collectors.toList()))) {
                sumAfterAmount = sumAfterAmount.add(collect2.stream().map(KeepAccountsDetailEo::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4));
            }
            log.info("\u552e\u540e\u6b63\u5411\u5bf9\u5e94\u5b9e\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6bd4\u8f83\uff1a{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), saleActualPayment, detailEo.getOrderNo()});
            if (null != saleActualPayment && saleActualPayment.compareTo(BigDecimal.ZERO) > 0 && refundActualPayment.compareTo(subtract = saleActualPayment.subtract(sumAfterAmount)) > 0) {
                log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u552e\u540e\u8bb0\u8d26\u91d1\u989d\u5927\u4e8e\u539f\u5355\u5546\u54c1\u7684\u5b9e\u4ed8\u91d1\u989d\u51cf\u53bb\u5df2\u9000\u6b3e\u91d1\u989d\u5408\u8ba1,\u4e0d\u8fdb\u884c\u8bb0\u8d26:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)item.getId());
                calcuatedDto.setNeedKeep(Boolean.FALSE);
                calcuatedDto.setActualPayment(refundActualPayment);
                calcuatedDto.setItemPrice(refundActualPayment);
                return calcuatedDto;
            }
            BigDecimal multiply = refundActualPayment.multiply(commissionPrice);
            BigDecimal decimal = multiply.setScale(2, 4);
            BigDecimal refundIsMultAreaItemPrice = refundActualPayment.subtract(decimal);
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8bb0\u8d26\u91d1\u989d\u5904\u7406refundIsMultAreaItemPrice:{},{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)refundIsMultAreaItemPrice);
            calcuatedDto.setDifferential(decimal.compareTo(BigDecimal.ZERO) > 0 ? decimal : BigDecimal.ZERO);
            calcuatedDto.setItemPrice(refundIsMultAreaItemPrice);
            calcuatedDto.setActualPayment(refundActualPayment);
            calcuatedDto.setNeedKeep(Boolean.TRUE);
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u8bb0\u8d26\u91d1\u989d\uff1a{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getId(), JSONObject.toJSONString((Object)calcuatedDto)});
            return calcuatedDto;
        }
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u9000\u8d27\u9000\u6b3e\u6362\u8d27\u6b63\u5411\u8bb0\u8d26\u660e\u7ec6\uff1a{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)detailEo));
        List<KeepAccountsDetailEo> afterAccountsDetailEo = this.getAfterKeepAccountsDetailList(detailEo.getOrderItemId(), detailEo.getOrderNo(), voucherType);
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u83b7\u53d6\u6b63\u5411\u9500\u552e\u8ba2\u5355\u5bf9\u5e94\u5176\u4ed6\u552e\u540e\u5355\u8bb0\u8d26\u660e\u7ec6:{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), detailEo.getOrderNo(), JSONObject.toJSONString(afterAccountsDetailEo)});
        BigDecimal sumAfterAmount = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(afterAccountsDetailEo) && CollectionUtil.isNotEmpty(collect = afterAccountsDetailEo.stream().filter(x -> null != x.getActualPayment()).collect(Collectors.toList()))) {
            sumAfterAmount = sumAfterAmount.add(collect.stream().map(KeepAccountsDetailEo::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4));
        }
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u9000\u8d27\u9000\u6b3e\u6362\u8d27-\u5176\u4ed6\u552e\u540e\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6\u91d1\u989d\uff1a{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)sumAfterAmount);
        log.info("\u552e\u540e\u6b63\u5411\u5bf9\u5e94\u5b9e\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6bd4\u8f83\uff1a{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), saleActualPayment, detailEo.getOrderNo()});
        BigDecimal subtract = BigDecimal.ZERO;
        if (null != saleActualPayment && saleActualPayment.compareTo(BigDecimal.ZERO) > 0) {
            subtract = saleActualPayment.subtract(sumAfterAmount);
        }
        Integer itemNum = CollectionUtil.isEmpty(keepAccountsDetailEoList = afterAccountsDetailEo.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOrderType()) && !Objects.equals(x.getOrderType(), BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())).collect(Collectors.toList())) ? Integer.valueOf(0) : keepAccountsDetailEoList.stream().map(KeepAccountsDetailEo::getItemNum).reduce(Integer::sum).get();
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u9000\u8d27\u9000\u6b3e/\u6362\u8d27\u5355\u5f00\u7968\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff1a{}", (Object)itemNum);
        remainingRefundableNum = detailEo.getItemNum() - itemNum;
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730-\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u8d26\u5269\u4f59\u53ef\u9000\u6570\u91cf\uff1a{}", (Object)remainingRefundableNum);
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)((ExtQueryChainWrapper)this.performOrderInfoDas.filter().eq((Object)"sale_order_no", (Object)afterSaleOrderEo.getSaleOrderNo())).one();
        if (Objects.nonNull(performOrderInfoEo) && SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(performOrderInfoEo.getOrderType())) {
            List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"order_item_id", (Object)item.getSaleOrderItemId())).eq((Object)"voucher_type", (Object)voucherType)).list();
            if (CollectionUtil.isNotEmpty((Collection)keepAccountsDetailEos)) {
                KeepAccountsDetailEo accountsDetailEo = (KeepAccountsDetailEo)keepAccountsDetailEos.get(0);
                calcuatedDto.setItemPrice(accountsDetailEo.getItemPrice());
                calcuatedDto.setActualPayment(accountsDetailEo.getActualPayment());
                calcuatedDto.setDifferential(accountsDetailEo.getDifferential());
                calcuatedDto.setNeedKeep(Boolean.TRUE);
            } else {
                BigDecimal multiply = refundActualPayment.multiply(commissionPrice);
                BigDecimal decimal = multiply.setScale(2, 4);
                BigDecimal refundIsMultAreaItemPrice = refundActualPayment.subtract(multiply);
                log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8bb0\u8d26\u91d1\u989d\u5904\u7406refundIsMultAreaItemPrice:{},{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)refundIsMultAreaItemPrice);
                calcuatedDto.setDifferential(multiply.compareTo(BigDecimal.ZERO) > 0 ? multiply.setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
                calcuatedDto.setActualPayment(refundActualPayment.multiply(new BigDecimal(item.getItemNum())));
                calcuatedDto.setItemPrice(refundIsMultAreaItemPrice);
            }
        } else {
            if (subtract.compareTo(BigDecimal.ZERO) <= 0) {
                BigDecimal multiply = refundActualPayment.multiply(commissionPrice);
                BigDecimal decimal = multiply.setScale(2, 4);
                calcuatedDto.setDifferential(decimal.compareTo(BigDecimal.ZERO) > 0 ? decimal : BigDecimal.ZERO);
                calcuatedDto.setActualPayment(refundActualPayment);
            } else {
                BigDecimal divide = subtract.divide(new BigDecimal(zxItemNum), 2, 4);
                BigDecimal multiply = divide.multiply(commissionPrice);
                BigDecimal decimal = multiply.setScale(2, 4);
                calcuatedDto.setDifferential(decimal.compareTo(BigDecimal.ZERO) > 0 ? decimal : BigDecimal.ZERO);
                calcuatedDto.setActualPayment(divide);
            }
            BigDecimal refundIsMultAreaSubtract = remainingRefundableNum > 0 ? saleActualPayment.subtract(sumAfterAmount).divide(new BigDecimal(remainingRefundableNum), 2, 4) : saleActualPayment.subtract(sumAfterAmount);
            BigDecimal actualPayment = refundIsMultAreaSubtract.multiply(new BigDecimal(item.getItemNum()));
            calcuatedDto.setActualPayment(actualPayment);
            log.info("\u552e\u540e\u5355\uff1a{} \u6b63\u5411\u5b9e\u4ed8\u91d1\u989d-\u5df2\u9000\u6b3e\u91d1\u989d\u5408\u8ba1:{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)refundIsMultAreaSubtract);
            BigDecimal refundIsMultAreaRatioSubtract = refundIsMultAreaSubtract.multiply(commissionPrice).setScale(2, 4);
            BigDecimal refundIsMultAreaItemPrice = refundIsMultAreaSubtract.subtract(refundIsMultAreaRatioSubtract).multiply(new BigDecimal(item.getItemNum()));
            log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u9000\u8d27\u9000\u6b3e\u6362\u8d27\u8bb0\u8d26\u91d1\u989d\u5904\u7406refundIsMultAreaItemPrice:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)refundIsMultAreaItemPrice);
            calcuatedDto.setItemPrice(refundIsMultAreaItemPrice);
        }
        calcuatedDto.setNeedKeep(Boolean.TRUE);
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u9000\u8d27\u9000\u6b3e\u6362\u8d27\u8bb0\u8d26\u91d1\u989d\uff1a{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getId(), JSONObject.toJSONString((Object)calcuatedDto)});
        return calcuatedDto;
    }

    private MatchRelatedTradeShopKeepDto getMatchRelatedTradeShopKeepDto(KeepAccountsDetailEo detailEo) {
        MatchRelatedTradeShopKeepDto keepDto = new MatchRelatedTradeShopKeepDto();
        keepDto.setRelatedTradeMatchResult(Boolean.TRUE);
        keepDto.setSiteCode(detailEo.getSiteCode());
        keepDto.setSiteName(detailEo.getSiteName());
        keepDto.setRuleCode(detailEo.getRuleCode());
        keepDto.setRuleName(detailEo.getRuleName());
        keepDto.setPlatformSellerEntityNumber(detailEo.getPlatformSellerEntityNumber());
        keepDto.setRelatedEntityNumber(detailEo.getRelatedEntityNumber());
        keepDto.setRelatedEntityId(detailEo.getRelatedEntityId());
        keepDto.setRelatedEntityName(detailEo.getRelatedEntityName());
        keepDto.setCustomerId(detailEo.getCustomerId());
        keepDto.setCustomerCode(detailEo.getCustomerCode());
        keepDto.setCustomerName(detailEo.getCustomerName());
        keepDto.setSaleAreaId(detailEo.getSaleAreaId());
        keepDto.setSaleAreaCode(detailEo.getSaleAreaCode());
        keepDto.setSaleAreaName(detailEo.getSaleAreaName());
        keepDto.setSaleDeptId(detailEo.getSaleDeptId());
        keepDto.setSaleDeptCode(detailEo.getSaleDeptCode());
        keepDto.setSaleDeptName(detailEo.getSaleDeptName());
        keepDto.setCompanyCode(detailEo.getCompanyCode());
        keepDto.setCompanyName(detailEo.getCompanyName());
        keepDto.setCommission(detailEo.getCommission());
        keepDto.setOwnEntity(detailEo.getOwnEntity());
        keepDto.setShopId(detailEo.getShopId());
        keepDto.setShopCode(detailEo.getShopCode());
        keepDto.setShopName(detailEo.getShopName());
        keepDto.setOrderOrgCode(detailEo.getOrderOrgCode());
        keepDto.setEffectBeginTime(detailEo.getEffectBeginTime());
        keepDto.setEffectEndTime(detailEo.getEffectEndTime());
        keepDto.setZxSaleOrderItemId(detailEo.getOrderItemId());
        keepDto.setExternalCustomerId(detailEo.getExternalCustomerId());
        return keepDto;
    }

    @Override
    public KeepAmountCalcuatedDto calculatedSubsidiesTypeAndIsMultiAreaKeepAmount(ShopEo shopEo, AfterSaleOrderEo afterSaleOrderEo, SaleOrderItemVo saleOrderItemVo, AfterSaleOrderItemDto item, Map<Long, KeepAccountsDetailEo> saleDetailMap, String voucherType) {
        List collect;
        KeepAccountsDetailEo detailEo = saleDetailMap.get(item.getSaleOrderItemId());
        if (Objects.isNull(detailEo)) {
            return new KeepAmountCalcuatedDto();
        }
        log.info("\u4e00\u54c1\u591a\u5730\u6b63\u5411\u8ba2\u5355\u8bb0\u8d26\u4fe1\u606f\uff1a\u9500\u552e\u5355\u53f7{}\uff1a\u5b9e\u4ed8\u91d1\u989d\uff1a{},\u4f63\u91d1\u6bd4\u4f8b\uff1a{}\uff0c\u5dee\u4ef7\uff1a{}", new Object[]{saleOrderItemVo.getSaleOrderNo(), detailEo.getActualPayment(), detailEo.getCommission(), detailEo.getDifferential()});
        BigDecimal saleActualPayment = null == detailEo.getActualPayment() ? BigDecimal.ZERO : detailEo.getActualPayment();
        BigDecimal saleItemPrice = detailEo.getItemPrice();
        String commission = null != detailEo.getCommission() ? detailEo.getCommission() : "0";
        Integer zxItemNum = detailEo.getItemNum();
        BigDecimal commissionPrice = new BigDecimal(commission).divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal saleDifferential = null == detailEo.getDifferential() ? BigDecimal.ZERO : detailEo.getDifferential();
        BigDecimal refundActualPayment = Objects.equals(shopEo.getManageType(), 1) ? item.getRefundAmount() : item.getSupplyPrice();
        log.info("\u552e\u540e\u5355\uff1a{},SKU:{},\u552e\u540e\u9000\u6b3e\u7533\u8bf7\u91d1\u989d:{},", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getSkuCode(), refundActualPayment});
        KeepAmountCalcuatedDto calcuatedDto = new KeepAmountCalcuatedDto();
        calcuatedDto.setCommission(commission);
        calcuatedDto.setOrderNo(afterSaleOrderEo.getAfterSaleOrderNo());
        calcuatedDto.setZxOrderItemId(detailEo.getOrderItemId());
        calcuatedDto.setSaleActualPayment(saleActualPayment);
        calcuatedDto.setOrderItemId(item.getId());
        calcuatedDto.setPlatformOrderNo(afterSaleOrderEo.getPlatformOrderNo());
        calcuatedDto.setSaleItemPrice(saleItemPrice);
        calcuatedDto.setSaleDifferential(saleDifferential);
        calcuatedDto.setAfterSaleOrderType(afterSaleOrderEo.getAfterSaleOrderType());
        calcuatedDto.setRelatedTradeShopKeepDto(this.getMatchRelatedTradeShopKeepDto(detailEo));
        if (null != refundActualPayment && refundActualPayment.compareTo(BigDecimal.ZERO) == 0) {
            calcuatedDto.setItemPrice(refundActualPayment);
            calcuatedDto.setActualPayment(refundActualPayment);
            calcuatedDto.setNeedKeep(Boolean.TRUE);
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u662f\u5426\u4e3a\u8d60\u54c1:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)JSONObject.toJSONString((Object)calcuatedDto));
            return calcuatedDto;
        }
        List<KeepAccountsDetailEo> afterAccountsDetailEo = this.getAfterKeepAccountsDetailList(detailEo.getOrderItemId(), detailEo.getOrderNo(), voucherType);
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u83b7\u53d6\u6b63\u5411\u9500\u552e\u8ba2\u5355\u5bf9\u5e94\u5176\u4ed6\u552e\u540e\u5355\u8bb0\u8d26\u660e\u7ec6:{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), detailEo.getOrderNo(), JSONObject.toJSONString(afterAccountsDetailEo)});
        BigDecimal sumAfterAmount = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(afterAccountsDetailEo) && CollectionUtil.isNotEmpty(collect = afterAccountsDetailEo.stream().filter(x -> null != x.getActualPayment()).collect(Collectors.toList()))) {
            sumAfterAmount = sumAfterAmount.add(collect.stream().map(KeepAccountsDetailEo::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4));
        }
        log.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u5df2\u9000\u6b3e\u91d1\u989d\u5408\u8ba1:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)sumAfterAmount);
        List keepAccountsDetailEos = afterAccountsDetailEo.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOrderType()) && !Objects.equals(x.getOrderType(), BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())).collect(Collectors.toList());
        Integer itemNum = CollectionUtil.isEmpty(keepAccountsDetailEos) ? Integer.valueOf(0) : keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getItemNum).reduce(Integer::sum).get();
        Integer remainingRefundableNum = detailEo.getItemNum() - itemNum;
        log.info("\u5269\u4f59\u53ef\u9000\u6570\u91cf\uff1a{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)remainingRefundableNum);
        if (Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.FHHTK.getCode()) || Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.THTK.getCode()) || Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.HH.getCode())) {
            if (Objects.equals(afterSaleOrderEo.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.FHHTK.getCode())) {
                BigDecimal subtract;
                log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u552e\u540e\u6b63\u5411\u5bf9\u5e94\u5b9e\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6bd4\u8f83\uff1a{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), saleActualPayment, detailEo.getOrderNo()});
                if (null != saleActualPayment && saleActualPayment.compareTo(BigDecimal.ZERO) > 0 && refundActualPayment.compareTo(saleActualPayment) > 0) {
                    log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u552e\u540e\u8bb0\u8d26\u91d1\u989d\u5927\u4e8e\u539f\u5355\u5546\u54c1\u884c\u5b9e\u4ed8\u91d1\u989d,\u4e0d\u8fdb\u884c\u8bb0\u8d26:{},{},SKU:{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getId(), item.getSkuCode()});
                    calcuatedDto.setNeedKeep(Boolean.FALSE);
                    calcuatedDto.setActualPayment(refundActualPayment);
                    calcuatedDto.setItemPrice(refundActualPayment);
                    return calcuatedDto;
                }
                if (null != saleActualPayment && saleActualPayment.compareTo(BigDecimal.ZERO) > 0 && refundActualPayment.compareTo(subtract = saleActualPayment.subtract(sumAfterAmount)) > 0) {
                    log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u552e\u540e\u8bb0\u8d26\u91d1\u989d\u5927\u4e8e\u539f\u5355\u5546\u54c1\u7684\u5b9e\u4ed8\u91d1\u989d\u51cf\u53bb\u5df2\u9000\u6b3e\u91d1\u989d\u5408\u8ba1,\u4e0d\u8fdb\u884c\u8bb0\u8d26:{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)item.getId());
                    calcuatedDto.setNeedKeep(Boolean.FALSE);
                    calcuatedDto.setActualPayment(refundActualPayment);
                    calcuatedDto.setItemPrice(refundActualPayment);
                    return calcuatedDto;
                }
                BigDecimal multiply = refundActualPayment.multiply(commissionPrice);
                BigDecimal decimal = multiply.setScale(2, 4);
                BigDecimal refundIsMultAreaItemPrice = refundActualPayment.subtract(decimal);
                log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8bb0\u8d26\u91d1\u989d\u5904\u7406refundIsMultAreaItemPrice:{},{},{}", (Object)afterSaleOrderEo.getAfterSaleOrderNo(), (Object)refundIsMultAreaItemPrice);
                calcuatedDto.setDifferential(decimal.compareTo(BigDecimal.ZERO) > 0 ? decimal : BigDecimal.ZERO);
                calcuatedDto.setItemPrice(refundIsMultAreaItemPrice);
                calcuatedDto.setActualPayment(refundActualPayment);
                calcuatedDto.setNeedKeep(Boolean.TRUE);
                log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u8bb0\u8d26\u91d1\u989d\uff1a{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getId(), JSONObject.toJSONString((Object)calcuatedDto)});
                return calcuatedDto;
            }
            BigDecimal divide = saleActualPayment.subtract(sumAfterAmount).divide(new BigDecimal(remainingRefundableNum), 2, 4);
            log.info("divide:{}", (Object)divide);
            BigDecimal multiply = divide.multiply(commissionPrice).compareTo(BigDecimal.ZERO) > 0 ? divide.multiply(commissionPrice).setScale(2, 4) : BigDecimal.ZERO;
            log.info("multiply:{}", (Object)multiply);
            BigDecimal itemPrice = divide.subtract(multiply).multiply(new BigDecimal(item.getItemNum())).setScale(2, 4);
            log.info("itemPrice:{}", (Object)itemPrice);
            calcuatedDto.setItemPrice(itemPrice);
            BigDecimal actualPayment = saleActualPayment.subtract(sumAfterAmount).divide(new BigDecimal(remainingRefundableNum), 2, 4).multiply(new BigDecimal(item.getItemNum()));
            log.info("actualPayment:{}", (Object)actualPayment);
            calcuatedDto.setActualPayment(actualPayment);
            BigDecimal differential = actualPayment.multiply(commissionPrice).setScale(2, 4);
            log.info("differential:{}", (Object)differential);
            calcuatedDto.setDifferential(differential.compareTo(BigDecimal.ZERO) > 0 ? differential : BigDecimal.ZERO);
            calcuatedDto.setNeedKeep(Boolean.TRUE);
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e/\u9000\u8d27\u9000\u6b3e\u56fd\u8865\u4e00\u54c1\u591a\u5730\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u8bb0\u8d26\u91d1\u989d\uff1a{},{},{}", new Object[]{afterSaleOrderEo.getAfterSaleOrderNo(), item.getId(), JSONObject.toJSONString((Object)calcuatedDto)});
        }
        return calcuatedDto;
    }
}

