/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.ItemRuleConverter;
import com.yunxi.dg.base.center.finance.dao.das.IItemRuleDas;
import com.yunxi.dg.base.center.finance.domain.entity.IItemRuleDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ItemRuleDto;
import com.yunxi.dg.base.center.finance.dto.request.ItemRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.response.ItemRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.ItemRuleEo;
import com.yunxi.dg.base.center.finance.service.entity.IItemRuleService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemRuleServiceImpl
extends BaseServiceImpl<ItemRuleDto, ItemRuleEo, IItemRuleDomain>
implements IItemRuleService {
    @Resource
    private IItemRuleDas itemRuleDas;
    @Resource
    private IItemRuleDomain iItemRuleDomain;

    public ItemRuleServiceImpl(IItemRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ItemRuleDto, ItemRuleEo> converter() {
        return ItemRuleConverter.INSTANCE;
    }

    @Override
    public Long addItemRule(ItemRuleReqDto addReqDto) {
        ItemRuleEo itemRuleEo = new ItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemRuleEo);
        this.itemRuleDas.insert((BaseEo)itemRuleEo);
        return itemRuleEo.getId();
    }

    @Override
    public void modifyItemRule(ItemRuleReqDto modifyReqDto) {
        ItemRuleEo itemRuleEo = new ItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemRuleEo);
        this.itemRuleDas.updateSelective((BaseEo)itemRuleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemRuleRespDto queryById(Long id) {
        ItemRuleEo itemRuleEo = (ItemRuleEo)this.itemRuleDas.selectByPrimaryKey(id);
        ItemRuleRespDto itemRuleRespDto = new ItemRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)itemRuleEo, (BaseVo)itemRuleRespDto);
        return itemRuleRespDto;
    }

    @Override
    public PageInfo<ItemRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemRuleReqDto itemRuleReqDto = (ItemRuleReqDto)JSON.parseObject((String)filter, ItemRuleReqDto.class);
        ItemRuleEo itemRuleEo = new ItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)itemRuleReqDto, (BaseEo)itemRuleEo);
        PageInfo eoPageInfo = this.iItemRuleDomain.selectPage((BaseEo)itemRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemRuleRespDto> page(ItemRuleReqDto ruleReqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemRuleDas.filter().orderByDesc((Object)"id");
        if (Objects.nonNull(ruleReqDto) && StringUtils.isNotBlank((CharSequence)ruleReqDto.getItemCode())) {
            sqlFilters.like((Object)"item_code", (Object)ruleReqDto.getItemCode());
        }
        if (Objects.nonNull(ruleReqDto) && StringUtils.isNotBlank((CharSequence)ruleReqDto.getItemName())) {
            sqlFilters.like((Object)"item_name", (Object)ruleReqDto.getItemName());
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

