/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.KeepItemRuleConverter;
import com.yunxi.dg.base.center.finance.dao.das.IKeepItemRuleDas;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepItemRuleDomain;
import com.yunxi.dg.base.center.finance.dto.entity.KeepItemRuleDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepItemRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepItemRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepItemRuleEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepItemRuleService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepItemRuleServiceImpl
extends BaseServiceImpl<KeepItemRuleDto, KeepItemRuleEo, IKeepItemRuleDomain>
implements IKeepItemRuleService {
    @Resource
    private IKeepItemRuleDas keepItemRuleDas;
    @Resource
    private IKeepItemRuleDomain keepItemRuleDomain;

    public KeepItemRuleServiceImpl(IKeepItemRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepItemRuleDto, KeepItemRuleEo> converter() {
        return KeepItemRuleConverter.INSTANCE;
    }

    @Override
    public Long addKeepItemRule(KeepItemRuleReqDto addReqDto) {
        KeepItemRuleEo keepItemRuleEo = new KeepItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)keepItemRuleEo);
        this.keepItemRuleDas.insert((BaseEo)keepItemRuleEo);
        return keepItemRuleEo.getId();
    }

    @Override
    public void modifyKeepItemRule(KeepItemRuleReqDto modifyReqDto) {
        KeepItemRuleEo keepItemRuleEo = new KeepItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)keepItemRuleEo);
        this.keepItemRuleDas.updateSelective((BaseEo)keepItemRuleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeKeepItemRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.keepItemRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public KeepItemRuleRespDto queryById(Long id) {
        KeepItemRuleEo keepItemRuleEo = (KeepItemRuleEo)this.keepItemRuleDas.selectByPrimaryKey(id);
        KeepItemRuleRespDto keepItemRuleRespDto = new KeepItemRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)keepItemRuleEo, (BaseVo)keepItemRuleRespDto);
        return keepItemRuleRespDto;
    }

    @Override
    public PageInfo<KeepItemRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        KeepItemRuleReqDto keepItemRuleReqDto = (KeepItemRuleReqDto)JSON.parseObject((String)filter, KeepItemRuleReqDto.class);
        KeepItemRuleEo keepItemRuleEo = new KeepItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)keepItemRuleReqDto, (BaseEo)keepItemRuleEo);
        PageInfo eoPageInfo = this.keepItemRuleDomain.selectPage((BaseEo)keepItemRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepItemRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<KeepItemRuleRespDto> page(KeepItemRuleReqDto ruleReqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.keepItemRuleDas.filter().orderByDesc((Object)"id");
        if (Objects.nonNull(ruleReqDto) && StringUtils.isNotBlank((CharSequence)ruleReqDto.getItemCode())) {
            sqlFilters.like((Object)"item_code", (Object)ruleReqDto.getItemCode());
        }
        if (Objects.nonNull(ruleReqDto) && StringUtils.isNotBlank((CharSequence)ruleReqDto.getItemName())) {
            sqlFilters.like((Object)"item_name", (Object)ruleReqDto.getItemName());
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepItemRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

