/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.trade.dto.entity.BatchUpdateInvoiceDto;
import com.dtyunxi.yundt.cube.center.trade.dto.entity.SaleOrderBillRecordReqProxyDto;
import com.dtyunxi.yundt.cube.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.dtyunxi.yundt.cube.center.trade.proxy.entity.ISaleOrderBillRecordApiProxy;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dao.das.IBillEntityDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyNoInvoiceItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.ISaleOrderBillRecordDas;
import com.yunxi.dg.base.center.finance.dao.vo.OrderMergeBillInfoQueryVo;
import com.yunxi.dg.base.center.finance.dao.vo.PlatformOrderFinishNoBillRespVo;
import com.yunxi.dg.base.center.finance.dto.entity.ItemRateDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemSkuDgDto;
import com.yunxi.dg.base.center.finance.dto.enums.AfterInvoiceFlagEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AllRedFlagEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillCreateTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillRowNameTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTitleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GiftEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GiftType;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.RelBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderInvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.WhetherMergeBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.OrderMergeBillInfoQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.OrderMergeBillInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.OrderMergeRedAgainBillReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BatchOperationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderMergeBillInfoRespDto;
import com.yunxi.dg.base.center.finance.eo.BillEntityEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.eo.BillOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyNoInvoiceItemEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.SaleOrderBillRecordEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillBusinessRelPlatformService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.IItemDgService;
import com.yunxi.dg.base.center.finance.service.entity.IMergeBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.finance.service.utils.GenerateCodeDataUtils;
import com.yunxi.dg.base.center.finance.service.utils.PageInfoUtil;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MergeBillInfoServiceImpl
implements IMergeBillInfoService {
    private static final Logger logger = LoggerFactory.getLogger(MergeBillInfoServiceImpl.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private ISaleOrderBillRecordDas saleOrderBillRecordDas;
    @Resource
    private IPerformOrderInfoDas performOrderInfoDas;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IDgAfterSaleOrderApiProxy afterSaleOrderApiProxy;
    @Resource
    private ILockService lockService;
    @Resource
    private GenerateCodeDataUtils generateCodeDataUtils;
    @Resource
    private IShopService shopService;
    @Resource
    private IBillEntityDas billEntityDas;
    @Resource
    private IBillBusinessRelPlatformService billBusinessRelPlatformService;
    @Resource
    private IBillOrderItemDas billOrderItemDas;
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private ISaleOrderBillRecordApiProxy saleOrderBillRecordApi;
    @Resource
    private IContext context;
    @Resource
    private IBillStrategyNoInvoiceItemDas billStrategyNoInvoiceItemDas;
    @Resource
    private IBillInfoService billInfoService;

    @Override
    public PageInfo<OrderMergeBillInfoRespDto> getOrderMergeBillInfoPage(OrderMergeBillInfoQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u5408\u5e76\u5f00\u7968\u6700\u65b0\u8ba2\u5355\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)queryDto));
        this.checkParamQueryMergeBillPage(queryDto);
        BillStrategyRespDto billStrategyRespDto = this.checkBillStrategyShop(queryDto.getShopCode());
        List<PlatformOrderFinishNoBillRespVo> list = this.getMergeBillDate(queryDto);
        if (CollectionUtils.isEmpty(list)) {
            throw new BizException("\u5f53\u524d\u6ca1\u6709\u53ef\u4ee5\u5f00\u7968\u6570\u636e");
        }
        if (list.stream().map(PlatformOrderFinishNoBillRespVo::getPlatformOrderNo).count() > 1000L) {
            throw new BizException("\u5408\u5e76\u5f00\u7968\u5e73\u53f0\u5355\u6570\u91cf\u5927\u4e8e1000\u65e0\u6cd5\u5408\u5e76,\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        List<OrderMergeBillInfoRespDto> orderMergeBillList = this.getOrderMergeBillList(list, billStrategyRespDto);
        return PageInfoUtil.selectPage(orderMergeBillList, queryDto.getPageNum(), queryDto.getPageSize());
    }

    public List<PlatformOrderFinishNoBillRespVo> getMergeBillDate(OrderMergeBillInfoQueryDto queryDto) {
        List<PlatformOrderFinishNoBillRespVo> afterOrderFinish;
        ArrayList<PlatformOrderFinishNoBillRespVo> list = new ArrayList<PlatformOrderFinishNoBillRespVo>();
        List<PlatformOrderFinishNoBillRespVo> platformOrderFinish = this.getPlatformOrderFinish(queryDto);
        if (CollectionUtils.isNotEmpty(platformOrderFinish)) {
            list.addAll(platformOrderFinish);
        }
        if (CollectionUtils.isNotEmpty(afterOrderFinish = this.getAfterOrderFinish(queryDto))) {
            list.addAll(afterOrderFinish);
        }
        return list;
    }

    public void checkParamQueryMergeBillPage(OrderMergeBillInfoQueryDto queryDto) {
        AssertUtil.isTrue(Objects.nonNull(queryDto.getPageNum()) && queryDto.getPageNum() > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(queryDto.getPageSize()) && queryDto.getPageSize() > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)queryDto.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)queryDto.getStartTime()), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)queryDto.getEndTime()), "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)queryDto.getShopCode()), "\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public BillStrategyRespDto checkBillStrategyShop(String shopCode) {
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.MERGE_BILL.getCode());
        if (Objects.nonNull(billStrategyRespDto) && null != billStrategyRespDto.getId()) {
            return billStrategyRespDto;
        }
        throw new BizException(String.format("\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u5408\u5e76\u5f00\u7968\u7b56\u7565:%s", shopCode));
    }

    public List<PlatformOrderFinishNoBillRespVo> getPlatformOrderFinish(OrderMergeBillInfoQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u6b63\u5411\u5b8c\u6210\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)queryDto));
        OrderMergeBillInfoQueryVo orderMergeBillInfoQueryVo = new OrderMergeBillInfoQueryVo();
        CubeBeanUtils.copyProperties((Object)orderMergeBillInfoQueryVo, (Object)queryDto, (String[])new String[0]);
        return this.saleOrderBillRecordDas.getPlatformOrderFinishNoBillList(orderMergeBillInfoQueryVo);
    }

    public List<PlatformOrderFinishNoBillRespVo> getAfterOrderFinish(OrderMergeBillInfoQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u9006\u5411\u5b8c\u6210\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)queryDto));
        OrderMergeBillInfoQueryVo orderMergeBillInfoQueryVo = new OrderMergeBillInfoQueryVo();
        CubeBeanUtils.copyProperties((Object)orderMergeBillInfoQueryVo, (Object)queryDto, (String[])new String[0]);
        return this.saleOrderBillRecordDas.getPlatformAfterOrderFinishNoBillList(orderMergeBillInfoQueryVo);
    }

    public List<OrderMergeBillInfoRespDto> getOrderMergeBillList(List<PlatformOrderFinishNoBillRespVo> respVoList, BillStrategyRespDto billStrategyRespDto) {
        List<String> skuCodeList = respVoList.stream().map(PlatformOrderFinishNoBillRespVo::getItemCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
        Map skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        ArrayList<OrderMergeBillInfoRespDto> orderMergeBillInfoRespDtoList = new ArrayList<OrderMergeBillInfoRespDto>();
        respVoList.forEach(resp -> {
            if (GiftType.YES.getCode().equals(billStrategyRespDto.getBillGift())) {
                OrderMergeBillInfoRespDto orderMergeBillInfoRespDto = this.generateInvoiceDetail(skuCodeMap, (PlatformOrderFinishNoBillRespVo)resp, billStrategyRespDto);
                orderMergeBillInfoRespDtoList.add(orderMergeBillInfoRespDto);
            } else if (GiftEnum.NOT_GIFT.getType().equals(resp.getGift())) {
                OrderMergeBillInfoRespDto orderMergeBillInfoRespDto = this.generateInvoiceDetail(skuCodeMap, (PlatformOrderFinishNoBillRespVo)resp, billStrategyRespDto);
                orderMergeBillInfoRespDtoList.add(orderMergeBillInfoRespDto);
            }
        });
        return orderMergeBillInfoRespDtoList;
    }

    public OrderMergeBillInfoRespDto generateInvoiceDetail(Map<String, ItemSkuDgDto> skuCodeMap, PlatformOrderFinishNoBillRespVo respVo, BillStrategyRespDto billStrategyRespDto) {
        OrderMergeBillInfoRespDto respDto = new OrderMergeBillInfoRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)respVo, (String[])new String[0]);
        ItemRateDgDto itemRateDgDto = new ItemRateDgDto();
        if (skuCodeMap.containsKey(respVo.getItemCode())) {
            ItemSkuDgDto itemSkuDgDto = skuCodeMap.get(respVo.getItemCode());
            respDto.setItemName(itemSkuDgDto.getName());
            respDto.setSpecification(itemSkuDgDto.getSpecModel());
            itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
        }
        respDto.setQuantity(respVo.getItemNum());
        respDto.setAmount(respVo.getAmount());
        this.handleBillLineItemName(itemRateDgDto, skuCodeMap, respVo, billStrategyRespDto, respDto);
        respDto.setUnit("\u53f0");
        return respDto;
    }

    public void handleBillLineItemName(ItemRateDgDto itemRateDgDto, Map<String, ItemSkuDgDto> skuCodeMap, PlatformOrderFinishNoBillRespVo respVo, BillStrategyRespDto billStrategyRespDto, OrderMergeBillInfoRespDto respDto) {
        if (null != itemRateDgDto && null != itemRateDgDto.getId()) {
            respDto.setTaxRate(itemRateDgDto.getRate());
            respDto.setTaxClassificationCode(itemRateDgDto.getCode());
            respDto.setTaxAmount(respVo.getAmount().divide(itemRateDgDto.getRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(itemRateDgDto.getRate()).setScale(2, 4));
            if (BillRowNameTypeEnum.TYPE_COMMODITY.getCode().equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)respDto.getItemName()) ? "" : respDto.getItemName();
                respDto.setBillLineItemName(itemDisplayName);
            } else if (BillRowNameTypeEnum.ELECTRONIC_NUMBER.getCode().equals(billStrategyRespDto.getBillRowName())) {
                if (skuCodeMap.containsKey(respVo.getItemCode())) {
                    ItemSkuDgDto itemSkuDgDto = skuCodeMap.get(respVo.getItemCode());
                    respDto.setBillLineItemName(itemSkuDgDto.getName());
                }
            } else {
                respDto.setBillLineItemName(respDto.getItemName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                respDto.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                respDto.setTaxAmount(respDto.getAmount().divide(respDto.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(respDto.getTaxRate()).setScale(2, 4));
            }
            if (BillRowNameTypeEnum.COMMODITY.getCode().equals(billStrategyRespDto.getBillRowName())) {
                respDto.setBillLineItemName(respDto.getItemName());
            } else if (BillRowNameTypeEnum.ELECTRONIC_NUMBER.getCode().equals(billStrategyRespDto.getBillRowName())) {
                if (skuCodeMap.containsKey(respVo.getItemCode())) {
                    ItemSkuDgDto itemSkuDgDto = skuCodeMap.get(respVo.getItemCode());
                    respDto.setBillLineItemName(itemSkuDgDto.getName());
                }
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)respDto.getItemName()) ? "" : respDto.getItemName();
                respDto.setBillLineItemName(itemDisplayName);
            }
            respDto.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addOrderMergeBill(OrderMergeBillInfoReqDto reqDto) {
        this.checkMergeBillInfoParams(reqDto);
        BillStrategyRespDto billStrategyRespDto = this.checkBillStrategyShop(reqDto.getShopCode());
        Mutex mutexBill = null;
        try {
            mutexBill = this.lockService.lock("merge_bill_info_key", "merge_bill_info_key", 10, 20, TimeUnit.SECONDS);
            if (null == mutexBill) {
                throw new BizException("\u670d\u52a1\u5668\u7e41\u5fd9\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            OrderMergeBillInfoQueryDto queryDto = new OrderMergeBillInfoQueryDto();
            CubeBeanUtils.copyProperties((Object)queryDto, (Object)reqDto, (String[])new String[0]);
            List<PlatformOrderFinishNoBillRespVo> list = this.getMergeBillDate(queryDto);
            List<PlatformOrderFinishNoBillRespVo> filterList = this.filterNoInvoiceItem(billStrategyRespDto, list);
            Map<String, List<PlatformOrderFinishNoBillRespVo>> typeMap = filterList.stream().collect(Collectors.groupingBy(PlatformOrderFinishNoBillRespVo::getType));
            this.checkAddMergeBillCondition(typeMap);
            this.assembleMergeBillInfo(filterList, billStrategyRespDto, reqDto, typeMap);
            if (mutexBill == null) return;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("\u5408\u5e76\u5f00\u7968\u5f02\u5e38:\u3010%s\u3011", e.getLocalizedMessage()), (Throwable)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (mutexBill == null) throw throwable;
                this.lockService.unlock(mutexBill);
                throw throwable;
            }
        }
        this.lockService.unlock(mutexBill);
        return;
    }

    public List<PlatformOrderFinishNoBillRespVo> filterNoInvoiceItem(BillStrategyRespDto billStrategyRespDto, List<PlatformOrderFinishNoBillRespVo> list) {
        ArrayList<PlatformOrderFinishNoBillRespVo> respVoList = new ArrayList<PlatformOrderFinishNoBillRespVo>();
        list.forEach(resp -> {
            if (GiftType.YES.getCode().equals(billStrategyRespDto.getBillGift())) {
                respVoList.add((PlatformOrderFinishNoBillRespVo)resp);
            } else if (GiftEnum.NOT_GIFT.getType().equals(resp.getGift())) {
                respVoList.add((PlatformOrderFinishNoBillRespVo)resp);
            }
        });
        List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
        if (CollectionUtils.isNotEmpty((Collection)noInvoiceItemEoList)) {
            Map itemEoMap = noInvoiceItemEoList.stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
            return respVoList.stream().filter(x -> !itemEoMap.containsKey(x.getItemCode())).collect(Collectors.toList());
        }
        return respVoList;
    }

    public void checkAddMergeBillCondition(Map<String, List<PlatformOrderFinishNoBillRespVo>> typeMap) {
        if (CollectionUtil.isEmpty(typeMap)) {
            throw new BizException("\u5f53\u524d\u6ca1\u6709\u53ef\u4ee5\u5f00\u7968\u6570\u636e");
        }
        List<PlatformOrderFinishNoBillRespVo> order = typeMap.get("order");
        BigDecimal orderAmount = ((List)Optional.ofNullable(order).orElse(new ArrayList())).stream().map(PlatformOrderFinishNoBillRespVo::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<PlatformOrderFinishNoBillRespVo> after = typeMap.get("after");
        BigDecimal afterAmount = ((List)Optional.ofNullable(after).orElse(new ArrayList())).stream().map(PlatformOrderFinishNoBillRespVo::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        logger.info("\u6b63\u9006\u5411\u91d1\u989d\u5bf9\u6bd4:{},{}", (Object)orderAmount, (Object)afterAmount);
        if (afterAmount.compareTo(orderAmount) >= 0) {
            throw new BizException("\u552e\u540e\u91d1\u989d\u5927\u4e8e/\u7b49\u4e8e\u8ba2\u5355\u91d1\u989d\u65e0\u6cd5\u521b\u5efa\u53d1\u7968");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void assembleMergeBillInfo(List<PlatformOrderFinishNoBillRespVo> list, BillStrategyRespDto billStrategyRespDto, OrderMergeBillInfoReqDto reqDto, Map<String, List<PlatformOrderFinishNoBillRespVo>> typeMap) {
        List<PlatformOrderFinishNoBillRespVo> billData = this.amountOffset(typeMap);
        this.generateMergeBillInfo(billData, billStrategyRespDto, reqDto, list, typeMap);
    }

    public String getPlatformOrderNoList(List<PlatformOrderFinishNoBillRespVo> list) {
        return list.stream().map(PlatformOrderFinishNoBillRespVo::getPlatformOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(","));
    }

    public List<PlatformOrderFinishNoBillRespVo> amountOffset(Map<String, List<PlatformOrderFinishNoBillRespVo>> typeMap) {
        List<PlatformOrderFinishNoBillRespVo> afterList = typeMap.get("after");
        BigDecimal afterAmount = ((List)Optional.ofNullable(afterList).orElse(new ArrayList())).stream().map(PlatformOrderFinishNoBillRespVo::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<PlatformOrderFinishNoBillRespVo> orderList = typeMap.get("order");
        ArrayList<PlatformOrderFinishNoBillRespVo> billData = new ArrayList<PlatformOrderFinishNoBillRespVo>();
        if (CollectionUtils.isNotEmpty(orderList)) {
            for (PlatformOrderFinishNoBillRespVo order : orderList) {
                PlatformOrderFinishNoBillRespVo info = new PlatformOrderFinishNoBillRespVo();
                CubeBeanUtils.copyProperties((Object)info, (Object)order, (String[])new String[0]);
                if (afterAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    billData.add(info);
                    continue;
                }
                if (afterAmount.compareTo(info.getAmount()) >= 0) {
                    afterAmount = afterAmount.subtract(info.getAmount());
                    continue;
                }
                info.setAmount(info.getAmount().subtract(afterAmount));
                billData.add(info);
                afterAmount = BigDecimal.ZERO;
            }
        }
        return billData;
    }

    public void generateMergeBillInfo(List<PlatformOrderFinishNoBillRespVo> billData, BillStrategyRespDto billStrategyRespDto, OrderMergeBillInfoReqDto reqDto, List<PlatformOrderFinishNoBillRespVo> list, Map<String, List<PlatformOrderFinishNoBillRespVo>> typeMap) {
        List<BillItemEo> mergeBillItem;
        BillInfoEo billInfoEo;
        if (CollectionUtils.isNotEmpty(billData)) {
            String platformOrderNoListStr = this.getPlatformOrderNoList(list);
            billInfoEo = new BillInfoEo();
            this.getMergeBillInfo(billInfoEo, billStrategyRespDto, reqDto, platformOrderNoListStr, billData.get(0));
            mergeBillItem = this.getMergeBillItem(billData, billStrategyRespDto, list, billInfoEo);
            if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType()) && null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType())) {
                String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCode();
                if (billStrategyRespDto.getBillApplyType().contains(code)) {
                    this.mergeBillAutoAuditCheck(billInfoEo, mergeBillItem);
                }
            }
        } else {
            throw new BizException("\u672a\u83b7\u53d6\u5230\u53ef\u4ee5\u5f00\u7968\u7684\u6570\u636e");
        }
        this.billInfoService.checkAndSetBlacklist(billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        this.updateOrderBillInfo(typeMap, billInfoEo);
        this.syncAddKingdeeMergeInvoice(billInfoEo, mergeBillItem, false);
    }

    public void updateOrderBillInfo(Map<String, List<PlatformOrderFinishNoBillRespVo>> typeMap, BillInfoEo billInfoEo) {
        List<PlatformOrderFinishNoBillRespVo> afterList;
        List<PlatformOrderFinishNoBillRespVo> orderList = typeMap.get("order");
        if (CollectionUtils.isNotEmpty(orderList)) {
            List<String> platformOrderNoList = orderList.stream().map(PlatformOrderFinishNoBillRespVo::getPlatformOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            this.updateOrderMergeBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_BILL.getCode(), platformOrderNoList);
        }
        if (CollectionUtils.isNotEmpty(afterList = typeMap.get("after"))) {
            List orderNoList = afterList.stream().map(PlatformOrderFinishNoBillRespVo::getOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            BatchUpdateInvoiceDto batchUpdateInvoiceDto = new BatchUpdateInvoiceDto();
            batchUpdateInvoiceDto.setAfterSaleOrderNoList(orderNoList);
            batchUpdateInvoiceDto.setInvoice(AfterInvoiceFlagEnum.YES_INVOICE.getCode());
            this.afterSaleOrderApiProxy.batchUpdateInvoiceByAfterSaleOrderNos(batchUpdateInvoiceDto);
        }
    }

    public void getMergeBillInfo(BillInfoEo billInfoEo, BillStrategyRespDto billStrategyRespDto, OrderMergeBillInfoReqDto reqDto, String platformOrderNoListStr, PlatformOrderFinishNoBillRespVo respVo) {
        String billFlowNo = this.generateCodeDataUtils.generateNo("KP");
        billInfoEo.setSumTimeStart(DateUtil.parseDate((String)reqDto.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        billInfoEo.setSumTimeEnd(DateUtil.parseDate((String)reqDto.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        billInfoEo.setBillFlowNo(billFlowNo);
        billInfoEo.setPlatformOrderNo(platformOrderNoListStr);
        billInfoEo.setWhetherMergeBill(WhetherMergeBillTypeEnum.YES_MERGE.getCode());
        billInfoEo.setShopId(respVo.getShopId());
        billInfoEo.setShopCode(respVo.getShopCode());
        billInfoEo.setSite(respVo.getSiteName());
        billInfoEo.setSiteCode(respVo.getSiteCode());
        ShopEo shopOrganizationCode = this.shopService.selectShopByCode(respVo.getShopCode());
        billInfoEo.setOrganizationCode(shopOrganizationCode.getOrganizationCode());
        billInfoEo.setShopName(respVo.getShopName());
        billInfoEo.setCustomerCode(respVo.getCustomerCode());
        billInfoEo.setCustomerName(respVo.getCustomerName());
        billInfoEo.setInvoiceType(reqDto.getInvoiceType());
        billInfoEo.setTitleType(reqDto.getTitleType());
        billInfoEo.setBillTitle(reqDto.getBillTitle());
        billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)reqDto.getTaxesCode()) ? reqDto.getTaxesCode().replace(" ", "") : null);
        billInfoEo.setRegisteredAddress(reqDto.getRegisteredAddress());
        billInfoEo.setRegisteredPhone(reqDto.getRegisteredPhone());
        billInfoEo.setBankAccount(reqDto.getBankAccount());
        billInfoEo.setBank(reqDto.getBank());
        billInfoEo.setMailbox(reqDto.getMailbox());
        billInfoEo.setPhone(reqDto.getPhone());
        billInfoEo.setBillPersonPhone(reqDto.getBillPersonPhone());
        billInfoEo.setBillPersonName(reqDto.getBillPersonName());
        billInfoEo.setBillAddress(reqDto.getBillAddress());
        BillEntityEo entityEo = new BillEntityEo();
        if (null != billStrategyRespDto.getBillEntityCode()) {
            entityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billStrategyRespDto.getBillEntityCode())).one();
        }
        billInfoEo.setDistributorRegisteredAddress(entityEo.getRegisteredAddress());
        billInfoEo.setDistributorRegisteredPhone(entityEo.getRegisteredPhone());
        billInfoEo.setDistributorTaxesCode(entityEo.getTaxesCode());
        billInfoEo.setDistributorBank(entityEo.getBank());
        billInfoEo.setDistributorBankAccount(entityEo.getBankAccount());
        billInfoEo.setCollectPerson(entityEo.getCollectPerson());
        billInfoEo.setBillPerson(entityEo.getBillPerson());
        billInfoEo.setReviewPerson(entityEo.getReviewPerson());
        billInfoEo.setEntityId(entityEo.getId());
        billInfoEo.setEntityCode(entityEo.getEntityCode());
        billInfoEo.setEntityName(entityEo.getEntityName());
        billInfoEo.setEnterprise(entityEo.getEnterprise());
        billInfoEo.setCreateType(BillCreateTypeEnum.SYSTEM.getCode());
        billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        billInfoEo.setBillChannel(billStrategyRespDto.getBillChannel());
        billInfoEo.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
    }

    public List<BillItemEo> getMergeBillItem(List<PlatformOrderFinishNoBillRespVo> billData, BillStrategyRespDto billStrategyRespDto, List<PlatformOrderFinishNoBillRespVo> list, BillInfoEo billInfoEo) {
        List<String> skuCodeList = list.stream().map(PlatformOrderFinishNoBillRespVo::getItemCode).distinct().collect(Collectors.toList());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
        Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        Map<String, List<PlatformOrderFinishNoBillRespVo>> platformItemMap = billData.stream().collect(Collectors.groupingBy(x -> x.getPlatformOrderNo() + "_" + x.getItemCode()));
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        platformItemMap.forEach((k, v) -> {
            BillItemEo billItemEo = new BillItemEo();
            PlatformOrderFinishNoBillRespVo respVo = (PlatformOrderFinishNoBillRespVo)v.get(0);
            CubeBeanUtils.copyProperties((Object)billItemEo, (Object)respVo, (String[])new String[0]);
            ItemRateDgDto itemRateDgDto = new ItemRateDgDto();
            if (skuCodeMap.containsKey(respVo.getItemCode())) {
                ItemSkuDgDto itemEo = (ItemSkuDgDto)skuCodeMap.get(respVo.getItemCode());
                billItemEo.setItemName(itemEo.getName());
                billItemEo.setItemShortName(itemEo.getName());
                billItemEo.setSpecification(itemEo.getSpecModel());
                itemRateDgDto = itemEo.getItemRateDgDto();
            }
            billItemEo.setQuantity(v.stream().map(PlatformOrderFinishNoBillRespVo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
            BigDecimal amount = v.stream().map(info -> Objects.nonNull(info.getAmount()) ? info.getAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItemEo.setAmount(amount);
            billItemEo.setClinchDealAmount(amount);
            number.set(((BigDecimal)number.get()).add(amount));
            billItemEo.setPlatformOrderNo(respVo.getPlatformOrderNo());
            billItemEo.setUnitPrice(respVo.getSalePrice());
            this.getBillLineItemName(itemRateDgDto, skuCodeMap, respVo, billStrategyRespDto, billItemEo);
            billItemEo.setUnit("\u53f0");
            if (BigDecimalUtils.gtZero((BigDecimal)billItemEo.getAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)billItemEo.getQuantity()).booleanValue()) {
                billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
            }
            this.billInfoService.setSpecialRate(billInfoEo, billItemEo);
            billItemEoList.add(billItemEo);
        });
        this.addMergeBillOrderItem(list, billInfoEo, skuCodeMap, billStrategyRespDto);
        billInfoEo.setInvoiceAmount(number.get());
        List<String> platformOrderNoList = list.stream().map(PlatformOrderFinishNoBillRespVo::getPlatformOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billInfoEo.getBillFlowNo(), RelBusinessTypeEnum.INVOICE.getCode());
        this.billItemDas.insertBatch(billItemEoList);
        return billItemEoList;
    }

    public void getBillLineItemName(ItemRateDgDto itemRateDgDto, Map<String, ItemSkuDgDto> skuCodeMap, PlatformOrderFinishNoBillRespVo respVo, BillStrategyRespDto billStrategyRespDto, BillItemEo billItemEo) {
        if (null != itemRateDgDto && null != itemRateDgDto.getId()) {
            billItemEo.setTaxRate(itemRateDgDto.getRate());
            billItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            billItemEo.setTaxAmount(respVo.getAmount().divide(itemRateDgDto.getRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(itemRateDgDto.getRate()).setScale(2, 4));
            if (BillRowNameTypeEnum.TYPE_COMMODITY.getCode().equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)respVo.getItemName()) ? "" : respVo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            } else if (BillRowNameTypeEnum.ELECTRONIC_NUMBER.getCode().equals(billStrategyRespDto.getBillRowName())) {
                if (skuCodeMap.containsKey(respVo.getItemCode())) {
                    ItemSkuDgDto itemEo = skuCodeMap.get(respVo.getItemCode());
                    billItemEo.setBillLineItemName(itemEo.getName());
                }
            } else {
                billItemEo.setBillLineItemName(billItemEo.getItemName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
            }
            if (BillRowNameTypeEnum.COMMODITY.getCode().equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(billItemEo.getItemName());
            } else if (BillRowNameTypeEnum.ELECTRONIC_NUMBER.getCode().equals(billStrategyRespDto.getBillRowName())) {
                if (skuCodeMap.containsKey(respVo.getItemCode())) {
                    ItemSkuDgDto itemEo = skuCodeMap.get(respVo.getItemCode());
                    billItemEo.setBillLineItemName(itemEo.getName());
                }
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            }
            billItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    public void addMergeBillOrderItem(List<PlatformOrderFinishNoBillRespVo> list, BillInfoEo billInfoEo, Map<String, ItemSkuDgDto> skuCodeMap, BillStrategyRespDto billStrategyRespDto) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList billOrderItemEoList = new ArrayList();
            list.forEach(respDto -> {
                ItemSkuDgDto itemEo;
                String itemDisplayName;
                BillOrderItemEo billOrderItemEo = new BillOrderItemEo();
                billOrderItemEo.setGift(respDto.getGift());
                CubeBeanUtils.copyProperties((Object)billOrderItemEo, (Object)respDto, (String[])new String[0]);
                billOrderItemEo.setQuantity(respDto.getItemNum());
                billOrderItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal amount = respDto.getAmount();
                billOrderItemEo.setAmount(amount);
                billOrderItemEo.setClinchDealAmount(amount);
                billOrderItemEo.setPlatformOrderNo(respDto.getPlatformOrderNo());
                ItemRateDgDto itemRateDgDto = new ItemRateDgDto();
                if (skuCodeMap.containsKey(respDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(respDto.getSkuCode());
                    billOrderItemEo.setItemShortName(itemSkuDgDto.getName());
                    billOrderItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
                }
                if (null != itemRateDgDto && null != itemRateDgDto.getId()) {
                    billOrderItemEo.setTaxRate(itemRateDgDto.getRate());
                    billOrderItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
                    billOrderItemEo.setTaxAmount(respDto.getAmount().divide(itemRateDgDto.getRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(itemRateDgDto.getRate()).setScale(2, 4));
                    if (BillRowNameTypeEnum.TYPE_COMMODITY.getCode().equals(billStrategyRespDto.getBillRowName())) {
                        itemDisplayName = StringUtils.isBlank((CharSequence)respDto.getItemName()) ? "" : respDto.getItemName();
                        billOrderItemEo.setBillLineItemName(itemDisplayName);
                    } else if (BillRowNameTypeEnum.ELECTRONIC_NUMBER.getCode().equals(billStrategyRespDto.getBillRowName())) {
                        if (skuCodeMap.containsKey(respDto.getItemCode())) {
                            itemEo = (ItemSkuDgDto)skuCodeMap.get(respDto.getItemCode());
                            billOrderItemEo.setBillLineItemName(itemEo.getName());
                        }
                    } else {
                        billOrderItemEo.setBillLineItemName(billOrderItemEo.getItemName());
                    }
                } else {
                    if (null != billStrategyRespDto.getTaxRate()) {
                        billOrderItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                        billOrderItemEo.setTaxAmount(billOrderItemEo.getAmount().divide(billOrderItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billOrderItemEo.getTaxRate()).setScale(2, 4));
                    }
                    if (BillRowNameTypeEnum.COMMODITY.getCode().equals(billStrategyRespDto.getBillRowName())) {
                        billOrderItemEo.setBillLineItemName(billOrderItemEo.getItemName());
                    } else if (BillRowNameTypeEnum.ELECTRONIC_NUMBER.getCode().equals(billStrategyRespDto.getBillRowName())) {
                        if (skuCodeMap.containsKey(respDto.getItemCode())) {
                            itemEo = (ItemSkuDgDto)skuCodeMap.get(respDto.getItemCode());
                            billOrderItemEo.setBillLineItemName(itemEo.getName());
                        }
                    } else {
                        itemDisplayName = StringUtils.isBlank((CharSequence)billOrderItemEo.getItemName()) ? "" : billOrderItemEo.getItemName();
                        billOrderItemEo.setBillLineItemName(itemDisplayName);
                    }
                    billOrderItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
                }
                billOrderItemEo.setUnitPrice(respDto.getSalePrice());
                billOrderItemEo.setUnit("\u53f0");
                billOrderItemEo.setOrderItemId(respDto.getOrderItemId());
                billOrderItemEo.setHsCustomerCode(respDto.getCustomerCode());
                billOrderItemEo.setHsCustomerName(respDto.getCustomerName());
                billOrderItemEo.setOrderType(respDto.getOrderType());
                billOrderItemEo.setType(respDto.getType());
                billOrderItemEo.setBusinessOrderNo(respDto.getOrderNo());
                this.billInfoService.setSpecialRateBillOrderItem(billInfoEo, billOrderItemEo);
                billOrderItemEoList.add(billOrderItemEo);
            });
            if (CollectionUtils.isNotEmpty(billOrderItemEoList)) {
                this.billOrderItemDas.insertBatch(billOrderItemEoList);
            }
        }
    }

    public void updateOrderMergeBillInfo(BillInfoEo billInfoEo, String status, List<String> platformOrderNoList) {
        logger.info("\u5408\u5e76\u5f00\u7968\u6210\u529f\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        List orderBillRecordList = ((ExtQueryChainWrapper)this.saleOrderBillRecordDas.filter().in((Object)"platform_order_no", platformOrderNoList)).list();
        Map map = ((List)Optional.ofNullable(orderBillRecordList).orElse(new ArrayList())).stream().collect(Collectors.toMap(SaleOrderBillRecordEo::getSaleOrderNo, Function.identity(), (v1, v2) -> v2));
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performOrderInfoDas.filter().in((Object)"platform_order_no", platformOrderNoList)).ne((Object)"order_status", (Object)OmsSaleOrderStatus.SPLIT.getCode())).list();
        list.forEach(order -> {
            if (map.containsKey(order.getSaleOrderNo())) {
                SaleOrderBillRecordEo saleOrderBillRecordEo = (SaleOrderBillRecordEo)map.get(order.getSaleOrderNo());
                SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
                saleOrderBillRecordReqDto.setId(saleOrderBillRecordEo.getId());
                saleOrderBillRecordReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
                saleOrderBillRecordReqDto.setSaleOrderNo(order.getSaleOrderNo());
                saleOrderBillRecordReqDto.setWhetherInvoice(status);
                saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
                saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
                saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
                this.saleOrderBillRecordApi.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
            } else {
                this.addOrderBillInfo(billInfoEo, status, (PerformOrderInfoEo)order);
            }
        });
    }

    public void addOrderBillInfo(BillInfoEo billInfoEo, String status, PerformOrderInfoEo saleOrder) {
        SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
        saleOrderBillRecordReqDto.setSaleOrderNo(saleOrder.getSaleOrderNo());
        saleOrderBillRecordReqDto.setPlatformOrderNo(saleOrder.getPlatformOrderNo());
        saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
        saleOrderBillRecordReqDto.setInvoiceType(billInfoEo.getInvoiceType());
        saleOrderBillRecordReqDto.setTitleType(billInfoEo.getTitleType());
        saleOrderBillRecordReqDto.setBillTitle(billInfoEo.getBillTitle());
        saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
        saleOrderBillRecordReqDto.setEntityId(billInfoEo.getEntityId());
        saleOrderBillRecordReqDto.setWhetherInvoice(status);
        saleOrderBillRecordReqDto.setTaxesCode(billInfoEo.getTaxesCode());
        saleOrderBillRecordReqDto.setRegisteredAddress(billInfoEo.getRegisteredAddress());
        saleOrderBillRecordReqDto.setRegisteredPhone(billInfoEo.getRegisteredPhone());
        saleOrderBillRecordReqDto.setBankAccount(billInfoEo.getBankAccount());
        saleOrderBillRecordReqDto.setBank(billInfoEo.getBank());
        saleOrderBillRecordReqDto.setBillPersonName(billInfoEo.getBillPersonName());
        saleOrderBillRecordReqDto.setBillPersonPhone(billInfoEo.getBillPersonPhone());
        saleOrderBillRecordReqDto.setBillAddress(billInfoEo.getBillAddress());
        saleOrderBillRecordReqDto.setDistributorBank(billInfoEo.getDistributorBank());
        saleOrderBillRecordReqDto.setDistributorBankAccount(billInfoEo.getDistributorBankAccount());
        saleOrderBillRecordReqDto.setDistributorRegisteredAddress(billInfoEo.getDistributorRegisteredAddress());
        saleOrderBillRecordReqDto.setDistributorRegisteredPhone(billInfoEo.getDistributorRegisteredPhone());
        saleOrderBillRecordReqDto.setDistributorTaxesCode(billInfoEo.getDistributorTaxesCode());
        saleOrderBillRecordReqDto.setCollectPerson(billInfoEo.getCollectPerson());
        saleOrderBillRecordReqDto.setReviewPerson(billInfoEo.getReviewPerson());
        saleOrderBillRecordReqDto.setBillPerson(billInfoEo.getBillPerson());
        saleOrderBillRecordReqDto.setBillChannel(billInfoEo.getBillChannel());
        saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
        saleOrderBillRecordReqDto.setMailbox(billInfoEo.getMailbox());
        saleOrderBillRecordReqDto.setPhone(billInfoEo.getPhone());
        this.saleOrderBillRecordApi.addSaleOrderBillRecord(saleOrderBillRecordReqDto);
    }

    public void mergeBillAutoAuditCheck(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList) {
        List collect;
        logger.info("\u5408\u5e76\u5f00\u7968\u81ea\u52a8\u5ba1\u6838\u5f00\u59cb");
        BillEntityEo billEntityEo = new BillEntityEo();
        if (null != billInfoEo.getEntityId()) {
            billEntityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billInfoEo.getEntityId())).one();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        AtomicBoolean flag = new AtomicBoolean(true);
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillInfoColourTypeEnum.RED_TICKET.getCode());
        billType.add(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        List billInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).in((Object)"bill_type", billType)).eq((Object)"all_red_flag", (Object)AllRedFlagEnum.YES_ALL_RED_FLAG.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)billInfoEos) && CollectionUtils.isNotEmpty(collect = billInfoEos.stream().filter(x -> x.getInvoiceState().equals(InvoiceStateEnum.WAIT_AUDIT.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.WAIT_BILL.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.INVOICING.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.FAILED.getCode())).collect(Collectors.toList()))) {
            errorList.add("\u5b58\u5728\u7ea2\u7968\u672a\u5f00\u7968\u6210\u529f\uff0c\u84dd\u7968\u65e0\u6cd5\u5ba1\u6838\u901a\u8fc7");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoEo.getBillPersonPhone()) && !billInfoEo.getBillPersonPhone().matches("1[0-9]\\d{9}")) {
            errorList.add("\u6536\u7968\u4eba\u7535\u8bdd\u53f7\u586b\u5199\u9519\u8bef");
            flag.set(false);
        }
        if (BigDecimal.ZERO.compareTo(billInfoEo.getInvoiceAmount()) >= 0) {
            errorList.add("\u53d1\u7968\u603b\u91d1\u989d\u4e3a\u96f6");
            flag.set(false);
        }
        if (CollectionUtils.isNotEmpty(billItemEoList)) {
            billItemEoList.forEach(item -> {
                if (StringUtils.isEmpty((CharSequence)item.getTaxClassificationCode())) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (null == item.getTaxRate() || BigDecimal.ZERO.compareTo(item.getTaxRate()) == 0) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u7387\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (StringUtils.isBlank((CharSequence)item.getBillLineItemName())) {
                    errorList.add(String.format("\u5546\u54c1%s\u53d1\u7968\u884c\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
            });
        } else {
            errorList.add("\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a");
            flag.set(false);
        }
        if (flag.get()) {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
        } else {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
            billInfoEo.setAuditFailReason(String.join((CharSequence)";", errorList));
        }
    }

    public void syncAddKingdeeMergeInvoice(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, Boolean reopenIsBill) {
    }

    @Override
    public BatchOperationRespDto cancelMergeBill(List<String> billFlowNoList) {
        logger.info("\u5408\u5e76\u5f00\u7968\u4fe1\u606f\u53d6\u6d88-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billFlowNoList));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        ArrayList errorList = new ArrayList();
        ArrayList successList = new ArrayList();
        billInfoList.forEach(info -> {
            if (InvoiceStateEnum.WAIT_AUDIT.getCode().equals(info.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(info.getInvoiceState())) {
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(info.getId());
                billInfoEo.setInvoiceState(InvoiceStateEnum.CANCELLED.getCode());
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
                this.cancelReleaseOrderFlag((BillInfoEo)info);
                successList.add(info.getBillFlowNo());
            } else {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s:\u975e\u5f85\u5ba1\u6838/\u5f00\u7968\u5931\u8d25\u7684\u72b6\u6001\u65e0\u6cd5\u53d6\u6d88", info.getBillFlowNo()));
            }
        });
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        if (CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        return batchOperationRespDto;
    }

    public void cancelReleaseOrderFlag(BillInfoEo billInfoEo) {
        List<BillOrderItemEo> afterList;
        List billOrderItemEoList = ((ExtQueryChainWrapper)this.billOrderItemDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getBillFlowNo())).list();
        Map<String, List<BillOrderItemEo>> typeMap = ((List)Optional.ofNullable(billOrderItemEoList).orElse(new ArrayList())).stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getType())).collect(Collectors.groupingBy(BillOrderItemEo::getType));
        if (CollUtil.isEmpty(typeMap)) {
            return;
        }
        List<BillOrderItemEo> orderList = typeMap.get("order");
        if (CollectionUtils.isNotEmpty(orderList)) {
            List<String> platformOrderNoList = orderList.stream().map(BillOrderItemEo::getPlatformOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            this.updateOrderMergeBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.UNINVOICED.getCode(), platformOrderNoList);
        }
        if (CollectionUtils.isNotEmpty(afterList = typeMap.get("after"))) {
            List orderNoList = afterList.stream().map(BillOrderItemEo::getBusinessOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            BatchUpdateInvoiceDto batchUpdateInvoiceDto = new BatchUpdateInvoiceDto();
            batchUpdateInvoiceDto.setAfterSaleOrderNoList(orderNoList);
            batchUpdateInvoiceDto.setInvoice(AfterInvoiceFlagEnum.YES_INVOICE.getCode());
            this.afterSaleOrderApiProxy.batchUpdateInvoiceByAfterSaleOrderNos(batchUpdateInvoiceDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void redAgainMergeBill(OrderMergeRedAgainBillReqDto reqDto) {
        logger.info("\u5408\u5e76\u5f00\u7968\u7ea2\u51b2\u91cd\u5f00-\u8f93\u5165:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        this.checkMergeBillInfoParams(reqDto);
        BillInfoEo billInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)reqDto.getBillFlowNo())).one();
        this.checkRedAgainInfo(billInfoEo);
        List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)reqDto.getBillFlowNo())).list();
        List billOrderItemList = ((ExtQueryChainWrapper)this.billOrderItemDas.filter().eq((Object)"bill_flow_no", (Object)reqDto.getBillFlowNo())).list();
        BillStrategyRespDto billStrategyRespDto = this.checkBillStrategyShop(billInfoEo.getShopCode());
        BillInfoEo redBillEo = this.copyGenerateRedBill(billInfoEo, billItemList, billOrderItemList);
        BillInfoEo infoEo = this.againMergeBill(reqDto, billInfoEo, billItemList, billOrderItemList, redBillEo.getBillFlowNo(), billStrategyRespDto);
        redBillEo.setInvoiceState(infoEo.getInvoiceState());
        redBillEo.setAuditTime(infoEo.getAuditTime());
        redBillEo.setAuditPerson(infoEo.getAuditPerson());
        this.billInfoService.checkAndSetBlacklist(redBillEo);
        this.billInfoDas.insert((BaseEo)redBillEo);
        this.syncAddKingdeeMergeInvoice(infoEo, billItemList, true);
    }

    public void checkMergeBillInfoParams(OrderMergeBillInfoReqDto reqDto) {
        AssertUtil.assertNotBlank(reqDto.getInvoiceType(), "\u53d1\u7968\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(reqDto.getTitleType(), "\u62ac\u5934\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(reqDto.getBillTitle(), "\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        if (BillTitleTypeEnum.COMPANY.getCode().equals(reqDto.getTitleType())) {
            AssertUtil.assertNotBlank(reqDto.getTaxesCode(), "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void checkMergeBillInfoParams(OrderMergeRedAgainBillReqDto reqDto) {
        AssertUtil.assertNotBlank(reqDto.getInvoiceType(), "\u53d1\u7968\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(reqDto.getTitleType(), "\u62ac\u5934\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(reqDto.getBillTitle(), "\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(reqDto.getBillFlowNo(), "\u53d1\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (BillTitleTypeEnum.COMPANY.getCode().equals(reqDto.getTitleType())) {
            AssertUtil.assertNotBlank(reqDto.getTaxesCode(), "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void checkRedAgainInfo(BillInfoEo billInfoEo) {
        AssertUtil.isTrue(InvoiceStateEnum.BILLED.getCode().equals(billInfoEo.getInvoiceState()), "\u53d1\u7968\u72b6\u6001\u4e3a\u5df2\u5f00\u7968\u624d\u80fd\u7ea2\u51b2\u91cd\u5f00");
    }

    public BillInfoEo copyGenerateRedBill(BillInfoEo info, List<BillItemEo> billItemList, List<BillOrderItemEo> billOrderItemList) {
        BillInfoEo addRedBill = new BillInfoEo();
        CubeBeanUtils.copyProperties((Object)addRedBill, (Object)info, (String[])new String[]{"id,extension,createTime,uploadPdfUrl"});
        addRedBill.setId(null);
        String code = this.generateCodeDataUtils.generateNo("KP");
        addRedBill.setBillFlowNo(code);
        addRedBill.setBlueTicketFlowNo(info.getBillFlowNo());
        addRedBill.setBlueTicketInvoiceCode(info.getExternalInvoiceCode());
        addRedBill.setBlueTicketInvoiceNo(info.getExternalInvoiceNo());
        addRedBill.setBillType(BillInfoColourTypeEnum.RED_TICKET.getCode());
        addRedBill.setUploadPdfUrl(null);
        addRedBill.setExtension(null);
        addRedBill.setCreateTime(new Date());
        addRedBill.setUpdateTime(new Date());
        addRedBill.setInvoiceUrl(null);
        addRedBill.setExternalInvoiceTime(null);
        addRedBill.setExternalInvoiceCode(null);
        addRedBill.setExternalInvoiceNo(null);
        addRedBill.setInvoiceConnectUrl(null);
        addRedBill.setAuditTime(null);
        addRedBill.setAuditPerson(null);
        addRedBill.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        addRedBill.setAllRedFlag(AllRedFlagEnum.NO_ALL_RED_FLAG.getCode());
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(addRedBill.getPlatformOrderNo().split(",")), code, RelBusinessTypeEnum.INVOICE.getCode());
        if (CollectionUtils.isNotEmpty(billItemList)) {
            billItemList.forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(code);
            });
            this.billItemDas.insertBatch(billItemList);
        }
        if (CollectionUtils.isNotEmpty(billOrderItemList)) {
            billOrderItemList.forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(code);
            });
            this.billOrderItemDas.insertBatch(billOrderItemList);
        }
        return addRedBill;
    }

    public BillInfoEo againMergeBill(OrderMergeRedAgainBillReqDto reqDto, BillInfoEo infoEo, List<BillItemEo> billItemList, List<BillOrderItemEo> billOrderItemList, String redBillNo, BillStrategyRespDto billStrategyRespDto) {
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setAgainBillRedBillFlowNo(redBillNo);
        String billFlowNo = this.generateCodeDataUtils.generateNo("KP");
        billInfoEo.setSumTimeStart(infoEo.getSumTimeStart());
        billInfoEo.setSumTimeEnd(infoEo.getSumTimeEnd());
        billInfoEo.setBillFlowNo(billFlowNo);
        billInfoEo.setPlatformOrderNo(infoEo.getPlatformOrderNo());
        billInfoEo.setWhetherMergeBill(infoEo.getWhetherMergeBill());
        billInfoEo.setShopId(infoEo.getShopId());
        billInfoEo.setShopCode(infoEo.getShopCode());
        billInfoEo.setOrganizationCode(infoEo.getOrganizationCode());
        billInfoEo.setShopName(infoEo.getShopName());
        billInfoEo.setSite(infoEo.getSite());
        billInfoEo.setSiteCode(infoEo.getSiteCode());
        billInfoEo.setCustomerCode(infoEo.getCustomerCode());
        billInfoEo.setCustomerName(infoEo.getCustomerName());
        billInfoEo.setInvoiceType(reqDto.getInvoiceType());
        billInfoEo.setTitleType(reqDto.getTitleType());
        billInfoEo.setBillTitle(reqDto.getBillTitle());
        billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)reqDto.getTaxesCode()) ? reqDto.getTaxesCode().replace(" ", "") : null);
        billInfoEo.setRegisteredAddress(reqDto.getRegisteredAddress());
        billInfoEo.setRegisteredPhone(reqDto.getRegisteredPhone());
        billInfoEo.setBankAccount(reqDto.getBankAccount());
        billInfoEo.setBank(reqDto.getBank());
        billInfoEo.setMailbox(reqDto.getMailbox());
        billInfoEo.setPhone(reqDto.getPhone());
        billInfoEo.setDistributorRegisteredAddress(infoEo.getDistributorRegisteredAddress());
        billInfoEo.setDistributorRegisteredPhone(infoEo.getDistributorRegisteredPhone());
        billInfoEo.setDistributorTaxesCode(infoEo.getDistributorTaxesCode());
        billInfoEo.setDistributorBank(infoEo.getDistributorBank());
        billInfoEo.setDistributorBankAccount(infoEo.getDistributorBankAccount());
        billInfoEo.setCollectPerson(infoEo.getCollectPerson());
        billInfoEo.setBillPerson(infoEo.getBillPerson());
        billInfoEo.setReviewPerson(infoEo.getReviewPerson());
        billInfoEo.setCreateType(BillCreateTypeEnum.SYSTEM.getCode());
        billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        billInfoEo.setEntityId(infoEo.getEntityId());
        billInfoEo.setEntityCode(infoEo.getEntityCode());
        billInfoEo.setEntityName(infoEo.getEntityName());
        billInfoEo.setEnterprise(infoEo.getEnterprise());
        billInfoEo.setBillChannel(infoEo.getBillChannel());
        billInfoEo.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        billInfoEo.setInvoiceAmount(infoEo.getInvoiceAmount());
        if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType()) && null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType())) {
            String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCode();
            if (billStrategyRespDto.getBillApplyType().contains(code)) {
                this.mergeBillAutoAuditCheck(billInfoEo, billItemList);
            }
        }
        this.billInfoService.checkAndSetBlacklist(billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billInfoEo.getPlatformOrderNo().split(",")), billFlowNo, RelBusinessTypeEnum.INVOICE.getCode());
        if (CollectionUtils.isNotEmpty(billItemList)) {
            billItemList.forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(billFlowNo);
            });
            this.billItemDas.insertBatch(billItemList);
        }
        if (CollectionUtils.isNotEmpty(billOrderItemList)) {
            billOrderItemList.forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(billFlowNo);
            });
            this.billOrderItemDas.insertBatch(billOrderItemList);
        }
        return billInfoEo;
    }
}

