/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.NoKeepBillConverter;
import com.yunxi.dg.base.center.finance.dao.das.INoKeepBillDas;
import com.yunxi.dg.base.center.finance.domain.entity.INoKeepBillDomain;
import com.yunxi.dg.base.center.finance.dto.entity.NoKeepBillDto;
import com.yunxi.dg.base.center.finance.dto.request.NoKeepBillReqDto;
import com.yunxi.dg.base.center.finance.dto.response.NoKeepBillRespDto;
import com.yunxi.dg.base.center.finance.eo.NoKeepBillEo;
import com.yunxi.dg.base.center.finance.service.entity.INoKeepBillService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NoKeepBillServiceImpl
extends BaseServiceImpl<NoKeepBillDto, NoKeepBillEo, INoKeepBillDomain>
implements INoKeepBillService {
    @Resource
    private INoKeepBillDas noKeepBillDas;
    @Resource
    private INoKeepBillDomain noKeepBillDomain;

    public NoKeepBillServiceImpl(INoKeepBillDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<NoKeepBillDto, NoKeepBillEo> converter() {
        return NoKeepBillConverter.INSTANCE;
    }

    @Override
    public Long addNoKeepBill(NoKeepBillReqDto addReqDto) {
        NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)noKeepBillEo);
        this.noKeepBillDas.insert((BaseEo)noKeepBillEo);
        return noKeepBillEo.getId();
    }

    @Override
    public void modifyNoKeepBill(NoKeepBillReqDto modifyReqDto) {
        NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)noKeepBillEo);
        this.noKeepBillDas.updateSelective((BaseEo)noKeepBillEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeNoKeepBill(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.noKeepBillDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public NoKeepBillRespDto queryById(Long id) {
        NoKeepBillEo noKeepBillEo = (NoKeepBillEo)this.noKeepBillDas.selectByPrimaryKey(id);
        NoKeepBillRespDto noKeepBillRespDto = new NoKeepBillRespDto();
        DtoHelper.eo2Dto((BaseEo)noKeepBillEo, (BaseVo)noKeepBillRespDto);
        return noKeepBillRespDto;
    }

    @Override
    public PageInfo<NoKeepBillRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        NoKeepBillReqDto noKeepBillReqDto = (NoKeepBillReqDto)JSON.parseObject((String)filter, NoKeepBillReqDto.class);
        NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
        DtoHelper.dto2Eo((BaseVo)noKeepBillReqDto, (BaseEo)noKeepBillEo);
        PageInfo eoPageInfo = this.noKeepBillDomain.selectPage((BaseEo)noKeepBillEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, NoKeepBillRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

