/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.OrderBusinessTypeConverter;
import com.yunxi.dg.base.center.finance.dao.das.IChargeAccountInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IOrderBusinessTypeDas;
import com.yunxi.dg.base.center.finance.domain.entity.IOrderBusinessTypeDomain;
import com.yunxi.dg.base.center.finance.dto.entity.OrderBusinessTypeDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.FinanceExceptionCode;
import com.yunxi.dg.base.center.finance.dto.request.OrderBusinessTypeReqDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderBusinessRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderBusinessTypeRespDto;
import com.yunxi.dg.base.center.finance.eo.OrderBusinessTypeEo;
import com.yunxi.dg.base.center.finance.service.entity.IOrderBusinessTypeService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderBusinessTypeServiceImpl
extends BaseServiceImpl<OrderBusinessTypeDto, OrderBusinessTypeEo, IOrderBusinessTypeDomain>
implements IOrderBusinessTypeService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IOrderBusinessTypeDas orderBusinessTypeDas;
    @Resource
    private IOrderBusinessTypeDomain orderBusinessTypeDomain;
    @Resource
    private IChargeAccountInfoDas chargeAccountInfoDas;

    public OrderBusinessTypeServiceImpl(IOrderBusinessTypeDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<OrderBusinessTypeDto, OrderBusinessTypeEo> converter() {
        return OrderBusinessTypeConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrderBusinessType(OrderBusinessTypeReqDto addReqDto) {
        this.logger.info("\u65b0\u589e\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u7ba1\u7406\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        OrderBusinessTypeEo orderBusinessTypeEo = (OrderBusinessTypeEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderBusinessTypeDas.filter().eq((Object)"order_type", (Object)addReqDto.getOrderType())).eq((Object)"business_type", (Object)addReqDto.getBusinessType())).one();
        if (Objects.nonNull(orderBusinessTypeEo)) {
            throw new BizException(FinanceExceptionCode.ORDER_BUSINESS_NOT_NULL.getMsg());
        }
        orderBusinessTypeEo = new OrderBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderBusinessTypeEo);
        this.orderBusinessTypeDas.insert((BaseEo)orderBusinessTypeEo);
        return orderBusinessTypeEo.getId();
    }

    @Override
    public void modifyOrderBusinessType(OrderBusinessTypeReqDto modifyReqDto) {
        OrderBusinessTypeEo orderBusinessTypeEo = new OrderBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderBusinessTypeEo);
        this.orderBusinessTypeDas.updateSelective((BaseEo)orderBusinessTypeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderBusinessType(List<Long> list) {
        List businessTypeEos = ((ExtQueryChainWrapper)this.orderBusinessTypeDas.filter().in((Object)"id", list)).list();
        if (Objects.isNull(businessTypeEos)) {
            throw new BizException("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        list.forEach(v -> {
            List chargeAccountInfoEos;
            OrderBusinessTypeEo businessTypeEo = (OrderBusinessTypeEo)businessTypeEos.get(0);
            ExtQueryChainWrapper sqlFilters = this.chargeAccountInfoDas.filter();
            sqlFilters.eq((Object)"order_type", (Object)businessTypeEo.getOrderType());
            if (!Objects.equals(BillTypeEnum.DELIVERY_REFUND_ONLY, businessTypeEo.getOrderType())) {
                sqlFilters.eq((Object)"business_type", (Object)businessTypeEo.getBusinessType());
            }
            if (CollectionUtils.isNotEmpty((Collection)(chargeAccountInfoEos = sqlFilters.list()))) {
                throw new BizException(BillTypeEnum.getDesc((String)businessTypeEo.getOrderType()) + "\u5df2\u8fdb\u884c\u8bb0\u8d26\u7c7b\u578b\u8bbe\u7f6e,\u65e0\u6cd5\u5220\u9664!");
            }
            this.orderBusinessTypeDas.logicDeleteById(v);
        });
    }

    @Override
    public OrderBusinessTypeRespDto queryById(Long id) {
        OrderBusinessTypeEo orderBusinessTypeEo = (OrderBusinessTypeEo)this.orderBusinessTypeDas.selectByPrimaryKey(id);
        OrderBusinessTypeRespDto orderBusinessTypeRespDto = new OrderBusinessTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)orderBusinessTypeEo, (BaseVo)orderBusinessTypeRespDto);
        return orderBusinessTypeRespDto;
    }

    @Override
    public PageInfo<OrderBusinessTypeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderBusinessTypeReqDto orderBusinessTypeReqDto = (OrderBusinessTypeReqDto)JSON.parseObject((String)filter, OrderBusinessTypeReqDto.class);
        OrderBusinessTypeEo orderBusinessTypeEo = new OrderBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)orderBusinessTypeReqDto, (BaseEo)orderBusinessTypeEo);
        PageInfo eoPageInfo = this.orderBusinessTypeDomain.selectPage((BaseEo)orderBusinessTypeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderBusinessTypeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<OrderBusinessTypeRespDto> queryPage(OrderBusinessTypeReqDto businessTypeReqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.orderBusinessTypeDas.filter().orderByDesc((Object)"create_time");
        if (Objects.nonNull(businessTypeReqDto.getOrderType())) {
            sqlFilters.like((Object)"order_type", (Object)("%" + businessTypeReqDto.getOrderType() + "%"));
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderBusinessTypeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<OrderBusinessRespDto> getOrderBusinessRelationList(OrderBusinessTypeReqDto businessTypeReqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.orderBusinessTypeDas.filter().orderByDesc((Object)"create_time");
        if (Objects.nonNull(businessTypeReqDto) && Objects.nonNull(businessTypeReqDto.getOrderType())) {
            sqlFilters.like((Object)"order_type", (Object)("%" + businessTypeReqDto.getOrderType() + "%"));
        }
        List businessTypeEos = sqlFilters.list();
        ArrayList businessTypeRespDtos = Lists.newArrayListWithCapacity((int)businessTypeEos.size());
        CubeBeanUtils.copyCollection((Collection)businessTypeRespDtos, (Collection)businessTypeEos, OrderBusinessTypeRespDto.class);
        Map<String, List<OrderBusinessTypeRespDto>> businessTypeListMap = businessTypeRespDtos.stream().collect(Collectors.groupingBy(OrderBusinessTypeRespDto::getOrderType));
        this.logger.info("businessTypeListMap\uff1a{}", (Object)JSON.toJSONString(businessTypeListMap));
        ArrayList orderBusinessRespDtos = Lists.newArrayList();
        businessTypeListMap.forEach((k, v) -> {
            OrderBusinessRespDto businessRespDto = new OrderBusinessRespDto();
            businessRespDto.setOrderType(k);
            businessRespDto.setOrderName(BillTypeEnum.getDesc((String)k));
            List businessTypeList = businessRespDto.getTypes();
            CubeBeanUtils.copyCollection((Collection)businessTypeList, (Collection)v, OrderBusinessRespDto.BusinessType.class);
            businessRespDto.setTypes(businessTypeList);
            orderBusinessRespDtos.add(businessRespDto);
        });
        return orderBusinessRespDtos;
    }
}

