/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepDetailMappingDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepAccountsDetailMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepDetailMappingMapper;
import com.yunxi.dg.base.center.finance.dto.enums.KeepAccountInterfaceEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillingLineInfo;
import com.yunxi.dg.base.center.finance.dto.request.DeliveryLineInfo;
import com.yunxi.dg.base.center.finance.dto.request.OrderKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepDetailMappingEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.ILineItemInfoService;
import com.yunxi.dg.base.center.finance.service.entity.ISapBookKeepService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SapBookKeepServiceImpl
implements ISapBookKeepService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IPushKeepAccountsDetailDas pushKeepAccountsDetailDas;
    @Value(value="${push.sap.flag:false}")
    private boolean isPushSap;
    @Value(value="${relate.without.return:false}")
    private boolean isWithOutKeep;
    @Value(value="${keep.split.account.size:10000}")
    private Integer splitSize;
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    @Resource
    private ILineItemInfoService lineItemInfoService;
    @Resource
    private IBookKeepAccountService bookKeepAccountService;
    @Resource
    private IKeepDetailMappingDas keepDetailMappingDas;
    @Resource
    private ILockService lockService;
    private static final String TABLENAME_DELIVERY = "keep_create_delivery";
    private static final String TABLENAME_BILL = "keep_create_invoice";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void partialKeepAccountDetails(List<KeepAccountsDetailEo> accountsDetailEos, String orderType) {
        ArrayList keepAccountsDetailEos;
        Map<String, KeepAccountsDetailEo> keepAccountsDetailEoMap;
        List keepAccountsDetailEoList;
        List orderItemIds;
        int length;
        HashMap addKeepMap = Maps.newHashMap();
        HashMap updateKeepMap = Maps.newHashMap();
        List voucherTypes = accountsDetailEos.stream().map(KeepAccountsDetailEo::getVoucherType).distinct().collect(Collectors.toList());
        List masterDeputyIdentity = accountsDetailEos.stream().map(KeepAccountsDetailEo::getMasterDeputyIdentity).distinct().collect(Collectors.toList());
        List realTimeFlag = accountsDetailEos.stream().map(KeepAccountsDetailEo::getRealTimeFlag).distinct().collect(Collectors.toList());
        int i = 0;
        for (length = accountsDetailEos.size(); length > 1500; length -= 1500) {
            orderItemIds = accountsDetailEos.subList(i, i + 1500).stream().map(KeepAccountsDetailEo::getOrderItemId).collect(Collectors.toList());
            keepAccountsDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", orderItemIds)).in((Object)"voucher_type", voucherTypes)).eq((Object)"order_type", (Object)orderType)).in((Object)"master_deputy_identity", masterDeputyIdentity)).in((Object)"real_time_flag", realTimeFlag)).list();
            keepAccountsDetailEoMap = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEoList)) {
                keepAccountsDetailEoMap = keepAccountsDetailEoList.stream().collect(Collectors.toMap(k -> k.getOrderItemId() + "_" + k.getVoucherType() + "_" + k.getMasterDeputyIdentity(), Function.identity()));
            }
            this.dealKeepAccountsDetail(addKeepMap, updateKeepMap, accountsDetailEos.subList(i, i + 1500), keepAccountsDetailEoMap);
            i += 1500;
        }
        if (length > 0) {
            orderItemIds = accountsDetailEos.subList(i, i + length).stream().map(KeepAccountsDetailEo::getOrderItemId).collect(Collectors.toList());
            keepAccountsDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", orderItemIds)).in((Object)"voucher_type", voucherTypes)).eq((Object)"order_type", (Object)orderType)).in((Object)"master_deputy_identity", masterDeputyIdentity)).in((Object)"real_time_flag", realTimeFlag)).list();
            keepAccountsDetailEoMap = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEoList)) {
                keepAccountsDetailEoMap = keepAccountsDetailEoList.stream().collect(Collectors.toMap(k -> k.getOrderItemId() + "_" + k.getVoucherType() + "_" + k.getMasterDeputyIdentity(), Function.identity()));
            }
            this.dealKeepAccountsDetail(addKeepMap, updateKeepMap, accountsDetailEos.subList(i, i + length), keepAccountsDetailEoMap);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(keepAccountsDetailEos = new ArrayList(addKeepMap.values()))) {
            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            KeepAccountsDetailMapper mapper = (KeepAccountsDetailMapper)session.getMapper(KeepAccountsDetailMapper.class);
            try {
                int len;
                int size = 1500;
                int j = 0;
                for (len = keepAccountsDetailEos.size(); len > size; len -= size) {
                    keepAccountsDetailEos.subList(j, j + size).forEach(v -> mapper.insert(v));
                    j += size;
                }
                if (len > 0) {
                    keepAccountsDetailEos.subList(j, j + len).forEach(v -> mapper.insert(v));
                }
                session.commit();
                session.close();
                session.clearCache();
            }
            finally {
                session.close();
            }
        }
        if (!CollectionUtils.isEmpty((Map)updateKeepMap)) {
            updateKeepMap.forEach((k, v) -> this.keepAccountsDetailDas.updateSelective((BaseEo)v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveKeepDetailMappings(List<KeepDetailMappingEo> list) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            KeepDetailMappingMapper mapper = (KeepDetailMappingMapper)session.getMapper(KeepDetailMappingMapper.class);
            try {
                int length;
                int size = 1500;
                int i = 0;
                for (length = list.size(); length > size; length -= size) {
                    list.subList(i, i + size).forEach(v -> mapper.insert(v));
                    i += size;
                }
                if (length > 0) {
                    list.subList(i, i + length).forEach(v -> mapper.insert(v));
                }
                session.commit();
                session.close();
                session.clearCache();
            }
            finally {
                session.close();
            }
        }
    }

    private void dealKeepAccountsDetail(Map<String, KeepAccountsDetailEo> addKeepMap, Map<String, KeepAccountsDetailEo> updateKeepMap, List<KeepAccountsDetailEo> accountsDetailEos, Map<String, KeepAccountsDetailEo> keepAccountsDetailEoMap) {
        if (!CollectionUtils.isEmpty(keepAccountsDetailEoMap)) {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType() + "_" + k.getMasterDeputyIdentity();
                KeepAccountsDetailEo accountsDetailEo = new KeepAccountsDetailEo();
                KeepAccountsDetailEo detailEo = (KeepAccountsDetailEo)keepAccountsDetailEoMap.get(code);
                if (Objects.nonNull(detailEo)) {
                    detailEo.setItemNum(k.getItemNum());
                    detailEo.setItemType(k.getItemType());
                    detailEo.setItemPrice(k.getItemPrice());
                    detailEo.setProductType(k.getProductType());
                    detailEo.setLineOrderType(k.getLineOrderType());
                    detailEo.setOrderId(k.getOrderId());
                    detailEo.setOrderItemId(k.getOrderItemId());
                    detailEo.setOrderType(k.getOrderType());
                    detailEo.setVoucherType(k.getVoucherType());
                    detailEo.setConditionType(k.getConditionType());
                    detailEo.setOrderInterface(k.getOrderInterface());
                    detailEo.setBillingInterface(k.getBillingInterface());
                    detailEo.setChargeAccountName(k.getChargeAccountName());
                    detailEo.setBillAccountName(k.getBillAccountName());
                    detailEo.setSaleOrderType(k.getSaleOrderType());
                    detailEo.setSaleDepartment(k.getSaleDepartment());
                    detailEo.setSaleGroup(k.getSaleGroup());
                    detailEo.setPostDelivery(k.getPostDelivery());
                    detailEo.setPlaceTime(k.getPlaceTime());
                    detailEo.setConditionType(k.getConditionType());
                    detailEo.setConditions(k.getConditions());
                    detailEo.setCompanyCategory(k.getCompanyCategory());
                    detailEo.setOrderNo(k.getOrderNo());
                    detailEo.setPlatformNo(k.getPlatformNo());
                    detailEo.setWarehouseCode(k.getWarehouseCode());
                    detailEo.setCompanyTypeCode(k.getCompanyTypeCode());
                    detailEo.setCostCenter(k.getCostCenter());
                    detailEo.setAssociateCompanyTypeCode(k.getAssociateCompanyTypeCode());
                    detailEo.setMasterDeputyIdentity(k.getMasterDeputyIdentity());
                    detailEo.setPlatformCreateTime(k.getPlatformCreateTime());
                    detailEo.setWmsItemNo(k.getWmsItemNo());
                    detailEo.setWmsOrderNo(k.getWmsOrderNo());
                    detailEo.setSingle(k.getSingle());
                    detailEo.setBillShopType(k.getBillShopType());
                    detailEo.setSnCode(k.getSnCode());
                    updateKeepMap.put(code, detailEo);
                } else {
                    CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                    addKeepMap.put(code, accountsDetailEo);
                }
            });
        } else {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType() + "_" + k.getMasterDeputyIdentity();
                KeepAccountsDetailEo accountsDetailEo = new KeepAccountsDetailEo();
                CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                addKeepMap.put(code, accountsDetailEo);
            });
        }
    }

    @Override
    public void writeChargeCodeToKeepDetail(List<PushKeepAccountsEo> keepAccountsEos) {
        ArrayList accountsDetailEos = Lists.newArrayList();
        keepAccountsEos.forEach(v -> {
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepDetailMappingDas.filter().eq((Object)"charge_code", (Object)v.getChargeCode())).eq((Object)"voucher_type", (Object)v.getVoucherType())).eq((Object)"master_deputy_identity", (Object)v.getMasterDeputyIdentity())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                list.forEach(m -> {
                    if (null != m.getKeepDetailId()) {
                        KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                        detailEo.setId(m.getKeepDetailId());
                        detailEo.setChargeCode(v.getChargeCode());
                        if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), v.getVoucherType())) {
                            detailEo.setSaleProjectId(m.getProjectId());
                        }
                        accountsDetailEos.add(detailEo);
                    }
                });
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) {
            int length;
            int i = 0;
            for (length = accountsDetailEos.size(); length > 500; length -= 500) {
                this.keepAccountsDetailDas.batchUpdateKeepDetail(accountsDetailEos.subList(i, i + 500));
                i += 500;
            }
            if (length > 0) {
                this.keepAccountsDetailDas.batchUpdateKeepDetail(accountsDetailEos.subList(i, i + length));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void updatePushKeepAccount(OrderKeepAccountReqDto orderKeepAccountReqDto) {
        PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)orderKeepAccountReqDto.getChargeCode())).eq((Object)"condition_type", (Object)orderKeepAccountReqDto.getConditionType())).one();
        if (Objects.nonNull(pushKeepAccountsEo)) {
            PushKeepAccountsEo keepAccountsEo = new PushKeepAccountsEo();
            keepAccountsEo.setId(pushKeepAccountsEo.getId());
            keepAccountsEo.setChargeCode(orderKeepAccountReqDto.getChargeCode());
            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getSaleNo())) {
                keepAccountsEo.setSaleNo(orderKeepAccountReqDto.getSaleNo());
            }
            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getDeliveryNo())) {
                keepAccountsEo.setDeliveryNote(orderKeepAccountReqDto.getDeliveryNo());
            }
            if (!CollectionUtils.isEmpty((Map)orderKeepAccountReqDto.getBillingLineInfos())) {
                Map billingLineInfoMap = orderKeepAccountReqDto.getBillingLineInfos();
                HashSet invoiceNoSet = new HashSet();
                billingLineInfoMap.forEach((k, v) -> invoiceNoSet.add(v.getBillNo()));
                ArrayList list = new ArrayList(invoiceNoSet);
                keepAccountsEo.setInvoiceNo(String.join((CharSequence)",", list));
            }
            if (null != orderKeepAccountReqDto.getDeliveryPushTime()) {
                keepAccountsEo.setDeliveryPushTime(orderKeepAccountReqDto.getDeliveryPushTime());
            }
            if (null != orderKeepAccountReqDto.getInvoicePushTime()) {
                keepAccountsEo.setInvoicePushTime(orderKeepAccountReqDto.getInvoicePushTime());
            }
            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getKeepingResult())) {
                keepAccountsEo.setKeepingResult(orderKeepAccountReqDto.getKeepingResult());
            }
            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getExtension())) {
                keepAccountsEo.setExtension(orderKeepAccountReqDto.getExtension());
            }
            if (null != orderKeepAccountReqDto.getChargeDate()) {
                keepAccountsEo.setChargeDate(orderKeepAccountReqDto.getChargeDate());
            }
            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getCheckedMark())) {
                keepAccountsEo.setCheckedMark(orderKeepAccountReqDto.getCheckedMark());
            }
            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getPushPerson())) {
                keepAccountsEo.setPushPerson(orderKeepAccountReqDto.getPushPerson());
            }
            keepAccountsEo.setReason(orderKeepAccountReqDto.getReason());
            this.pushKeepAccountsDas.updateSelective((BaseEo)keepAccountsEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void batchUpdateKeepAccountsDetail(OrderKeepAccountReqDto orderKeepAccountReqDto) {
        long start = System.currentTimeMillis();
        List keepDetailMappingEos = ((ExtQueryChainWrapper)this.keepDetailMappingDas.filter().eq((Object)"charge_code", (Object)orderKeepAccountReqDto.getChargeCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepDetailMappingEos)) {
            ArrayList accountsDetailEos = Lists.newArrayList();
            keepDetailMappingEos.forEach(v -> {
                if (null != v.getKeepDetailId()) {
                    BillingLineInfo billingLineInfo;
                    DeliveryLineInfo deliveryLineInfo;
                    KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                    detailEo.setId(v.getKeepDetailId());
                    if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getDeliveryNo())) {
                        detailEo.setDeliveryNote(orderKeepAccountReqDto.getDeliveryNo());
                    }
                    if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getSaleNo())) {
                        detailEo.setSaleNo(orderKeepAccountReqDto.getSaleNo());
                    }
                    if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getBillNo())) {
                        detailEo.setPostingNo(orderKeepAccountReqDto.getBillNo());
                    }
                    if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getBillingBookKeeping())) {
                        detailEo.setBookKeeping(orderKeepAccountReqDto.getBillingBookKeeping());
                    } else {
                        detailEo.setBookKeeping(orderKeepAccountReqDto.getBookKeeping());
                    }
                    if (null != orderKeepAccountReqDto.getChargeDate()) {
                        detailEo.setChargeDate(orderKeepAccountReqDto.getChargeDate());
                    }
                    if (!CollectionUtils.isEmpty((Map)orderKeepAccountReqDto.getDeliveryLineInfos()) && Objects.nonNull(deliveryLineInfo = (DeliveryLineInfo)orderKeepAccountReqDto.getDeliveryLineInfos().get(v.getProjectId()))) {
                        detailEo.setDeliveryProjectId(deliveryLineInfo.getDeliveryLineNo());
                    }
                    if (!CollectionUtils.isEmpty((Map)orderKeepAccountReqDto.getBillingLineInfos()) && Objects.nonNull(billingLineInfo = (BillingLineInfo)orderKeepAccountReqDto.getBillingLineInfos().get(v.getProjectId()))) {
                        detailEo.setBillingProjectId(billingLineInfo.getBillLineNo());
                        detailEo.setInvoiceNo(billingLineInfo.getBillNo());
                    }
                    if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getPushPerson())) {
                        detailEo.setPushPerson(orderKeepAccountReqDto.getPushPerson());
                    }
                    accountsDetailEos.add(detailEo);
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) {
                int length;
                int i = 0;
                for (length = accountsDetailEos.size(); length > 500; length -= 500) {
                    this.keepAccountsDetailDas.batchUpdateKeepAccountsDetail(accountsDetailEos.subList(i, i + 500));
                    i += 500;
                }
                if (length > 0) {
                    this.keepAccountsDetailDas.batchUpdateKeepAccountsDetail(accountsDetailEos.subList(i, i + length));
                }
            }
            this.logger.info("\u66f4\u65b0\u8bb0\u8d26\u660e\u7ec6\u6570\u636e\u8017\u65f6\uff1a{},{}", (Object)orderKeepAccountReqDto.getChargeCode(), (Object)(System.currentTimeMillis() - start));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void batchUpdatePushKeepDetail(OrderKeepAccountReqDto orderKeepAccountReqDto) {
        ArrayList accountsDetailEos = new ArrayList();
        List pushKeepAccountsDetailEoList = ((ExtQueryChainWrapper)this.pushKeepAccountsDetailDas.filter().eq((Object)"charge_code", (Object)orderKeepAccountReqDto.getChargeCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepAccountsDetailEoList)) {
            pushKeepAccountsDetailEoList.forEach(v -> {
                DeliveryLineInfo deliveryLineInfo;
                PushKeepAccountsDetailEo pushKeepAccountsDetailEo = new PushKeepAccountsDetailEo();
                pushKeepAccountsDetailEo.setId(v.getId());
                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getSaleNo())) {
                    pushKeepAccountsDetailEo.setSaleNo(orderKeepAccountReqDto.getSaleNo());
                }
                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getDeliveryNo())) {
                    pushKeepAccountsDetailEo.setDeliveryNote(orderKeepAccountReqDto.getDeliveryNo());
                }
                if (null != orderKeepAccountReqDto.getChargeDate()) {
                    pushKeepAccountsDetailEo.setChargeDate(orderKeepAccountReqDto.getChargeDate());
                }
                if (null != orderKeepAccountReqDto.getDeliveryLineInfos() && Objects.nonNull(deliveryLineInfo = (DeliveryLineInfo)orderKeepAccountReqDto.getDeliveryLineInfos().get(v.getProjectId()))) {
                    pushKeepAccountsDetailEo.setDeliveryProjectId(deliveryLineInfo.getDeliveryLineNo());
                }
                if (null != orderKeepAccountReqDto.getBillingLineInfos()) {
                    BillingLineInfo billingLineInfo = null;
                    billingLineInfo = Objects.equals(KeepAccountInterfaceEnum.ZDR1.getCode(), v.getChargeAccountName()) || Objects.equals(KeepAccountInterfaceEnum.ZCR1.getCode(), v.getChargeAccountName()) ? (BillingLineInfo)orderKeepAccountReqDto.getBillingLineInfos().get(v.getProjectId()) : (BillingLineInfo)orderKeepAccountReqDto.getBillingLineInfos().get(v.getDeliveryProjectId());
                    if (Objects.nonNull(billingLineInfo)) {
                        pushKeepAccountsDetailEo.setBillingProjectId(billingLineInfo.getBillLineNo());
                        pushKeepAccountsDetailEo.setInvoiceNo(billingLineInfo.getBillNo());
                    }
                }
                accountsDetailEos.add(pushKeepAccountsDetailEo);
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(accountsDetailEos) && org.apache.commons.collections.CollectionUtils.isNotEmpty(accountsDetailEos)) {
                int length;
                int i = 0;
                for (length = accountsDetailEos.size(); length > 500; length -= 500) {
                    this.pushKeepAccountsDetailDas.batchUpdatePushKeepDetail(accountsDetailEos.subList(i, i + 500));
                    i += 500;
                }
                if (length > 0) {
                    this.pushKeepAccountsDetailDas.batchUpdatePushKeepDetail(accountsDetailEos.subList(i, i + length));
                }
            }
        }
    }

    private List<KeepAccountsDetailEo> getKeepAccountDetail(String customerCode, String chargeAccountName, String voucherType, String warehouseCode, String platformNo, String orderNo, String shopCode, String productType, String batchNo, String deliveryConfirmTime, String innerOrderNo) {
        ExtQueryChainWrapper sqlFilters = this.keepAccountsDetailDas.filter();
        sqlFilters.eq((Object)"customer_code", (Object)customerCode);
        sqlFilters.eq((Object)"charge_account_name", (Object)chargeAccountName);
        sqlFilters.eq((Object)"voucher_type", (Object)voucherType);
        if (Objects.nonNull(warehouseCode)) {
            sqlFilters.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        sqlFilters.eq((Object)"shop_code", (Object)shopCode);
        sqlFilters.eq((Object)"product_type", (Object)productType);
        if (StringUtils.isNotBlank((CharSequence)platformNo) && !"null".equals(platformNo)) {
            sqlFilters.eq((Object)"platform_no", (Object)platformNo);
        }
        if (StringUtils.isNotBlank((CharSequence)orderNo) && !"null".equals(orderNo)) {
            sqlFilters.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotBlank((CharSequence)innerOrderNo)) {
            sqlFilters.eq((Object)"real_time_flag", (Object)1);
            sqlFilters.eq((Object)"order_no", (Object)innerOrderNo);
        }
        sqlFilters.eq((Object)"batch_no", (Object)batchNo);
        sqlFilters.isNull((Object)"charge_code");
        sqlFilters.last(" AND DATE_FORMAT(delivery_confirm_time,'%Y-%m-%d') = '" + deliveryConfirmTime + "'  order by id asc");
        List keepAccountsDetailEos = sqlFilters.list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) {
            return keepAccountsDetailEos;
        }
        return new ArrayList<KeepAccountsDetailEo>();
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }
}

