/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl.rule;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.center.finance.dto.PushOutsideSysAccountDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushSapEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IHckBookKeepService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HckPushErpBillingNodeRule
implements KeepNodeRule {
    private static final Logger log = LoggerFactory.getLogger(HckPushErpBillingNodeRule.class);
    private static final String TABLENAME_DELIVERY = "keep_invoice";
    private String conditionType;

    public HckPushErpBillingNodeRule(String conditionType) {
        this.conditionType = conditionType;
    }

    @Override
    public void execute(KeepNodeRuleParam context) {
        long start = System.currentTimeMillis();
        log.info("===============\u63a8\u9001ERP\u751f\u6210\u5f00\u7968================,{},", (Object)JSON.toJSONString((Object)context));
        IHckBookKeepService erpBookKeepService = (IHckBookKeepService)SpringBeanUtil.getBean(IHckBookKeepService.class);
        OrderRuleRespDto orderRuleRespDto = context.getOrderRuleRespDto();
        if (Objects.isNull(orderRuleRespDto)) {
            IOrderRuleService orderRuleService = (IOrderRuleService)SpringBeanUtil.getBean(IOrderRuleService.class);
            orderRuleRespDto = orderRuleService.selectOrderRule();
        }
        if (Objects.isNull(orderRuleRespDto) || Objects.equals(PushSapEnum.FALSE.getCode(), orderRuleRespDto.getInvoicePushSap())) {
            log.info("\u5f53\u524d\u5f00\u7968\u8bb0\u8d26\u81ea\u52a8\u63a8\u9001\u914d\u7f6e\u4e3a\u4e0d\u81ea\u52a8\u63a8\u9001");
            return;
        }
        log.info("\u5f00\u7968\u81ea\u52a8\u63a8\u9001erp\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)orderRuleRespDto));
        Map<String, PushOutsideSysAccountDto> pushErpMap = erpBookKeepService.groupBySummaryToErp(context.getParamReqDto());
        try {
            erpBookKeepService.rePushOpenapiNew(orderRuleRespDto, context, "1", pushErpMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u63a8\u9001\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u5904\u7406\u63a8\u9001erp\u751f\u6210\u9500\u552e\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        if (Objects.equals(KeepTypeEnum.MAMUAL.getCode(), context.getParamReqDto().getType()) || Objects.equals(KeepTypeEnum.AUTO.getCode(), context.getParamReqDto().getType())) {
            ICacheService cacheService = (ICacheService)SpringBeanUtil.getBean(ICacheService.class);
            if (Objects.equals(BillTypeEnum.SALE_LIST.getCode(), context.getParamReqDto().getOrderType())) {
                cacheService.setCache("SALE_LIST_" + VoucherTypeEnum.INVOICE.getCode(), (Object)"0");
            }
        }
    }
}

