/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl.rule;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderDas;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderItemLineDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderSnapshotDas;
import com.yunxi.dg.base.center.finance.dao.vo.BookAccountsReqVo;
import com.yunxi.dg.base.center.finance.dto.ResultSaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BookKeepingType;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.MasterSlaveTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SingleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.RuleParamReqDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepInterfaceTypeRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepOutResultDetailEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepNodeCommonService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.finance.service.utils.TradeUtil;
import com.yunxi.dg.base.center.logistics.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.logistics.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class HckRefundsBaseDeliveryNodeRule
implements KeepNodeRule {
    private static final Logger log = LoggerFactory.getLogger(HckRefundsBaseDeliveryNodeRule.class);
    private String voucherType;
    @Value(value="${keep.base.mode:AJR}")
    private String mode;

    public HckRefundsBaseDeliveryNodeRule(String voucherType, String mode) {
        this.voucherType = voucherType;
        this.mode = mode;
    }

    @Override
    public void execute(KeepNodeRuleParam context) {
        long start = System.currentTimeMillis();
        IOrderRuleService orderRuleService = (IOrderRuleService)SpringBeanUtil.getBean(IOrderRuleService.class);
        OrderRuleRespDto orderRuleRespDto = orderRuleService.selectOrderRule();
        BookAccountsReqVo reqVo = new BookAccountsReqVo();
        HckRefundsBaseDeliveryNodeRule.extractedAssemblyParameter(context, orderRuleRespDto, reqVo);
        context.setVoucherType(this.voucherType);
        IKeepNodeCommonService keepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
        context.getParamReqDto().setVoucherType(this.voucherType);
        List<SaleOrderItemVo> saleOrderItemVos = keepNodeCommonService.matcherCustomerAfterSaleItemWarehouseInfo(context, reqVo);
        log.info("\u9006\u5411\u5355\u636e-\u67e5\u8be2\u5230\u7684\u5355\u636e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(saleOrderItemVos));
        if (CollectionUtils.isEmpty(saleOrderItemVos)) {
            return;
        }
        keepNodeCommonService.summaryGroupingKeepNode(context, saleOrderItemVos);
        log.info("\u9006\u5411\u5355\u636e-\u6c47\u603b\u540e\u5355\u636e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(saleOrderItemVos));
        keepNodeCommonService.insertPushKeepAccountAndDetail(saleOrderItemVos, context);
        List<String> chargCodes = saleOrderItemVos.stream().map(SaleOrderItemVo::getChargeCode).distinct().collect(Collectors.toList());
        IKeepNodeCommonService iKeepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
        iKeepNodeCommonService.sendPushKeepAccountMessage(chargCodes);
    }

    private static void extractedAssemblyParameter(KeepNodeRuleParam context, OrderRuleRespDto orderRuleRespDto, BookAccountsReqVo reqVo) {
        reqVo.setOrderStatus(Arrays.asList(OmsOrderStatusEnum.FINISH.getCode(), OmsOrderStatusEnum.COMPLETE.getCode()));
        String orderType = context.getOrderType();
        if (BillTypeEnum.RETURN_BASE.getCode().equals(orderType)) {
            reqVo.setAfterSaleOrderTypes(Arrays.asList(AfterSaleOrderTypeEnum.THTK.getCode(), AfterSaleOrderTypeEnum.thtk.getCode()));
            reqVo.setAfterTypeFlag(AfterSaleOrderTypeEnum.THTK.getCode());
        } else if (BillTypeEnum.EXCHANGE.getCode().equals(orderType)) {
            reqVo.setAfterSaleOrderTypes(Arrays.asList(AfterSaleOrderTypeEnum.HH.getCode(), AfterSaleOrderTypeEnum.hh.getCode()));
            reqVo.setAfterTypeFlag(AfterSaleOrderTypeEnum.HH.getCode());
        } else if (BillTypeEnum.DELIVERY_REFUND_ONLY.getCode().equals(orderType)) {
            reqVo.setAfterSaleOrderTypes(Arrays.asList(AfterSaleOrderTypeEnum.FHHTK.getCode(), AfterSaleOrderTypeEnum.fhhtk.getCode()));
            reqVo.setAfterTypeFlag(AfterSaleOrderTypeEnum.FHHTK.getCode());
        }
        if (null != orderRuleRespDto) {
            reqVo.setAfterCreateDelivery(orderRuleRespDto.getReverse());
        }
        if (Objects.equals(KeepTypeEnum.AUTO.getCode(), context.getParamReqDto().getType())) {
            reqVo.setStartTime(context.getParamReqDto().getStartDate());
            reqVo.setEndTime(context.getOrderRuleEo().getBillTime());
        } else if (Objects.equals(KeepTypeEnum.REAL.getCode(), context.getParamReqDto().getType())) {
            reqVo.setInnerOrderNo(context.getParamReqDto().getInnerOrderNo());
            reqVo.setRealTimeFlag(Integer.valueOf(BigDecimal.ONE.intValue()));
        } else {
            reqVo.setStartTime(context.getParamReqDto().getStartTime() + " 00:00:00");
            reqVo.setEndTime(context.getParamReqDto().getEndTime() + " 23:59:59");
            reqVo.setWarehouseCode(context.getParamReqDto().getWarehouseCode());
        }
    }

    public void handler(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos, String startTime, String endTime, String orderType) {
        long start = System.currentTimeMillis();
        IBookKeepAccountService iBookKeepAccountService = (IBookKeepAccountService)SpringBeanUtil.getBean(IBookKeepAccountService.class);
        if (CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
            iBookKeepAccountService.partialDealKeepAccountDetails(keepAccountsDetailEos, orderType);
            log.info("\u4fdd\u5b58\u8bb0\u8d26\u660e\u7ec6\u8017\u65f6\uff1a{}~{}\uff0c{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
        }
        if (CollectionUtils.isNotEmpty(outResultDetailEos)) {
            iBookKeepAccountService.partialOutDealKeepAccountDetails(outResultDetailEos, orderType);
            log.info("\u4fdd\u5b58\u51fa\u5e93\u7ed3\u679c\u8bb0\u8d26\u660e\u7ec6\u8017\u65f6\uff1a{}~{}\uff0c{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
        }
    }

    public Map<String, Object> validateKeep(List<SaleOrderItemVo> orderItemVoList, KeepNodeRuleParam context) {
        HashMap keepDetailMap = Maps.newHashMap();
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        ArrayList outResultDetailEos = Lists.newArrayList();
        HashSet exceptionDetailEos = new HashSet();
        orderItemVoList.forEach(v -> {
            KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
            KeepOutResultDetailEo outResultDetailEo = new KeepOutResultDetailEo();
            IKeepNodeCommonService keepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
            if (context.isAction()) {
                v.setPushPerson(context.getCreator());
            }
            keepNodeCommonService.initKeepAccountsDetail(keepAccountsDetailEo, (SaleOrderItemVo)v);
            keepAccountsDetailEos.add(keepAccountsDetailEo);
        });
        keepDetailMap.put("keepDetails", keepAccountsDetailEos);
        keepDetailMap.put("outKeepDetails", outResultDetailEos);
        keepDetailMap.put("exceptionDetails", exceptionDetailEos);
        return keepDetailMap;
    }

    private KeepExceptionDetailEo setKeepException(String saleOrderNo, String itemCode, String extension) {
        KeepExceptionDetailEo exceptionDetailEo = new KeepExceptionDetailEo();
        exceptionDetailEo.setOrderNo(saleOrderNo);
        exceptionDetailEo.setConditionType(ConditionTypeEnum.RETURN_BASE_DELIVERY.getCode());
        exceptionDetailEo.setOrderType(BillTypeEnum.RETURN_BASE.getCode());
        exceptionDetailEo.setItemCode(itemCode);
        exceptionDetailEo.setExtension(extension);
        return exceptionDetailEo;
    }

    public void initKeepAccountsDetail(KeepAccountsDetailEo keepAccountsDetailEo, SaleOrderItemVo v) {
        keepAccountsDetailEo.setChargeCode(v.getChargeCode());
        keepAccountsDetailEo.setBatchNo(v.getBatchNo());
        keepAccountsDetailEo.setOrderNo(v.getOrderNo());
        keepAccountsDetailEo.setCustomerId(v.getCustomerId());
        keepAccountsDetailEo.setCustomerCode(v.getCustomerCode());
        keepAccountsDetailEo.setCustomerName(v.getCustomerName());
        keepAccountsDetailEo.setSapCode(v.getSapCode());
        keepAccountsDetailEo.setItemCode(v.getItemCode());
        keepAccountsDetailEo.setWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setItemNum(v.getItemNum());
        keepAccountsDetailEo.setItemPrice(v.getItemPrice());
        keepAccountsDetailEo.setBookKeeping(BookKeepingType.NOT_DEAL.getCode());
        keepAccountsDetailEo.setOrderInterface(v.getOrderInterface());
        keepAccountsDetailEo.setBillingInterface(v.getBillingInterface());
        keepAccountsDetailEo.setItemType(Convert.toStr((Object)v.getProductType()));
        keepAccountsDetailEo.setOrderType(v.getOrderType());
        keepAccountsDetailEo.setOrderId(v.getOrderId());
        keepAccountsDetailEo.setConditionType(v.getConditionType());
        keepAccountsDetailEo.setVoucherType(v.getVoucherType());
        keepAccountsDetailEo.setDeliveryConfirmTime(v.getDeliveryCompleteDate());
        keepAccountsDetailEo.setItemName(v.getItemName());
        keepAccountsDetailEo.setSiteCode(v.getSiteCode());
        keepAccountsDetailEo.setSiteName(v.getSiteName());
        keepAccountsDetailEo.setOrderItemId(v.getOrderItemId());
        keepAccountsDetailEo.setInvoice(v.getInvoice());
        keepAccountsDetailEo.setShopCode(v.getShopCode());
        keepAccountsDetailEo.setShopName(v.getShopName());
        keepAccountsDetailEo.setShopId(v.getShopId());
        keepAccountsDetailEo.setSingle(v.getSingle());
        keepAccountsDetailEo.setProductType(v.getProductType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setPlaceTime(v.getPlaceTime());
        keepAccountsDetailEo.setPlatformNo(v.getPlatformNo());
        keepAccountsDetailEo.setPlatformOrderNo(v.getPlatformOrderNo());
        keepAccountsDetailEo.setDocumentNo(v.getDocumentNo());
        keepAccountsDetailEo.setDocumentId(v.getDocumentId());
        keepAccountsDetailEo.setOrderStatus(v.getOrderStatus());
        keepAccountsDetailEo.setCompleteTime(v.getCompleteDate());
        keepAccountsDetailEo.setDeliveryTime(v.getInWarehouseDate());
        keepAccountsDetailEo.setItemId(v.getItemId());
        keepAccountsDetailEo.setGeneratePerson(v.getGeneratePerson());
        keepAccountsDetailEo.setPlatformCreateTime(v.getPlatformCreateTime());
        keepAccountsDetailEo.setSaleOrderType(v.getSaleOrderType());
        keepAccountsDetailEo.setGroupSkuCode(v.getGroupSkuCode());
        keepAccountsDetailEo.setGroupItemName(v.getGroupItemName());
        keepAccountsDetailEo.setGroupItemId(v.getGroupItemId());
        keepAccountsDetailEo.setRealTimeFlag(v.getRealTimeFlag());
        keepAccountsDetailEo.setOrganizationCode(v.getOrganizationCode());
        keepAccountsDetailEo.setOrganizationName(v.getOrganizationName());
        keepAccountsDetailEo.setErpOrderType(v.getErpOrderType());
        keepAccountsDetailEo.setShippingNo(v.getShippingNo());
        keepAccountsDetailEo.setShopOrganizationCode(v.getShopOrganizationCode());
        keepAccountsDetailEo.setShopOrganizationName(v.getShopOrganizationName());
        keepAccountsDetailEo.setWarehouseType(v.getWarehouseType());
        keepAccountsDetailEo.setDeliveryWay(v.getDeliveryWay());
        keepAccountsDetailEo.setWarehouseProperty(v.getWarehouseProperty());
        keepAccountsDetailEo.setOutResultCreateTime(v.getOutResultCreateTime());
        keepAccountsDetailEo.setOutResultUpdateTime(v.getOutResultUpdateTime());
        keepAccountsDetailEo.setPreOrderNo(v.getPreOrderNo());
        keepAccountsDetailEo.setOutWarehouseCode(v.getOutWarehouseCode());
        keepAccountsDetailEo.setChargeAccountName(v.getChargeAccountName());
        keepAccountsDetailEo.setPlatformCompleteTime(v.getPlatformCompleteTime());
        keepAccountsDetailEo.setPlatformOrderId(v.getPlatformOrderId());
        keepAccountsDetailEo.setPlatformOrderItemNo(v.getPlatformOrderItemNo());
        keepAccountsDetailEo.setPlatformItemName(v.getPlatformItemName());
        keepAccountsDetailEo.setPlatformItemCode(v.getPlatformItemCode());
        keepAccountsDetailEo.setPlatformItemSkuCode(v.getPlatformItemSkuCode());
    }

    public void initResultKeepAccountsDetail(KeepOutResultDetailEo keepAccountsDetailEo, SaleOrderItemVo v) {
        ResultSaleOrderItemVo vo = v.getResultSaleOrderItemVo();
        keepAccountsDetailEo.setOrderType(v.getOrderType());
        keepAccountsDetailEo.setChargeCode(v.getChargeCode());
        keepAccountsDetailEo.setOrderNo(v.getOrderNo());
        keepAccountsDetailEo.setItemCode(null != vo ? vo.getLongCode() : null);
        keepAccountsDetailEo.setWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setItemNum(null != vo ? Integer.valueOf(vo.getQuantity().intValue()) : null);
        keepAccountsDetailEo.setItemPrice(v.getItemPrice());
        keepAccountsDetailEo.setBookKeeping(BookKeepingType.NOT_DEAL.getCode());
        keepAccountsDetailEo.setItemType(Convert.toStr((Object)v.getProductType()));
        keepAccountsDetailEo.setOrderId(null != vo ? vo.getDocumentId() : null);
        keepAccountsDetailEo.setItemName(null != vo ? vo.getCargoName() : null);
        keepAccountsDetailEo.setOrderItemId(null != vo ? vo.getTradeOrderItemId() : null);
        keepAccountsDetailEo.setSingle(v.getSingle());
        keepAccountsDetailEo.setProductType(v.getProductType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setDocumentNo(Objects.nonNull(vo) ? vo.getDocumentNo() : null);
        keepAccountsDetailEo.setItemId(Objects.nonNull(vo) ? vo.getCargoId() : null);
        keepAccountsDetailEo.setGeneratePerson(v.getGeneratePerson());
        keepAccountsDetailEo.setResultDetailId(Objects.nonNull(vo) ? vo.getResultOrderDetailId() : null);
        keepAccountsDetailEo.setBatchNo(v.getBatchNo());
        keepAccountsDetailEo.setOutResultCreateTime(null != vo ? vo.getOutResultCreateTime() : null);
        keepAccountsDetailEo.setOutResultUpdateTime(null != vo ? vo.getOutResultUpdateTime() : null);
        keepAccountsDetailEo.setPreOrderNo(null != vo ? vo.getPreOrderNo() : null);
    }

    public List<SaleOrderItemVo> matcherCustomerItemWarehouseInfo(KeepNodeRuleParam context, BookAccountsReqVo reqVo) {
        Map interfaceTypeListMap = context.getParamReqDto().getInterfaceTypeListMap();
        RuleParamReqDto paramReqDto = context.getParamReqDto();
        IAfterSaleOrderDas afterSaleOrderDas = (IAfterSaleOrderDas)SpringBeanUtil.getBean(IAfterSaleOrderDas.class);
        List afterSaleOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)afterSaleOrderDas.filter().in((Object)"after_sale_order_no", (Collection)paramReqDto.getInnerOrderNos())).in((Object)"order_status", Arrays.asList(OmsOrderStatusEnum.FINISH.getCode(), OmsOrderStatusEnum.COMPLETE.getCode()))).list();
        List afterSaleOrderIds = afterSaleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        Map afterSaleOrderEoMap = afterSaleOrderEos.stream().collect(Collectors.toMap(AfterSaleOrderEo::getSaleOrderNo, Function.identity(), (v1, v2) -> v2));
        IAfterSaleOrderItemDas afterSaleOrderItemDas = (IAfterSaleOrderItemDas)SpringBeanUtil.getBean(IAfterSaleOrderItemDas.class);
        List afterSaleOrderItemEos = ((ExtQueryChainWrapper)afterSaleOrderItemDas.filter().in((Object)"after_sale_order_id", afterSaleOrderIds)).list();
        Map<Long, List<AfterSaleOrderItemEo>> afterSaleOrderItemEoMap = afterSaleOrderItemEos.stream().collect(Collectors.groupingBy(AfterSaleOrderItemEo::getAfterSaleOrderId));
        List performOrderIds = afterSaleOrderEos.stream().map(AfterSaleOrderEo::getSaleOrderId).collect(Collectors.toList());
        IDgPerformOrderInfoDas dgPerformOrderInfoDas = (IDgPerformOrderInfoDas)SpringBeanUtil.getBean(IDgPerformOrderInfoDas.class);
        List performOrderInfoEos = ((ExtQueryChainWrapper)dgPerformOrderInfoDas.filter().in((Object)"id", performOrderIds)).list();
        Map performOrderInfoMap = performOrderInfoEos.stream().collect(Collectors.toMap(DgPerformOrderInfoEo::getSaleOrderNo, Function.identity(), (v1, v2) -> v2));
        IDgPerformOrderSnapshotDas dgPerformOrderSnapshotDas = (IDgPerformOrderSnapshotDas)SpringBeanUtil.getBean(IDgPerformOrderSnapshotDas.class);
        List performOrderSnapshotEos = ((ExtQueryChainWrapper)dgPerformOrderSnapshotDas.filter().in((Object)"order_id", performOrderIds)).list();
        Map performOrderSnapshotMap = performOrderSnapshotEos.stream().collect(Collectors.toMap(DgPerformOrderSnapshotEo::getOrderId, Function.identity(), (v1, v2) -> v2));
        IDgPerformOrderItemLineDas dgPerformOrderItemLineDas = (IDgPerformOrderItemLineDas)SpringBeanUtil.getBean(IDgPerformOrderItemLineDas.class);
        List performOrderItemLineEos = ((ExtQueryChainWrapper)dgPerformOrderItemLineDas.filter().in((Object)"order_id", performOrderIds)).list();
        Map dgPerformOrderItemLineEoMap = performOrderItemLineEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
        List orderItemList = performOrderItemLineEos.stream().map(DgPerformOrderItemLineEo::getOrderLineId).collect(Collectors.toList());
        IDgPerformOrderLineDomain dgPerformOrderLineDomain = (IDgPerformOrderLineDomain)SpringBeanUtil.getBean(IDgPerformOrderLineDomain.class);
        List dgPerformOrderLineEos = dgPerformOrderLineDomain.selectByIds(orderItemList);
        Map<Long, List<DgPerformOrderLineEo>> dgPerformOrderLineEoMap = dgPerformOrderLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineEo::getOrderId));
        IShopService shopService = (IShopService)SpringBeanUtil.getBean(IShopService.class);
        List<String> shopCodes = performOrderSnapshotEos.stream().map(DgPerformOrderSnapshotEo::getShopCode).collect(Collectors.toList());
        List<ShopEo> shopEos = shopService.selectShopByCodes(shopCodes);
        Map shopEoMap = shopEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
        ILogicWarehouseDomain logicWarehouseDomain = (ILogicWarehouseDomain)SpringBeanUtil.getBean(ILogicWarehouseDomain.class);
        List warehouseIds = dgPerformOrderLineEos.stream().map(DgPerformOrderLineEo::getLogicalWarehouseId).distinct().collect(Collectors.toList());
        List logicWarehouseEos = logicWarehouseDomain.selectByIds(warehouseIds);
        Map logicWarehouseRespDtoMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        HashMap chargeCodeCache = Maps.newHashMap();
        String TABLENAME = "after_thtk_order_item_id#";
        ILockService lockService = (ILockService)SpringBeanUtil.getBean(ILockService.class);
        ArrayList<SaleOrderItemVo> list = new ArrayList<SaleOrderItemVo>();
        afterSaleOrderItemEoMap.forEach((k, v) -> v.forEach(item -> {
            Mutex mutex = null;
            try {
                BigDecimal refundAmount;
                String primaryKey = k + "_" + Convert.toStr((Object)item.getId());
                mutex = lockService.lock(TABLENAME, primaryKey);
                if (null == mutex) {
                    throw new BizException(String.format("\u63a5\u6536\u9000\u8d27\u9000\u6b3e\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,primaryKey:\u3010%s\u3011", primaryKey));
                }
                SaleOrderItemVo saleOrderItemVo = new SaleOrderItemVo();
                String code = (String)chargeCodeCache.get(paramReqDto.getInnerOrderNo());
                if (StringUtils.isBlank((CharSequence)code)) {
                    String chargeCode = "BL" + TradeUtil.generateTradeNo();
                    saleOrderItemVo.setChargeCode(chargeCode);
                    chargeCodeCache.put(paramReqDto.getInnerOrderNo(), chargeCode);
                } else {
                    saleOrderItemVo.setChargeCode(code);
                }
                saleOrderItemVo.setSingle(SingleTypeEnum.YES.getCode());
                saleOrderItemVo.setMasterDeputyIdentity(MasterSlaveTypeEnum.MASTER.getCode());
                saleOrderItemVo.setRealTimeFlag(Integer.valueOf(null != reqVo.getRealTimeFlag() ? reqVo.getRealTimeFlag().intValue() : BigDecimal.ZERO.intValue()));
                saleOrderItemVo.setGeneratePerson(null != context.getParamReqDto().getGeneratePerson() ? context.getParamReqDto().getGeneratePerson() : null);
                saleOrderItemVo.setOrderType(BillTypeEnum.RETURN_BASE.getCode());
                saleOrderItemVo.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
                saleOrderItemVo.setConditionType(ConditionTypeEnum.RETURN_BASE_DELIVERY.getCode());
                AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)afterSaleOrderEoMap.get(k);
                ShopEo shopEo = (ShopEo)shopEoMap.get(afterSaleOrderEo.getShopId());
                if (null != shopEo) {
                    saleOrderItemVo.setShopId(shopEo.getId());
                    saleOrderItemVo.setShopCode(shopEo.getCode());
                    saleOrderItemVo.setShopCustomerCode(shopEo.getCustomerCode());
                    saleOrderItemVo.setShopOrganizationCode(shopEo.getOrganizationCode());
                    saleOrderItemVo.setShopOrganizationName(shopEo.getOrganizationName());
                    saleOrderItemVo.setSiteName(shopEo.getSiteName());
                    saleOrderItemVo.setSiteName(shopEo.getSiteName());
                    saleOrderItemVo.setSupplierCode(shopEo.getSupplierCode());
                }
                BigDecimal supplyPrice = null != item.getSupplyPrice() ? item.getSupplyPrice() : BigDecimal.ZERO;
                Integer itemNum = item.getItemNum();
                BigDecimal itemPrice = BigDecimal.ZERO;
                if (null != shopEo && null != shopEo.getSettlementAmount() && 1 == shopEo.getSettlementAmount()) {
                    itemPrice = supplyPrice.multiply(new BigDecimal(itemNum));
                } else if (null != shopEo && null != shopEo.getSettlementAmount() && 2 == shopEo.getSettlementAmount()) {
                    itemPrice = item.getOrigPayAmount();
                } else if (null != shopEo && null != shopEo.getSettlementAmount() && 3 == shopEo.getSettlementAmount()) {
                    BigDecimal orgRealPayAmount = BigDecimal.ZERO;
                    BigDecimal bigDecimal = refundAmount = null != item.getRefundAmount() ? item.getRefundAmount() : BigDecimal.ZERO;
                    if (null != item.getSaleOrderItemId()) {
                        orgRealPayAmount = null != item.getRealPayAmount() ? item.getRealPayAmount() : BigDecimal.ZERO;
                        itemPrice = orgRealPayAmount.compareTo(refundAmount) > 0 ? refundAmount : orgRealPayAmount;
                    }
                }
                saleOrderItemVo.setItemPrice(itemPrice);
                saleOrderItemVo.setItemType(Integer.valueOf(itemPrice.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO.intValue() : BigDecimal.ONE.intValue()));
                saleOrderItemVo.setProductType(Integer.valueOf(itemPrice.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO.intValue() : BigDecimal.ONE.intValue()));
                saleOrderItemVo.setItemId(item.getItemId());
                saleOrderItemVo.setItemName(item.getItemName());
                DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)performOrderInfoMap.get(afterSaleOrderEo.getSaleOrderNo());
                if (null != performOrderInfoEo) {
                    if (StringUtils.isNotBlank((CharSequence)performOrderInfoEo.getDeliveryLogicalWarehouseCode())) {
                        refundAmount = (LogicWarehouseEo)logicWarehouseRespDtoMap.get(performOrderInfoEo.getDeliveryLogicalWarehouseCode());
                    }
                } else {
                    List interfaceTypeRespDtos = (List)interfaceTypeListMap.get(saleOrderItemVo.getAfterSaleOrderType().toUpperCase());
                    KeepInterfaceTypeRespDto keepInterfaceTypeRespDto = (KeepInterfaceTypeRespDto)interfaceTypeRespDtos.get(0);
                    if (Convert.toInt((Object)InvoiceTypeEnum.YES.getCode()) == keepInterfaceTypeRespDto.getInvoice()) {
                        saleOrderItemVo.setInvoice(InvoiceTypeEnum.YES.getCode());
                    } else {
                        saleOrderItemVo.setInvoice(InvoiceTypeEnum.NO.getCode());
                    }
                    saleOrderItemVo.setInterfaceName(keepInterfaceTypeRespDto.getInterfaceName());
                    saleOrderItemVo.setInterfaceNameValue(keepInterfaceTypeRespDto.getInterfaceNameValue());
                    saleOrderItemVo.setInvoiceName(keepInterfaceTypeRespDto.getInvoiceName());
                    saleOrderItemVo.setInvoiceNameValue(keepInterfaceTypeRespDto.getInvoiceNameValue());
                    saleOrderItemVo.setOrderInterface(keepInterfaceTypeRespDto.getInterfaceName());
                    saleOrderItemVo.setBillingInterface(keepInterfaceTypeRespDto.getInvoiceName());
                    saleOrderItemVo.setChargeAccountName(keepInterfaceTypeRespDto.getChargeAccountName());
                }
                list.add(saleOrderItemVo);
                if (mutex == null) return;
            }
            catch (Exception e) {
                try {
                    log.error("\u63a5\u6536\u9000\u8d27\u9000\u6b3e\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u4fe1\u606f\u5904\u7406\u5f02\u5e38:\u3010%s\u3011\uff0c\u3010%s\u3011", (Object)e.getMessage(), (Object)e);
                    throw new BizException(String.format("\u63a5\u6536\u9000\u8d27\u9000\u6b3e\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u4fe1\u606f\u5904\u7406\u5f02\u5e38:\u3010%s\u3011\uff0c\u3010%s\u3011", e.getMessage(), e));
                }
                catch (Throwable throwable) {
                    if (mutex == null) throw throwable;
                    lockService.unlock(mutex);
                    throw throwable;
                }
            }
            lockService.unlock(mutex);
            return;
        }));
        return list;
    }
}

