/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.generate.impl;

import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.service.generate.AbstractGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.DateUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="CsBillInfoServiceImpl")
public class BillInfoGenerateCodeServiceImpl
extends AbstractGenerateCodeService {
    Logger logger = LoggerFactory.getLogger(BillInfoGenerateCodeServiceImpl.class);

    @Override
    public String getGenerateCodeStrategy() {
        return GenerateCodeStrategyEnum.BILL_INFO.getCode();
    }

    @Override
    protected String lockKey() {
        String dateStr = DateUtils.formatDate(new Date(), "yyMMdd");
        String lockKey = this.getCodePrefix() + "_" + dateStr;
        this.logger.info("BillApplyGenerateCodeServiceImpl==>lockKey:{}", (Object)lockKey);
        return lockKey;
    }

    @Override
    protected String getCodePrefix() {
        return BillInfoEo.class.getName();
    }

    @Override
    protected Long queryMaxCode() {
        return 0L;
    }

    @Override
    public String getCode() {
        return super.generateCode(this.getCodePrefix(), BillInfoEo.class.getName(), this.lockKey());
    }

    @Override
    public String getCode(String prefixCode) {
        return super.generateCode(prefixCode, BillInfoEo.class.getName(), this.lockKey());
    }
}

