/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.utils;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.commons.utils.Consumer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class LockUtils {
    private static ILockService lockService;
    public static PlatformTransactionManager platformTransactionManager;

    @Autowired
    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        LockUtils.platformTransactionManager = platformTransactionManager;
    }

    @Autowired
    public void setLockService(ILockService lockService) {
        LockUtils.lockService = lockService;
    }

    public static <REQ> REQ lock(Supplier<REQ> supplier, String orderNo, String business) {
        return LockUtils.lock(supplier, orderNo, business, 10);
    }

    public static <REQ> REQ lock(Supplier<REQ> supplier, String orderNo, String business, int waitTime) {
        Mutex lock = lockService.lock(business, orderNo, waitTime, waitTime * 2, TimeUnit.SECONDS);
        try {
            REQ REQ = supplier.get();
            return REQ;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            LockUtils.registerSynchronizationAfterCompletion(() -> Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)lockService).unlock(arg_0)));
        }
    }

    public static <REQ> REQ lockList(Supplier<REQ> supplier, List<String> orderNoList, String business, int waitTime) {
        HashSet<String> set = new HashSet<String>(orderNoList);
        ArrayList mutexes = new ArrayList();
        try {
            set.forEach(orderNo -> mutexes.add(lockService.lock(business, orderNo, waitTime, waitTime * 2, TimeUnit.SECONDS)));
            REQ REQ = supplier.get();
            return REQ;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            LockUtils.registerSynchronizationAfterCompletion(() -> Optional.of(mutexes).filter(CollectionUtils::isNotEmpty).ifPresent(r -> r.forEach(arg_0 -> ((ILockService)lockService).unlock(arg_0))));
        }
    }

    public static <REQ> REQ executorNewTransaction(TransactionCallback<REQ> action) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(platformTransactionManager);
        transactionTemplate.setIsolationLevel(2);
        transactionTemplate.setPropagationBehavior(3);
        return (REQ)transactionTemplate.execute(action);
    }

    public static void registerSynchronizationAfterCompletion(final Consumer consumer) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    consumer.accept();
                }
            });
        } else {
            consumer.accept();
        }
    }
}

