/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.utils;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class PageInfoUtil {
    public static <T> Boolean isNotEmpty(PageInfo<T> pageInfo) {
        return null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }

    public static void copyPageInfo(PageInfo source, PageInfo target) {
        target.setTotal(source.getTotal());
        target.setEndRow(source.getEndRow());
        target.setStartRow(source.getStartRow());
        target.setSize(source.getSize());
        target.setHasNextPage(source.isHasNextPage());
        target.setHasPreviousPage(source.isHasPreviousPage());
        target.setIsFirstPage(source.isIsFirstPage());
        target.setIsLastPage(source.isIsLastPage());
        target.setNavigateFirstPage(source.getNavigateFirstPage());
        target.setNavigateLastPage(source.getNavigateLastPage());
        target.setNavigatepageNums(source.getNavigatepageNums());
        target.setNavigatePages(source.getNavigatePages());
        target.setNextPage(source.getNextPage());
        target.setPageNum(source.getPageNum());
        target.setPages(source.getPages());
        target.setPageSize(source.getPageSize());
        target.setPrePage(source.getPrePage());
    }

    public static <T> PageInfo<T> selectPage(List<T> items, int pageNum, int pageSize) {
        Page page = new Page(pageNum, pageSize);
        int total = items.size();
        page.setTotal((long)total);
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        page.setPages((int)Math.ceil(Double.valueOf(page.getTotal()) / Double.valueOf(pageSize)));
        page.setStartRow((long)pageNum);
        int startIndex = (pageNum - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, total);
        page.addAll(items.subList(startIndex, endIndex));
        PageInfo pageInfo = new PageInfo((List)page);
        return pageInfo;
    }
}

