/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IInvoiceMatchingReportDas;
import com.yunxi.dg.base.center.finance.dao.mapper.InvoiceMatchingReportMapper;
import com.yunxi.dg.base.center.finance.dto.entity.GenerateInvoiceMatchingDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceReconciliationReportDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceReconciliationReportQueryDto;
import com.yunxi.dg.base.center.finance.dto.response.TimeRespDto;
import com.yunxi.dg.base.center.finance.eo.InvoiceMatchingReportEo;
import com.yunxi.dg.base.center.finance.service.entity.IInvoiceReconciliationReportService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.finance.service.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvoiceReconciliationReportServiceImpl
implements IInvoiceReconciliationReportService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceReconciliationReportServiceImpl.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IInvoiceMatchingReportDas matchingReportDas;
    @Resource
    private ILockService lockService;
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    private static final String TABLE_NAME_KEEP_BILL_REPORT = "keep_bill_report";

    @Override
    public PageInfo<InvoiceReconciliationReportDto> page(InvoiceReconciliationReportQueryDto queryDto) {
        log.info("\u53d1\u7968\u6838\u5bf9\u62a5\u8868\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageInfo pageInfo = this.billInfoDas.invoiceReconciliationPage(queryDto, pageNum, pageSize);
        if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List<String> platformOrderNoList = pageInfo.getList().stream().map(InvoiceReconciliationReportDto::getPlatformOrderNo).distinct().collect(Collectors.toList());
            Map<String, String> enterpriseMap = this.queryEnterprise(platformOrderNoList);
            AtomicReference<Long> id = new AtomicReference<Long>(0L);
            pageInfo.getList().forEach(v -> {
                id.set((Long)id.get() + 1L);
                v.setId((Long)id.get());
                if (enterpriseMap.containsKey(v.getPlatformOrderNo())) {
                    v.setEnterprise((String)enterpriseMap.get(v.getPlatformOrderNo()));
                }
            });
        }
        return pageInfo;
    }

    @Override
    public PageInfo<InvoiceReconciliationReportDto> queryPage(InvoiceReconciliationReportQueryDto queryDto) {
        log.info("\u53d1\u7968\u6838\u5bf9\u62a5\u8868\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageInfo pageInfo = this.matchingReportDas.matchInvoiceReport(queryDto, pageNum, pageSize);
        if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List<String> platformOrderNoList = pageInfo.getList().stream().map(InvoiceReconciliationReportDto::getPlatformOrderNo).distinct().collect(Collectors.toList());
            Map<String, String> enterpriseMap = this.queryEnterprise(platformOrderNoList);
            AtomicReference<Long> id = new AtomicReference<Long>(0L);
            pageInfo.getList().forEach(v -> {
                id.set((Long)id.get() + 1L);
                v.setId((Long)id.get());
                if (enterpriseMap.containsKey(v.getPlatformOrderNo())) {
                    v.setEnterprise((String)enterpriseMap.get(v.getPlatformOrderNo()));
                }
            });
        }
        return pageInfo;
    }

    private Map<String, String> queryEnterprise(List<String> platformOrderNoList) {
        List billInfoEoList;
        int length;
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(platformOrderNoList)) {
            return resultMap;
        }
        int i = 0;
        for (length = platformOrderNoList.size(); length > 1000; length -= 1000) {
            billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNoList.subList(i, i + 1000))).isNotNull((Object)"enterprise")).groupBy((Object)"platform_order_no")).list();
            if (CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                billInfoEoList.forEach(v -> resultMap.put(v.getPlatformOrderNo(), v.getEnterprise()));
            }
            i += 1000;
        }
        if (length > 0 && CollectionUtils.isNotEmpty((Collection)(billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNoList.subList(i, i + length))).isNotNull((Object)"enterprise")).groupBy((Object)"platform_order_no")).list()))) {
            billInfoEoList.forEach(v -> resultMap.put(v.getPlatformOrderNo(), v.getEnterprise()));
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invoiceMatchingReport(GenerateInvoiceMatchingDto dto) {
        log.info("\u751f\u6210\u53d1\u7968\u6838\u5bf9\u62a5\u8868\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        String generateDate = dto.getGenerateDate();
        if (Objects.isNull(dto.getGenerateDate())) {
            generateDate = com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd");
        }
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock(TABLE_NAME_KEEP_BILL_REPORT, generateDate, 10, 20, TimeUnit.SECONDS);
            if (null == mutex) {
                throw new BizException("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            InvoiceReconciliationReportQueryDto queryDto = new InvoiceReconciliationReportQueryDto();
            String startDate = dto.getStartDate() + " 00:00:00";
            if (StringUtils.isBlank((CharSequence)dto.getStartDate())) {
                startDate = com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd") + " 00:00:00";
            }
            String endDate = dto.getEndDate() + " 23:59:59";
            if (StringUtils.isBlank((CharSequence)dto.getEndDate())) {
                endDate = com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59";
            }
            queryDto.setBusinessStarDate(startDate);
            queryDto.setBusinessEndDate(endDate);
            queryDto.setChargeStartDate(startDate);
            queryDto.setChargeEndDate(endDate);
            queryDto.setInvoiceStartDate(startDate);
            queryDto.setInvoiceEndDate(endDate);
            Date date = StringUtils.isBlank((CharSequence)dto.getStartDate()) ? new Date() : DateUtil.stringToDate(dto.getStartDate() + " " + com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"HH:mm:ss"));
            log.info("date:{}", (Object)date);
            List reportDtos = this.matchingReportDas.invoiceMatchReport(queryDto);
            if (CollectionUtils.isNotEmpty((Collection)reportDtos)) {
                log.info("reportDtos:{}", (Object)reportDtos.size());
                this.matchingReportDas.deleteInvoiceMatchingReport(generateDate);
                List<String> platformOrderNoList = reportDtos.stream().map(InvoiceReconciliationReportDto::getPlatformOrderNo).distinct().collect(Collectors.toList());
                Map<String, String> enterpriseMap = this.queryEnterprise(platformOrderNoList);
                reportDtos.forEach(v -> {
                    if (enterpriseMap.containsKey(v.getPlatformOrderNo())) {
                        v.setEnterprise((String)enterpriseMap.get(v.getPlatformOrderNo()));
                    }
                });
                ArrayList matchingReportEos = Lists.newArrayList();
                String finalGenerateDate = generateDate;
                reportDtos.forEach(v -> {
                    InvoiceMatchingReportEo reportEo = new InvoiceMatchingReportEo();
                    reportEo.setPlatformOrderNo(v.getPlatformOrderNo());
                    reportEo.setShopCode(v.getShopCode());
                    reportEo.setShopName(v.getShopName());
                    reportEo.setSkuCode(v.getSkuCode());
                    reportEo.setSkuName(v.getSkuName());
                    reportEo.setBusinessVolume(v.getBusinessVolume());
                    reportEo.setBusinessAmount(v.getBusinessAmount());
                    reportEo.setInvoicingKeepingSuccessCount(v.getInvoicingKeepingSuccessCount());
                    reportEo.setInvoicingKeepingSuccessAmount(v.getInvoicingKeepingSuccessAmount());
                    reportEo.setInvoicedQuantity(v.getInvoicedQuantity());
                    reportEo.setInvoicedAmount(v.getInvoicedAmount());
                    reportEo.setQuantityDifference(v.getQuantityDifference());
                    reportEo.setKeepInvoiceAmountDifference(v.getKeepInvoiceAmountDifference());
                    reportEo.setIssuedInvoiceAmount(v.getIssuedInvoiceAmount());
                    reportEo.setEnterprise(v.getEnterprise());
                    reportEo.setGenerateDate(finalGenerateDate);
                    reportEo.setBusinessDate(date);
                    reportEo.setKeepBillDate(date);
                    reportEo.setInvoiceDate(date);
                    matchingReportEos.add(reportEo);
                });
                if (CollectionUtils.isNotEmpty((Collection)matchingReportEos)) {
                    SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
                    InvoiceMatchingReportMapper mapper = (InvoiceMatchingReportMapper)session.getMapper(InvoiceMatchingReportMapper.class);
                    try {
                        int len;
                        int size = 1000;
                        int i = 0;
                        for (len = matchingReportEos.size(); len > size; len -= size) {
                            matchingReportEos.subList(i, i + size).forEach(v -> mapper.insert(v));
                            i += 1000;
                        }
                        if (len > 0) {
                            matchingReportEos.subList(i, i + len).forEach(v -> mapper.insert(v));
                        }
                        session.commit();
                        session.close();
                        session.clearCache();
                    }
                    finally {
                        session.close();
                    }
                }
            }
            if (mutex == null) return;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                log.error("\u751f\u6210\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                throw new BizException("\u751f\u6210\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (Throwable throwable) {
                if (mutex == null) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handworkKeepBillReport(String startTime, String endTime) {
        log.info("\u751f\u6210\u53d1\u7968\u6838\u5bf9\u65f6\u95f4\uff1a{},{}", (Object)startTime, (Object)endTime);
        List<Map<String, Object>> timeList = DateUtil.getSplitTimeperiod(1, startTime + " 00:00:00", endTime + " 23:59:59");
        List timeRespDtos = JSONArray.parseArray((String)JSON.toJSONString(timeList), TimeRespDto.class);
        log.info("\u65f6\u95f4\u5468\u671flist\uff1a{}", (Object)JSON.toJSONString((Object)timeRespDtos));
        Mutex mutex = null;
        if (CollectionUtils.isNotEmpty((Collection)timeRespDtos)) {
            for (TimeRespDto respDto : timeRespDtos) {
                try {
                    mutex = this.lockService.lock(TABLE_NAME_KEEP_BILL_REPORT, respDto.getStartTime().substring(0, 10), 10, 20, TimeUnit.SECONDS);
                    if (null == mutex) {
                        throw new BizException("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    InvoiceReconciliationReportQueryDto queryDto = new InvoiceReconciliationReportQueryDto();
                    queryDto.setBusinessStarDate(respDto.getStartTime());
                    queryDto.setBusinessEndDate(respDto.getEndTime());
                    queryDto.setChargeStartDate(respDto.getStartTime());
                    queryDto.setChargeEndDate(respDto.getEndTime());
                    queryDto.setInvoiceStartDate(respDto.getStartTime());
                    queryDto.setInvoiceEndDate(respDto.getEndTime());
                    String generateDate = respDto.getStartTime().substring(0, 10);
                    Date date = StringUtils.isBlank((CharSequence)respDto.getStartTime()) ? new Date() : DateUtil.stringToDate(respDto.getStartTime() + " " + com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"HH:mm:ss"));
                    log.info("date:{}", (Object)date);
                    List reportDtos = this.matchingReportDas.invoiceMatchReport(queryDto);
                    if (CollectionUtils.isNotEmpty((Collection)reportDtos)) {
                        this.matchingReportDas.deleteInvoiceMatchingReport(generateDate);
                        List<String> platformOrderNoList = reportDtos.stream().map(InvoiceReconciliationReportDto::getPlatformOrderNo).distinct().collect(Collectors.toList());
                        Map<String, String> enterpriseMap = this.queryEnterprise(platformOrderNoList);
                        reportDtos.forEach(v -> {
                            if (enterpriseMap.containsKey(v.getPlatformOrderNo())) {
                                v.setEnterprise((String)enterpriseMap.get(v.getPlatformOrderNo()));
                            }
                        });
                        ArrayList matchingReportEos = Lists.newArrayList();
                        String finalGenerateDate = generateDate;
                        reportDtos.forEach(v -> {
                            InvoiceMatchingReportEo reportEo = new InvoiceMatchingReportEo();
                            reportEo.setPlatformOrderNo(v.getPlatformOrderNo());
                            reportEo.setShopCode(v.getShopCode());
                            reportEo.setShopName(v.getShopName());
                            reportEo.setSkuCode(v.getSkuCode());
                            reportEo.setSkuName(v.getSkuName());
                            reportEo.setBusinessVolume(v.getBusinessVolume());
                            reportEo.setBusinessAmount(v.getBusinessAmount());
                            reportEo.setInvoicingKeepingSuccessCount(v.getInvoicingKeepingSuccessCount());
                            reportEo.setInvoicingKeepingSuccessAmount(v.getInvoicingKeepingSuccessAmount());
                            reportEo.setInvoicedQuantity(v.getInvoicedQuantity());
                            reportEo.setInvoicedAmount(v.getInvoicedAmount());
                            reportEo.setQuantityDifference(v.getQuantityDifference());
                            reportEo.setKeepInvoiceAmountDifference(v.getKeepInvoiceAmountDifference());
                            reportEo.setIssuedInvoiceAmount(v.getIssuedInvoiceAmount());
                            reportEo.setEnterprise(v.getEnterprise());
                            reportEo.setGenerateDate(finalGenerateDate);
                            reportEo.setBusinessDate(date);
                            reportEo.setKeepBillDate(date);
                            reportEo.setInvoiceDate(date);
                            matchingReportEos.add(reportEo);
                        });
                        if (CollectionUtils.isNotEmpty((Collection)matchingReportEos)) {
                            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
                            InvoiceMatchingReportMapper mapper = (InvoiceMatchingReportMapper)session.getMapper(InvoiceMatchingReportMapper.class);
                            try {
                                int len;
                                int size = 1000;
                                int i = 0;
                                for (len = matchingReportEos.size(); len > size; len -= size) {
                                    matchingReportEos.subList(i, i + size).forEach(v -> mapper.insert(v));
                                    i += 1000;
                                }
                                if (len > 0) {
                                    matchingReportEos.subList(i, i + len).forEach(v -> mapper.insert(v));
                                }
                                session.commit();
                                session.close();
                                session.clearCache();
                            }
                            finally {
                                session.close();
                            }
                        }
                    }
                    if (mutex == null) continue;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        log.error("\u91cd\u65b0\u751f\u6210\u53d1\u7968\u6838\u5bf9\u62a5\u8868\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                        throw new BizException("\u91cd\u65b0\u751f\u6210\u53d1\u7968\u6838\u5bf9\u62a5\u8868\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    catch (Throwable throwable) {
                        if (mutex != null) {
                            this.lockService.unlock(mutex);
                        }
                        throw throwable;
                    }
                }
                this.lockService.unlock(mutex);
            }
        }
    }
}

