/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.OrderRuleConverter;
import com.yunxi.dg.base.center.finance.dao.das.IInvoiceShopRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IItemRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepItemRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IOrderRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IParentSubsidiaryCompanyShopRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IShopRuleDas;
import com.yunxi.dg.base.center.finance.domain.entity.IOrderRuleDomain;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAccountsNodeConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.OrderRuleDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountNodeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillShopTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceShopRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.OrderRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.request.RuleParamReqDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceShopRuleRespDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepItemRuleRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ParentSubsidiaryCompanyShopRuleRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ShopRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.InvoiceShopRuleEo;
import com.yunxi.dg.base.center.finance.eo.KeepItemRuleEo;
import com.yunxi.dg.base.center.finance.eo.OrderRuleEo;
import com.yunxi.dg.base.center.finance.eo.ParentSubsidiaryCompanyShopRuleEo;
import com.yunxi.dg.base.center.finance.eo.ShopRuleEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepAccountsNodeConfigService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepInterfaceTypeService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderRuleServiceImpl
extends BaseServiceImpl<OrderRuleDto, OrderRuleEo, IOrderRuleDomain>
implements IOrderRuleService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IOrderRuleDas orderRuleDas;
    @Resource
    private IOrderRuleDomain orderRuleDomain;
    @Resource
    private IItemRuleDas itemRuleDas;
    @Resource
    private IShopRuleDas shopRuleDas;
    @Resource
    private IKeepItemRuleDas keepItemRuleDas;
    @Resource
    private IInvoiceShopRuleDas invoiceShopRuleDas;
    @Resource
    private IParentSubsidiaryCompanyShopRuleDas parentSubsidiaryCompanyShopRuleDas;
    @Resource
    private IKeepInterfaceTypeService keepInterfaceTypeService;
    @Value(value="${keep.account.day:20}")
    private Integer day;
    @Value(value="${keep.mode:HCK}")
    private String keepSystem;
    @Autowired
    private IAppBizQueryApi appBizQueryApi;
    @Resource
    private IKeepAccountsNodeConfigService keepAccountsNodeConfigService;
    @Resource
    private ICacheService cacheService;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public OrderRuleServiceImpl(IOrderRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<OrderRuleDto, OrderRuleEo> converter() {
        return OrderRuleConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrderRule(OrderRuleReqDto addReqDto) {
        OrderRuleEo orderRuleEo;
        this.logger.info("\u65b0\u589e\u8bb0\u8d26\u8bbe\u7f6e\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        this.cacheService.delCache("orderRuleKey");
        addReqDto.setAccountNode(AccountNodeEnum.forCode((String)addReqDto.getAccountNode()).getCode());
        List orderRuleEos = this.orderRuleDas.selectAll();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderRuleEos)) {
            orderRuleEo = (OrderRuleEo)orderRuleEos.get(0);
            addReqDto.setId(orderRuleEo.getId());
        }
        orderRuleEo = new OrderRuleEo();
        if (Objects.nonNull(addReqDto.getId())) {
            orderRuleEo = (OrderRuleEo)((ExtQueryChainWrapper)this.orderRuleDas.filter().eq((Object)"id", (Object)addReqDto.getId())).one();
            if (Objects.isNull(orderRuleEo)) {
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderRuleEo);
                orderRuleEo.setEnable(Integer.valueOf(1));
                orderRuleEo.setBillTime(addReqDto.getBillTime());
                orderRuleEo.setAccountType(addReqDto.getAccountType());
                if (StringUtils.isNotBlank((CharSequence)addReqDto.getItemNo())) {
                    orderRuleEo.setItemNo(addReqDto.getItemNo().replace("\uff0c", ","));
                }
                if (StringUtils.isNotBlank((CharSequence)addReqDto.getShopCode())) {
                    orderRuleEo.setShopCode(addReqDto.getShopCode().replace("\uff0c", ","));
                }
                orderRuleEo.setFreightGoodsCode(addReqDto.getFreightGoodsCode());
                orderRuleEo.setReverse(addReqDto.getReverse());
                orderRuleEo.setDeliveryPushSap(addReqDto.getDeliveryPushSap());
                orderRuleEo.setInvoicePushSap(addReqDto.getInvoicePushSap());
                orderRuleEo.setInsiderTransactionAction(addReqDto.getInsiderTransactionAction());
                orderRuleEo.setAccountNode(addReqDto.getAccountNode());
                this.orderRuleDas.insert((BaseEo)orderRuleEo);
            } else {
                if (StringUtils.isNotBlank((CharSequence)addReqDto.getItemNo())) {
                    orderRuleEo.setItemNo(addReqDto.getItemNo().replace("\uff0c", ","));
                } else {
                    orderRuleEo.setItemNo("");
                }
                if (StringUtils.isNotBlank((CharSequence)addReqDto.getShopCode())) {
                    orderRuleEo.setShopCode(addReqDto.getShopCode().replace("\uff0c", ","));
                } else {
                    orderRuleEo.setShopCode("");
                }
                if (StringUtils.isBlank((CharSequence)addReqDto.getFreightGoodsCode())) {
                    orderRuleEo.setFreightGoodsCode("");
                } else {
                    orderRuleEo.setFreightGoodsCode(addReqDto.getFreightGoodsCode());
                }
                orderRuleEo.setReverse(addReqDto.getReverse());
                orderRuleEo.setDeliveryPushSap(addReqDto.getDeliveryPushSap());
                orderRuleEo.setInvoicePushSap(addReqDto.getInvoicePushSap());
                orderRuleEo.setInsiderTransactionAction(addReqDto.getInsiderTransactionAction());
                orderRuleEo.setEnable(Integer.valueOf(1));
                orderRuleEo.setAccountType(addReqDto.getAccountType());
                orderRuleEo.setAccountPriceType(addReqDto.getAccountPriceType());
                orderRuleEo.setBillTime(addReqDto.getBillTime());
                orderRuleEo.setAccountNode(addReqDto.getAccountNode());
                this.orderRuleDas.updateSelective((BaseEo)orderRuleEo);
            }
        } else {
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderRuleEo);
            orderRuleEo.setEnable(Integer.valueOf(1));
            orderRuleEo.setBillTime(addReqDto.getBillTime());
            orderRuleEo.setAccountType(addReqDto.getAccountType());
            if (StringUtils.isNotBlank((CharSequence)addReqDto.getItemNo())) {
                orderRuleEo.setItemNo(addReqDto.getItemNo().replace("\uff0c", ","));
            }
            if (StringUtils.isNotBlank((CharSequence)addReqDto.getShopCode())) {
                orderRuleEo.setShopCode(addReqDto.getShopCode().replace("\uff0c", ","));
            }
            orderRuleEo.setFreightGoodsCode(addReqDto.getFreightGoodsCode());
            orderRuleEo.setReverse(addReqDto.getReverse());
            orderRuleEo.setDeliveryPushSap(addReqDto.getDeliveryPushSap());
            orderRuleEo.setInvoicePushSap(addReqDto.getInvoicePushSap());
            orderRuleEo.setInsiderTransactionAction(addReqDto.getInsiderTransactionAction());
            this.orderRuleDas.insert((BaseEo)orderRuleEo);
        }
        this.saveKeepItemAndShop(orderRuleEo, addReqDto);
        return orderRuleEo.getId();
    }

    @Override
    public void modifyOrderRule(OrderRuleReqDto modifyReqDto) {
        this.cacheService.delCache("orderRuleKey");
        if (Objects.nonNull(modifyReqDto) && Objects.nonNull(modifyReqDto.getId())) {
            OrderRuleEo orderRuleEo = (OrderRuleEo)((ExtQueryChainWrapper)this.orderRuleDas.filter().eq((Object)"id", (Object)modifyReqDto.getId())).one();
            modifyReqDto.setAccountNode(AccountNodeEnum.forCode((String)modifyReqDto.getAccountNode()).getCode());
            if (Objects.isNull(orderRuleEo)) {
                DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderRuleEo);
                try {
                    String date = DateUtil.format((Date)com.yunxi.dg.base.center.finance.service.utils.DateUtil.toDate(modifyReqDto.getBillTime()), (String)"HH:mm:ss");
                    orderRuleEo.setEnable(Integer.valueOf(1));
                    orderRuleEo.setBillTime(date);
                    this.orderRuleDas.insert((BaseEo)orderRuleEo);
                }
                catch (ParseException e) {
                    this.logger.error(e.getMessage());
                    e.printStackTrace();
                }
            } else {
                try {
                    String date = DateUtil.format((Date)com.yunxi.dg.base.center.finance.service.utils.DateUtil.toDate(modifyReqDto.getBillTime()), (String)"HH:mm:ss");
                    orderRuleEo.setItemNo(modifyReqDto.getItemNo());
                    orderRuleEo.setEnable(Integer.valueOf(1));
                    orderRuleEo.setBillTime(date);
                    this.orderRuleDas.updateSelective((BaseEo)orderRuleEo);
                }
                catch (ParseException e) {
                    this.logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderRule(String ids, Long instanceId) {
        String[] removeIds;
        this.cacheService.delCache("orderRuleKey");
        for (String id : removeIds = ids.split(",")) {
            this.orderRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderRuleRespDto queryById(Long id) {
        OrderRuleEo orderRuleEo = (OrderRuleEo)this.orderRuleDas.selectByPrimaryKey(id);
        OrderRuleRespDto orderRuleRespDto = new OrderRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)orderRuleEo, (BaseVo)orderRuleRespDto);
        return orderRuleRespDto;
    }

    @Override
    public OrderRuleRespDto selectOrderRule() {
        OrderRuleRespDto cacheVal = (OrderRuleRespDto)this.cacheService.getCache("orderRuleKey", (TypeReference)new TypeReference<OrderRuleRespDto>(){});
        if (cacheVal != null) {
            return cacheVal;
        }
        List orderRuleEos = this.orderRuleDas.filter().list();
        OrderRuleRespDto orderRuleRespDto = new OrderRuleRespDto();
        if (!CollectionUtils.isEmpty((Collection)orderRuleEos)) {
            CubeBeanUtils.copyProperties((Object)orderRuleRespDto, orderRuleEos.get(0), (String[])new String[0]);
            this.cacheService.setCache("orderRuleKey", (Object)orderRuleRespDto, 7200);
        } else {
            this.cacheService.setCache("orderRuleKey", (Object)orderRuleRespDto, 300);
        }
        this.logger.info("\u67e5\u8be2\u8bb0\u8d26\u57fa\u7840\u8bbe\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderRuleRespDto));
        return orderRuleRespDto;
    }

    @Override
    public OrderRuleRespDto queryOrderRule(OrderRuleReqDto orderRuleReqDto) {
        OrderRuleEo orderRuleEo = new OrderRuleEo();
        CubeBeanUtils.copyProperties((Object)orderRuleEo, (Object)orderRuleReqDto, (String[])new String[0]);
        OrderRuleEo ruleEo = (OrderRuleEo)this.orderRuleDas.selectOne((BaseEo)orderRuleEo);
        List keepItemRuleEos = ((ExtQueryChainWrapper)this.keepItemRuleDas.filter().eq((Object)"order_rule_id", (Object)ruleEo.getId())).list();
        List shopRuleEos = ((ExtQueryChainWrapper)this.shopRuleDas.filter().eq((Object)"order_rule_id", (Object)ruleEo.getId())).list();
        ArrayList itemCodes = Lists.newArrayList();
        ArrayList keepItemCodes = Lists.newArrayList();
        ArrayList keepFreightCodes = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)keepItemRuleEos)) {
            List<KeepItemRuleEo> keepItemRuleEosUnFreight;
            List<KeepItemRuleEo> keepItemRuleEosUnAccounted;
            Map<String, List<KeepItemRuleEo>> itemMap = keepItemRuleEos.stream().collect(Collectors.groupingBy(KeepItemRuleEo::getItemType));
            List<KeepItemRuleEo> keepItemRuleEosRepair = itemMap.get("REPAIR");
            if (CollectionUtil.isNotEmpty(keepItemRuleEosRepair)) {
                List collect = keepItemRuleEosRepair.stream().map(KeepItemRuleEo::getSkuCode).collect(Collectors.toList());
                itemCodes.addAll(collect);
            }
            if (CollectionUtil.isNotEmpty(keepItemRuleEosUnAccounted = itemMap.get("UNACCOUNTED"))) {
                List unaccountedList = keepItemRuleEosUnAccounted.stream().map(KeepItemRuleEo::getSkuCode).collect(Collectors.toList());
                keepItemCodes.addAll(unaccountedList);
            }
            if (CollectionUtil.isNotEmpty(keepItemRuleEosUnFreight = itemMap.get("FREIGHT"))) {
                List freightList = keepItemRuleEosUnFreight.stream().map(KeepItemRuleEo::getSkuCode).collect(Collectors.toList());
                keepFreightCodes.addAll(freightList);
            }
        }
        ArrayList shopCodes = Lists.newArrayList();
        ArrayList warehouseCodes = Lists.newArrayList();
        ArrayList invoiceCodes = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)shopRuleEos)) {
            List<ShopRuleEo> shopRuleEosAccountInvoice;
            List<ShopRuleEo> shopRuleEosAccountWarehouse;
            Map<String, List<ShopRuleEo>> shopMap = shopRuleEos.stream().collect(Collectors.groupingBy(ShopRuleEo::getShopType));
            List<ShopRuleEo> shopRuleEosAccountOrder = shopMap.get("ACCOUNT_BY_ORDER");
            if (CollectionUtil.isNotEmpty(shopRuleEosAccountOrder)) {
                List collect = shopRuleEosAccountOrder.stream().filter(e -> e.getShopType().equals("ACCOUNT_BY_ORDER")).map(e -> e.getShopCode()).collect(Collectors.toList());
                shopCodes.addAll(collect);
            }
            if (CollectionUtil.isNotEmpty(shopRuleEosAccountWarehouse = shopMap.get("DELIVERY_ACCOUNT_WAREHOUSE"))) {
                List warehouseCodeList = shopRuleEosAccountWarehouse.stream().filter(e -> e.getShopType().equals("DELIVERY_ACCOUNT_WAREHOUSE")).map(e -> e.getShopCode()).collect(Collectors.toList());
                warehouseCodes.addAll(warehouseCodeList);
            }
            if (CollectionUtil.isNotEmpty(shopRuleEosAccountInvoice = shopMap.get("ACCOUNT_BY_INVOICE"))) {
                List invoiceCodeList = shopRuleEosAccountInvoice.stream().filter(e -> e.getShopType().equals("ACCOUNT_BY_INVOICE")).map(e -> e.getShopCode()).collect(Collectors.toList());
                invoiceCodes.addAll(invoiceCodeList);
            }
        }
        OrderRuleRespDto orderRuleRespDto = new OrderRuleRespDto();
        CubeBeanUtils.copyProperties((Object)orderRuleRespDto, (Object)ruleEo, (String[])new String[0]);
        orderRuleRespDto.setItemCodes((List)itemCodes);
        orderRuleRespDto.setKeepItemCodes((List)keepItemCodes);
        orderRuleRespDto.setKeepFreightCodes((List)keepFreightCodes);
        orderRuleRespDto.setShopCodes((List)shopCodes);
        orderRuleRespDto.setWarehouseCodes((List)warehouseCodes);
        orderRuleRespDto.setInvoiceCodes((List)invoiceCodes);
        ArrayList keepItemRuleRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(keepItemRuleRespDtos, (Collection)keepItemRuleEos, KeepItemRuleRespDto.class);
        orderRuleRespDto.setKeepItemRuleRespDtos(keepItemRuleRespDtos);
        ArrayList shopRuleRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(shopRuleRespDtos, (Collection)keepItemRuleEos, ShopRuleRespDto.class);
        orderRuleRespDto.setShopRuleRespDtos(shopRuleRespDtos);
        orderRuleRespDto.setNodeConfigMap(this.keepAccountsNodeConfigService.getMapConfig());
        return orderRuleRespDto;
    }

    @Override
    public PageInfo<OrderRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderRuleReqDto orderRuleReqDto = (OrderRuleReqDto)JSON.parseObject((String)filter, OrderRuleReqDto.class);
        OrderRuleEo orderRuleEo = new OrderRuleEo();
        DtoHelper.dto2Eo((BaseVo)orderRuleReqDto, (BaseEo)orderRuleEo);
        PageInfo eoPageInfo = this.orderRuleDomain.selectPage((BaseEo)orderRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            Map<String, KeepAccountsNodeConfigDto> nodeConfigDtoMap = this.keepAccountsNodeConfigService.getMapConfig();
            List dtoList = eoPageInfo.getList().stream().map(v -> {
                OrderRuleRespDto respDto = new OrderRuleRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                respDto.setBillTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + " " + v.getBillTime());
                HashSet shopCodes = new HashSet();
                List shopRuleEos = ((ExtQueryChainWrapper)this.shopRuleDas.filter().eq((Object)"order_rule_id", (Object)v.getId())).list();
                ArrayList shopRuleRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)shopRuleRespDtos, (Collection)shopRuleEos, ShopRuleRespDto.class);
                respDto.setShopRuleRespDtos((List)shopRuleRespDtos);
                shopCodes.addAll(shopRuleRespDtos.stream().map(ShopRuleRespDto::getShopCode).collect(Collectors.toSet()));
                List keepItemRuleEos = ((ExtQueryChainWrapper)this.keepItemRuleDas.filter().eq((Object)"order_rule_id", (Object)v.getId())).list();
                ArrayList keepItemRuleRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)keepItemRuleRespDtos, (Collection)keepItemRuleEos, KeepItemRuleRespDto.class);
                respDto.setKeepItemRuleRespDtos((List)keepItemRuleRespDtos);
                List invoiceShopRuleEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.invoiceShopRuleDas.filter().eq((Object)"order_rule_id", (Object)v.getId())).eq((Object)"bill_shop_type", (Object)BillShopTypeEnum.C.getCode())).list();
                ArrayList invoiceShopRuleRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)invoiceShopRuleRespDtos, (Collection)invoiceShopRuleEos, InvoiceShopRuleRespDto.class);
                respDto.setInvoiceShopRuleRespDtos((List)invoiceShopRuleRespDtos);
                shopCodes.addAll(invoiceShopRuleRespDtos.stream().map(InvoiceShopRuleRespDto::getShopCode).collect(Collectors.toSet()));
                List invoiceShopRuleEosTob = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.invoiceShopRuleDas.filter().eq((Object)"order_rule_id", (Object)v.getId())).eq((Object)"bill_shop_type", (Object)BillShopTypeEnum.B.getCode())).list();
                ArrayList invoiceShopRuleRespDtosTob = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)invoiceShopRuleRespDtosTob, (Collection)invoiceShopRuleEosTob, InvoiceShopRuleRespDto.class);
                respDto.setInvoiceShopRuleRespDtosTob((List)invoiceShopRuleRespDtosTob);
                shopCodes.addAll(invoiceShopRuleRespDtosTob.stream().map(InvoiceShopRuleRespDto::getShopCode).collect(Collectors.toSet()));
                List parentSubsidiaryCompanyShopRuleEos = ((ExtQueryChainWrapper)this.parentSubsidiaryCompanyShopRuleDas.filter().eq((Object)"order_rule_id", (Object)v.getId())).list();
                ArrayList parentSubsidiaryCompanyShopRuleRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)parentSubsidiaryCompanyShopRuleRespDtos, (Collection)parentSubsidiaryCompanyShopRuleEos, ParentSubsidiaryCompanyShopRuleRespDto.class);
                respDto.setParentSubsidiaryCompanyShopRuleRespDtos((List)parentSubsidiaryCompanyShopRuleRespDtos);
                shopCodes.addAll(parentSubsidiaryCompanyShopRuleRespDtos.stream().map(ParentSubsidiaryCompanyShopRuleRespDto::getShopCode).collect(Collectors.toSet()));
                respDto.setNodeConfigMap(nodeConfigDtoMap);
                return respDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(dtoList);
        }
        return dtoPageInfo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveKeepItemAndShop(OrderRuleEo orderRuleEo, OrderRuleReqDto orderRuleReqDto) {
        List keepItemRuleEos;
        List shopRuleEos;
        if (!CollectionUtils.isEmpty((Collection)orderRuleReqDto.getInvoiceShopRuleReqDtos()) && !CollectionUtils.isEmpty((Collection)orderRuleReqDto.getInvoiceShopRuleReqDtosTob())) {
            List toCShopCodes = orderRuleReqDto.getInvoiceShopRuleReqDtos().stream().map(InvoiceShopRuleReqDto::getShopCode).distinct().collect(Collectors.toList());
            List toBShopCodes = orderRuleReqDto.getInvoiceShopRuleReqDtosTob().stream().map(InvoiceShopRuleReqDto::getShopCode).distinct().collect(Collectors.toList());
            List intersection = toCShopCodes.stream().filter(item -> toBShopCodes.contains(item)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(intersection) && intersection.size() > 0) {
                this.logger.info("\u5b58\u5728\u76f8\u540c\u5e97\u94fa\u96c6\u5408:{}", (Object)JSON.toJSONString(intersection));
                throw new BizException("C\u7aef\u4e0eB\u7aef\u5b58\u5728\u76f8\u540c\u7684\u5e97\u94fa\uff1a\u5e97\u94fa\u7f16\u7801\u4e3a\uff1a" + JSON.toJSONString(intersection));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(shopRuleEos = ((ExtQueryChainWrapper)this.shopRuleDas.filter().eq((Object)"order_rule_id", (Object)orderRuleEo.getId())).list()))) {
            this.shopRuleDas.updateShopRuleByOrderRuleId(orderRuleEo.getId());
        }
        List<Object> shopRuleEoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)orderRuleReqDto.getShopRuleReqDtos())) {
            shopRuleEoList = orderRuleReqDto.getShopRuleReqDtos().stream().map(v -> {
                ShopRuleEo ruleEo = new ShopRuleEo();
                ruleEo.setShopCode(v.getShopCode());
                ruleEo.setShopName(v.getShopName());
                ruleEo.setShopType(v.getShopType());
                ruleEo.setSiteCode(v.getSiteCode());
                ruleEo.setSiteName(v.getSiteName());
                ruleEo.setOrderRuleId(orderRuleEo.getId());
                return ruleEo;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)shopRuleEoList)) {
            this.shopRuleDas.insertBatch((List)shopRuleEoList);
        }
        if (!CollectionUtils.isEmpty((Collection)(keepItemRuleEos = ((ExtQueryChainWrapper)this.keepItemRuleDas.filter().eq((Object)"order_rule_id", (Object)orderRuleEo.getId())).list()))) {
            this.keepItemRuleDas.updateKeepItemRuleByOrderRuleId(orderRuleEo.getId());
        }
        List<Object> keepItemRuleEoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)orderRuleReqDto.getKeepItemRuleReqDtos())) {
            keepItemRuleEoList = orderRuleReqDto.getKeepItemRuleReqDtos().stream().map(v -> {
                KeepItemRuleEo ruleEo = new KeepItemRuleEo();
                ruleEo.setItemCode(v.getItemCode());
                ruleEo.setItemName(v.getItemName());
                ruleEo.setSkuCode(v.getSkuCode());
                ruleEo.setSkuName(v.getSkuName());
                ruleEo.setItemType(v.getItemType());
                ruleEo.setOrderRuleId(orderRuleEo.getId());
                return ruleEo;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)keepItemRuleEoList)) {
            this.keepItemRuleDas.insertBatch((List)keepItemRuleEoList);
        }
        this.extractedBCShopRecord(orderRuleEo, orderRuleReqDto);
        this.extractedParentSumRecord(orderRuleEo, orderRuleReqDto);
    }

    private void extractedParentSumRecord(OrderRuleEo orderRuleEo, OrderRuleReqDto orderRuleReqDto) {
        List parentSubsidiaryCompanyShopRuleEos;
        if (!CollectionUtils.isEmpty((Collection)orderRuleReqDto.getParentSubsidiaryCompanyShopRuleReqDtos())) {
            StringBuffer buffer = new StringBuffer();
            orderRuleReqDto.getParentSubsidiaryCompanyShopRuleReqDtos().forEach(v -> {
                if (Objects.isNull(v.getDeliveryCreateTime()) || Objects.isNull(v.getDeliveryCompleteTime())) {
                    buffer.append("\u5e97\u94fa\uff1a" + v.getShopCode() + " ");
                    buffer.append("\u4ea4\u8d27\u5355\u521b\u5efa\u65f6\u95f4\u4e0e\u4ea4\u8d27\u5355\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\r\n");
                }
            });
            if (StringUtils.isNotBlank((CharSequence)buffer.toString())) {
                throw new BizException(buffer.toString());
            }
            orderRuleReqDto.getParentSubsidiaryCompanyShopRuleReqDtos().forEach(v -> {
                Date deliveryCompleteTime;
                Date deliveryCreateTime = com.dtyunxi.cube.utils.DateUtil.parseDate((String)v.getDeliveryCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
                if (deliveryCreateTime.after(deliveryCompleteTime = com.dtyunxi.cube.utils.DateUtil.parseDate((String)v.getDeliveryCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"))) {
                    buffer.append("\u5e97\u94fa\uff1a" + v.getShopCode() + " ");
                    buffer.append("\u4ea4\u8d27\u5355\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u4ea4\u8d27\u5355\u5b8c\u6210\u65f6\u95f4\r\n");
                }
            });
            if (StringUtils.isNotBlank((CharSequence)buffer.toString())) {
                throw new BizException(buffer.toString());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(parentSubsidiaryCompanyShopRuleEos = ((ExtQueryChainWrapper)this.parentSubsidiaryCompanyShopRuleDas.filter().eq((Object)"order_rule_id", (Object)orderRuleEo.getId())).list()))) {
            ParentSubsidiaryCompanyShopRuleEo parentSubsidiaryCompanyShopRuleEo = new ParentSubsidiaryCompanyShopRuleEo();
            parentSubsidiaryCompanyShopRuleEo.setOrderRuleId(orderRuleEo.getId());
            this.parentSubsidiaryCompanyShopRuleDas.logicDelete((BaseEo)parentSubsidiaryCompanyShopRuleEo);
        }
        List<Object> parentSubsidiaryCompanyShopRuleEoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)orderRuleReqDto.getParentSubsidiaryCompanyShopRuleReqDtos())) {
            parentSubsidiaryCompanyShopRuleEoList = orderRuleReqDto.getParentSubsidiaryCompanyShopRuleReqDtos().stream().map(v -> {
                ParentSubsidiaryCompanyShopRuleEo ruleEo = new ParentSubsidiaryCompanyShopRuleEo();
                ruleEo.setSiteCode(v.getSiteCode());
                ruleEo.setSiteName(v.getSiteName());
                ruleEo.setShopCode(v.getShopCode());
                ruleEo.setShopName(v.getShopName());
                ruleEo.setOrderRuleId(orderRuleEo.getId());
                ruleEo.setAssociateCompanyTypeCode(v.getAssociateCompanyTypeCode());
                ruleEo.setDeliveryCreateTime(v.getDeliveryCreateTime());
                ruleEo.setDeliveryCompleteTime(v.getDeliveryCompleteTime());
                return ruleEo;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)parentSubsidiaryCompanyShopRuleEoList)) {
            this.parentSubsidiaryCompanyShopRuleDas.insertBatch((List)parentSubsidiaryCompanyShopRuleEoList);
        }
    }

    private void extractedBCShopRecord(OrderRuleEo orderRuleEo, OrderRuleReqDto orderRuleReqDto) {
        List invoiceShopRuleEosTob;
        List invoiceShopRuleEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.invoiceShopRuleDas.filter().eq((Object)"order_rule_id", (Object)orderRuleEo.getId())).eq((Object)"bill_shop_type", (Object)BillShopTypeEnum.C.getCode())).list();
        if (!CollectionUtils.isEmpty((Collection)invoiceShopRuleEos)) {
            InvoiceShopRuleEo invoiceShopRuleEo = new InvoiceShopRuleEo();
            invoiceShopRuleEo.setOrderRuleId(orderRuleEo.getId());
            this.invoiceShopRuleDas.logicDelete((BaseEo)invoiceShopRuleEo);
        }
        List<Object> invoiceShopRuleEoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)orderRuleReqDto.getInvoiceShopRuleReqDtos())) {
            invoiceShopRuleEoList = orderRuleReqDto.getInvoiceShopRuleReqDtos().stream().map(v -> {
                InvoiceShopRuleEo ruleEo = new InvoiceShopRuleEo();
                ruleEo.setShopCode(v.getShopCode());
                ruleEo.setShopName(v.getShopName());
                ruleEo.setOrderRuleId(orderRuleEo.getId());
                ruleEo.setBillShopType(BillShopTypeEnum.C.getCode());
                return ruleEo;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)invoiceShopRuleEoList)) {
            this.invoiceShopRuleDas.insertBatch((List)invoiceShopRuleEoList);
        }
        if (!CollectionUtils.isEmpty((Collection)(invoiceShopRuleEosTob = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.invoiceShopRuleDas.filter().eq((Object)"order_rule_id", (Object)orderRuleEo.getId())).eq((Object)"bill_shop_type", (Object)BillShopTypeEnum.B.getCode())).list()))) {
            InvoiceShopRuleEo invoiceShopRuleEo = new InvoiceShopRuleEo();
            invoiceShopRuleEo.setOrderRuleId(orderRuleEo.getId());
            this.invoiceShopRuleDas.logicDelete((BaseEo)invoiceShopRuleEo);
        }
        List<Object> invoiceShopRuleEoTobList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)orderRuleReqDto.getInvoiceShopRuleReqDtosTob())) {
            invoiceShopRuleEoTobList = orderRuleReqDto.getInvoiceShopRuleReqDtosTob().stream().map(v -> {
                InvoiceShopRuleEo ruleEo = new InvoiceShopRuleEo();
                ruleEo.setShopCode(v.getShopCode());
                ruleEo.setShopName(v.getShopName());
                ruleEo.setOrderRuleId(orderRuleEo.getId());
                ruleEo.setBillShopType(BillShopTypeEnum.B.getCode());
                return ruleEo;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)invoiceShopRuleEoTobList)) {
            this.invoiceShopRuleDas.insertBatch((List)invoiceShopRuleEoTobList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void openAutomaticPush(OrderRuleReqDto orderRuleReqDto) {
        this.logger.info("\u662f\u5426\u5f00\u542f\u5f00\u7968\u8bb0\u8d26\u81ea\u52a8\u63a8\u9001\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderRuleReqDto));
        OrderRuleEo orderRuleEo = (OrderRuleEo)this.orderRuleDas.selectByPrimaryKey(orderRuleReqDto.getId());
        if (Objects.isNull(orderRuleEo)) {
            throw new BizException("\u8bb0\u8d26\u57fa\u7840\u8bbe\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        OrderRuleEo eo = new OrderRuleEo();
        orderRuleEo.setId(orderRuleEo.getId());
        orderRuleEo.setInvoicePushSap(orderRuleReqDto.getInvoicePushSap());
        this.orderRuleDas.updateSelective((BaseEo)eo);
    }

    @Override
    public RuleParamReqDto getRuleParamReqDto(MamualKeepAccountReqDto mamualKeepAccountReqDto, String node, String orderType) {
        RuleParamReqDto ruleParamReqDto = new RuleParamReqDto();
        ruleParamReqDto.setNode(node);
        ruleParamReqDto.setOrderType(orderType);
        ruleParamReqDto.setType(mamualKeepAccountReqDto.getType());
        if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{mamualKeepAccountReqDto.getStartTime(), mamualKeepAccountReqDto.getEndTime(), mamualKeepAccountReqDto.getInnerOrderNo()}) && CollectionUtil.isEmpty((Collection)mamualKeepAccountReqDto.getInnerOrderNos())) {
            LocalDate currentDate = LocalDate.now();
            LocalDateTime startTime = LocalDateTime.of(currentDate, LocalTime.MIN);
            LocalDateTime endTime = LocalDateTime.of(currentDate, LocalTime.MAX);
            String dateString = startTime.format(FORMATTER);
            String format = endTime.format(FORMATTER);
            mamualKeepAccountReqDto.setStartTime(dateString);
            mamualKeepAccountReqDto.setEndTime(format);
        }
        if (Objects.nonNull(mamualKeepAccountReqDto.getStartTime())) {
            ruleParamReqDto.setDeliverStartDate(com.dtyunxi.util.DateUtil.parse((String)mamualKeepAccountReqDto.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (Objects.nonNull(mamualKeepAccountReqDto.getEndTime())) {
            ruleParamReqDto.setDeliverEndDate(com.dtyunxi.util.DateUtil.parse((String)mamualKeepAccountReqDto.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        ruleParamReqDto.setStartTime(mamualKeepAccountReqDto.getStartTime());
        ruleParamReqDto.setEndTime(mamualKeepAccountReqDto.getEndTime());
        ruleParamReqDto.setChargeDate(mamualKeepAccountReqDto.getChargeDate());
        ruleParamReqDto.setGeneratePerson(mamualKeepAccountReqDto.getGeneratePerson());
        ruleParamReqDto.setPushPerson(mamualKeepAccountReqDto.getPushPerson());
        ruleParamReqDto.setBillShopType(mamualKeepAccountReqDto.getBillShopType());
        ruleParamReqDto.setWarehouseCode(mamualKeepAccountReqDto.getWarehouseCode());
        ruleParamReqDto.setReceiveWarehouseCode(mamualKeepAccountReqDto.getReceiveWarehouseCode());
        ruleParamReqDto.setInnerOrderNo(mamualKeepAccountReqDto.getInnerOrderNo());
        ruleParamReqDto.setPlatformNo(mamualKeepAccountReqDto.getPlatformNo());
        ruleParamReqDto.setInnerOrderNos(mamualKeepAccountReqDto.getInnerOrderNos());
        ruleParamReqDto.setVoucherType(mamualKeepAccountReqDto.getVoucherType());
        ruleParamReqDto.setBusinessType(mamualKeepAccountReqDto.getBusinessType());
        ruleParamReqDto.setBusinessTypeName(mamualKeepAccountReqDto.getBusinessTypeName());
        return ruleParamReqDto;
    }

    @Override
    public KeepNodeRuleParam init(MamualKeepAccountReqDto mamualKeepAccountReqDto, String node, String orderType) {
        RuleParamReqDto paramReqDto = this.getRuleParamReqDto(mamualKeepAccountReqDto, node, orderType);
        OrderRuleEo orderRuleEo = (OrderRuleEo)this.orderRuleDas.filter().one();
        OrderRuleRespDto orderRuleRespDto = this.queryOrderRule(new OrderRuleReqDto());
        List itemCodes = orderRuleRespDto.getItemCodes();
        List shopCodes = orderRuleRespDto.getShopCodes();
        List keepItemCodes = orderRuleRespDto.getKeepItemCodes();
        List warehouseCodes = orderRuleRespDto.getWarehouseCodes();
        Map<Object, Object> interfaceTypeListMap = Maps.newHashMap();
        if ("HCK".equals(this.keepSystem)) {
            interfaceTypeListMap = this.keepInterfaceTypeService.queryKeepInterfaceType();
        }
        paramReqDto.setItemCodes(itemCodes);
        paramReqDto.setShopCodes(shopCodes);
        paramReqDto.setKeepItemCodes(keepItemCodes);
        paramReqDto.setInterfaceTypeListMap((Map)interfaceTypeListMap);
        paramReqDto.setKeepNodeWarehouseCodes(warehouseCodes);
        paramReqDto.setOrderType(paramReqDto.getOrderType());
        this.logger.info("\u521d\u59cb\u5316\u6570\u636e\uff1a{},{}", (Object)JSON.toJSONString((Object)orderRuleEo), (Object)JSON.toJSONString((Object)paramReqDto));
        KeepNodeRuleParam keepNodeRuleParam = new KeepNodeRuleParam();
        keepNodeRuleParam.setOrderRuleEo(orderRuleEo);
        keepNodeRuleParam.setParamReqDto(paramReqDto);
        keepNodeRuleParam.setOrderType(paramReqDto.getOrderType());
        keepNodeRuleParam.setBusinessType(paramReqDto.getBusinessType());
        keepNodeRuleParam.setBusinessTypeName(paramReqDto.getBusinessTypeName());
        keepNodeRuleParam.setOrderRuleRespDto(orderRuleRespDto);
        return keepNodeRuleParam;
    }
}

