/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl.rule;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.vo.BookAccountsReqVo;
import com.yunxi.dg.base.center.finance.dto.ResultSaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BookKeepingType;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.MasterSlaveTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SingleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepOutResultDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.finance.service.utils.TradeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HckExchangeDeliveryNodeRule
implements KeepNodeRule {
    private static final Logger log = LoggerFactory.getLogger(HckExchangeDeliveryNodeRule.class);

    @Override
    public void execute(KeepNodeRuleParam context) {
        long start = System.currentTimeMillis();
        log.info("\u6362\u8d27\u5165\u5e93\u521d\u59cb\u5316\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context));
        IOrderRuleService orderRuleService = (IOrderRuleService)SpringBeanUtil.getBean(IOrderRuleService.class);
        OrderRuleRespDto orderRuleRespDto = orderRuleService.selectOrderRule();
        ArrayList orderItemVoList = Lists.newArrayList();
        BookAccountsReqVo reqVo = new BookAccountsReqVo();
        reqVo.setOrderStatus(Arrays.asList(OmsOrderStatusEnum.IN_WAREHOUSE.getCode(), OmsOrderStatusEnum.FINISH.getCode()));
        reqVo.setAfterSaleOrderTypes(Arrays.asList(AfterSaleOrderTypeEnum.HH.getCode(), AfterSaleOrderTypeEnum.hh.getCode()));
        reqVo.setAfterTypeFlag(AfterSaleOrderTypeEnum.HH.getCode());
        if (null != orderRuleRespDto) {
            reqVo.setAfterCreateDelivery(orderRuleRespDto.getReverse());
        }
        if (Objects.equals(KeepTypeEnum.AUTO.getCode(), context.getParamReqDto().getType())) {
            reqVo.setStartTime(context.getParamReqDto().getStartDate());
            reqVo.setEndTime(context.getOrderRuleEo().getBillTime());
        } else if (Objects.equals(KeepTypeEnum.REAL.getCode(), context.getParamReqDto().getType())) {
            reqVo.setInnerOrderNo(context.getParamReqDto().getInnerOrderNo());
            reqVo.setRealTimeFlag(Integer.valueOf(BigDecimal.ONE.intValue()));
        } else {
            reqVo.setStartTime(context.getParamReqDto().getStartTime() + " 00:00:00");
            reqVo.setEndTime(context.getParamReqDto().getEndTime() + " 23:59:59");
            reqVo.setWarehouseCode(context.getParamReqDto().getWarehouseCode());
        }
    }

    public void handler(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos, String startTime, String endTime, String orderType) {
        long start = System.currentTimeMillis();
        IBookKeepAccountService iBookKeepAccountService = (IBookKeepAccountService)SpringBeanUtil.getBean(IBookKeepAccountService.class);
        if (CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
            iBookKeepAccountService.partialDealKeepAccountDetails(keepAccountsDetailEos, orderType);
            log.info("\u4fdd\u5b58\u8bb0\u8d26\u660e\u7ec6\u8017\u65f6\uff1a{}~{}\uff0c{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
        }
        if (CollectionUtils.isNotEmpty(outResultDetailEos)) {
            iBookKeepAccountService.partialOutDealKeepAccountDetails(outResultDetailEos, orderType);
            log.info("\u4fdd\u5b58\u51fa\u5e93\u7ed3\u679c\u8bb0\u8d26\u660e\u7ec6\u8017\u65f6\uff1a{}~{}\uff0c{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
        }
        log.info("\u5206\u9875\u67e5\u8be2\u751f\u6210\u9700\u8981\u751f\u6210\u4ea4\u8d27\u8bb0\u8d26\u660e\u7ec6\u5546\u54c1\u884c\u8017\u65f6\uff1a{}~{},{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
    }

    public Map<String, Object> validateKeep(List<SaleOrderItemVo> orderItemVoList, KeepNodeRuleParam context) {
        HashMap keepDetailMap = Maps.newHashMap();
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        ArrayList outResultDetailEos = Lists.newArrayList();
        HashSet exceptionDetailEos = new HashSet();
        orderItemVoList.forEach(v -> {
            KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
            KeepOutResultDetailEo outResultDetailEo = new KeepOutResultDetailEo();
            if (CollectionUtils.isNotEmpty((Collection)context.getParamReqDto().getKeepItemCodes()) && context.getParamReqDto().getKeepItemCodes().contains(v.getItemCode())) {
                log.info("\u6362\u8d27\u4e0d\u8bb0\u8d26\u5546\u54c1\u8bbe\u7f6e\u8ba2\u5355: " + v.getOrderId() + "\u4e0d\u8bb0\u8d26\u5546\u54c1\u8bbe\u7f6e\u4e0d\u8fdb\u884c\u8bb0\u8d26");
                String extension = "\u6362\u8d27\u4e0d\u8bb0\u8d26\u5546\u54c1\u8bbe\u7f6e\u8ba2\u5355\uff1a" + v.getOrderId() + " \u4e0d\u8bb0\u8d26\u5546\u54c1\u8bbe\u7f6e\u4e0d\u8fdb\u884c\u8bb0\u8d26";
                exceptionDetailEos.add(this.setKeepException(v.getOrderNo(), v.getItemCode(), extension));
                return;
            }
            this.initKeepAccountsDetail(keepAccountsDetailEo, (SaleOrderItemVo)v);
            this.initResultKeepAccountsDetail(outResultDetailEo, (SaleOrderItemVo)v);
            keepAccountsDetailEos.add(keepAccountsDetailEo);
            outResultDetailEos.add(outResultDetailEo);
        });
        keepDetailMap.put("keepDetails", keepAccountsDetailEos);
        keepDetailMap.put("outKeepDetails", outResultDetailEos);
        keepDetailMap.put("exceptionDetails", exceptionDetailEos);
        return keepDetailMap;
    }

    private KeepExceptionDetailEo setKeepException(String saleOrderNo, String itemCode, String extension) {
        KeepExceptionDetailEo exceptionDetailEo = new KeepExceptionDetailEo();
        exceptionDetailEo.setOrderNo(saleOrderNo);
        exceptionDetailEo.setConditionType(ConditionTypeEnum.RETURN_BASE_DELIVERY.getCode());
        exceptionDetailEo.setOrderType(BillTypeEnum.RETURN_BASE.getCode());
        exceptionDetailEo.setItemCode(itemCode);
        exceptionDetailEo.setExtension(extension);
        return exceptionDetailEo;
    }

    public void initKeepAccountsDetail(KeepAccountsDetailEo keepAccountsDetailEo, SaleOrderItemVo v) {
        keepAccountsDetailEo.setChargeCode(v.getChargeCode());
        keepAccountsDetailEo.setBatchNo(v.getBatchNo());
        keepAccountsDetailEo.setOrderNo(v.getOrderNo());
        keepAccountsDetailEo.setCustomerId(v.getCustomerId());
        keepAccountsDetailEo.setCustomerCode(v.getCustomerCode());
        keepAccountsDetailEo.setCustomerName(v.getCustomerName());
        keepAccountsDetailEo.setSapCode(v.getSapCode());
        keepAccountsDetailEo.setItemCode(v.getItemCode());
        keepAccountsDetailEo.setWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setItemNum(v.getItemNum());
        keepAccountsDetailEo.setItemPrice(v.getItemPrice());
        keepAccountsDetailEo.setBookKeeping(BookKeepingType.NOT_DEAL.getCode());
        keepAccountsDetailEo.setOrderInterface(v.getOrderInterface());
        keepAccountsDetailEo.setBillingInterface(v.getBillingInterface());
        keepAccountsDetailEo.setItemType(Convert.toStr((Object)v.getProductType()));
        keepAccountsDetailEo.setOrderType(v.getOrderType());
        keepAccountsDetailEo.setOrderId(v.getOrderId());
        keepAccountsDetailEo.setConditionType(v.getConditionType());
        keepAccountsDetailEo.setVoucherType(v.getVoucherType());
        keepAccountsDetailEo.setDeliveryConfirmTime(v.getDeliveryCompleteDate());
        keepAccountsDetailEo.setItemName(v.getItemName());
        keepAccountsDetailEo.setSiteCode(v.getSiteCode());
        keepAccountsDetailEo.setSiteName(v.getSiteName());
        keepAccountsDetailEo.setOrderItemId(v.getOrderItemId());
        keepAccountsDetailEo.setInvoice(v.getInvoice());
        keepAccountsDetailEo.setShopCode(v.getShopCode());
        keepAccountsDetailEo.setShopName(v.getShopName());
        keepAccountsDetailEo.setShopId(v.getShopId());
        keepAccountsDetailEo.setSingle(v.getSingle());
        keepAccountsDetailEo.setProductType(v.getProductType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setPlaceTime(v.getPlaceTime());
        keepAccountsDetailEo.setPlatformNo(v.getPlatformNo());
        keepAccountsDetailEo.setPlatformOrderNo(v.getPlatformOrderNo());
        keepAccountsDetailEo.setDocumentNo(v.getDocumentNo());
        keepAccountsDetailEo.setDocumentId(v.getDocumentId());
        keepAccountsDetailEo.setOrderStatus(v.getOrderStatus());
        keepAccountsDetailEo.setCompleteTime(v.getCompleteDate());
        keepAccountsDetailEo.setDeliveryTime(v.getInWarehouseDate());
        keepAccountsDetailEo.setItemId(v.getItemId());
        keepAccountsDetailEo.setGeneratePerson(v.getGeneratePerson());
        keepAccountsDetailEo.setPlatformCreateTime(v.getPlatformCreateTime());
        keepAccountsDetailEo.setSaleOrderType(v.getSaleOrderType());
        keepAccountsDetailEo.setGroupSkuCode(v.getGroupSkuCode());
        keepAccountsDetailEo.setGroupItemName(v.getGroupItemName());
        keepAccountsDetailEo.setGroupItemId(v.getGroupItemId());
        keepAccountsDetailEo.setRealTimeFlag(v.getRealTimeFlag());
        keepAccountsDetailEo.setOrganizationCode(v.getOrganizationCode());
        keepAccountsDetailEo.setOrganizationName(v.getOrganizationName());
        keepAccountsDetailEo.setErpOrderType(v.getErpOrderType());
        keepAccountsDetailEo.setShippingNo(v.getShippingNo());
        keepAccountsDetailEo.setShopOrganizationCode(v.getShopOrganizationCode());
        keepAccountsDetailEo.setShopOrganizationName(v.getShopOrganizationName());
        keepAccountsDetailEo.setWarehouseType(v.getWarehouseType());
        keepAccountsDetailEo.setDeliveryWay(v.getDeliveryWay());
        keepAccountsDetailEo.setWarehouseProperty(v.getWarehouseProperty());
        keepAccountsDetailEo.setOutResultCreateTime(v.getOutResultCreateTime());
        keepAccountsDetailEo.setOutResultUpdateTime(v.getOutResultUpdateTime());
        keepAccountsDetailEo.setPreOrderNo(v.getPreOrderNo());
        keepAccountsDetailEo.setOutWarehouseCode(v.getOutWarehouseCode());
        keepAccountsDetailEo.setChargeAccountName(v.getChargeAccountName());
        keepAccountsDetailEo.setPlatformCompleteTime(v.getPlatformCompleteTime());
        keepAccountsDetailEo.setPlatformOrderId(v.getPlatformOrderId());
        keepAccountsDetailEo.setPlatformOrderItemNo(v.getPlatformOrderItemNo());
        keepAccountsDetailEo.setPlatformItemName(v.getPlatformItemName());
        keepAccountsDetailEo.setPlatformItemCode(v.getPlatformItemCode());
        keepAccountsDetailEo.setPlatformItemSkuCode(v.getPlatformItemSkuCode());
    }

    public void initResultKeepAccountsDetail(KeepOutResultDetailEo keepAccountsDetailEo, SaleOrderItemVo v) {
        ResultSaleOrderItemVo vo = v.getResultSaleOrderItemVo();
        keepAccountsDetailEo.setOrderType(v.getOrderType());
        keepAccountsDetailEo.setChargeCode(v.getChargeCode());
        keepAccountsDetailEo.setOrderNo(v.getOrderNo());
        keepAccountsDetailEo.setItemCode(null != vo ? vo.getLongCode() : null);
        keepAccountsDetailEo.setWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setItemNum(null != vo ? Integer.valueOf(vo.getQuantity().intValue()) : null);
        keepAccountsDetailEo.setItemPrice(v.getItemPrice());
        keepAccountsDetailEo.setBookKeeping(BookKeepingType.NOT_DEAL.getCode());
        keepAccountsDetailEo.setItemType(Convert.toStr((Object)v.getProductType()));
        keepAccountsDetailEo.setOrderId(null != vo ? vo.getDocumentId() : null);
        keepAccountsDetailEo.setItemName(null != vo ? vo.getCargoName() : null);
        keepAccountsDetailEo.setOrderItemId(null != vo ? vo.getTradeOrderItemId() : null);
        keepAccountsDetailEo.setSingle(v.getSingle());
        keepAccountsDetailEo.setProductType(v.getProductType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setDocumentNo(null != vo ? vo.getDocumentNo() : null);
        keepAccountsDetailEo.setItemId(null != vo ? vo.getCargoId() : null);
        keepAccountsDetailEo.setGeneratePerson(v.getGeneratePerson());
        keepAccountsDetailEo.setResultDetailId(null != vo ? vo.getResultOrderDetailId() : null);
        keepAccountsDetailEo.setBatchNo(v.getBatchNo());
        keepAccountsDetailEo.setOutResultCreateTime(null != vo ? vo.getOutResultCreateTime() : null);
        keepAccountsDetailEo.setOutResultUpdateTime(null != vo ? vo.getOutResultUpdateTime() : null);
        keepAccountsDetailEo.setPreOrderNo(null != vo ? vo.getPreOrderNo() : null);
    }

    public List<SaleOrderItemVo> matcherCustomerItemWarehouseInfo(List<SaleOrderItemVo> orderItemVoList, KeepNodeRuleParam context, BookAccountsReqVo reqVo) {
        Map interfaceTypeListMap = context.getParamReqDto().getInterfaceTypeListMap();
        List itemCodes = orderItemVoList.stream().map(SaleOrderItemVo::getItemCode).distinct().collect(Collectors.toList());
        HashMap chargeCodeCache = Maps.newHashMap();
        HashMap batchNoCache = Maps.newHashMap();
        String TABLENAME = "after_thtk_order_item_id#";
        ILockService lockService = (ILockService)SpringBeanUtil.getBean(ILockService.class);
        orderItemVoList.forEach(v -> {
            Mutex mutex = null;
            try {
                String primaryKey = v.getOrderNo() + "_" + Convert.toStr((Object)v.getOrderItemId());
                mutex = lockService.lock(TABLENAME, primaryKey);
                if (null == mutex) {
                    throw new BizException(String.format("\u63a5\u6536\u6362\u8d27\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,primaryKey:\u3010%s\u3011", primaryKey));
                }
                String code = (String)chargeCodeCache.get(v.getOrderNo());
                if (StringUtils.isBlank((CharSequence)code)) {
                    String chargeCode = "BL" + TradeUtil.generateTradeNo();
                    v.setChargeCode(chargeCode);
                    chargeCodeCache.put(v.getOrderNo(), chargeCode);
                } else {
                    v.setChargeCode(code);
                }
                String batch = (String)batchNoCache.get(v.getOrderNo());
                if (StringUtils.isBlank((CharSequence)batch)) {
                    String batchNo = TradeUtil.generateTradeNo();
                    v.setBatchNo(batchNo);
                    batchNoCache.put(v.getOrderNo(), batchNo);
                } else {
                    v.setBatchNo(batch);
                }
                v.setSingle(SingleTypeEnum.YES.getCode());
                v.setMasterDeputyIdentity(MasterSlaveTypeEnum.MASTER.getCode());
                v.setRealTimeFlag(Integer.valueOf(null != reqVo.getRealTimeFlag() ? reqVo.getRealTimeFlag().intValue() : BigDecimal.ZERO.intValue()));
                v.setGeneratePerson(null != context.getParamReqDto().getGeneratePerson() ? context.getParamReqDto().getGeneratePerson() : null);
                v.setOrderType(BillTypeEnum.EXCHANGE.getCode());
                v.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
                v.setConditionType(ConditionTypeEnum.EXCHANGE_DELIVERY.getCode());
                if (mutex == null) return;
            }
            catch (Exception e) {
                try {
                    log.error("\u63a5\u6536\u6362\u8d27\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u4fe1\u606f\u5904\u7406\u5f02\u5e38:\u3010%s\u3011\uff0c\u3010%s\u3011", (Object)e.getMessage(), (Object)e);
                    throw new BizException(String.format("\u63a5\u6536\u6362\u8d27\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u4fe1\u606f\u5904\u7406\u5f02\u5e38:\u3010%s\u3011\uff0c\u3010%s\u3011", e.getMessage(), e));
                }
                catch (Throwable throwable) {
                    if (mutex == null) throw throwable;
                    lockService.unlock(mutex);
                    throw throwable;
                }
            }
            lockService.unlock(mutex);
            return;
        });
        orderItemVoList.forEach(v -> {});
        List relevanceNos = orderItemVoList.stream().map(SaleOrderItemVo::getSaleOrderNo).distinct().collect(Collectors.toList());
        List tradeOrderItemIds = orderItemVoList.stream().map(SaleOrderItemVo::getSaleOrderItemId).distinct().collect(Collectors.toList());
        reqVo.setRelevanceNos(relevanceNos);
        reqVo.setTradeOrderItemIds(tradeOrderItemIds);
        log.info("\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqVo));
        return orderItemVoList;
    }
}

