/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl.rule;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Maps;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.center.finance.dto.PushOutsideSysAccountDto;
import com.yunxi.dg.base.center.finance.dto.common.FinanceConstant;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepResultEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KingdeeErpConstantEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushSapEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushStatusEnum;
import com.yunxi.dg.base.center.finance.dto.request.ConnectorOrderReturnReqDto;
import com.yunxi.dg.base.center.finance.dto.request.ConnectorSaleOrderReturnReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepTimeOutReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeDirectTransferAllotReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeOfflineConsignmentDeliveryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeOrderOutStockReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeOutboundReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeProxySaleDeliveryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KingdeeSupplierOrderOutStockReqDto;
import com.yunxi.dg.base.center.finance.dto.request.PushKeepAccountsReqDto;
import com.yunxi.dg.base.center.finance.dto.request.RuleParamReqDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IHckBookKeepService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepTimeOutService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.impl.KeepAccountingServiceImpl;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HckPushErpDeliveryNodeRule
implements KeepNodeRule {
    private static final Logger log = LoggerFactory.getLogger(HckPushErpDeliveryNodeRule.class);
    private String conditionType;
    private static final String TABLENAME_DELIVERY = "keep_delivery";

    public String getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(String conditionType) {
        this.conditionType = conditionType;
    }

    public HckPushErpDeliveryNodeRule(String conditionType) {
        this.conditionType = conditionType;
    }

    @Override
    public void execute(KeepNodeRuleParam context) {
        long start = System.currentTimeMillis();
        log.info("===============\u63a8\u9001erp\u751f\u6210\u9500\u552e\u5355/\u552e\u540e\u5355\u5f00\u59cb================,{}", (Object)JSON.toJSONString((Object)context));
        IHckBookKeepService erpBookKeepService = (IHckBookKeepService)SpringBeanUtil.getBean(IHckBookKeepService.class);
        OrderRuleRespDto orderRuleRespDto = context.getOrderRuleRespDto();
        if (Objects.isNull(orderRuleRespDto)) {
            IOrderRuleService orderRuleService = (IOrderRuleService)SpringBeanUtil.getBean(IOrderRuleService.class);
            orderRuleRespDto = orderRuleService.selectOrderRule();
        }
        if (Objects.isNull(orderRuleRespDto) || Objects.equals(PushSapEnum.FALSE.getCode(), orderRuleRespDto.getDeliveryPushSap())) {
            log.info("\u5f53\u524d\u4ea4\u8d27\u8bb0\u8d26\u81ea\u52a8\u63a8\u9001\u914d\u7f6e\u4e3a\u4e0d\u81ea\u52a8\u63a8\u9001!");
            return;
        }
        RuleParamReqDto paramReqDto = context.getParamReqDto();
        log.info("\u5f53\u524d\u63a8\u9001\u7b2c\u4e09\u65b9\u8bf7\u6c42,\u65e5\u5fd7\u6570\u636e:{}", (Object)JSON.toJSONString((Object)paramReqDto));
        Map<String, PushOutsideSysAccountDto> pushErpMap = erpBookKeepService.groupBySaleOrderKeep(paramReqDto);
        log.info("\u5f53\u524d\u63a8\u9001\u7b2c\u4e09\u65b9\u8bf7\u6c42,\u8bf7\u6c42\u5355\u636e\u6570\u636e:{}", (Object)JSON.toJSONString(pushErpMap));
        try {
            erpBookKeepService.rePushOpenapiNew(orderRuleRespDto, context, "0", pushErpMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u63a8\u9001\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u5904\u7406\u63a8\u9001erp\u751f\u6210\u9500\u552e\u5355/\u552e\u540e\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }

    public Map<String, Object> rePushErp(Map<String, Object> pushErpMap, KeepNodeRuleParam context, IHckBookKeepService erpBookKeepService, Object kingdeeStorageApi, IPushKeepAccountsService pushKeepAccountsService, ILockService lockService, IKeepTimeOutService keepTimeOutService) {
        HashMap pushErrorMap = Maps.newHashMap();
        pushErpMap.forEach((k, v) -> {
            List<String> keyList = Arrays.asList(k.split("_"));
            String chargeCode = keyList.get(0);
            String interfaceName = keyList.get(1);
            PushKeepAccountsReqDto pushKeepAccountsReqDto = new PushKeepAccountsReqDto();
            pushKeepAccountsReqDto.setChargeCode(chargeCode);
            Mutex mutex = null;
            try {
                mutex = lockService.lock(TABLENAME_DELIVERY, chargeCode, FinanceConstant.LOCK_WAIT_TIME_OUT, FinanceConstant.LOCK_LEASE_TIME, TimeUnit.MINUTES);
                if (null == mutex) {
                    throw new BizException("\u91cd\u65b0\u751f\u6210\u4ea4\u8d27\u8bb0\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                HckPushErpDeliveryNodeRule.extractedExternalInterfaces(erpBookKeepService, kingdeeStorageApi, v, chargeCode, interfaceName, pushKeepAccountsReqDto);
                pushKeepAccountsService.modifyPushKeepAndKeepDetail(pushKeepAccountsReqDto);
            }
            catch (Exception e) {
                block8: {
                    try {
                        log.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u662f\u5427\u8ba2\u5355\u51fa\u5e93\u63a5\u53e3\u5931\u8d25\uff1a{}", (Throwable)e);
                        pushKeepAccountsReqDto.setReason(e.getMessage());
                        pushKeepAccountsReqDto.setPushStatus(PushStatusEnum.PUSH_FAIL.getCode());
                        pushKeepAccountsReqDto.setKeepingResult(KeepResultEnum.FAIL.getCode());
                        pushKeepAccountsService.modifyPushKeepAndKeepDetail(pushKeepAccountsReqDto);
                        if (e.getMessage().contains("Read timed out executing")) {
                            KeepTimeOutReqDto timeOutReqDto = new KeepTimeOutReqDto();
                            timeOutReqDto.setChargeCode(chargeCode);
                            timeOutReqDto.setStatus(Integer.valueOf(1));
                            if (Objects.equals(BillTypeEnum.SALE_LIST.getCode(), context.getParamReqDto().getOrderType())) {
                                timeOutReqDto.setBusinessType("order");
                            } else {
                                timeOutReqDto.setBusinessType("after");
                            }
                            keepTimeOutService.addKeepTimeOut(timeOutReqDto);
                            break block8;
                        }
                        pushErrorMap.put(k, v);
                    }
                    catch (Throwable throwable) {
                        lockService.unlock(mutex);
                        throw throwable;
                    }
                }
                lockService.unlock(mutex);
            }
            lockService.unlock(mutex);
        });
        return pushErrorMap;
    }

    private static void extractedExternalInterfaces(IHckBookKeepService erpBookKeepService, Object kingdeeStorageApi, Object v, String chargeCode, String interfaceName, PushKeepAccountsReqDto pushKeepAccountsReqDto) {
        KeepAccountingServiceImpl bean = (KeepAccountingServiceImpl)SpringBeanUtil.getBean(KeepAccountingServiceImpl.class);
        if (KingdeeErpConstantEnum.OmsErp21Service.getCode().equals(interfaceName)) {
            KingdeeOrderOutStockReqDto saleOrderOutStockReqDto = (KingdeeOrderOutStockReqDto)v;
            log.info("\u8c03\u7528\u9500\u552e-\u8ba2\u5355\u51fa\u5e93\u91d1\u8776erp\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)saleOrderOutStockReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u9500\u552e-\u8ba2\u5355\u51fa\u5e93\u91d1\u8776erp\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        } else if (KingdeeErpConstantEnum.OmsErp3Service.getCode().equals(interfaceName)) {
            KingdeeSupplierOrderOutStockReqDto supplierSaleOrderOutStockReqDto = (KingdeeSupplierOrderOutStockReqDto)v;
            log.info("\u8c03\u7528\u91d1\u8776-\u4f9b\u5e94\u5546\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)supplierSaleOrderOutStockReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u91d1\u8776-\u4f9b\u5e94\u5546\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        } else if (KingdeeErpConstantEnum.OmsErp8Service.getCode().equals(interfaceName)) {
            KingdeeOutboundReqDto otherOutboundReqDto = (KingdeeOutboundReqDto)v;
            log.info("\u8c03\u7528\u91d1\u8776-\u5176\u4ed6\u51fa\u5e93\u5355(ERP8)\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)otherOutboundReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u91d1\u8776-\u5176\u4ed6\u51fa\u5e93\u5355(ERP8)\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        } else if (KingdeeErpConstantEnum.OmsErp42Service.getCode().equals(interfaceName)) {
            KingdeeOfflineConsignmentDeliveryReqDto consignmentDeliveryReqDto = (KingdeeOfflineConsignmentDeliveryReqDto)v;
            log.info("\u8c03\u7528\u91d1\u8776-erp\u4ee3\u9500\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)consignmentDeliveryReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u91d1\u8776-erp\u4ee3\u9500\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        } else if (KingdeeErpConstantEnum.OmsErp43Service.getCode().equals(interfaceName)) {
            KingdeeProxySaleDeliveryReqDto consignmentDeliveryReqDto = (KingdeeProxySaleDeliveryReqDto)v;
            log.info("\u8c03\u7528\u91d1\u8776erp43\u4ee3\u9500\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)consignmentDeliveryReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u91d1\u8776erp43\u4ee3\u9500\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        } else if (KingdeeErpConstantEnum.OmsErp51Service.getCode().equals(interfaceName)) {
            ConnectorSaleOrderReturnReqDto saleOrderReturnReqDto = (ConnectorSaleOrderReturnReqDto)v;
            log.info("\u8c03\u7528\u91d1\u8776\u9500\u552e\u8ba2\u5355\u9000\u8d27\u6362\u8d27\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)saleOrderReturnReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u91d1\u8776\u9500\u552e\u8ba2\u5355\u9000\u8d27\u6362\u8d27\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        } else if (KingdeeErpConstantEnum.OmsErp53Service.getCode().equals(interfaceName)) {
            ConnectorOrderReturnReqDto orderReturnReqDto = (ConnectorOrderReturnReqDto)v;
            log.info("\u8c03\u7528\u91d1\u8776OMS\u9000\u8d27\u5b8c\u6210\u63a8\u9001\u4fe1\u606f\u7ed9\u91d1\u8776\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)orderReturnReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u91d1\u8776\u9500\u552eOMS\u9000\u8d27\u5b8c\u6210\u63a8\u9001\u4fe1\u606f\u7ed9\u91d1\u8776\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        } else if (KingdeeErpConstantEnum.OmsErp73Service.getCode().equals(interfaceName)) {
            KingdeeDirectTransferAllotReqDto transferAllotReqDto = (KingdeeDirectTransferAllotReqDto)v;
            log.info("\u8c03\u7528\u91d1\u8776\u9500\u552e\u8ba2\u5355\u76f4\u63a5\u8c03\u62e8\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{},{}", (Object)chargeCode, (Object)JSON.toJSONString((Object)transferAllotReqDto));
            RestResponse restResponse = bean.mockInterconnectExternalInterfaces(null, chargeCode, interfaceName);
            log.info("\u8c03\u7528\u91d1\u8776\u9500\u552e\u8ba2\u5355\u76f4\u63a5\u8c03\u62e8\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            erpBookKeepService.setPushKeepAccountsReqDto(pushKeepAccountsReqDto, restResponse);
        }
    }
}

