/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.mqc.baseorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.domain.entity.IInspectionPassRecordDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.WaitInspectionRecordPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassRecordEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IWaitInspectionRecordService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEnum;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@MQDesc(tag="inspectionPassSuccess", msgType="publish")
@Component
public class InspectionPassSuccessConsumer
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(InspectionPassSuccessConsumer.class);
    @Resource
    private IInspectionPassRecordDomain inspectionPassRecordDomain;
    @Resource(name="inventoryStatusAdjustmentOrderServiceImpl")
    private IAdjustmentOrderService inventoryStatusAdjustmentOrderServiceImpl;
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IWaitInspectionRecordService waitInspectionRecordService;

    @NotNull
    public MessageResponse process(MessageVo messageVo) {
        InspectionPassRecordEo eo;
        block4: {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u884c\u8bb0\u5f55\u5ba1\u6838\u6210\u529f\u65b0\u589e\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u5355\u5f85\u68c0->\u6b63\u54c1:{}", (Object)JSON.toJSONString((Object)messageVo));
            AdjustmentOrderDto adjustmentOrderDto = (AdjustmentOrderDto)JSONObject.parseObject((String)((String)messageVo.getData()), AdjustmentOrderDto.class);
            eo = (InspectionPassRecordEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionPassRecordDomain.filter().eq((Object)"inspection_pass_record_no", (Object)adjustmentOrderDto.getExternalOrderNo())).last(" limit 1")).one();
            try {
                adjustmentOrderDto.setAuditRemark("\u8d28\u68c0\u653e\u884c\u5ba1\u6838\u901a\u8fc7");
                adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey());
                Long id = this.inventoryStatusAdjustmentOrderServiceImpl.addAdjustmentOrder(adjustmentOrderDto);
                AdjustmentOrderDto adjustmentOrderDto1 = this.inventoryStatusAdjustmentOrderServiceImpl.queryById(id);
                if (Objects.nonNull(eo)) {
                    eo.setRelevanceNo(adjustmentOrderDto1.getAdjustmentNo());
                    eo.setBusinessType(adjustmentOrderDto1.getBusinessType());
                    Optional.ofNullable(this.pcpDictQueryApiProxy.basicDataInfo(eo.getBusinessType())).filter(d -> StringUtils.isNotBlank((CharSequence)d.getGroupCode())).ifPresent(dataDictDto -> eo.setOrderType(dataDictDto.getCode()));
                }
                log.info("\u8d28\u68c0\u653e\u884c\u5ba1\u6838\u901a\u8fc7,\u63a8\u9001\u751f\u6210\u5e93\u5b58\u8c03\u6574\u5355:{},{}", (Object)adjustmentOrderDto1.getAdjustmentNo(), (Object)adjustmentOrderDto1.getExternalOrderNo());
                this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PUSH_INSPECTION_PASS_GEN_ADJUSTMENT_ORDER", (Object)JSONObject.toJSONString((Object)adjustmentOrderDto1));
                WaitInspectionRecordPageReqDto reqDto = new WaitInspectionRecordPageReqDto();
                reqDto.setBatch(eo.getBatch());
                reqDto.setSkuCode(eo.getSkuCode());
                this.waitInspectionRecordService.updateQuantity(eo.getSkuCode(), eo.getBatch());
            }
            catch (Exception e) {
                log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u884c\u8bb0\u5f55\u5ba1\u6838\u6210\u529f\u65b0\u589e\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u5355\u5f85\u68c0->\u6b63\u54c1\u5931\u8d25:{},{}", (Object)JSON.toJSONString((Object)messageVo), (Object)e.getMessage());
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                String failureMessage = this.getFailureMessage(e.getLocalizedMessage(), 255);
                if (!Objects.nonNull(eo)) break block4;
                eo.setFailureMessage(failureMessage);
                eo.setPassStatus(DgInspectionPassRecordStatusEnum.PASS_FAIL.getKey());
            }
        }
        if (Objects.nonNull(eo)) {
            this.inspectionPassRecordDomain.updateSelective((BaseEo)eo);
        }
        return MessageResponse.SUCCESS;
    }

    private String getFailureMessage(String message, Integer num) {
        return StringUtils.isNotBlank((CharSequence)message) && message.length() > num ? message.substring(0, num - 1) : message;
    }
}

