/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.enums.WmsOrderTypeConstant;
import com.yunxi.dg.base.center.inventory.constants.logicWarehouseTypeEnum;
import com.yunxi.dg.base.center.inventory.dao.mapper.DgThirdWarehouseMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.DgThirdWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.AbstractPushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.message.OrderCancelQimenMessageReqDto;
import com.yunxi.dg.base.center.openapi.dto.request.WmsOrderCancelReqDto;
import com.yunxi.dg.base.center.openapi.proxy.wms.IExternalWmsApiProxy;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DefaultPushWmsAble
extends AbstractPushWmsAble {
    private static final Logger log = LoggerFactory.getLogger(DefaultPushWmsAble.class);
    @Resource
    private IPhysicsWarehouseDomain iPhysicsWarehouseDomain;
    @Resource
    private ILogicWarehouseDomain iLogicWarehouseDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IExternalWmsApiProxy iExternalWmsApiProxy;
    @Resource
    private DgThirdWarehouseMapper dgThirdWarehouseMapper;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private Environment environment;

    @Override
    public String getType() {
        return "default";
    }

    @Override
    public boolean canPushWms(PushWmsAble.CanPushWmsBo canPushWmsBo) {
        log.info("\u5224\u65ad\u662f\u5426\u63a8\u9001wms\u5165\u53c2:{}", (Object)LogUtils.buildLogContent((Object)canPushWmsBo));
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)canPushWmsBo.getLogicWarehouseCode())).last("limit 1")).one();
        AssertUtils.isFalse((boolean)Objects.isNull(logicWarehouseEo), (String)("\u903b\u8f91\u4ed3" + canPushWmsBo.getLogicWarehouseCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        ArrayList logicWarehouseTypeList = Lists.newArrayList((Object[])new String[]{logicWarehouseTypeEnum.CUSTOMER.getCode(), logicWarehouseTypeEnum.OVERSEAS_C.getCode()});
        if (logicWarehouseTypeList.contains(logicWarehouseEo.getWarehouseType())) {
            log.info("\u4e0d\u662fB\u4ed3\uff0c\u4e0d\u63a8wms");
            return Boolean.FALSE;
        }
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iPhysicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).last("limit 1")).one();
        AssertUtils.isFalse((boolean)Objects.isNull(physicsWarehouseEo), (String)("\u7269\u7406\u4ed3" + logicWarehouseEo.getPhysicsWarehouseCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        return ObjectUtil.equals((Object)physicsWarehouseEo.getInterconnectionFlag(), (Object)1) && this.checkBySetting(canPushWmsBo, physicsWarehouseEo);
    }

    @Override
    public boolean pushWms(InOutNoticeOrderContext inOutNoticeOrderContext) {
        log.info("\u63a8\u9001wms\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderContext));
        MessageVo messageVo = new MessageVo();
        this.settingMappingType(inOutNoticeOrderContext);
        messageVo.setData((Object)JSON.toJSONString((Object)inOutNoticeOrderContext));
        this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("${inventory.process.mq:PUBLISH_TOPIC}"), "PUSH_WMS", (Object)messageVo);
        return Boolean.FALSE;
    }

    @Override
    public boolean sendOrderCancel(OrderCancelQimenMessageReqDto orderCancelQimenMessageReqDto) {
        log.info("\u63a8\u9001wms\u53d6\u6d88\u5355\u636e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)orderCancelQimenMessageReqDto));
        try {
            WmsOrderCancelReqDto wmsOrderCancelReqDto = this.getWmsOrderCancelReqDto(orderCancelQimenMessageReqDto);
            RestResponseHelper.extractData((RestResponse)this.iExternalWmsApiProxy.cancel(wmsOrderCancelReqDto));
        }
        catch (Exception e) {
            log.info("wms\u53d6\u6d88\u5931\u8d25:{}", (Object)e.getMessage());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public boolean sendOrderClose(OrderCancelQimenMessageReqDto orderCancelQimenMessageReqDto) {
        log.info("\u63a8\u9001wms\u5173\u95ed\u5355\u636e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)orderCancelQimenMessageReqDto));
        try {
            WmsOrderCancelReqDto wmsOrderCancelReqDto = this.getWmsOrderCancelReqDto(orderCancelQimenMessageReqDto);
            RestResponseHelper.extractData((RestResponse)this.iExternalWmsApiProxy.close(wmsOrderCancelReqDto));
        }
        catch (Exception e) {
            log.info("wms\u5173\u95ed\u5931\u8d25:{}", (Object)e.getMessage());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private WmsOrderCancelReqDto getWmsOrderCancelReqDto(OrderCancelQimenMessageReqDto orderCancelQimenMessageReqDto) {
        WmsOrderCancelReqDto wmsOrderCancelReqDto = new WmsOrderCancelReqDto();
        InOutNoticeOrderEo inOutNoticeOrderEo = this.getInOutNoticeOrderEo(orderCancelQimenMessageReqDto);
        AssertUtils.notNull((Object)inOutNoticeOrderEo, (String)"\u67e5\u4e0d\u5230\u8be5\u901a\u77e5\u5355");
        String physicsWarehouseCode = null;
        String orderType = null;
        if (StrUtil.equals((CharSequence)"out", (CharSequence)orderCancelQimenMessageReqDto.getOrderType())) {
            physicsWarehouseCode = inOutNoticeOrderEo.getOutPhysicsWarehouseCode();
            orderType = Optional.ofNullable(WmsOrderTypeConstant.OUT.get(inOutNoticeOrderEo.getBusinessType())).orElse(WmsOrderTypeConstant.COMMON_OUT);
        } else if (StrUtil.equals((CharSequence)"in", (CharSequence)orderCancelQimenMessageReqDto.getOrderType())) {
            physicsWarehouseCode = inOutNoticeOrderEo.getInPhysicsWarehouseCode();
            orderType = Optional.ofNullable(WmsOrderTypeConstant.IN.get(inOutNoticeOrderEo.getBusinessType())).orElse(WmsOrderTypeConstant.COMMON_IN);
        }
        AssertUtils.notBlank((String)physicsWarehouseCode, (String)"\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)this.iPhysicsWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PhysicsWarehouseEo.class).eq(PhysicsWarehouseEo::getWarehouseCode, (Object)physicsWarehouseCode)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notNull((Object)physicsWarehouseEo, (String)"\u7269\u7406\u4ed3\u7f16\u7801\u67e5\u8be2\u4e0d\u5b58\u5728");
        String customerId = this.getCustomerId(physicsWarehouseEo.getEntitySystemCode());
        AssertUtils.notEmpty((String)customerId, (String)"\u67e5\u4e0d\u5230customerId");
        wmsOrderCancelReqDto.setOrderType(orderType);
        wmsOrderCancelReqDto.setWarehouseCode(physicsWarehouseEo.getThirdCode());
        wmsOrderCancelReqDto.setCustomerId(customerId);
        wmsOrderCancelReqDto.setOutInType(Optional.ofNullable(WmsOrderTypeConstant.WMS_OUT_IN.get(orderCancelQimenMessageReqDto.getOrderType())).orElse(WmsOrderTypeConstant.COMMON_IN));
        wmsOrderCancelReqDto.setOrderCode(orderCancelQimenMessageReqDto.getDocumentNo());
        wmsOrderCancelReqDto.setOwnerCode(orderCancelQimenMessageReqDto.getOwnerCode());
        wmsOrderCancelReqDto.setRemark(orderCancelQimenMessageReqDto.getCancelReason());
        return wmsOrderCancelReqDto;
    }

    private InOutNoticeOrderEo getInOutNoticeOrderEo(OrderCancelQimenMessageReqDto orderCancelQimenMessageReqDto) {
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderEo.class).eq(InOutNoticeOrderEo::getDocumentNo, (Object)orderCancelQimenMessageReqDto.getDocumentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEos)) {
            return null;
        }
        return (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
    }

    private String getCustomerId(String thirdCode) {
        AssertUtils.notBlank((String)thirdCode, (String)"\u4e09\u65b9\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        List dgThirdWarehouseEos = this.dgThirdWarehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgThirdWarehouseEo.class).eq(DgThirdWarehouseEo::getWarehouseCode, (Object)thirdCode)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)dgThirdWarehouseEos)) {
            log.info("\u67e5\u4e0d\u5230customerId");
            return null;
        }
        DgThirdWarehouseEo dgThirdWarehouseEo = (DgThirdWarehouseEo)dgThirdWarehouseEos.get(0);
        if (StringUtils.isBlank((String)dgThirdWarehouseEo.getCustomerId())) {
            return null;
        }
        return dgThirdWarehouseEo.getCustomerId();
    }
}

