/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.abstracts;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.unit.OrderUnitConverterDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiveDeliveryNoticeOrderAble
implements ReceiveDeliveryNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractReceiveDeliveryNoticeOrderAble.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    public IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    public IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    public IBaseOrderAddressDomain baseOrderAddressDomain;
    @Resource
    public IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    public IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;

    @Override
    public void doGenerate(ReceiveDeliveryNoticeOrderContext context) {
        log.info("\u751f\u6210\u6536\u53d1\u8d27\u901a\u77e5\u5355,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)context));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = this.getReceiveDeliveryNoticeOrderEo(context);
        List<ReceiveDeliveryNoticeOrderDetailEo> detailEoList = this.getReceiveDeliveryNoticeOrderDetailEos(context, receiveDeliveryNoticeOrderEo);
        context.setReceiveDeliveryNoticeOrderEo(receiveDeliveryNoticeOrderEo);
        context.setReceiveDeliveryNoticeOrderDetailEoList(detailEoList);
        this.wrapperGenerate(context);
        context.execBefore();
        log.info("\u751f\u6210\u6536\u53d1\u8d27\u901a\u77e5\u5355,\u53c2\u6570context:{}", (Object)JSONObject.toJSONString((Object)context));
        if (!context.isOnlyGenResult() || !context.getAutoComplete().booleanValue()) {
            this.receiveDeliveryNoticeOrderDomain.insert((BaseEo)context.getReceiveDeliveryNoticeOrderEo());
            this.receiveDeliveryNoticeOrderDetailDomain.insertBatch(context.getReceiveDeliveryNoticeOrderDetailEoList());
        }
        if (CollectionUtils.isNotEmpty(context.getBaseOrderAddressEoList())) {
            Set contactsTypeSet = ((List)Optional.ofNullable(context.getBaseOrderAddressEoList()).orElse(new ArrayList())).stream().map(BaseOrderAddressEo::getContactsType).collect(Collectors.toSet());
            List addressEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderEo.getRelevanceNo())).in((Object)"contacts_type", contactsTypeSet)).list();
            HashSet hasSet = new HashSet();
            ArrayList baseOrderAddressIds = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)addressEos)) {
                addressEos.forEach(e -> {
                    hasSet.add(this.getAddressKey(e.getDocumentNo(), e.getContactsType()));
                    baseOrderAddressIds.add(e.getId());
                });
            }
            if (CollectionUtils.isNotEmpty(baseOrderAddressIds)) {
                this.baseOrderAddressDomain.getMapper().deleteBatchIds(baseOrderAddressIds);
            }
            Optional.ofNullable(context.getBaseOrderAddressEoList()).map(docu -> docu.stream().peek(d -> {
                d.setId(null);
                d.setDocumentNo(receiveDeliveryNoticeOrderEo.getRelevanceNo());
            }).collect(Collectors.toList())).ifPresent(arg_0 -> ((IBaseOrderAddressDomain)this.baseOrderAddressDomain).insertBatch(arg_0));
        }
        context.execAfter();
        this.wrapperGenerateAfter(context);
    }

    @NotNull
    private String getAddressKey(String documentNo, String contactsType) {
        return documentNo + InventoryConfig.getCommonSeparate() + contactsType;
    }

    public List<ReceiveDeliveryNoticeOrderDetailEo> getReceiveDeliveryNoticeOrderDetailEos(ReceiveDeliveryNoticeOrderContext context, ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo) {
        return context.getOrderBasicsDetailReqDtoList().stream().map(d -> {
            ReceiveDeliveryNoticeOrderDetailEo detailEo = (ReceiveDeliveryNoticeOrderDetailEo)BeanUtil.copyProperties((Object)d, ReceiveDeliveryNoticeOrderDetailEo.class, (String[])new String[0]);
            detailEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
            detailEo.setPreOrderNo(receiveDeliveryNoticeOrderEo.getPreOrderNo());
            detailEo.setRelevanceNo(receiveDeliveryNoticeOrderEo.getRelevanceNo());
            detailEo.setExternalOrderNo(receiveDeliveryNoticeOrderEo.getExternalOrderNo());
            detailEo.setPlanQuantity(d.getQuantity());
            detailEo.setLineNo(d.getLineNo());
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            detailEo.setInventoryProperty(d.getInventoryProperty());
            detailEo.setCreatePerson(context.getCreatePerson());
            if (context.getAutoComplete().booleanValue()) {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setDoneQuantity(d.getQuantity());
            } else {
                detailEo.setDoneQuantity(BigDecimal.ZERO);
                detailEo.setWaitQuantity(d.getQuantity());
            }
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEo.setPreOrderItemId(d.getPreOrderItemId());
            detailEo.setItemStatus(StringUtils.isNotBlank((CharSequence)d.getItemStatus()) ? d.getItemStatus() : CsPlannedOrderItemStatusEnum.COMMON.getCode());
            BasicOrderDtoExtension basicOrderDtoExtension = new BasicOrderDtoExtension();
            basicOrderDtoExtension.setVolume(d.getVolume());
            basicOrderDtoExtension.setWeight(d.getWeight());
            basicOrderDtoExtension.setSkuDisplayName(d.getSkuDisplayName());
            detailEo.setExtension(JSONObject.toJSONString((Object)basicOrderDtoExtension));
            return detailEo;
        }).collect(Collectors.toList());
    }

    private ReceiveDeliveryNoticeOrderEo getReceiveDeliveryNoticeOrderEo(ReceiveDeliveryNoticeOrderContext context) {
        context.setDocumentNo(this.getDocumentNo(context));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = Optional.ofNullable(context.getReceiveDeliveryNoticeOrderEo()).orElse(new ReceiveDeliveryNoticeOrderEo());
        BeanUtil.copyProperties((Object)context, (Object)receiveDeliveryNoticeOrderEo, (CopyOptions)CopyOptions.create().ignoreNullValue());
        receiveDeliveryNoticeOrderEo.setRelevanceTableName(context.getRelevanceTableName().getCode());
        receiveDeliveryNoticeOrderEo.setBusinessType(context.getBusinessType());
        receiveDeliveryNoticeOrderEo.setOrderStatus(context.getOrderStatus().getCode());
        receiveDeliveryNoticeOrderEo.setOrderType(BaseOrderOperateTypeEnum.DELIVERY.equals((Object)context.getOperateTypeEnum()) ? "delivery" : "receive");
        receiveDeliveryNoticeOrderEo.setTotalQuantity(context.getTotalQuantity() == null ? BigDecimal.ZERO : context.getTotalQuantity());
        receiveDeliveryNoticeOrderEo.setCreateTime(new Date());
        receiveDeliveryNoticeOrderEo.setLogisticsOrderNo(context.getLogisticsOrderNo());
        receiveDeliveryNoticeOrderEo.setOffsetType(context.getOffsetType());
        receiveDeliveryNoticeOrderEo.setCreatePerson(context.getCreatePerson());
        BaseOrderExtensionHelper.settingExtensionByContext(context, receiveDeliveryNoticeOrderEo);
        if (CollectionUtils.isNotEmpty(context.getShippingInfoReqDtoList())) {
            Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> {
                CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
                receiveDeliveryNoticeOrderEo.setShippingCode(csWmsShippingInfoReqDto.getShippingNo());
                receiveDeliveryNoticeOrderEo.setShipmentEnterpriseCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                receiveDeliveryNoticeOrderEo.setShipmentEnterpriseName(csWmsShippingInfoReqDto.getShippingCompanyName());
                receiveDeliveryNoticeOrderEo.setShippingType(csWmsShippingInfoReqDto.getShippingType());
                receiveDeliveryNoticeOrderEo.setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyCode());
                receiveDeliveryNoticeOrderEo.setShippingCompanyName(csWmsShippingInfoReqDto.getShippingCompanyName());
                receiveDeliveryNoticeOrderEo.setShippingJson(JSON.toJSONString((Object)shippingInfoReqDtoList));
            });
        }
        return receiveDeliveryNoticeOrderEo;
    }

    private String getDocumentNo(ReceiveDeliveryNoticeOrderContext context) {
        if (BaseOrderOperateTypeEnum.RECEIVE.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.RECEIVE_NOTICE_ORDER.getCode()));
        }
        return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.DELIVERY_NOTICE_ORDER.getCode()));
    }

    protected abstract void wrapperGenerate(ReceiveDeliveryNoticeOrderContext var1);

    protected abstract void wrapperGenerateAfter(ReceiveDeliveryNoticeOrderContext var1);

    @Override
    public void doClose(ReceiveDeliveryNoticeOrderContext context) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context.getReceiveDeliveryNoticeOrderEo();
        ReceiveDeliveryNoticeOrderEo updateEo = new ReceiveDeliveryNoticeOrderEo();
        updateEo.setId(receiveDeliveryNoticeOrderEo.getId());
        updateEo.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)updateEo);
        this.doCloseInventory(context);
        this.updateDetailQuantity(context);
    }

    protected abstract void doCloseInventory(ReceiveDeliveryNoticeOrderContext var1);

    @Override
    public boolean validClose(ReceiveDeliveryNoticeOrderContext context) {
        return this.checkData(context);
    }

    private boolean checkData(ReceiveDeliveryNoticeOrderContext context) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).last(" limit 1")).one();
        AssertUtil.isTrue((null != receiveDeliveryNoticeOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u6536\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        context.setReceiveDeliveryNoticeOrderEo(receiveDeliveryNoticeOrderEo);
        context.setRelevanceNo(receiveDeliveryNoticeOrderEo.getRelevanceNo());
        context.setPreOrderNo(receiveDeliveryNoticeOrderEo.getPreOrderNo());
        context.setExternalOrderNo(receiveDeliveryNoticeOrderEo.getExternalOrderNo());
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)receiveDeliveryNoticeOrderEo.getRelevanceTableName()));
        return true;
    }

    @Override
    public boolean validCancel(ReceiveDeliveryNoticeOrderContext context) {
        return this.checkData(context);
    }

    @Override
    public void complete(ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext) {
        log.info("complete\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)receiveDeliveryNoticeOrderContext));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).last(" limit 1")).one();
        AssertUtils.isTrue((boolean)Objects.nonNull(receiveDeliveryNoticeOrderEo), (String)"\u8c03\u7528\u5b8c\u6210\u5355\u636e\u4e0d\u5b58\u5728");
        List detailEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).list();
        log.info("complete--detailEoList\uff1a{}", (Object)JSON.toJSONString((Object)detailEoList));
        Map<Long, BigDecimal> orderDetailReqDtoMap = receiveDeliveryNoticeOrderContext.getOrderBasicsDetailReqDtoList().stream().filter(r -> Objects.nonNull(r.getLineNo())).collect(Collectors.groupingBy(BaseOrderDetailReqDto::getLineNo, Collectors.mapping(OrderUnitConverterDto::getQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        detailEoList.forEach(detailEo -> Optional.ofNullable(orderDetailReqDtoMap.get(detailEo.getLineNo())).ifPresent(q -> {
            detailEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneQuantity(), (BigDecimal)q));
            detailEo.setWaitQuantity(DataExtractUtils.ifLtZeroSetZero((BigDecimal)detailEo.getWaitQuantity().subtract((BigDecimal)q)));
        }));
        AtomicBoolean existBatch = new AtomicBoolean(false);
        detailEoList.forEach(detailEo -> existBatch.set(StringUtils.isNotBlank((CharSequence)detailEo.getBatch())));
        if (!receiveDeliveryNoticeOrderContext.isNoticeEnd() && this.checkEnd(receiveDeliveryNoticeOrderContext, detailEoList)) {
            receiveDeliveryNoticeOrderContext.setNoticeEnd(true);
        }
        if (receiveDeliveryNoticeOrderContext.isNoticeEndStatus() && this.checkEnd(receiveDeliveryNoticeOrderContext, detailEoList)) {
            receiveDeliveryNoticeOrderContext.setNoticeEndStatus(false);
        }
        receiveDeliveryNoticeOrderEo.setOrderStatus(this.getCompleteStatus(receiveDeliveryNoticeOrderContext));
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)receiveDeliveryNoticeOrderEo);
        this.receiveDeliveryNoticeOrderDetailDomain.getMapper().updateBatchByIds(detailEoList);
        receiveDeliveryNoticeOrderContext.setReceiveDeliveryNoticeOrderEo(receiveDeliveryNoticeOrderEo);
        receiveDeliveryNoticeOrderContext.setReceiveDeliveryNoticeOrderDetailEoList(detailEoList);
    }

    @NotNull
    private List<ReceiveDeliveryNoticeOrderDetailEo> getReceiveNoticeOrderDetailEos(ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo) {
        log.info("\u6536\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728\u6279\u6b21\u4e14\u975e\u8c03\u62e8\u5355\u7c7b\u578b\u66f4\u65b0\u4e3a\u5b8c\u6210/\u5df2\u5b8c\u7ed3\u72b6\u6001\uff0c\u6839\u636e\u7ed3\u679c\u5355\u751f\u6210\u901a\u77e5\u5355\u660e\u7ec6\u4fe1\u606f\u5165\u53c2\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)receiveDeliveryNoticeOrderEo));
        List receiveDeliveryResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"relevance_no", (Object)receiveDeliveryNoticeOrderEo.getRelevanceNo())).eq((Object)"order_status", (Object)BaseOrderStatusEnum.RRO_RECEIVED.getCode())).list();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)receiveDeliveryResultOrderEos), (String)("\u6839\u636e\u5173\u8054\u5355\u53f7\uff1a" + receiveDeliveryNoticeOrderEo.getRelevanceNo() + "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6536\u8d27\u7ed3\u679c\u5355\u4fe1\u606f"));
        Map<String, ReceiveDeliveryResultOrderDetailEo> map = this.getReceiveDeliveryResultOrderDetailMap(receiveDeliveryResultOrderEos);
        List<ReceiveDeliveryNoticeOrderDetailEo> receiveDeliveryNoticeOrderDetailEos = map.values().stream().map(e -> {
            ReceiveDeliveryNoticeOrderDetailEo receiveDeliveryNoticeOrderDetailEo = new ReceiveDeliveryNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)receiveDeliveryNoticeOrderDetailEo, (Object)e, (String[])new String[]{"id"});
            receiveDeliveryNoticeOrderDetailEo.setPreOrderNo(receiveDeliveryNoticeOrderEo.getPreOrderNo());
            receiveDeliveryNoticeOrderDetailEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
            receiveDeliveryNoticeOrderDetailEo.setCreateTime(receiveDeliveryNoticeOrderEo.getCreateTime());
            receiveDeliveryNoticeOrderDetailEo.setCreatePerson(receiveDeliveryNoticeOrderEo.getCreatePerson());
            return receiveDeliveryNoticeOrderDetailEo;
        }).collect(Collectors.toList());
        if (BaseOrderStatusEnum.RNO_TOTAL_RECEIVE.getCode().equals(receiveDeliveryNoticeOrderEo.getOrderStatus())) {
            QueryWrapper receiveDeliveryNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
            receiveDeliveryNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderEo.getDocumentNo());
            this.receiveDeliveryNoticeOrderDetailDomain.getMapper().delete((Wrapper)receiveDeliveryNoticeOrderDetailEoQueryWrapper);
        }
        this.receiveDeliveryNoticeOrderDetailDomain.insertBatch(receiveDeliveryNoticeOrderDetailEos);
        return receiveDeliveryNoticeOrderDetailEos;
    }

    protected abstract String getCompleteStatus(ReceiveDeliveryNoticeOrderContext var1);

    public void updateDetailQuantity(ReceiveDeliveryNoticeOrderContext context) {
        List<ReceiveDeliveryNoticeOrderDetailEo> receiveDeliveryNoticeOrderDetailEoList = this.loadDetailList(context);
        for (ReceiveDeliveryNoticeOrderDetailEo receiveDeliveryNoticeOrderDetailEo : receiveDeliveryNoticeOrderDetailEoList) {
            receiveDeliveryNoticeOrderDetailEo.setCancelQuantity(receiveDeliveryNoticeOrderDetailEo.getWaitQuantity());
            receiveDeliveryNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
        }
        receiveDeliveryNoticeOrderDetailEoList.forEach(out -> {
            ReceiveDeliveryNoticeOrderDetailEo outUpdate = new ReceiveDeliveryNoticeOrderDetailEo();
            outUpdate.setId(out.getId());
            outUpdate.setCancelQuantity(out.getCancelQuantity());
            outUpdate.setWaitQuantity(out.getWaitQuantity());
            this.receiveDeliveryNoticeOrderDetailDomain.updateSelective((BaseEo)outUpdate);
        });
    }

    public List<ReceiveDeliveryNoticeOrderDetailEo> loadDetailList(ReceiveDeliveryNoticeOrderContext context) {
        List receiveDeliveryNoticeOrderDetailEoList = Optional.ofNullable(context.getReceiveDeliveryNoticeOrderDetailEoList()).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).list());
        context.setReceiveDeliveryNoticeOrderDetailEoList(receiveDeliveryNoticeOrderDetailEoList);
        return receiveDeliveryNoticeOrderDetailEoList;
    }

    @NotNull
    private Map<String, ReceiveDeliveryResultOrderDetailEo> getReceiveDeliveryResultOrderDetailMap(List<ReceiveDeliveryResultOrderEo> receiveDeliveryResultOrderEos) {
        List documentNos = receiveDeliveryResultOrderEos.stream().map(ReceiveDeliveryResultOrderEo::getDocumentNo).collect(Collectors.toList());
        QueryWrapper receiveDeliveryResultOrderDetailQueryWrapper = new QueryWrapper();
        receiveDeliveryResultOrderDetailQueryWrapper.in((Object)"document_no", documentNos);
        receiveDeliveryResultOrderDetailQueryWrapper.eq((Object)"dr", (Object)0);
        List receiveDeliveryResultOrderDetailEos = this.receiveDeliveryResultOrderDetailDomain.getMapper().selectList((Wrapper)receiveDeliveryResultOrderDetailQueryWrapper);
        String documentNoStr = StringUtils.join(documentNos, (String)",");
        log.info(String.format("\u6839\u636e\u5165\u5e93\u901a\u77e5\u5355\u53f7\uff1a%s \u67e5\u8be2\u5230\u6536\u8d27\u7ed3\u679c\u5355\u4fe1\u606f\uff1a%s", documentNoStr, JSON.toJSONString((Object)receiveDeliveryResultOrderDetailEos)));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)receiveDeliveryResultOrderDetailEos), (String)(documentNoStr + "\u5bf9\u5e94\u7684\u6536\u8d27\u7ed3\u679c\u5355\u660e\u7ec6\u4e0d\u5b58\u5728"));
        HashMap<String, ReceiveDeliveryResultOrderDetailEo> map = new HashMap<String, ReceiveDeliveryResultOrderDetailEo>(receiveDeliveryResultOrderDetailEos.size());
        for (ReceiveDeliveryResultOrderDetailEo detailEo : receiveDeliveryResultOrderDetailEos) {
            String key = detailEo.getSkuCode() + " " + detailEo.getBatch();
            ReceiveDeliveryResultOrderDetailEo inOutResultOrderDetailEo = (ReceiveDeliveryResultOrderDetailEo)map.get(key);
            if (Objects.nonNull(inOutResultOrderDetailEo)) {
                detailEo.setDoneQuantity(detailEo.getDoneQuantity().add(inOutResultOrderDetailEo.getDoneQuantity()));
                detailEo.setWaitQuantity(detailEo.getWaitQuantity().add(inOutResultOrderDetailEo.getWaitQuantity()));
                detailEo.setQuantity(detailEo.getQuantity().add(inOutResultOrderDetailEo.getQuantity()));
                detailEo.setPlanQuantity(detailEo.getPlanQuantity().add(inOutResultOrderDetailEo.getPlanQuantity()));
                detailEo.setCancelQuantity(detailEo.getCancelQuantity().add(inOutResultOrderDetailEo.getCancelQuantity()));
            }
            map.put(key, detailEo);
        }
        log.info("\u6839\u636eskuCode\u3001\u6279\u6b21\u6c47\u603b\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(map));
        return map;
    }

    private boolean checkEnd(ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext, List<ReceiveDeliveryNoticeOrderDetailEo> detailEoList) {
        return detailEoList.stream().noneMatch(r -> BigDecimalUtils.gtZero((BigDecimal)r.getWaitQuantity())) || receiveDeliveryNoticeOrderContext.isNoticeEndModule() && detailEoList.stream().collect(Collectors.groupingBy(ReceiveDeliveryNoticeOrderDetailEo::getSkuCode, Collectors.mapping(r -> BigDecimalUtils.subtract((BigDecimal)r.getPlanQuantity(), (BigDecimal)r.getDoneQuantity()), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))).values().stream().allMatch(BigDecimalUtils::eqZero);
    }
}

