/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractReceiveDeliveryNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeliveryNoticeOrderAbleImpl
extends AbstractReceiveDeliveryNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(DeliveryNoticeOrderAbleImpl.class);
    @Resource
    ICalcInventoryService calcInventoryService;

    @Override
    protected void wrapperGenerateAfter(ReceiveDeliveryNoticeOrderContext context) {
    }

    private void preempt(ReceiveDeliveryNoticeOrderContext context) {
        PreemptDto preemptDto = new PreemptDto();
        this.wrapper(context, (CalcDto)preemptDto);
        preemptDto.setNoneLineNo(Boolean.TRUE);
        preemptDto.setIsSaleOrder(context.getIsSaleOrder());
        preemptDto.setValidNegative(context.getValidNegative());
        preemptDto.setShoutBatch(context.getShoutBatch());
        preemptDto.setLendEnable(context.isLendEnable());
        if (!context.getShoutBatch().booleanValue()) {
            preemptDto.setNoneBatch(Boolean.valueOf(true));
        }
        preemptDto.setExistsForError(context.getExistsForError());
        ReceiveDeliveryNoticeOrderEo noticeOrderEo = context.getReceiveDeliveryNoticeOrderEo();
        if (Objects.nonNull(noticeOrderEo) && StrUtil.isBlank((CharSequence)preemptDto.getBusinessType())) {
            preemptDto.setBusinessType(noticeOrderEo.getBusinessType());
        }
        List<InventoryUsageRecordEo> inventoryUsageRecordEos = this.calcInventoryService.updatePreempt(preemptDto);
        log.info("preempt,inventoryPreemptionEos:{}", (Object)JSON.toJSONString(inventoryUsageRecordEos));
        List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList = context.getOrderBasicsDetailReqDtoList();
        Map<String, BaseOrderDetailReqDto> skuOptMap = orderBasicsDetailReqDtoList.stream().collect(Collectors.toMap(b -> b.getPreOrderItemId() + b.getSkuCode(), o -> o, (o1, o2) -> o1));
        Map<String, BaseOrderDetailReqDto> skuOptBatchMap = orderBasicsDetailReqDtoList.stream().collect(Collectors.toMap(b -> b.getPreOrderItemId() + b.getSkuCode() + Optional.ofNullable(b.getBatch()).orElse("").toUpperCase(), o -> o, (o1, o2) -> o1));
        HashMap<Long, BaseOrderDetailReqDto> preTradeIdMap = new HashMap<Long, BaseOrderDetailReqDto>(10);
        for (BaseOrderDetailReqDto r : orderBasicsDetailReqDtoList) {
            if (!Objects.nonNull(r.getPreOrderItemId())) continue;
            preTradeIdMap.putIfAbsent(r.getPreOrderItemId(), r);
        }
        context.setOrderBasicsDetailReqDtoList(inventoryUsageRecordEos.stream().map(in -> {
            BaseOrderDetailReqDto reqDto;
            if (context.getIsBatchManage().booleanValue()) {
                reqDto = (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties(skuOptBatchMap.getOrDefault(in.getPreOrderItemId() + in.getSkuCode() + Optional.ofNullable(in.getBatch()).orElse(""), (BaseOrderDetailReqDto)((Object)skuOptMap.get(in.getPreOrderItemId() + in.getSkuCode()))), BaseOrderDetailReqDto.class, (String[])new String[]{"id"})));
                reqDto.setBatch(in.getBatch());
                if (Objects.equals(in.getBatch(), "99999999-hidden")) {
                    reqDto.setBatch(null);
                }
            } else {
                reqDto = Objects.nonNull(in.getPreOrderItemId()) && !preTradeIdMap.isEmpty() ? (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties(preTradeIdMap.get(in.getPreOrderItemId()), BaseOrderDetailReqDto.class, (String[])new String[]{"id"}))) : (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties(skuOptMap.get(in.getSkuCode()), BaseOrderDetailReqDto.class, (String[])new String[]{"id"})));
            }
            reqDto.setPreOrderItemId(in.getPreOrderItemId());
            reqDto.setInventoryProperty(in.getInventoryProperty());
            reqDto.setQuantity(in.getPreemptNum());
            reqDto.setLineNo(in.getLineNo());
            return reqDto;
        }).collect(Collectors.toList()));
        context.setReceiveDeliveryNoticeOrderDetailEoList(this.getReceiveDeliveryNoticeOrderDetailEos(context, context.getReceiveDeliveryNoticeOrderEo()));
    }

    private void wrapper(ReceiveDeliveryNoticeOrderContext context, CalcDto transferInDto) {
        context.wrapperInventoryOd(transferInDto);
        List detailDtos = context.getOrderBasicsDetailReqDtoList().stream().map(detail -> this.getCalcDetailDto(context, (BaseOrderDetailReqDto)((Object)detail))).collect(Collectors.toList());
        transferInDto.setDetails(detailDtos);
    }

    private CalcDetailDto getCalcDetailDto(ReceiveDeliveryNoticeOrderContext context, BaseOrderDetailReqDto detail) {
        CalcDetailDto detailDto = new CalcDetailDto();
        detailDto.setBatch(detail.getBatch());
        detailDto.setLineNo(detail.getLineNo());
        detailDto.setPreOrderItemId(detail.getPreOrderItemId());
        detailDto.setLogicWarehouseCode(context.getLogicWarehouseCode());
        detailDto.setSkuCode(detail.getSkuCode());
        detailDto.setNum(detail.getQuantity());
        if (context.isLendEnable()) {
            detailDto.setLendDto(detail.getLendDto());
        }
        detailDto.setNum(detail.getQuantity());
        detailDto.setInventoryProperty(detail.getInventoryProperty());
        return detailDto;
    }

    @Override
    protected void wrapperGenerate(ReceiveDeliveryNoticeOrderContext context) {
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryLogicWarehouseName(context.getLogicWarehouseName());
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryPhysicsWarehouseName(context.getPhysicsWarehouseName());
        context.getReceiveDeliveryNoticeOrderEo().setWarehouseCode(context.getLogicWarehouseCode());
        context.getReceiveDeliveryNoticeOrderEo().setJumpDocumentType(context.getJumpDocumentType());
        context.getReceiveDeliveryNoticeOrderEo().setJumpDocumentName(context.getJumpDocumentName());
        context.getReceiveDeliveryNoticeOrderEo().setDisplayBusinessType(context.getDisplayBusinessType());
        context.getReceiveDeliveryNoticeOrderEo().setDisplayBusinessName(context.getDisplayBusinessName());
        if (!context.getUpdateInventory().booleanValue()) {
            return;
        }
        if (this.canNoticeInventoryProcess(context)) {
            this.preempt(context);
        }
    }

    @Override
    public void merge(ReceiveDeliveryNoticeOrderContext context) {
    }

    @Override
    protected void doCloseInventory(ReceiveDeliveryNoticeOrderContext context) {
        this.releasePreempt(context);
    }

    @Override
    protected String getCompleteStatus(ReceiveDeliveryNoticeOrderContext inOutNoticeOrderContext) {
        return inOutNoticeOrderContext.isNoticeEnd() ? (inOutNoticeOrderContext.isNoticeEndStatus() ? BaseOrderStatusEnum.FINISH_OVER.getCode() : BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode()) : BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode();
    }

    @Override
    public void doCancel(ReceiveDeliveryNoticeOrderContext context) {
        log.info("=======\u53d6\u6d88\u6536\u53d1\u8d27\u901a\u77e5\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)context));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context.getReceiveDeliveryNoticeOrderEo();
        BaseOrderExtensionHelper.loadByExtension(context, receiveDeliveryNoticeOrderEo);
        ReceiveDeliveryNoticeOrderEo updateEo = new ReceiveDeliveryNoticeOrderEo();
        updateEo.setId(receiveDeliveryNoticeOrderEo.getId());
        updateEo.setOrderStatus(BaseOrderStatusEnum.DNO_CANCEL.getCode());
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)updateEo);
        this.releasePreempt(context);
        this.updateDetailQuantity(context);
    }

    private void releasePreempt(ReceiveDeliveryNoticeOrderContext context) {
        if (!context.getUpdateInventory().booleanValue() || !context.getReleasePreempt().booleanValue()) {
            return;
        }
        this.loadDetailList(context);
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(context.getReceiveDeliveryNoticeOrderEo().getRelevanceNo());
        releasePreemptParam.setSourceType((String)DataExtractUtils.ifNullElse((Object)context.getSourceType(), (Object)context.getReceiveDeliveryNoticeOrderEo().getBusinessType()));
        releasePreemptParam.setBusinessType((String)DataExtractUtils.ifNullElse((Object)context.getBusinessType(), (Object)DataExtractUtils.ifNullElse((Object)context.getReceiveDeliveryNoticeOrderEo().getDisplayBusinessType(), (Object)context.getReceiveDeliveryNoticeOrderEo().getBusinessType())));
        releasePreemptParam.setDetails(context.getReceiveDeliveryNoticeOrderDetailEoList().stream().filter(r -> BigDecimalUtils.gtZero((BigDecimal)r.getWaitQuantity())).map(detail -> {
            CalcDetailDto detailDto = new CalcDetailDto();
            detailDto.setBatch(detail.getBatch());
            detailDto.setLineNo(detail.getLineNo());
            detailDto.setPreOrderItemId(detail.getPreOrderItemId());
            detailDto.setLogicWarehouseCode(context.getLogicWarehouseCode());
            detailDto.setSkuCode(detail.getSkuCode());
            detailDto.setNum(detail.getWaitQuantity());
            detailDto.setInventoryProperty(detail.getInventoryProperty());
            return detailDto;
        }).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)releasePreemptParam.getDetails())) {
            return;
        }
        this.calcInventoryService.releasePreempt(releasePreemptParam);
    }
}

