/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.AdjustmentOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInspectionPassDomain;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictQueryExtReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassEo;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassRecordEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.AbstractAdjustmentOrder;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentChangeTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionPassRecordService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="inventoryStatusAdjustmentOrderServiceImpl")
public class InventoryStatusAdjustmentOrderServiceImpl
extends AbstractAdjustmentOrder<AdjustmentOrderDto, AdjustmentOrderEo, IAdjustmentOrderDomain> {
    private static final Logger log = LoggerFactory.getLogger(InventoryStatusAdjustmentOrderServiceImpl.class);
    @Resource
    private IInspectionPassDomain inspectionPassDomain;
    @Resource
    private IInspectionPassRecordService inspectionPassRecordService;
    @Resource
    private IPcpDictQueryApiProxy pcpDictApiProxy;

    public InventoryStatusAdjustmentOrderServiceImpl(IAdjustmentOrderDomain domain) {
        super(domain);
    }

    public IConverter<AdjustmentOrderDto, AdjustmentOrderEo> converter() {
        return AdjustmentOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long addAdjustmentOrder(AdjustmentOrderDto adjustmentOrderDto) {
        List splitBusinessType;
        this.paramCheck(adjustmentOrderDto);
        DictQueryExtReqDto dictQueryExtReqDto = new DictQueryExtReqDto();
        dictQueryExtReqDto.setGroupCodes(Collections.singletonList("COMMON_CONFIG"));
        dictQueryExtReqDto.setCodes(Collections.singletonList("adjustment_order_split_business_type"));
        List dictExtRespDtos = this.pcpDictApiProxy.queryByParam(dictQueryExtReqDto);
        log.info("\u65b0\u589e\u8c03\u6574\u5355\u6309\u5546\u54c1\u884c\u62c6\u5206\u7684\u4e1a\u52a1\u7c7b\u578b\u7684dict:{}", (Object)JSON.toJSONString((Object)dictExtRespDtos));
        Long id = null;
        boolean splitOrder = false;
        if (CollectionUtils.isNotEmpty((Collection)dictExtRespDtos) && (splitBusinessType = dictExtRespDtos.stream().filter(e -> 1 == e.getStatus() && 1 == e.getSubStatus()).map(DictExtRespDto::getSubValue).collect(Collectors.toList())).contains(adjustmentOrderDto.getBusinessType())) {
            for (AdjustmentOrderDetailDto detailDto : adjustmentOrderDto.getAdjustmentOrderDetailDtos()) {
                AdjustmentOrderDto dto = new AdjustmentOrderDto();
                CubeBeanUtils.copyProperties((Object)dto, (Object)adjustmentOrderDto, (String[])new String[]{"adjustmentOrderDetailDtos"});
                dto.setAdjustmentOrderDetailDtos((List)Lists.newArrayList((Object[])new AdjustmentOrderDetailDto[]{detailDto}));
                id = super.addAdjustmentOrder(dto);
                this.addInspectionPassRecord(dto);
            }
            splitOrder = true;
        }
        if (!splitOrder) {
            id = super.addAdjustmentOrder(adjustmentOrderDto);
            this.addInspectionPassRecord(adjustmentOrderDto);
        }
        return id;
    }

    private void addInspectionPassRecord(AdjustmentOrderDto adjustmentOrderDto) {
        List inspectionPassEos;
        if (CodeGenEnum.INSPECTION_PASS_ORDER.getRefTableName().equals(adjustmentOrderDto.getExternalOrderType()) && CollectionUtil.isNotEmpty((Collection)(inspectionPassEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionPassDomain.filter().eq((Object)"inspection_no", (Object)adjustmentOrderDto.getExternalOrderNo())).orderByDesc((Object)"id")).list()))) {
            Map inspectionPassEosMap = inspectionPassEos.stream().collect(Collectors.toMap(e -> this.getMapKey(e.getSkuCode(), e.getBatch()), Function.identity(), (k1, k2) -> k1));
            adjustmentOrderDto.getAdjustmentOrderDetailDtos().forEach(e -> {
                InspectionPassEo inspectionPassEo = (InspectionPassEo)inspectionPassEosMap.get(this.getMapKey(e.getSkuCode(), e.getBatch()));
                if (Objects.nonNull(inspectionPassEo)) {
                    InspectionPassRecordEo inspectionPassRecordEo = new InspectionPassRecordEo();
                    CubeBeanUtils.copyProperties((Object)inspectionPassRecordEo, (Object)inspectionPassEo, (String[])new String[]{"id"});
                    inspectionPassRecordEo.setRelevanceNo(adjustmentOrderDto.getAdjustmentNo());
                    inspectionPassRecordEo.setBusinessType(adjustmentOrderDto.getBusinessType());
                    inspectionPassRecordEo.setOrderType(adjustmentOrderDto.getOrderType());
                    inspectionPassRecordEo.setQuantity(e.getChangeQuantity());
                    inspectionPassRecordEo.setPassStatus(DgInspectionPassRecordStatusEnum.WAIT_COMMIT.getKey());
                    this.inspectionPassRecordService.add(inspectionPassRecordEo, DgInspectionPassRecordStatusEventEnum.BUSINESS_ORDER_COMPLETE);
                    OptUtil.addOptLog((String)OperationLogTypeEnum.FROZEN.name(), (String)"EMPTY", (String)inspectionPassEo.getInspectionNo(), (String)CodeGenEnum.INSPECTION_PASS_ORDER.getCode());
                }
            });
        }
    }

    @NotNull
    private String getMapKey(String skuCode, String batch) {
        return skuCode + " " + batch;
    }

    @Override
    public void audit(AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        super.audit(adjustmentOrderUpdateDto);
    }

    @Override
    public void submit(AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        super.submit(adjustmentOrderUpdateDto);
    }

    @Override
    protected String genAdjustmentOrderNo() {
        return InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.STATUS_ADJUSTMENT);
    }

    @Override
    public void paramCheck(AdjustmentOrderDto adjustmentOrderDto) {
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderDto.getBusinessType()), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)adjustmentOrderDto.getAdjustmentOrderDetailDtos()), (String)"\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        adjustmentOrderDto.getAdjustmentOrderDetailDtos().forEach(adjustmentOrderDetailDto -> {
            AssertUtil.isFalse((boolean)Objects.isNull(adjustmentOrderDetailDto.getChangeQuantity()), (String)"\u8c03\u6574\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjustmentOrderDetailDto.getInventoryProperty()), (String)"\u539f\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjustmentOrderDetailDto.getNewInventoryProperty()), (String)"\u65b0\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjustmentOrderDetailDto.getUnit()), (String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        });
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderDto.getWarehouseCode()), (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)BeanUtil.isEmpty((Object)adjustmentOrderDto.getBizDate(), (String[])new String[0]), (String)"\u4e1a\u52a1\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderDto.getOrderType()), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjustmentOrderDto.getInventoryProperty()), (String)"\u539f\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjustmentOrderDto.getNewInventoryProperty()), (String)"\u65b0\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        super.paramCheck(adjustmentOrderDto);
    }

    @Override
    public String getChageType(AdjustmentOrderDetailEo orderDetailEo) {
        return AdjustmentChangeTypeEnum.DECREASE.getCode();
    }

    @Override
    public List<AdjustmentOrderDto> queryByExternalOrderNos(List<String> externalOrderNos) {
        return super.queryByExternalOrderNos(externalOrderNos);
    }
}

