/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.guard;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.stereotype.Component;

@Component
public class AdjustmentOrderCancelExeChoiceGuard
implements Guard<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentOrderCancelExeChoiceGuard.class);
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;

    public boolean evaluate(StateContext<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> context) {
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        AdjustmentOrderEo eo = (AdjustmentOrderEo)executorBo.getEo();
        Optional.ofNullable(this.inOutNoticeOrderDomain.queryByRelevanceNo(eo.getAdjustmentNo())).ifPresent(list -> list.forEach(o -> {
            if (BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode().equals(o.getOrderStatus()) || BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(o.getOrderStatus()) || BaseOrderStatusEnum.INO_PORTION_IN.getCode().equals(o.getOrderStatus()) || BaseOrderStatusEnum.ONO_PORTION_OUT.getCode().equals(o.getOrderStatus())) {
                throw new BizException("\u901a\u77e5\u5355\u5df2\u64cd\u4f5c\uff0c\u65e0\u6cd5\u53d6\u6d88");
            }
        }));
        return Boolean.TRUE;
    }
}

