/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.guard;

import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.stereotype.Component;

@Component
public class AdjustmentOrderCompleteChoiceGuard
implements Guard<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentOrderCompleteChoiceGuard.class);
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;

    public boolean evaluate(StateContext<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> context) {
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        AdjustmentOrderEo eo = (AdjustmentOrderEo)executorBo.getEo();
        return this.inOutNoticeOrderDomain.queryByRelevanceNo(eo.getAdjustmentNo()).stream().allMatch(o -> BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode().equals(o.getOrderStatus()) || BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(o.getOrderStatus()));
    }
}

